/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.utils;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.DocEmitterUtils;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IFileScope;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;

public class ClosureUtils {
    public static void collectPropertyNamesToKeep(ICompilationUnit cu, RoyaleJSProject project, Set<String> result) {
        if (project.isExternalLinkage(cu)) {
            return;
        }
        boolean preventRenamePublicSymbols = project.config != null && project.config.getPreventRenamePublicSymbols();
        boolean preventRenamePublicInstanceMethods = project.config != null && project.config.getPreventRenamePublicInstanceMethods();
        boolean preventRenamePublicStaticMethods = project.config != null && project.config.getPreventRenamePublicStaticMethods();
        boolean preventRenamePublicInstanceVariables = project.config != null && project.config.getPreventRenamePublicInstanceVariables();
        boolean preventRenamePublicStaticVariables = project.config != null && project.config.getPreventRenamePublicStaticVariables();
        boolean preventRenamePublicInstanceAccessors = project.config != null && project.config.getPreventRenamePublicInstanceAccessors();
        boolean preventRenamePublicStaticAccessors = project.config != null && project.config.getPreventRenamePublicStaticAccessors();
        boolean preventRenameProtectedSymbols = project.config != null && project.config.getPreventRenameProtectedSymbols();
        boolean preventRenameProtectedInstanceMethods = project.config != null && project.config.getPreventRenameProtectedInstanceMethods();
        boolean preventRenameProtectedStaticMethods = project.config != null && project.config.getPreventRenameProtectedStaticMethods();
        boolean preventRenameProtectedInstanceVariables = project.config != null && project.config.getPreventRenameProtectedInstanceVariables();
        boolean preventRenameProtectedStaticVariables = project.config != null && project.config.getPreventRenameProtectedStaticVariables();
        boolean preventRenameProtectedInstanceAccessors = project.config != null && project.config.getPreventRenameProtectedInstanceAccessors();
        boolean preventRenameProtectedStaticAccessors = project.config != null && project.config.getPreventRenameProtectedStaticAccessors();
        boolean preventRenameInternalSymbols = project.config != null && project.config.getPreventRenameInternalSymbols();
        boolean preventRenameInternalInstanceMethods = project.config != null && project.config.getPreventRenameInternalInstanceMethods();
        boolean preventRenameInternalStaticMethods = project.config != null && project.config.getPreventRenameInternalStaticMethods();
        boolean preventRenameInternalInstanceVariables = project.config != null && project.config.getPreventRenameInternalInstanceVariables();
        boolean preventRenameInternalStaticVariables = project.config != null && project.config.getPreventRenameInternalStaticVariables();
        boolean preventRenameInternalInstanceAccessors = project.config != null && project.config.getPreventRenameInternalInstanceAccessors();
        boolean preventRenameInternalStaticAccessors = project.config != null && project.config.getPreventRenameInternalStaticAccessors();
        try {
            for (IASScope scope : ((IFileScopeRequestResult)cu.getFileScopeRequest().get()).getScopes()) {
                for (IDefinition def : scope.getAllLocalDefinitions()) {
                    IVariableDefinition varDef;
                    if (def instanceof IPackageDefinition) {
                        IPackageDefinition packageDef = (IPackageDefinition)def;
                        def = (IDefinition)packageDef.getContainedScope().getAllLocalDefinitions().iterator().next();
                    }
                    if (scope instanceof IFileScope && def.isPrivate()) {
                        result.add(def.getBaseName());
                    }
                    if (def instanceof IVariableDefinition && !(def instanceof IAccessorDefinition) && (varDef = (IVariableDefinition)def).getVariableClassification().equals((Object)IVariableDefinition.VariableClassification.PACKAGE_MEMBER)) {
                        result.add(def.getBaseName());
                    }
                    if (!(def instanceof ITypeDefinition) || def.isImplicit() || def.isNative()) continue;
                    ITypeDefinition typeDef = (ITypeDefinition)def;
                    for (IDefinition localDef : typeDef.getContainedScope().getAllLocalDefinitions()) {
                        boolean isAccessor;
                        if (localDef.isImplicit() || localDef.isPrivate()) continue;
                        INamespaceReference nsRef = localDef.getNamespaceReference();
                        boolean isCustomNS = !nsRef.isLanguageNamespace();
                        boolean isMethod = localDef instanceof IFunctionDefinition && !(localDef instanceof IAccessorDefinition);
                        boolean isVar = localDef instanceof IVariableDefinition && !(localDef instanceof IAccessorDefinition) && !localDef.isBindable();
                        boolean bl = isAccessor = localDef instanceof IAccessorDefinition || localDef instanceof IVariableDefinition && localDef.isBindable();
                        if (localDef.isPublic() || isCustomNS ? !preventRenamePublicSymbols || (localDef.isStatic() ? isMethod && !preventRenamePublicStaticMethods || isVar && !preventRenamePublicStaticVariables || isAccessor && !preventRenamePublicStaticAccessors : isMethod && !preventRenamePublicInstanceMethods || isVar && !preventRenamePublicInstanceVariables || isAccessor && !preventRenamePublicInstanceAccessors) : (localDef.isProtected() ? !preventRenameProtectedSymbols || (localDef.isStatic() ? isMethod && !preventRenameProtectedStaticMethods || isVar && !preventRenameProtectedStaticVariables || isAccessor && !preventRenameProtectedStaticAccessors : isMethod && !preventRenameProtectedInstanceMethods || isVar && !preventRenameProtectedInstanceVariables || isAccessor && !preventRenameProtectedInstanceAccessors) : !localDef.isInternal() || !preventRenameInternalSymbols || (localDef.isStatic() ? isMethod && !preventRenameInternalStaticMethods || isVar && !preventRenameInternalStaticVariables || isAccessor && !preventRenameInternalStaticAccessors : isMethod && !preventRenameInternalInstanceMethods || isVar && !preventRenameInternalInstanceVariables || isAccessor && !preventRenameInternalInstanceAccessors))) continue;
                        String baseName = localDef.getBaseName();
                        if (isCustomNS) {
                            String uri = nsRef.resolveNamespaceReference((ICompilerProject)project).getURI();
                            baseName = JSRoyaleEmitter.formatNamespacedProperty(uri, baseName, false);
                        }
                        result.add(baseName);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void collectSymbolNamesToExport(ICompilationUnit cu, RoyaleJSProject project, LinkedHashSet<String> symbolsResult) {
        if (project.isExternalLinkage(cu)) {
            return;
        }
        boolean exportPublic = project.config != null && project.config.getExportPublicSymbols();
        boolean exportProtected = project.config != null && project.config.getExportProtectedSymbols();
        boolean exportInternal = project.config != null && project.config.getExportInternalSymbols();
        try {
            String parentQName = null;
            LinkedHashSet<String> filePrivateNames = new LinkedHashSet<String>();
            for (IASScope scope : ((IFileScopeRequestResult)cu.getFileScopeRequest().get()).getScopes()) {
                for (IDefinition def : scope.getAllLocalDefinitions()) {
                    ITypeDefinition typeDef;
                    ASDocComment asDoc;
                    if (def instanceof IPackageDefinition) {
                        IPackageDefinition packageDef = (IPackageDefinition)def;
                        def = (IDefinition)packageDef.getContainedScope().getAllLocalDefinitions().iterator().next();
                    }
                    if (def.isImplicit() || def.isNative()) continue;
                    String qualifiedName = def.getQualifiedName();
                    boolean isFilePrivate = false;
                    if (scope instanceof IFileScope && def.isPrivate()) {
                        isFilePrivate = true;
                        filePrivateNames.add(qualifiedName);
                    } else {
                        if (project.isExterns(qualifiedName)) {
                            return;
                        }
                        symbolsResult.add(qualifiedName);
                        if (parentQName == null) {
                            parentQName = qualifiedName;
                        }
                    }
                    if (!(def instanceof ITypeDefinition) || (asDoc = (ASDocComment)(typeDef = (ITypeDefinition)def).getExplicitSourceComment()) != null && DocEmitterUtils.hasSuppressExport(null, asDoc.commentNoEnd()).booleanValue()) continue;
                    for (IDefinition localDef : typeDef.getContainedScope().getAllLocalDefinitions()) {
                        boolean isCustomNS;
                        boolean isAccessor;
                        if (localDef.isImplicit()) continue;
                        boolean isMethod = localDef instanceof IFunctionDefinition && !(localDef instanceof IAccessorDefinition);
                        boolean isVar = localDef instanceof IVariableDefinition && !(localDef instanceof IAccessorDefinition) && !localDef.isBindable();
                        boolean bl = isAccessor = localDef instanceof IAccessorDefinition || localDef instanceof IVariableDefinition && localDef.isBindable();
                        if (!isMethod && !isVar && !isAccessor) continue;
                        INamespaceReference nsRef = localDef.getNamespaceReference();
                        boolean bl2 = isCustomNS = !nsRef.isLanguageNamespace();
                        if (!(localDef.isPublic() && exportPublic || isCustomNS && exportPublic || localDef.isProtected() && exportProtected) && (!localDef.isInternal() || !exportInternal)) continue;
                        String baseName = localDef.getBaseName();
                        if (isCustomNS) {
                            String uri = nsRef.resolveNamespaceReference((ICompilerProject)project).getURI();
                            baseName = JSRoyaleEmitter.formatNamespacedProperty(uri, localDef.getBaseName(), false);
                        }
                        if (isFilePrivate) {
                            filePrivateNames.add(qualifiedName + (localDef.isStatic() ? "." : ".prototype.") + baseName);
                            continue;
                        }
                        symbolsResult.add(qualifiedName + (localDef.isStatic() ? "." : ".prototype.") + baseName);
                    }
                }
            }
            for (String filePrivateName : filePrivateNames) {
                symbolsResult.add(parentQName + "." + filePrivateName);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

