/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.driver.js.goog;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.clients.JSConfiguration;
import org.apache.royale.compiler.clients.MXMLJSC;
import org.apache.royale.compiler.config.ConfigurationValue;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.annotations.Arguments;
import org.apache.royale.compiler.internal.config.annotations.Config;
import org.apache.royale.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.royale.compiler.internal.config.annotations.Mapping;
import org.apache.royale.compiler.internal.config.annotations.RoyaleOnly;

public class JSGoogConfiguration
extends JSConfiguration {
    protected String closureLib = "";
    private String bindingValueChangeEventType = "valueChange";
    private Boolean childrenAsData = true;
    private String marmotinni;
    protected List<String> sdkJSLib = new ArrayList<String>();
    private List<String> externalJSLib = new ArrayList<String>();
    private boolean strictPublish = true;
    private boolean keepASDoc = true;
    private boolean removeCirculars = true;
    private boolean skipTranspile = false;
    protected List<String> jsCompilerOptions = new ArrayList<String>();
    protected List<String> jsOutputOptimizations = new ArrayList<String>();
    private String htmlTemplateFileName = null;
    private String htmlOutputFileName = "index.html";
    private Set<String> keepCodeWithMetadata = null;
    private boolean exportPublicSymbols = true;
    private boolean exportProtectedSymbols = false;
    private boolean exportInternalSymbols = false;
    private boolean preventRenameMxmlSymbolReferences = true;
    private boolean preventRenamePublicSymbols = true;
    private boolean preventRenamePublicInstanceMethods = true;
    private boolean preventRenamePublicStaticMethods = true;
    private boolean preventRenamePublicInstanceVariables = true;
    private boolean preventRenamePublicStaticVariables = true;
    private boolean preventRenamePublicInstanceAccessors = true;
    private boolean preventRenamePublicStaticAccessors = true;
    private boolean preventRenameProtectedSymbols = true;
    private boolean preventRenameProtectedInstanceMethods = true;
    private boolean preventRenameProtectedStaticMethods = true;
    private boolean preventRenameProtectedInstanceVariables = true;
    private boolean preventRenameProtectedStaticVariables = true;
    private boolean preventRenameProtectedInstanceAccessors = true;
    private boolean preventRenameProtectedStaticAccessors = true;
    private boolean preventRenameInternalSymbols = true;
    private boolean preventRenameInternalInstanceMethods = true;
    private boolean preventRenameInternalStaticMethods = true;
    private boolean preventRenameInternalInstanceVariables = true;
    private boolean preventRenameInternalStaticVariables = true;
    private boolean preventRenameInternalInstanceAccessors = true;
    private boolean preventRenameInternalStaticAccessors = true;
    private boolean allowDynamicBindings = true;
    private boolean mxmlReflectObjectProperty = false;
    private boolean warnPublicVars = true;
    private String externsReportFileName = null;
    private boolean inlineConstants = false;

    public boolean isClosureLibSet() {
        return !this.closureLib.isEmpty();
    }

    public String getClosureLib() {
        try {
            if (this.closureLib.equals("")) {
                if (System.getenv("GOOG_HOME") != null) {
                    this.closureLib = System.getenv("GOOG_HOME");
                }
                if (this.closureLib.equals("")) {
                    return this.getAbsolutePathFromPathRelativeToMXMLC("../../js/lib/google/closure-library");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.closureLib;
    }

    @Config
    @Mapping(value={"closure-lib"})
    public void setClosureLib(ConfigurationValue cv, String value) throws ConfigurationException {
        if (value != null) {
            this.closureLib = value;
        }
    }

    public String getBindingValueChangeEventType() {
        return this.bindingValueChangeEventType;
    }

    @Config(advanced=true)
    public void setCompilerBindingValueChangeEventType(ConfigurationValue cv, String b) {
        this.bindingValueChangeEventType = b;
    }

    public Boolean getCompilerMxmlChildrenAsData() {
        return this.childrenAsData;
    }

    @Config
    @Mapping(value={"compiler", "mxml", "children-as-data"})
    @RoyaleOnly
    public void setCompilerMxmlChildrenAsData(ConfigurationValue cv, Boolean asData) throws ConfigurationException {
        this.childrenAsData = asData;
    }

    public String getMarmotinni() {
        return this.marmotinni;
    }

    @Config
    @Mapping(value={"marmotinni"})
    public void setMarmotinni(ConfigurationValue cv, String value) throws ConfigurationException {
        this.marmotinni = value;
    }

    public List<String> getSDKJSLib() {
        if (this.sdkJSLib.size() == 0) {
            try {
                String path = this.getAbsolutePathFromPathRelativeToMXMLC("../../frameworks/js/Royale/src");
                this.sdkJSLib.add(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sdkJSLib;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"sdk-js-lib"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setSDKJSLib(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.sdkJSLib.addAll(value);
    }

    public List<String> getExternalJSLib() {
        return this.externalJSLib;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"external-js-lib"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setExternalJSLib(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.externalJSLib.addAll(value);
    }

    public boolean getStrictPublish() {
        return this.strictPublish;
    }

    @Config
    @Mapping(value={"strict-publish"})
    public void setStrictPublish(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.strictPublish = value;
    }

    public boolean getKeepASDoc() {
        return this.keepASDoc;
    }

    @Config
    @Mapping(value={"keep-asdoc"})
    public void setKeepASDoc(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.keepASDoc = value;
    }

    public boolean getRemoveCirculars() {
        return this.removeCirculars;
    }

    @Config
    @Mapping(value={"remove-circulars"})
    public void setRemoveCirculars(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.removeCirculars = value;
    }

    public boolean getSkipTranspile() {
        return this.skipTranspile;
    }

    @Config
    @Mapping(value={"skip-transpile"})
    public void setSkipTranspile(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.skipTranspile = value;
    }

    protected String getAbsolutePathFromPathRelativeToMXMLC(String relativePath) throws IOException {
        String mxmlcURL = MXMLJSC.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File mxmlc = new File(URLDecoder.decode(mxmlcURL, "utf-8"));
        return new File(mxmlc.getParent() + File.separator + relativePath).getCanonicalPath();
    }

    public List<String> getJSCompilerOptions() {
        return this.jsCompilerOptions;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"js-compiler-option"})
    @Arguments(value={"option"})
    @InfiniteArguments
    public void setJSCompilerOptions(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.jsCompilerOptions.addAll(value);
    }

    public List<String> getJSOutputOptimizations() {
        return this.jsOutputOptimizations;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"js-output-optimization"})
    @Arguments(value={"optimization"})
    @InfiniteArguments
    public void setJSOutputOptimizations(ConfigurationValue cv, List<String> value) throws ConfigurationException {
        this.jsOutputOptimizations.addAll(value);
    }

    public File getHtmlTemplate() {
        return this.htmlTemplateFileName != null ? new File(this.htmlTemplateFileName) : null;
    }

    @Config(advanced=true)
    @Mapping(value={"html-template"})
    @Arguments(value={"filename"})
    public void setHtmlTemplate(ConfigurationValue cv, String filename) {
        this.htmlTemplateFileName = this.getOutputPath(cv, filename);
    }

    public String getHtmlOutputFileName() {
        return this.htmlOutputFileName;
    }

    @Config(advanced=true)
    @Mapping(value={"html-output-filename"})
    @Arguments(value={"filename"})
    public void setHtmlOutputFileName(ConfigurationValue cv, String filename) {
        this.htmlOutputFileName = filename;
    }

    public Set<String> getCompilerKeepCodeWithMetadata() {
        return this.keepCodeWithMetadata == null ? Collections.emptySet() : this.keepCodeWithMetadata;
    }

    @Config(advanced=true, allowMultiple=true)
    @Mapping(value={"compiler", "keep-code-with-metadata"})
    @Arguments(value={"name"})
    @InfiniteArguments
    public void setCompilerKeepCodeWithMetadata(ConfigurationValue cv, List<String> values) {
        if (this.keepCodeWithMetadata == null) {
            this.keepCodeWithMetadata = new HashSet<String>();
        }
        this.keepCodeWithMetadata.addAll(values);
    }

    public boolean getExportPublicSymbols() {
        return this.exportPublicSymbols;
    }

    @Config
    @Mapping(value={"export-public-symbols"})
    public void setExportPublicSymbols(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.exportPublicSymbols = value;
    }

    public boolean getExportProtectedSymbols() {
        return this.exportProtectedSymbols;
    }

    @Config
    @Mapping(value={"export-protected-symbols"})
    public void setExportProtectedSymbols(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.exportProtectedSymbols = value;
    }

    public boolean getExportInternalSymbols() {
        return this.exportInternalSymbols;
    }

    @Config
    @Mapping(value={"export-internal-symbols"})
    public void setExportInternalSymbols(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.exportInternalSymbols = value;
    }

    public boolean getPreventRenameMxmlSymbolReferences() {
        return this.preventRenameMxmlSymbolReferences;
    }

    @Config
    @Mapping(value={"prevent-rename-mxml-symbol-references"})
    public void setPreventRenameMxmlSymbolReferences(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameMxmlSymbolReferences = value;
    }

    public boolean getPreventRenamePublicSymbols() {
        return this.preventRenamePublicSymbols;
    }

    @Config
    @Mapping(value={"prevent-rename-public-symbols"})
    public void setPreventRenamePublicSymbols(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenamePublicSymbols = value;
    }

    public boolean getPreventRenamePublicInstanceMethods() {
        return this.preventRenamePublicInstanceMethods;
    }

    @Config
    @Mapping(value={"prevent-rename-public-instance-methods"})
    public void setPreventRenamePublicInstanceMethods(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenamePublicInstanceMethods = value;
    }

    public boolean getPreventRenamePublicStaticMethods() {
        return this.preventRenamePublicStaticMethods;
    }

    @Config
    @Mapping(value={"prevent-rename-public-static-methods"})
    public void setPreventRenamePublicStaticMethods(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenamePublicStaticMethods = value;
    }

    public boolean getPreventRenamePublicInstanceVariables() {
        return this.preventRenamePublicInstanceVariables;
    }

    @Config
    @Mapping(value={"prevent-rename-public-instance-variables"})
    public void setPreventRenamePublicInstanceVariables(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenamePublicInstanceVariables = value;
    }

    public boolean getPreventRenamePublicStaticVariables() {
        return this.preventRenamePublicStaticVariables;
    }

    @Config
    @Mapping(value={"prevent-rename-public-static-variables"})
    public void setPreventRenamePublicStaticVariables(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenamePublicStaticVariables = value;
    }

    public boolean getPreventRenamePublicInstanceAccessors() {
        return this.preventRenamePublicInstanceAccessors;
    }

    @Config
    @Mapping(value={"prevent-rename-public-instance-accessors"})
    public void setPreventRenamePublicInstanceAccessors(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenamePublicInstanceAccessors = value;
    }

    public boolean getPreventRenamePublicStaticAccessors() {
        return this.preventRenamePublicStaticAccessors;
    }

    @Config
    @Mapping(value={"prevent-rename-public-static-accessors"})
    public void setPreventRenamePublicStaticAccessors(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenamePublicStaticAccessors = value;
    }

    public boolean getPreventRenameProtectedSymbols() {
        return this.preventRenameProtectedSymbols;
    }

    @Config
    @Mapping(value={"prevent-rename-protected-symbols"})
    public void setPreventRenameProtectedSymbols(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameProtectedSymbols = value;
    }

    public boolean getPreventRenameProtectedInstanceMethods() {
        return this.preventRenameProtectedInstanceMethods;
    }

    @Config
    @Mapping(value={"prevent-rename-protected-instance-methods"})
    public void setPreventRenameProtectedInstanceMethods(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameProtectedInstanceMethods = value;
    }

    public boolean getPreventRenameProtectedStaticMethods() {
        return this.preventRenameProtectedStaticMethods;
    }

    @Config
    @Mapping(value={"prevent-rename-protected-static-methods"})
    public void setPreventRenameProtectedStaticMethods(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameProtectedStaticMethods = value;
    }

    public boolean getPreventRenameProtectedInstanceVariables() {
        return this.preventRenameProtectedInstanceVariables;
    }

    @Config
    @Mapping(value={"prevent-rename-protected-instance-variables"})
    public void setPreventRenameProtectedInstanceVariables(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameProtectedInstanceVariables = value;
    }

    public boolean getPreventRenameProtectedStaticVariables() {
        return this.preventRenameProtectedStaticVariables;
    }

    @Config
    @Mapping(value={"prevent-rename-protected-static-variables"})
    public void setPreventRenameProtectedStaticVariables(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameProtectedStaticVariables = value;
    }

    public boolean getPreventRenameProtectedInstanceAccessors() {
        return this.preventRenameProtectedInstanceAccessors;
    }

    @Config
    @Mapping(value={"prevent-rename-protected-instance-accessors"})
    public void setPreventRenameProtectedInstanceAccessors(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameProtectedInstanceAccessors = value;
    }

    public boolean getPreventRenameProtectedStaticAccessors() {
        return this.preventRenameProtectedStaticAccessors;
    }

    @Config
    @Mapping(value={"prevent-rename-protected-static-accessors"})
    public void setPreventRenameProtectedStaticAccessors(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameProtectedStaticAccessors = value;
    }

    public boolean getPreventRenameInternalSymbols() {
        return this.preventRenameInternalSymbols;
    }

    @Config
    @Mapping(value={"prevent-rename-internal-symbols"})
    public void setPreventRenameInternalSymbols(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameInternalSymbols = value;
    }

    public boolean getPreventRenameInternalInstanceMethods() {
        return this.preventRenameInternalInstanceMethods;
    }

    @Config
    @Mapping(value={"prevent-rename-internal-instance-methods"})
    public void setPreventRenameInternalInstanceMethods(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameInternalInstanceMethods = value;
    }

    public boolean getPreventRenameInternalStaticMethods() {
        return this.preventRenameInternalStaticMethods;
    }

    @Config
    @Mapping(value={"prevent-rename-internal-static-methods"})
    public void setPreventRenameInternalStaticMethods(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameInternalStaticMethods = value;
    }

    public boolean getPreventRenameInternalInstanceVariables() {
        return this.preventRenameInternalInstanceVariables;
    }

    @Config
    @Mapping(value={"prevent-rename-internal-instance-variables"})
    public void setPreventRenameInternalInstanceVariables(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameInternalInstanceVariables = value;
    }

    public boolean getPreventRenameInternalStaticVariables() {
        return this.preventRenameInternalStaticVariables;
    }

    @Config
    @Mapping(value={"prevent-rename-internal-static-variables"})
    public void setPreventRenameInternalStaticVariables(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameInternalStaticVariables = value;
    }

    public boolean getPreventRenameInternalInstanceAccessors() {
        return this.preventRenameInternalInstanceAccessors;
    }

    @Config
    @Mapping(value={"prevent-rename-internal-instance-accessors"})
    public void setPreventRenameInternalInstanceAccessors(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameInternalInstanceAccessors = value;
    }

    public boolean getPreventRenameInternalStaticAccessors() {
        return this.preventRenameInternalStaticAccessors;
    }

    @Config
    @Mapping(value={"prevent-rename-internal-static-accessors"})
    public void setPreventRenameInternalStaticAccessors(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.preventRenameInternalStaticAccessors = value;
    }

    public boolean getAllowDynamicBindings() {
        return this.allowDynamicBindings;
    }

    @Config
    @Mapping(value={"allow-dynamic-bindings"})
    public void setAllowDynamicBindings(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.allowDynamicBindings = value;
    }

    public boolean getMxmlReflectObjectProperty() {
        return this.mxmlReflectObjectProperty;
    }

    @Config
    @Mapping(value={"mxml-reflect-object-property"})
    public void setMxmlReflectObjectProperty(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.mxmlReflectObjectProperty = value;
    }

    public boolean getWarnPublicVars() {
        return this.warnPublicVars;
    }

    @Config
    @Mapping(value={"warn-public-vars"})
    public void setWarnPublicVars(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.warnPublicVars = value;
    }

    public File getExternsReport() {
        return this.externsReportFileName != null ? new File(this.externsReportFileName) : null;
    }

    @Config(advanced=true)
    @Mapping(value={"externs-report"})
    @Arguments(value={"filename"})
    public void setExternsReport(ConfigurationValue cv, String filename) {
        this.externsReportFileName = this.getOutputPath(cv, filename);
    }

    public int getReflectionFlags() {
        int ret = 0;
        boolean WITH_DEFAULT_INITIALIZERS = true;
        int HAS_KEEP_AS3_METADATA = 2;
        int HAS_KEEP_CODE_WITH_METADATA = 4;
        int HAS_EXPORT_PUBLIC_SYMBOLS = 8;
        int EXPORT_PROTECTED_SYMBOLS = 16;
        int EXPORT_INTERNAL_SYMBOLS = 32;
        if (this.getJsDefaultInitializers()) {
            ret |= 1;
        }
        if (this.getCompilerKeepAs3Metadata().size() > 0) {
            ret |= 2;
        }
        if (this.getCompilerKeepCodeWithMetadata().size() > 0) {
            ret |= 4;
        }
        if (this.getExportPublicSymbols()) {
            ret |= 8;
        }
        if (this.getExportProtectedSymbols()) {
            ret |= 0x10;
        }
        if (this.getExportInternalSymbols()) {
            ret |= 0x20;
        }
        return ret;
    }

    public boolean getInlineConstants() {
        return this.inlineConstants;
    }

    @Config
    @Mapping(value={"inline-constants"})
    public void setInlineConstants(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.inlineConstants = value;
    }
}

