/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.HashMap;
import java.util.Set;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.as.codegen.BindableHelper;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.GetterNode;
import org.apache.royale.compiler.internal.tree.as.SetterNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.ISetterNode;

public class AccessorEmitter
extends JSSubEmitter
implements ISubEmitter<IAccessorNode> {
    public AccessorEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IAccessorNode node) {
        if (node.getNodeID() == ASTNodeID.GetterID) {
            this.emitGet((IGetterNode)node);
        } else if (node.getNodeID() == ASTNodeID.SetterID) {
            this.emitSet((ISetterNode)node);
        }
    }

    @Override
    public void emit(IClassDefinition definition) {
        IGetterNode node;
        String baseName;
        ISetterNode setterNode;
        IGetterNode getterNode;
        JSSessionModel.PropertyNodes p;
        Set<String> propertyNames;
        String qname;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        boolean emitExports = true;
        if (project != null && project.config != null) {
            emitExports = project.config.getExportPublicSymbols();
        }
        if (!this.getModel().getPropertyMap().isEmpty()) {
            qname = definition.getQualifiedName();
            propertyNames = this.getModel().getPropertyMap().keySet();
            for (String string : propertyNames) {
                IGetterNode accessorNode;
                p = this.getModel().getPropertyMap().get(string);
                getterNode = p.getter;
                setterNode = p.setter;
                baseName = p.name;
                if (this.getModel().isExterns) {
                    node = getterNode != null ? getterNode : setterNode;
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline("/**");
                    if (emitExports) {
                        this.writeNewline(" * @export");
                    }
                    if (p.type != null) {
                        this.writeNewline(" * @type {" + JSGoogDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
                    }
                    this.writeNewline(" */");
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.PROTOTYPE);
                    if (p.uri != null) {
                        INamespaceDecorationNode ns = ((FunctionNode)node).getActualNamespaceNode();
                        INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(baseName);
                    }
                    this.write(ASEmitterTokens.SEMICOLON);
                    continue;
                }
                Object object = accessorNode = getterNode != null ? getterNode : setterNode;
                if (!accessorNode.getDefinition().isOverride()) {
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline("/**");
                    if (p.preventRename) {
                        this.writeNewline(" * @nocollapse");
                    }
                    if (p.resolvedExport && !p.suppressExport) {
                        this.writeNewline(" * @export");
                    }
                    if (p.type != null) {
                        this.writeNewline(" * @type {" + JSGoogDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
                    }
                    this.writeNewline(" */");
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.PROTOTYPE);
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    if (p.uri != null) {
                        INamespaceDecorationNode ns = ((FunctionNode)accessorNode).getActualNamespaceNode();
                        INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, false));
                    } else {
                        this.write(baseName);
                    }
                    this.write(ASEmitterTokens.SEMICOLON);
                }
                if (getterNode != null) {
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline();
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.PROTOTYPE);
                    if (p.uri != null) {
                        INamespaceDecorationNode ns = ((FunctionNode)getterNode).getActualNamespaceNode();
                        INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, JSRoyaleEmitterTokens.GETTER_PREFIX.getToken() + baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                        this.write(baseName);
                    }
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.EQUAL);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    fjs.emitParameters(getterNode.getParametersContainerNode());
                    fjs.emitDefinePropertyFunction((IAccessorNode)getterNode);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
                if (setterNode == null) continue;
                boolean isClassBindable = BindableHelper.isClassCodeGenBindable((IClassDefinition)definition);
                boolean isBindable = false;
                IAccessorDefinition setterDef = (IAccessorDefinition)setterNode.getDefinition();
                IAccessorDefinition getterDef = null;
                if (getterNode != null) {
                    getterDef = (IAccessorDefinition)getterNode.getDefinition();
                }
                if (getterDef != null && (setterDef.isBindable() || getterDef.isBindable())) {
                    boolean foundExplicitBindableTag = false;
                    if (setterDef.isBindable()) {
                        isBindable = BindableHelper.isCodeGenBindableMember((IDefinition)setterDef, (boolean)isClassBindable);
                        foundExplicitBindableTag = BindableHelper.hasExplicitBindable((IDefinition)setterDef);
                    }
                    if (getterDef.isBindable()) {
                        isBindable = isBindable || BindableHelper.isCodeGenBindableMember((IDefinition)getterDef, (boolean)isClassBindable);
                        boolean bl = foundExplicitBindableTag = foundExplicitBindableTag || BindableHelper.hasExplicitBindable((IDefinition)getterDef);
                    }
                    if (isClassBindable) {
                        isBindable = !foundExplicitBindableTag;
                    }
                }
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.write(this.getEmitter().formatQualifiedName(qname));
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.PROTOTYPE);
                if (p.uri != null) {
                    INamespaceDecorationNode ns = ((FunctionNode)setterNode).getActualNamespaceNode();
                    INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, JSRoyaleEmitterTokens.SETTER_PREFIX.getToken() + baseName, true));
                } else {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    if (isBindable) {
                        this.write(JSRoyaleEmitterTokens.BINDABLE_PREFIX);
                        this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                        this.write(this.getEmitter().formatPrivateName(definition.getQualifiedName(), baseName, true));
                    } else {
                        this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                        this.write(baseName);
                    }
                }
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.FUNCTION);
                fjs.emitParameters(setterNode.getParametersContainerNode());
                fjs.emitDefinePropertyFunction((IAccessorNode)setterNode);
                this.write(ASEmitterTokens.SEMICOLON);
                if (!isBindable) continue;
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.write(this.getEmitter().formatQualifiedName(qname));
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.PROTOTYPE);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                this.write(baseName);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.FUNCTION);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write("value");
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.write(ASEmitterTokens.SPACE);
                this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
                this.write(ASEmitterTokens.VAR);
                this.write(ASEmitterTokens.SPACE);
                this.write("oldValue");
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.THIS);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                this.write(baseName);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.write(ASEmitterTokens.IF);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write("oldValue != value");
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.write(ASEmitterTokens.SPACE);
                this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
                this.write(ASEmitterTokens.THIS);
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSRoyaleEmitterTokens.BINDABLE_PREFIX);
                this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                this.write(this.getEmitter().formatPrivateName(definition.getQualifiedName(), baseName, true));
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write("value");
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeNewline("    this.dispatchEvent(" + fjs.formatQualifiedName(BindableEmitter.VALUECHANGE_EVENT_QNAME) + ".createUpdateEvent(");
                this.writeNewline("         this, \"" + p.originalName + "\", oldValue, value));");
                this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.SEMICOLON);
            }
        }
        if (!this.getModel().getPropertyMap().isEmpty() && !this.getModel().isExterns) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.write(JSGoogEmitterTokens.OBJECT);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.DEFINE_PROPERTIES);
            this.write(ASEmitterTokens.PAREN_OPEN);
            qname = definition.getQualifiedName();
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + ".prototype} */ ");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
            propertyNames = this.getModel().getPropertyMap().keySet();
            boolean firstTime = true;
            for (String propName : propertyNames) {
                INamespaceDefinition nsDef;
                INamespaceDecorationNode ns;
                IAccessorDefinition other;
                INamespaceDefinition nsDef2;
                INamespaceDecorationNode ns2;
                FunctionNode fnNode;
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.writeNewline(ASEmitterTokens.COMMA);
                }
                boolean wroteGetter = false;
                JSSessionModel.PropertyNodes p2 = this.getModel().getPropertyMap().get(propName);
                baseName = p2.name;
                IGetterNode getterNode2 = p2.getter;
                ISetterNode setterNode2 = p2.setter;
                this.writeNewline("/**");
                if (p2.type != null) {
                    String typeName = p2.type.getBaseName();
                    if (this.getModel().isInternalClass(typeName)) {
                        typeName = this.getModel().getInternalClasses().get(typeName);
                    }
                    this.writeNewline(" * @type {" + JSGoogDocEmitter.convertASTypeToJSType(typeName, p2.type.getPackageName()) + "}");
                }
                this.writeNewline(" */");
                FunctionNode functionNode = fnNode = getterNode2 != null ? (FunctionNode)getterNode2 : (FunctionNode)setterNode2;
                if (p2.uri != null) {
                    INamespaceDecorationNode ns22 = fnNode.getActualNamespaceNode();
                    INamespaceDefinition nsDef22 = (INamespaceDefinition)ns22.resolve((ICompilerProject)project);
                    fjs.formatQualifiedName(nsDef22.getQualifiedName());
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(p2.uri, baseName, false));
                } else {
                    this.write(baseName);
                }
                this.write(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                this.writeNewline();
                if (getterNode2 != null) {
                    this.write(ASEmitterTokens.GET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.PROTOTYPE);
                    if (p2.uri != null) {
                        ns2 = ((FunctionNode)getterNode2).getActualNamespaceNode();
                        nsDef2 = (INamespaceDefinition)ns2.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef2.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p2.uri, JSRoyaleEmitterTokens.GETTER_PREFIX.getToken() + baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                        this.write(baseName);
                    }
                    wroteGetter = true;
                } else if (setterNode2 != null && (other = (IAccessorDefinition)SemanticUtils.resolveCorrespondingAccessor((IDefinition)p2.setter.getDefinition(), (ICompilerProject)this.getProject())) != null) {
                    this.write(ASEmitterTokens.GET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(this.getEmitter().formatQualifiedName(other.getParent().getQualifiedName()));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.PROTOTYPE);
                    if (p2.uri != null) {
                        ns = ((FunctionNode)setterNode2).getActualNamespaceNode();
                        nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p2.uri, JSRoyaleEmitterTokens.GETTER_PREFIX.getToken() + baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                        this.write(baseName);
                    }
                    wroteGetter = true;
                }
                if (setterNode2 != null) {
                    if (wroteGetter) {
                        this.writeNewline(ASEmitterTokens.COMMA);
                    }
                    this.write(ASEmitterTokens.SET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.PROTOTYPE);
                    if (p2.uri != null) {
                        ns2 = ((FunctionNode)setterNode2).getActualNamespaceNode();
                        nsDef2 = (INamespaceDefinition)ns2.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef2.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p2.uri, JSRoyaleEmitterTokens.SETTER_PREFIX.getToken() + baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                        this.write(baseName);
                    }
                } else if (getterNode2 != null && (other = (IAccessorDefinition)SemanticUtils.resolveCorrespondingAccessor((IDefinition)p2.getter.getDefinition(), (ICompilerProject)this.getProject())) != null) {
                    if (wroteGetter) {
                        this.writeNewline(ASEmitterTokens.COMMA);
                    }
                    this.write(ASEmitterTokens.SET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(this.getEmitter().formatQualifiedName(other.getParent().getQualifiedName()));
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSEmitterTokens.PROTOTYPE);
                    if (p2.uri != null) {
                        ns = ((FunctionNode)getterNode2).getActualNamespaceNode();
                        nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p2.uri, JSRoyaleEmitterTokens.SETTER_PREFIX.getToken() + baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                        this.write(baseName);
                    }
                }
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
            this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        if (!this.getModel().getStaticPropertyMap().isEmpty()) {
            qname = definition.getQualifiedName();
            propertyNames = this.getModel().getStaticPropertyMap().keySet();
            for (String string : propertyNames) {
                INamespaceDefinition nsDef;
                INamespaceDecorationNode ns;
                p = this.getModel().getStaticPropertyMap().get(string);
                getterNode = p.getter;
                setterNode = p.setter;
                baseName = p.name;
                if (this.getModel().isExterns) {
                    node = getterNode != null ? getterNode : setterNode;
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline("/**");
                    if (emitExports) {
                        this.writeNewline(" * @export");
                    }
                    if (p.type != null) {
                        this.writeNewline(" * @type {" + JSGoogDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
                    }
                    this.writeNewline(" */");
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    if (p.uri != null) {
                        INamespaceDecorationNode ns3 = ((FunctionNode)node).getActualNamespaceNode();
                        INamespaceDefinition nsDef3 = (INamespaceDefinition)ns3.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef3.getQualifiedName());
                        String s = nsDef3.getURI();
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(baseName);
                    }
                    this.write(ASEmitterTokens.SEMICOLON);
                    continue;
                }
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.writeNewline("/**");
                if (p.preventRename) {
                    this.writeNewline(" * @nocollapse");
                }
                if (p.resolvedExport && !p.suppressExport) {
                    this.writeNewline(" * @export");
                }
                if (p.type != null) {
                    this.writeNewline(" * @type {" + JSGoogDocEmitter.convertASTypeToJSType(p.type.getBaseName(), p.type.getPackageName()) + "}");
                }
                this.writeNewline(" */");
                this.write(this.getEmitter().formatQualifiedName(qname));
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                if (p.uri != null) {
                    node = getterNode != null ? getterNode : setterNode;
                    INamespaceDecorationNode ns3 = ((FunctionNode)node).getActualNamespaceNode();
                    INamespaceDefinition nsDef3 = (INamespaceDefinition)ns3.resolve((ICompilerProject)project);
                    fjs.formatQualifiedName(nsDef3.getQualifiedName());
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, baseName, false));
                } else {
                    this.write(baseName);
                }
                this.write(ASEmitterTokens.SEMICOLON);
                if (getterNode != null) {
                    this.writeNewline();
                    this.writeNewline();
                    this.writeNewline();
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    if (p.uri != null) {
                        ns = ((FunctionNode)getterNode).getActualNamespaceNode();
                        nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, JSRoyaleEmitterTokens.GETTER_PREFIX.getToken() + baseName, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                        this.write(baseName);
                    }
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.EQUAL);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.FUNCTION);
                    fjs.emitParameters(getterNode.getParametersContainerNode());
                    fjs.emitDefinePropertyFunction((IAccessorNode)getterNode);
                    this.write(ASEmitterTokens.SEMICOLON);
                }
                if (setterNode == null) continue;
                this.writeNewline();
                this.writeNewline();
                this.writeNewline();
                this.write(this.getEmitter().formatQualifiedName(qname));
                if (p.uri != null) {
                    ns = ((FunctionNode)setterNode).getActualNamespaceNode();
                    nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(p.uri, JSRoyaleEmitterTokens.SETTER_PREFIX.getToken() + baseName, true));
                } else {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                    this.write(baseName);
                }
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.FUNCTION);
                fjs.emitParameters(setterNode.getParametersContainerNode());
                fjs.emitDefinePropertyFunction((IAccessorNode)setterNode);
                this.write(ASEmitterTokens.SEMICOLON);
            }
        }
        if (!this.getModel().getStaticPropertyMap().isEmpty() && !this.getModel().isExterns) {
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            this.write(JSGoogEmitterTokens.OBJECT);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.DEFINE_PROPERTIES);
            this.write(ASEmitterTokens.PAREN_OPEN);
            qname = definition.getQualifiedName();
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write("/** @lends {" + this.getEmitter().formatQualifiedName(qname) + "} */ ");
            this.writeNewline(ASEmitterTokens.BLOCK_OPEN);
            propertyNames = this.getModel().getStaticPropertyMap().keySet();
            boolean firstTime = true;
            for (String propName : propertyNames) {
                INamespaceDefinition nsDef;
                INamespaceDecorationNode ns;
                FunctionNode fnNode;
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.writeNewline(ASEmitterTokens.COMMA);
                }
                JSSessionModel.PropertyNodes p3 = this.getModel().getStaticPropertyMap().get(propName);
                IGetterNode getterNode3 = p3.getter;
                ISetterNode setterNode3 = p3.setter;
                String baseName2 = p3.name;
                this.writeNewline("/**");
                if (p3.type != null) {
                    this.writeNewline(" * @type {" + JSGoogDocEmitter.convertASTypeToJSType(p3.type.getBaseName(), p3.type.getPackageName()) + "}");
                }
                this.writeNewline(" */");
                FunctionNode functionNode = fnNode = getterNode3 != null ? (FunctionNode)getterNode3 : (FunctionNode)setterNode3;
                if (p3.uri != null) {
                    ns = fnNode.getActualNamespaceNode();
                    nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(p3.uri, baseName2, false));
                } else {
                    this.write(baseName2);
                }
                this.write(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                this.writeNewline();
                if (getterNode3 != null) {
                    this.write(ASEmitterTokens.GET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    if (p3.uri != null) {
                        ns = ((FunctionNode)getterNode3).getActualNamespaceNode();
                        nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p3.uri, JSRoyaleEmitterTokens.GETTER_PREFIX.getToken() + baseName2, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.GETTER_PREFIX);
                        this.write(baseName2);
                    }
                }
                if (setterNode3 != null) {
                    if (p3.getter != null) {
                        this.writeNewline(ASEmitterTokens.COMMA);
                    }
                    this.write(ASEmitterTokens.SET);
                    this.write(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    if (p3.uri != null) {
                        ns = ((FunctionNode)setterNode3).getActualNamespaceNode();
                        nsDef = (INamespaceDefinition)ns.resolve((ICompilerProject)project);
                        fjs.formatQualifiedName(nsDef.getQualifiedName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(p3.uri, JSRoyaleEmitterTokens.SETTER_PREFIX.getToken() + baseName2, true));
                    } else {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSRoyaleEmitterTokens.SETTER_PREFIX);
                        this.write(baseName2);
                    }
                }
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
            this.writeNewline(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
    }

    public void emitGet(IGetterNode node) {
        JSSessionModel.PropertyNodes p;
        IFunctionDefinition def;
        ModifiersSet modifierSet;
        boolean suppress;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        boolean bl = suppress = this.getModel().suppressExports || node.getASDocComment() != null && ((ASDocComment)node.getASDocComment()).commentNoEnd().contains(JSRoyaleEmitterTokens.SUPPRESS_EXPORT.getToken());
        if (suppress) {
            this.getModel().suppressedExportNodes.add((IASNode)node);
        }
        boolean isStatic = (modifierSet = (def = node.getDefinition()).getModifiers()) != null && modifierSet.hasModifier(ASModifier.STATIC);
        HashMap<String, JSSessionModel.PropertyNodes> map = isStatic ? this.getModel().getStaticPropertyMap() : this.getModel().getPropertyMap();
        String name = node.getName();
        if (!isStatic && def != null && def.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
            name = fjs.formatPrivateName(def.getParent().getQualifiedName(), name);
        }
        String uri = null;
        String key = name;
        if (!def.getNamespaceReference().isLanguageNamespace()) {
            uri = ((INamespaceDefinition)((GetterNode)node).getActualNamespaceNode().resolve(this.getProject())).getURI();
            key = uri + "::" + name;
        }
        boolean emitExports = true;
        boolean exportProtected = false;
        boolean exportInternal = false;
        boolean preventRenamePublicSymbols = true;
        boolean preventRenameProtectedSymbols = true;
        boolean preventRenameInternalSymbols = true;
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        if (project != null && project.config != null) {
            emitExports = project.config.getExportPublicSymbols();
            exportProtected = project.config.getExportProtectedSymbols();
            exportInternal = project.config.getExportInternalSymbols();
            preventRenamePublicSymbols = project.config.getPreventRenamePublicSymbols();
            preventRenameProtectedSymbols = project.config.getPreventRenameProtectedSymbols();
            preventRenameInternalSymbols = project.config.getPreventRenameInternalSymbols();
        }
        if ((p = map.get(key)) == null) {
            p = new JSSessionModel.PropertyNodes();
            p.name = name;
            p.originalName = node.getName();
            p.uri = uri;
            map.put(key, p);
        }
        if (uri != null || def.isPublic()) {
            p.resolvedExport = p.resolvedExport || emitExports;
            p.preventRename = p.preventRename || preventRenamePublicSymbols;
        } else if (def.isInternal()) {
            p.resolvedExport = p.resolvedExport || exportInternal;
            p.preventRename = p.preventRename || preventRenameInternalSymbols;
        } else if (def.isProtected()) {
            p.resolvedExport = p.resolvedExport || exportProtected;
            p.preventRename = p.preventRename || preventRenameProtectedSymbols;
        }
        p.getter = node;
        if (!p.suppressExport) {
            p.suppressExport = suppress;
        }
        if (p.type == null && project != null) {
            p.type = node.getDefinition().resolveReturnType((ICompilerProject)project);
        }
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
    }

    public void emitSet(ISetterNode node) {
        JSSessionModel.PropertyNodes p;
        IFunctionDefinition def;
        ModifiersSet modifierSet;
        boolean suppress;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        JSRoyaleDocEmitter doc = (JSRoyaleDocEmitter)fjs.getDocEmitter();
        boolean bl = suppress = this.getModel().suppressExports || node.getASDocComment() != null && ((ASDocComment)node.getASDocComment()).commentNoEnd().contains(JSRoyaleEmitterTokens.SUPPRESS_EXPORT.getToken());
        if (suppress) {
            this.getModel().suppressedExportNodes.add((IASNode)node);
        }
        boolean isStatic = (modifierSet = (def = node.getDefinition()).getModifiers()) != null && modifierSet.hasModifier(ASModifier.STATIC);
        HashMap<String, JSSessionModel.PropertyNodes> map = isStatic ? this.getModel().getStaticPropertyMap() : this.getModel().getPropertyMap();
        String name = node.getName();
        if (!isStatic && def != null && def.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
            name = fjs.formatPrivateName(def.getParent().getQualifiedName(), name);
        }
        String uri = null;
        String key = name;
        if (!def.getNamespaceReference().isLanguageNamespace()) {
            uri = ((INamespaceDefinition)((SetterNode)node).getActualNamespaceNode().resolve(this.getProject())).getURI();
            key = uri + "::" + name;
        }
        boolean emitExports = true;
        boolean exportProtected = false;
        boolean exportInternal = false;
        boolean preventRenamePublicSymbols = true;
        boolean preventRenameProtectedSymbols = true;
        boolean preventRenameInternalSymbols = true;
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        if (project != null && project.config != null) {
            emitExports = project.config.getExportPublicSymbols();
            exportProtected = project.config.getExportProtectedSymbols();
            exportInternal = project.config.getExportInternalSymbols();
            preventRenamePublicSymbols = project.config.getPreventRenamePublicSymbols();
            preventRenameProtectedSymbols = project.config.getPreventRenameProtectedSymbols();
            preventRenameInternalSymbols = project.config.getPreventRenameInternalSymbols();
        }
        if ((p = map.get(key)) == null) {
            p = new JSSessionModel.PropertyNodes();
            p.name = name;
            p.originalName = node.getName();
            p.uri = uri;
            map.put(key, p);
        }
        if (uri != null || def.isPublic()) {
            p.resolvedExport = p.resolvedExport || emitExports;
            p.preventRename = p.preventRename || preventRenamePublicSymbols;
        } else if (def.isInternal()) {
            p.resolvedExport = p.resolvedExport || exportInternal;
            p.preventRename = p.preventRename || preventRenameInternalSymbols;
        } else if (def.isProtected()) {
            p.resolvedExport = p.resolvedExport || exportProtected;
            p.preventRename = p.preventRename || preventRenameProtectedSymbols;
        }
        p.setter = node;
        if (!p.suppressExport) {
            p.suppressExport = suppress;
        }
        if (p.type == null && project != null) {
            IParameterDefinition[] params = def.getParameters();
            p.type = params[0].resolveType((ICompilerProject)project);
        }
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(fjs.getProblems());
        boolean isBindableSetter = false;
        if (node instanceof SetterNode) {
            IMetaInfo[] metaInfos = null;
            for (IMetaInfo metaInfo : metaInfos = node.getMetaInfos()) {
                name = metaInfo.getTagName();
                if (!name.equals("Bindable") || metaInfo.getAllAttributes().length != 0) continue;
                isBindableSetter = true;
                break;
            }
        }
        if (isBindableSetter) {
            IFunctionDefinition definition = node.getDefinition();
            ITypeDefinition type = (ITypeDefinition)definition.getParent();
            doc.emitMethodDoc((IFunctionNode)fn, this.getProject());
            this.write(fjs.formatQualifiedName(type.getQualifiedName()));
            if (!node.hasModifier(ASModifier.STATIC)) {
                this.write(ASEmitterTokens.MEMBER_ACCESS);
                this.write(JSEmitterTokens.PROTOTYPE);
            }
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write("__bindingWrappedSetter__");
            this.writeToken(node.getName());
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            fjs.emitParameters(node.getParametersContainerNode());
            fjs.emitMethodScope(node.getScopedNode());
            this.writeNewline();
        }
    }
}

