/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.tasks.configuration;

import java.io.File;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.launcher.OperatingSystem;
import org.apache.royale.test.ant.tasks.configuration.StepConfiguration;
import org.apache.tools.ant.BuildException;

public class TestRunConfiguration
implements StepConfiguration {
    private final int FLOOR_FOR_PORT = 1;
    private final int SHORTEST_SOCKET_TIMEOUT = 5000;
    private String player;
    private File command = null;
    private int display = 99;
    private boolean failOnTestFailure = false;
    private String failureProperty = "royaleunit.failed";
    private File royaleHome = null;
    private boolean headless = false;
    private boolean isLocalTrusted = true;
    private int port = 1024;
    private File reportDir = null;
    private int serverBufferSize = 262144;
    private int socketTimeout = 60000;
    private File swf = null;
    private String url = null;
    private File precompiledAppDescriptor = null;
    private OperatingSystem os = OperatingSystem.identify();

    public File getCommand() {
        return this.command;
    }

    public void setCommand(File command) {
        this.command = command;
    }

    public boolean isCustomCommand() {
        return this.command != null;
    }

    public int getDisplay() {
        return this.display;
    }

    public void setDisplay(int display) {
        this.display = display;
    }

    public boolean isFailOnTestFailure() {
        return this.failOnTestFailure;
    }

    public void setFailOnTestFailure(boolean failOnTestFailure) {
        this.failOnTestFailure = failOnTestFailure;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public File getRoyaleHome() {
        return this.royaleHome;
    }

    public void setRoyaleHome(File royaleHome) {
        this.royaleHome = royaleHome;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public boolean isLocalTrusted() {
        return this.isLocalTrusted;
    }

    public boolean usePolicyFile() {
        return !this.isLocalTrusted && this.player.equals("flash");
    }

    public void setLocalTrusted(boolean isLocalTrusted) {
        this.isLocalTrusted = isLocalTrusted;
    }

    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    public int getServerBufferSize() {
        return this.serverBufferSize;
    }

    public void setServerBufferSize(int serverBufferSize) {
        this.serverBufferSize = serverBufferSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public File getSwf() {
        return this.swf;
    }

    public void setSwf(File swf) {
        this.swf = swf;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public File getPrecompiledAppDescriptor() {
        return this.precompiledAppDescriptor;
    }

    public void setPrecompiledAppDescriptor(File precompiledAppDescriptor) {
        this.precompiledAppDescriptor = precompiledAppDescriptor;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    @Override
    public void validate() throws BuildException {
        if (this.port < 1) {
            throw new BuildException("The provided 'port' property value [" + this.port + "] must be great than " + 1 + ".");
        }
        if (this.socketTimeout < 5000) {
            throw new BuildException("The provided 'timeout' property value [" + this.socketTimeout + "] must be great than " + 5000 + ".");
        }
        if (this.reportDir != null && !this.reportDir.exists()) {
            LoggingUtil.log("Provided report directory path [" + this.reportDir.getPath() + "] does not exist.");
        }
        if (this.command != null) {
            if (!this.command.exists()) {
                throw new BuildException("The provided command path [" + this.command + "] does not exist.");
            }
            if (this.command.isDirectory()) {
                throw new BuildException("The provided command path [" + this.command + "] is a directory, it must be an executable.");
            }
        }
        if (this.headless) {
            if (OperatingSystem.identify() != OperatingSystem.LINUX) {
                throw new BuildException("Headless mode can only be used on Linux with vncserver installed.");
            }
            if (this.display < 1) {
                throw new BuildException("The provided 'display' number must be set higher than 0.  99 or higher is recommended.");
            }
        }
    }

    @Override
    public void log() {
        LoggingUtil.log("Using the following settings for the test run:");
        if (this.royaleHome != null) {
            LoggingUtil.log("\tROYALE_HOME: [" + this.royaleHome.getAbsolutePath() + "]");
        }
        LoggingUtil.log("\thaltonfailure: [" + this.failOnTestFailure + "]");
        LoggingUtil.log("\theadless: [" + this.headless + "]");
        LoggingUtil.log("\tdisplay: [" + this.display + "]");
        LoggingUtil.log("\tlocalTrusted: [" + this.isLocalTrusted + "]");
        LoggingUtil.log("\tplayer: [" + this.player + "]");
        if (this.isCustomCommand()) {
            LoggingUtil.log("\tcommand: [" + this.command + "]");
        }
        LoggingUtil.log("\tport: [" + this.port + "]");
        LoggingUtil.log("\tswf: [" + this.swf + "]");
        LoggingUtil.log("\ttimeout: [" + this.socketTimeout + "ms]");
        LoggingUtil.log("\ttoDir: [" + this.reportDir.getAbsolutePath() + "]");
    }
}

