/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLArrayNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLBooleanNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassReferenceNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDesignLayerNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLFunctionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLHTTPServiceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLIntNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNumberNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLObjectNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLRegExpNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLRemoteObjectNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLRepeaterNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLStateNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLStringNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.MXMLUintNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLVectorNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLWebServiceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLXMLListNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLXMLNode;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLAttributeVersionProblem;
import org.apache.royale.compiler.problems.MXMLDuplicateIDProblem;
import org.apache.royale.compiler.problems.MXMLIncludeInAndExcludeFromProblem;
import org.apache.royale.compiler.problems.MXMLInvalidIDProblem;
import org.apache.royale.compiler.problems.MXMLInvalidItemCreationPolicyProblem;
import org.apache.royale.compiler.problems.MXMLInvalidItemDestructionPolicyProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassReferenceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;

public class MXMLInstanceNode
extends MXMLClassReferenceNodeBase
implements IMXMLInstanceNode {
    private String id;
    private String localId;
    private String[] includeIn;
    private String[] excludeFrom;
    private String itemCreationPolicy;
    private String itemDestructionPolicy;

    public static boolean isStateClass(String instanceType, RoyaleProject project) {
        if (!instanceType.endsWith(".State")) {
            return false;
        }
        if (instanceType.equals(project.getStateClass())) {
            return true;
        }
        IResolvedQualifiersReference instanceRef = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), instanceType);
        ITypeDefinition instanceTypeDef = (ITypeDefinition)instanceRef.resolve(project);
        if (project.stateClassType == null) {
            IResolvedQualifiersReference stateRef = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), project.getStateClass());
            project.stateClassType = (ITypeDefinition)stateRef.resolve(project);
        }
        return instanceTypeDef.isInstanceOf(project.stateClassType, (ICompilerProject)project);
    }

    protected static MXMLInstanceNode createInstanceNode(MXMLTreeBuilder builder, String instanceType, NodeBase parent) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (instanceType.equals("Boolean")) {
            return new MXMLBooleanNode(parent);
        }
        if (instanceType.equals("int")) {
            return new MXMLIntNode(parent);
        }
        if (instanceType.equals("uint")) {
            return new MXMLUintNode(parent);
        }
        if (instanceType.equals("Number")) {
            return new MXMLNumberNode(parent);
        }
        if (instanceType.equals("String")) {
            return new MXMLStringNode(parent);
        }
        if (instanceType.equals("Class")) {
            return new MXMLClassNode(parent);
        }
        if (instanceType.equals("Object")) {
            return new MXMLObjectNode(parent);
        }
        if (instanceType.equals("Array")) {
            return new MXMLArrayNode(parent);
        }
        if (instanceType.equals(IASLanguageConstants.Vector_qname)) {
            return new MXMLVectorNode(parent);
        }
        if (MXMLInstanceNode.isStateClass(instanceType, builder.getProject()) && mxmlDialect != MXMLDialect.MXML_2006) {
            return new MXMLStateNode(parent);
        }
        if (instanceType.equals(builder.getProject().getWebServiceQName())) {
            return new MXMLWebServiceNode(parent);
        }
        if (instanceType.equals(builder.getProject().getRemoteObjectQName())) {
            return new MXMLRemoteObjectNode(parent);
        }
        if (instanceType.equals(builder.getProject().getHTTPServiceQName())) {
            return new MXMLHTTPServiceNode(parent);
        }
        if (instanceType.equals(builder.getProject().getDesignLayerQName())) {
            return new MXMLDesignLayerNode(parent);
        }
        if (instanceType.equals(builder.getProject().getRepeaterQName())) {
            return new MXMLRepeaterNode(parent);
        }
        if (instanceType.equals("XML")) {
            return new MXMLXMLNode(parent);
        }
        if (instanceType.equals("XMLList")) {
            return new MXMLXMLListNode(parent);
        }
        if (instanceType.equals("Function")) {
            return new MXMLFunctionNode(parent);
        }
        if (instanceType.equals("RegExp")) {
            return new MXMLRegExpNode(parent);
        }
        return new MXMLInstanceNode(parent);
    }

    MXMLInstanceNode(NodeBase parent) {
        super(parent);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("id")) {
            this.id = this.processIDAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("localId")) {
            this.localId = this.processIDAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("includeIn")) {
            this.includeIn = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("excludeFrom")) {
            this.excludeFrom = this.processIncludeInOrExcludeFromAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("itemCreationPolicy")) {
            this.itemCreationPolicy = this.processItemCreationPolicyAttribute(builder, attribute);
        } else if (attribute.isSpecialAttribute("itemDestructionPolicy")) {
            this.itemDestructionPolicy = this.processItemDestructionPolicyAttribute(builder, attribute);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    private String processIDAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect;
        String value = attribute.getRawValue();
        if (value == null) {
            value = "";
        }
        if (!MXMLInstanceNode.isValidASIdentifier(value = (mxmlDialect = builder.getMXMLDialect()).trim(value))) {
            MXMLInvalidIDProblem problem = new MXMLInvalidIDProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        IMXMLInstanceNode previousNodeWithSameID = ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).addNodeWithID(value, this);
        if (previousNodeWithSameID != null && !this.isEqual(previousNodeWithSameID)) {
            MXMLDuplicateIDProblem problem = new MXMLDuplicateIDProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        return value;
    }

    protected String processItemCreationPolicyAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (mxmlDialect == MXMLDialect.MXML_2006) {
            MXMLAttributeVersionProblem problem = new MXMLAttributeVersionProblem(attribute, attribute.getName(), "2009");
            builder.addProblem(problem);
            return null;
        }
        String value = attribute.getRawValue();
        if (!(value = mxmlDialect.trim(value)).equals("immediate") && !value.equals("deferred")) {
            MXMLInvalidItemCreationPolicyProblem problem = new MXMLInvalidItemCreationPolicyProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        return value;
    }

    protected String processItemDestructionPolicyAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        MXMLDialect mxmlDialect = builder.getMXMLDialect();
        if (mxmlDialect == MXMLDialect.MXML_2006) {
            MXMLAttributeVersionProblem problem = new MXMLAttributeVersionProblem(attribute, attribute.getName(), "2009");
            builder.addProblem(problem);
            return null;
        }
        String value = attribute.getRawValue();
        if (!(value = mxmlDialect.trim(value)).equals("auto") && !value.equals("never")) {
            MXMLInvalidItemDestructionPolicyProblem problem = new MXMLInvalidItemDestructionPolicyProblem(attribute);
            builder.addProblem(problem);
            return null;
        }
        return value;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        RoyaleProject project;
        IClassDefinition classReference;
        super.initializationComplete(builder, tag, info);
        if (this.id == null) {
            ((MXMLClassDefinitionNode)this.getClassDefinitionNode()).generateID(this);
        }
        if (this.includeIn != null && this.excludeFrom != null) {
            MXMLIncludeInAndExcludeFromProblem problem = new MXMLIncludeInAndExcludeFromProblem(tag);
            builder.addProblem(problem);
            this.includeIn = null;
            this.excludeFrom = null;
        }
        if ((classReference = this.getClassReference(project = builder.getProject())) != null) {
            String qname = classReference.getQualifiedName();
            builder.addDependency(qname, DependencyType.EXPRESSION);
            if (this.id != null) {
                builder.addDependency(qname, DependencyType.SIGNATURE);
            }
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLInstanceID;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getLocalID() {
        return this.localId;
    }

    @Override
    public String getEffectiveID() {
        return this.id != null ? this.id : (this.localId != null ? this.localId : this.getClassDefinitionNode().getGeneratedID(this));
    }

    @Override
    public IVariableDefinition resolveID() {
        MXMLClassDefinitionNode classDefinitionNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        IClassDefinition classDefinition = classDefinitionNode.getClassDefinition();
        ASScope classScope = (ASScope)classDefinition.getContainedScope();
        IDefinitionSet definitionSet = classScope.getLocalDefinitionSetByName(this.id);
        int n = definitionSet.getSize();
        for (int i = 0; i < n; ++i) {
            IDefinition definition = definitionSet.getDefinition(i);
            if (!(definition instanceof IVariableDefinition)) continue;
            return (IVariableDefinition)definition;
        }
        return null;
    }

    @Override
    public String[] getIncludeIn() {
        return this.includeIn;
    }

    @Override
    public String[] getExcludeFrom() {
        return this.excludeFrom;
    }

    @Override
    public String getItemCreationPolicy() {
        return this.itemCreationPolicy;
    }

    @Override
    public String getItemDestructionPolicy() {
        return this.itemDestructionPolicy;
    }

    @Override
    public boolean needsDescriptor() {
        IASNode parent;
        if (this.isContainer()) {
            return true;
        }
        return this.isDeferredInstantiationUIComponent() && (parent = this.getParent()) instanceof IMXMLClassReferenceNode && ((IMXMLClassReferenceNode)parent).isContainer();
    }

    @Override
    public boolean needsDocumentDescriptor() {
        return this.isContainer() && this.getParent() instanceof IMXMLInstanceNode && !((IMXMLInstanceNode)this.getParent()).isContainer();
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        super.buildInnerString(sb);
        String id = this.getID();
        if (id != null) {
            sb.append(' ');
            sb.append("id=");
            sb.append('\"');
            sb.append(id);
            sb.append('\"');
        }
        return true;
    }

    @Override
    public boolean isEqual(IMXMLInstanceNode node) {
        return node.getLine() == this.getLine() && node.getColumn() == this.getColumn();
    }
}

