/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BaseStatementExpressionNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorInNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.royale.compiler.internal.tree.as.ForLoopNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.as.TreeNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.problems.ArrayLikeConfigurationErrorProblem;
import org.apache.royale.compiler.problems.ArrayLikeUsageErrorProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.projects.IRoyaleProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.utils.ArrayLikeLoopMutation;

public class ArrayLikeUtil {
    private static final String LENGTH_ARG = "length";
    private static final String LENGTH_ACCESS_ARG = "lengthAccess";
    private static final String GETVALUE_ARG = "getValue";
    private static final String SETVALUE_ARG = "setValue";
    private static final String SETTER_ARG_SEQUENCE_ARG = "setterArgSequence";
    private static final String SETTER_ARG_SEQUENCE_VALUE_INDEX = "value,index";
    private static final String SETTER_ARG_SEQUENCE_INDEX_VALUE = "index,value";
    private static final String LENGTH_ACCESS_METHOD = "method";
    private static final String LENGTH_ACCESS_GETTER = "getter";
    private static final String INDEX_ACCESS_UNCHANGED = "[]";
    private static final String LENGTH_ACCESS_DEFAULT = "getter";
    private static final String SETTER_ARG_SEQUENCE_DEFAULT = "value,index";
    private static final String ARRAY_LIKE_FOREACH_ITERATOR_VARNAME_BASE = "royale$for$Each$Iterator";
    private static final String ARRAYLIKE_GENERIC_SUPPORT_ITERATOR_FACTORY_FUNC_QNAME = "org.apache.royale.language.iterator.arrayLike";
    private static final String ARRAYLIKE_GENERIC_SUPPORT_ITERATOR_FACTORY_FUNC = "arrayLike";
    static final String ARRAYLIKE_HAS_NEXT = "hasNext";
    static final String ARRAYLIKE_GET_NEXT = "next";
    private static int currentProject = -1;
    private static HashMap<String, String> arrayLikeLookups = null;

    private static String wrapQuotes(String original) {
        return "'" + original + "'";
    }

    public static void preProcessGetterSetters(ICompilerProject project, ContainerNode node, NodeBase lower) {
        if (!(project instanceof IRoyaleProject)) {
            return;
        }
        NodeBase parent = lower != null ? lower : node;
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            FunctionCallNode replacement;
            ExpressionNodeBase indexArg;
            ITypeDefinition target;
            IDefinition metaSource;
            IMetaTag arrayLikeTag;
            DynamicAccessNode dynNode;
            IASNode child = parent.getChild(i);
            if (child instanceof BinaryOperatorAssignmentNode) {
                String setterArg;
                if (((BinaryOperatorAssignmentNode)child).getLeftOperandNode() instanceof DynamicAccessNode && ArrayLikeUtil.isArrayLikeCandidate(dynNode = (DynamicAccessNode)((BinaryOperatorAssignmentNode)child).getLeftOperandNode(), project) && !(setterArg = ArrayLikeUtil.getSetterArg(arrayLikeTag = ArrayLikeUtil.getArrayLikeMetaData(metaSource = ArrayLikeUtil.resolveArrayLikeDefinitionSource(target = dynNode.getLeftOperandNode().resolveType(project), project)))).equals(INDEX_ACCESS_UNCHANGED)) {
                    indexArg = (ExpressionNodeBase)dynNode.getRightOperandNode();
                    ExpressionNodeBase valueArg = (ExpressionNodeBase)((BinaryOperatorAssignmentNode)child).getRightOperandNode();
                    replacement = ArrayLikeUtil.createDynamicAccessMutation(dynNode, setterArg);
                    String argSequence = ArrayLikeUtil.getSetterArgSequenceArg(arrayLikeTag);
                    if (argSequence.equals("value,index")) {
                        replacement.getArgumentsNode().addChild(valueArg);
                        replacement.getArgumentsNode().addChild(indexArg);
                    } else {
                        replacement.getArgumentsNode().addChild(indexArg);
                        replacement.getArgumentsNode().addChild(valueArg);
                    }
                    replacement.getArgumentsNode().setParent(replacement);
                    if (parent instanceof ContainerNode) {
                        ((ContainerNode)parent).removeItem((NodeBase)child);
                        ((ContainerNode)parent).addChild(replacement, i);
                        ((BinaryOperatorAssignmentNode)child).setParent(null);
                        child = replacement;
                    }
                }
            } else if (child instanceof DynamicAccessNode && ArrayLikeUtil.isArrayLikeCandidate(dynNode = (DynamicAccessNode)child, project)) {
                ExpressionNodeBase indexArg2;
                String getterArg;
                IMetaTag arrayLikeTag2;
                IDefinition metaSource2;
                ITypeDefinition target2;
                FunctionCallNode replacement2;
                String getterArg2;
                if (parent instanceof BaseStatementExpressionNode) {
                    target = dynNode.getLeftOperandNode().resolveType(project);
                    metaSource = ArrayLikeUtil.resolveArrayLikeDefinitionSource(target, project);
                    arrayLikeTag = ArrayLikeUtil.getArrayLikeMetaData(metaSource);
                    getterArg2 = ArrayLikeUtil.getGetterArg(arrayLikeTag);
                    if (!getterArg2.equals(INDEX_ACCESS_UNCHANGED)) {
                        indexArg = (ExpressionNodeBase)dynNode.getRightOperandNode();
                        replacement2 = ArrayLikeUtil.createDynamicAccessMutation(dynNode, getterArg2);
                        replacement2.getArgumentsNode().addChild(indexArg);
                        replacement2.getArgumentsNode().setParent(replacement2);
                        ((BaseStatementExpressionNode)parent).setStatementExpression(replacement2);
                        replacement2.setParent(parent);
                        dynNode.setParent(null);
                        child = replacement2;
                    }
                } else if (parent instanceof ContainerNode) {
                    target = dynNode.getLeftOperandNode().resolveType(project);
                    metaSource = ArrayLikeUtil.resolveArrayLikeDefinitionSource(target, project);
                    arrayLikeTag = ArrayLikeUtil.getArrayLikeMetaData(metaSource);
                    getterArg2 = ArrayLikeUtil.getGetterArg(arrayLikeTag);
                    if (!getterArg2.equals(INDEX_ACCESS_UNCHANGED)) {
                        indexArg = (ExpressionNodeBase)dynNode.getRightOperandNode();
                        replacement2 = ArrayLikeUtil.createDynamicAccessMutation(dynNode, getterArg2);
                        replacement2.getArgumentsNode().addChild(indexArg);
                        replacement2.getArgumentsNode().setParent(replacement2);
                        ((ContainerNode)parent).removeItem((NodeBase)child);
                        ((ContainerNode)parent).addChild(replacement2, i);
                        dynNode.setParent(null);
                        child = replacement2;
                    }
                } else if (parent instanceof BinaryOperatorNodeBase) {
                    BinaryOperatorNodeBase binaryOp = (BinaryOperatorNodeBase)parent;
                    target2 = dynNode.getLeftOperandNode().resolveType(project);
                    metaSource2 = ArrayLikeUtil.resolveArrayLikeDefinitionSource(target2, project);
                    arrayLikeTag2 = ArrayLikeUtil.getArrayLikeMetaData(metaSource2);
                    getterArg = ArrayLikeUtil.getGetterArg(arrayLikeTag2);
                    if (!getterArg.equals(INDEX_ACCESS_UNCHANGED)) {
                        indexArg2 = (ExpressionNodeBase)dynNode.getRightOperandNode();
                        replacement = ArrayLikeUtil.createDynamicAccessMutation(dynNode, getterArg);
                        replacement.getArgumentsNode().addChild(indexArg2);
                        replacement.getArgumentsNode().setParent(replacement);
                        if (binaryOp.getLeftOperandNode() == child) {
                            binaryOp.setLeftOperandNode(replacement);
                        } else {
                            binaryOp.setRightOperandNode(replacement);
                        }
                        replacement.setParent(binaryOp);
                        dynNode.setParent(null);
                        child = replacement;
                    }
                } else if (parent instanceof VariableNode) {
                    VariableNode variableNode = (VariableNode)parent;
                    target2 = dynNode.getLeftOperandNode().resolveType(project);
                    metaSource2 = ArrayLikeUtil.resolveArrayLikeDefinitionSource(target2, project);
                    arrayLikeTag2 = ArrayLikeUtil.getArrayLikeMetaData(metaSource2);
                    getterArg = ArrayLikeUtil.getGetterArg(arrayLikeTag2);
                    if (!getterArg.equals(INDEX_ACCESS_UNCHANGED)) {
                        indexArg2 = (ExpressionNodeBase)dynNode.getRightOperandNode();
                        replacement = ArrayLikeUtil.createDynamicAccessMutation(dynNode, getterArg);
                        replacement.getArgumentsNode().addChild(indexArg2);
                        replacement.getArgumentsNode().setParent(replacement);
                        variableNode.setAssignedValue(null, replacement);
                        replacement.setParent(variableNode);
                        dynNode.setParent(null);
                        child = replacement;
                    }
                } else if (parent instanceof UnaryOperatorNodeBase) {
                    target = dynNode.getLeftOperandNode().resolveType(project);
                    metaSource = ArrayLikeUtil.resolveArrayLikeDefinitionSource(target, project);
                    arrayLikeTag = ArrayLikeUtil.getArrayLikeMetaData(metaSource);
                    getterArg2 = ArrayLikeUtil.getGetterArg(arrayLikeTag);
                    String setterArg = ArrayLikeUtil.getSetterArg(arrayLikeTag);
                    if (!INDEX_ACCESS_UNCHANGED.equals(getterArg2) || !INDEX_ACCESS_UNCHANGED.equals(setterArg)) {
                        UnaryOperatorNodeBase unaryOperatorNodeBase = (UnaryOperatorNodeBase)parent;
                        SourceLocation loc = new SourceLocation();
                        loc.setSourcePath(unaryOperatorNodeBase.getSourcePath());
                        if (unaryOperatorNodeBase.getOperandNode().getAbsoluteStart() > unaryOperatorNodeBase.getOperatorAbsoluteStart()) {
                            loc.setColumn(unaryOperatorNodeBase.getColumn());
                            loc.setLine(unaryOperatorNodeBase.getLine());
                            loc.setEndColumn(unaryOperatorNodeBase.getOperatorAbsoluteStart() - unaryOperatorNodeBase.getOperandNode().getAbsoluteStart());
                            loc.setEndLine(unaryOperatorNodeBase.getLine());
                            loc.setStart(unaryOperatorNodeBase.getStart());
                            loc.setEnd(unaryOperatorNodeBase.getOperatorAbsoluteStart() - 1);
                        } else {
                            loc.setColumn(unaryOperatorNodeBase.getOperandNode().getEndColumn());
                            loc.setLine(unaryOperatorNodeBase.getOperandNode().getEndLine());
                            loc.setEndColumn(unaryOperatorNodeBase.getEndColumn());
                            loc.setEndLine(unaryOperatorNodeBase.getEndLine());
                            loc.setStart(unaryOperatorNodeBase.getOperandNode().getAbsoluteStart());
                            loc.setStart(unaryOperatorNodeBase.getAbsoluteEnd());
                        }
                        ArrayLikeUsageErrorProblem usageError = new ArrayLikeUsageErrorProblem(loc, "Unary Operation not supported");
                        project.getProblems().add(usageError);
                    }
                }
            }
            if (!(child instanceof FixedChildrenNode) && !(child instanceof TreeNode)) continue;
            ArrayLikeUtil.preProcessGetterSetters(project, node, (NodeBase)child);
        }
    }

    private static boolean isArrayLikeCandidate(DynamicAccessNode dynNode, ICompilerProject project) {
        if (!(project instanceof IRoyaleProject)) {
            return false;
        }
        boolean isCandidate = false;
        ITypeDefinition dynType = dynNode.getRightOperandNode().resolveType(project);
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER).equals(dynType) || project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).equals(dynType) || project.getBuiltinType(IASLanguageConstants.BuiltinType.INT).equals(dynType)) {
            ITypeDefinition target = dynNode.getLeftOperandNode().resolveType(project);
            isCandidate = ArrayLikeUtil.isArrayLike(target, project);
        }
        return isCandidate;
    }

    private static FunctionCallNode createDynamicAccessMutation(DynamicAccessNode original, String methodName) {
        ExpressionNodeBase base = (ExpressionNodeBase)original.getLeftOperandNode();
        IdentifierNode methodCallName = new IdentifierNode(methodName);
        MemberAccessExpressionNode nameNode = new MemberAccessExpressionNode(base, null, (ExpressionNodeBase)methodCallName);
        base.setParent(nameNode);
        methodCallName.setParent(nameNode);
        FunctionCallNode replacement = new FunctionCallNode(nameNode);
        nameNode.setParent(replacement);
        return replacement;
    }

    public static void preProcessLoopChecks(ASScope searchScope, IRoyaleProject project) {
        ScopedBlockNode funcScopeNode = (ScopedBlockNode)searchScope.getScopeNode();
        IForLoopNode[] forLoops = searchScope.getLoopChecks(true);
        List<IForLoopNode> forLoopList = Arrays.asList(forLoops);
        boolean importAdded = false;
        ArrayList<String> usedIterators = new ArrayList<String>();
        for (IForLoopNode loopNode : forLoopList) {
            ITypeDefinition targetType;
            int depth = 0;
            IASNode nodeCheck = loopNode;
            while (nodeCheck.getParent() != null && nodeCheck.getParent() != funcScopeNode) {
                if (nodeCheck.getParent() instanceof IForLoopNode && forLoopList.indexOf(nodeCheck.getParent()) != -1) {
                    ++depth;
                }
                nodeCheck = nodeCheck.getParent();
            }
            boolean isForeach = loopNode.getKind() == IForLoopNode.ForLoopKind.FOR_EACH;
            String arrIter = ARRAY_LIKE_FOREACH_ITERATOR_VARNAME_BASE + depth;
            ITypeDefinition xmlListDef = project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
            try {
                BinaryOperatorInNode conditionalExpressions = (BinaryOperatorInNode)loopNode.getConditionalExpressionNodes()[0];
                if (conditionalExpressions.getRightOperandNode() instanceof IFunctionCallNode) {
                    ExpressionNodeBase nameNode = ((FunctionCallNode)conditionalExpressions.getRightOperandNode()).getNameNode();
                    if (nameNode instanceof IMemberAccessExpressionNode) {
                        IFunctionDefinition funcDef = (IFunctionDefinition)((IMemberAccessExpressionNode)((Object)nameNode)).getRightOperandNode().resolve(project);
                        targetType = funcDef.resolveReturnType(project);
                    } else {
                        targetType = conditionalExpressions.getRightOperandNode().resolveType(project);
                    }
                } else if (conditionalExpressions.getRightOperandNode() instanceof IMemberAccessExpressionNode) {
                    targetType = conditionalExpressions.getRightOperandNode().resolveType(project);
                    IExpressionNode left = ((IMemberAccessExpressionNode)conditionalExpressions.getRightOperandNode()).getLeftOperandNode();
                    while (targetType == null && left != null) {
                        targetType = left.resolveType(project);
                        if (targetType == null) {
                            if (left instanceof IMemberAccessExpressionNode || left instanceof IDynamicAccessNode) {
                                left = ((IBinaryOperatorNode)left).getLeftOperandNode();
                                continue;
                            }
                            left = null;
                            continue;
                        }
                        if (SemanticUtils.isXMLish(targetType, project)) {
                            targetType = xmlListDef;
                        }
                        if (targetType == xmlListDef) continue;
                        targetType = null;
                        left = null;
                    }
                } else {
                    targetType = conditionalExpressions.getRightOperandNode().resolveType(project);
                }
            }
            catch (Exception e) {
                continue;
            }
            if (!ArrayLikeUtil.isArrayLike(targetType, project)) continue;
            if (!importAdded) {
                List<String> imports;
                if (searchScope.getImports() != null && (imports = Arrays.asList(searchScope.getImports())).contains(ARRAYLIKE_GENERIC_SUPPORT_ITERATOR_FACTORY_FUNC_QNAME)) {
                    importAdded = true;
                }
                if (!importAdded) {
                    searchScope.addImport(ARRAYLIKE_GENERIC_SUPPORT_ITERATOR_FACTORY_FUNC_QNAME);
                    importAdded = true;
                }
            }
            ASProjectScope projectScope = (ASProjectScope)project.getScope();
            boolean alreadyUsed = usedIterators.contains(arrIter);
            if (!alreadyUsed) {
                usedIterators.add(arrIter);
            }
            IDefinition metaSource = ArrayLikeUtil.resolveArrayLikeDefinitionSource(targetType, project);
            IMetaTag arrayLikeTag = ArrayLikeUtil.getArrayLikeMetaData(metaSource);
            boolean useDynamicAccess = !project.isStaticTypedTarget();
            ArrayLikeLoopMutation mutation = ArrayLikeUtil.createArrayLikeLoopMutation((ForLoopNode)loopNode, arrIter, useDynamicAccess);
            String generatorFuncName = ARRAYLIKE_GENERIC_SUPPORT_ITERATOR_FACTORY_FUNC;
            IdentifierNode funcName = new IdentifierNode(generatorFuncName);
            FunctionCallNode specificIteratorFunc = new FunctionCallNode(funcName);
            specificIteratorFunc.getNameNode().setParent(specificIteratorFunc);
            specificIteratorFunc.getArgumentsNode().addItem((NodeBase)((Object)mutation.getIterationTarget()));
            specificIteratorFunc.getArgumentsNode().setParent(specificIteratorFunc);
            LiteralNode metaArg = new LiteralNode(ILiteralNode.LiteralType.STRING, ArrayLikeUtil.wrapQuotes(ArrayLikeUtil.getLengthArg(arrayLikeTag)));
            metaArg.setSynthetic(true);
            specificIteratorFunc.getArgumentsNode().addItem(metaArg);
            String getter = ArrayLikeUtil.getGetterArg(arrayLikeTag);
            if (getter.equals(INDEX_ACCESS_UNCHANGED)) {
                metaArg = new LiteralNode(ILiteralNode.LiteralType.NULL, "null");
                metaArg.setSynthetic(true);
            } else {
                metaArg = new LiteralNode(ILiteralNode.LiteralType.STRING, ArrayLikeUtil.wrapQuotes(ArrayLikeUtil.getGetterArg(arrayLikeTag)));
                metaArg.setSynthetic(true);
            }
            specificIteratorFunc.getArgumentsNode().addItem(metaArg);
            metaArg = new LiteralNode(ILiteralNode.LiteralType.BOOLEAN, ArrayLikeUtil.getLengthAccessArg(arrayLikeTag).equals(LENGTH_ACCESS_METHOD) ? "true" : "false");
            metaArg.setSynthetic(true);
            specificIteratorFunc.getArgumentsNode().addItem(metaArg);
            if (!isForeach) {
                metaArg = new LiteralNode(ILiteralNode.LiteralType.BOOLEAN, "true");
                metaArg.setSynthetic(true);
                specificIteratorFunc.getArgumentsNode().addItem(metaArg);
            }
            mutation.prepareConditionals(!alreadyUsed, specificIteratorFunc);
            mutation.prepareContent();
            Collection<ICompilerProblem> problems = ((ForLoopNode)loopNode).processMutation(mutation, searchScope);
            if (problems.size() <= 0) continue;
            project.getProblems().addAll(problems);
        }
    }

    private static void resetLookupsIfNeeded(ICompilerProject project) {
        if (currentProject == project.hashCode()) {
            return;
        }
        arrayLikeLookups = new HashMap(20);
        currentProject = project.hashCode();
    }

    public static boolean definitionIsArrayLike(IDefinition definition) {
        return (definition instanceof IClassDefinition || definition instanceof IInterfaceDefinition) && definition.hasMetaTagByName("RoyaleArrayLike");
    }

    public static boolean validateArrayLikeDefinition(IDefinition definition, ICompilerProject project, List<ICompilerProblem> problems) {
        ASProjectScope projectScope;
        IDefinition def;
        IMetaTag arrayLikeTag = definition.getMetaTagByName("RoyaleArrayLike");
        if (!(project instanceof IRoyaleProject)) {
            if (problems != null) {
                problems.add(new ArrayLikeConfigurationErrorProblem(arrayLikeTag, "This is not a Royale Project. Only Royale projects support RoyaleArrayLike"));
            }
            return false;
        }
        String lengthCheck = arrayLikeTag.getAttributeValue(LENGTH_ARG);
        boolean pass = true;
        if (lengthCheck == null) {
            pass = false;
            if (problems != null) {
                problems.add(new ArrayLikeConfigurationErrorProblem(arrayLikeTag, "Missing 'length' metadata argument"));
            }
        }
        if (pass) {
            String getterCheck = arrayLikeTag.getAttributeValue(GETVALUE_ARG);
            if (getterCheck == null) {
                pass = false;
                if (problems != null) {
                    problems.add(new ArrayLikeConfigurationErrorProblem(arrayLikeTag, "Missing 'getValue' metadata argument"));
                }
            } else if (getterCheck != INDEX_ACCESS_UNCHANGED) {
                // empty if block
            }
        }
        String setterCheck = null;
        if (pass) {
            setterCheck = arrayLikeTag.getAttributeValue(SETVALUE_ARG);
            if (setterCheck == null) {
                pass = false;
                if (problems != null) {
                    problems.add(new ArrayLikeConfigurationErrorProblem(arrayLikeTag, "Missing 'setValue' metadata argument"));
                }
            } else if (setterCheck != INDEX_ACCESS_UNCHANGED) {
                // empty if block
            }
        }
        if (pass && !setterCheck.equals(INDEX_ACCESS_UNCHANGED)) {
            String setterSequenceCheck = arrayLikeTag.getAttributeValue(SETTER_ARG_SEQUENCE_ARG);
            if (setterSequenceCheck == null) {
                setterSequenceCheck = "value,index";
            }
            if (!setterSequenceCheck.equals("value,index") && !setterSequenceCheck.equals(SETTER_ARG_SEQUENCE_INDEX_VALUE)) {
                pass = false;
                if (problems != null) {
                    problems.add(new ArrayLikeConfigurationErrorProblem(arrayLikeTag, "Missing 'setValue' metadata argument"));
                }
            }
        }
        if (pass) {
            String lengthAccess = arrayLikeTag.getAttributeValue(LENGTH_ACCESS_ARG);
            if (lengthAccess == null) {
                lengthAccess = "getter";
            }
            if (!lengthAccess.equals("getter") && !lengthAccess.equals(LENGTH_ACCESS_METHOD)) {
                pass = false;
                if (problems != null) {
                    problems.add(new ArrayLikeConfigurationErrorProblem(arrayLikeTag, "Metadata argument for 'lengthAccess' missing or invalid"));
                }
            }
        }
        if (pass && !((def = (projectScope = (ASProjectScope)project.getScope()).findDefinitionByName(ARRAYLIKE_GENERIC_SUPPORT_ITERATOR_FACTORY_FUNC_QNAME)) instanceof FunctionDefinition)) {
            problems.add(new ArrayLikeConfigurationErrorProblem(arrayLikeTag, "The RoyaleArrayLike Tag is valid, but there is a missing concrete reference in the project to: org.apache.royale.language.iterator.arrayLike (which is required)"));
            pass = false;
        }
        return pass;
    }

    public static synchronized boolean isArrayLike(IDefinition definition, ICompilerProject project) {
        if (definition != null && project instanceof IRoyaleProject) {
            ArrayLikeUtil.resetLookupsIfNeeded(project);
            if (definition instanceof IClassDefinition) {
                String qName = definition.getQualifiedName();
                if (arrayLikeLookups.containsKey(qName)) {
                    return arrayLikeLookups.get(qName) != null;
                }
                return ArrayLikeUtil.checkClass((IClassDefinition)definition, (IRoyaleProject)project);
            }
            if (definition instanceof IInterfaceDefinition) {
                String qName = definition.getQualifiedName();
                if (arrayLikeLookups.containsKey(qName)) {
                    return arrayLikeLookups.get(qName) != null;
                }
                return ArrayLikeUtil.checkInterface((IInterfaceDefinition)definition, (IRoyaleProject)project);
            }
        }
        return false;
    }

    private static boolean checkClass(IClassDefinition definition, IRoyaleProject project) {
        String qName = definition.getQualifiedName();
        ArrayLikeUtil.resetLookupsIfNeeded(project);
        if (arrayLikeLookups.containsKey(qName)) {
            return arrayLikeLookups.get(qName) != null;
        }
        boolean isArrayLike = false;
        isArrayLike = definition.hasMetaTagByName("RoyaleArrayLike");
        String originalQName = qName;
        if (!isArrayLike) {
            IClassDefinition baseClassDef;
            Set<IInterfaceDefinition> interfaces = definition.resolveAllInterfaces(project);
            for (IInterfaceDefinition interfaceDef : interfaces) {
                isArrayLike = ArrayLikeUtil.checkInterface(interfaceDef, project);
                if (!isArrayLike) continue;
                qName = arrayLikeLookups.get(interfaceDef.getQualifiedName());
                break;
            }
            if (!isArrayLike && (baseClassDef = definition.resolveBaseClass(project)) != null && (isArrayLike = ArrayLikeUtil.checkClass(baseClassDef, project))) {
                qName = arrayLikeLookups.get(baseClassDef.getQualifiedName());
            }
        }
        arrayLikeLookups.put(originalQName, isArrayLike ? qName : null);
        return isArrayLike;
    }

    private static boolean checkInterface(IInterfaceDefinition interfaceDefinition, IRoyaleProject project) {
        String qName = interfaceDefinition.getQualifiedName();
        ArrayLikeUtil.resetLookupsIfNeeded(project);
        if (arrayLikeLookups.containsKey(qName)) {
            return arrayLikeLookups.get(qName) != null;
        }
        boolean isArrayLike = interfaceDefinition.hasMetaTagByName("RoyaleArrayLike");
        String originalQName = qName;
        if (!isArrayLike) {
            qName = null;
        }
        ArrayList<String> ancestry = null;
        if (!isArrayLike) {
            ancestry = new ArrayList<String>();
            Iterator<IInterfaceDefinition> interfaceIterator = interfaceDefinition.interfaceIterator(project, false);
            while (interfaceIterator.hasNext()) {
                interfaceDefinition = interfaceIterator.next();
                qName = interfaceDefinition.getQualifiedName();
                if (arrayLikeLookups.containsKey(qName)) {
                    qName = arrayLikeLookups.get(qName);
                    break;
                }
                ancestry.add(qName);
                isArrayLike = interfaceDefinition.hasMetaTagByName("RoyaleArrayLike");
                if (isArrayLike) break;
                qName = null;
            }
        }
        if (ancestry != null) {
            for (String ancestorQName : ancestry) {
                arrayLikeLookups.put(ancestorQName, qName);
            }
        }
        arrayLikeLookups.put(originalQName, qName);
        return isArrayLike;
    }

    public static IDefinition resolveArrayLikeDefinitionSource(IDefinition sourceDefinition, ICompilerProject project) {
        IDefinition metaSource = null;
        if (sourceDefinition != null) {
            ArrayLikeUtil.resetLookupsIfNeeded(project);
            String sourceDefinitionQName = sourceDefinition.getQualifiedName();
            if (arrayLikeLookups.containsKey(sourceDefinitionQName)) {
                String resolvedQName = arrayLikeLookups.get(sourceDefinitionQName);
                metaSource = !sourceDefinitionQName.equals(resolvedQName) ? project.resolveQNameToDefinition(resolvedQName) : sourceDefinition;
            }
        }
        return metaSource;
    }

    public static IMetaTag getArrayLikeMetaData(IDefinition definition) {
        return definition.getMetaTagByName("RoyaleArrayLike");
    }

    public static String getLengthArg(IMetaTag arrayLikeTag) {
        return arrayLikeTag.getAttributeValue(LENGTH_ARG);
    }

    public static String getGetterArg(IMetaTag arrayLikeTag) {
        return arrayLikeTag.getAttributeValue(GETVALUE_ARG);
    }

    public static String getSetterArg(IMetaTag arrayLikeTag) {
        return arrayLikeTag.getAttributeValue(SETVALUE_ARG);
    }

    public static String getSetterArgSequenceArg(IMetaTag arrayLikeTag) {
        String val = arrayLikeTag.getAttributeValue(SETTER_ARG_SEQUENCE_ARG);
        if (val == null) {
            val = "value,index";
        }
        return val;
    }

    public static String getLengthAccessArg(IMetaTag arrayLikeTag) {
        String val = arrayLikeTag.getAttributeValue(LENGTH_ACCESS_ARG);
        if (val == null) {
            val = "getter";
        }
        return val;
    }

    public static ArrayLikeLoopMutation createArrayLikeLoopMutation(ForLoopNode loopNode, String arrIterName, boolean useDynamicAccess) {
        return new ArrayLikeLoopMutation(loopNode, arrIterName, useDynamicAccess);
    }
}

