////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package
{
    /**
     *  The MaterialIconType class list all possible icons
     *  found in https://material.io/icons/ to use with the 
     *  Icon class.
     *
     *  @langversion 3.0
     *  @playerversion Flash 10.2
     *  @playerversion AIR 2.6
     *  @productversion Royale 0.9.3
     */
    public class MaterialIconType
    {
        /**
		 *  constructor.
         * 
		 *  @langversion 3.0
		 *  @playerversion Flash 10.2
		 *  @playerversion AIR 2.6
		 *  @productversion Royale 0.9.3
		 */
		public function MaterialIconType()
		{
			super();
		}

        public static const _3D_ROTATION:String = '3d_rotation';
        public static const ACCESSIBILITY:String = 'accessibility';
        public static const ACCESSIBLE:String = 'accessible';
        public static const ACCOUNT_BALANCE:String = 'account_balance';
        public static const ACCOUNT_BALANCE_WALLET:String = 'account_balance_wallet';
        public static const ACCOUNT_BOX:String = 'account_box';
        public static const ACCOUNT_CIRCLE:String = 'account_circle';
        public static const ADD_SHOPING_CART:String = 'add_shopping_cart';
        public static const ALARM:String = 'alarm';
        public static const ALARM_ADD:String = 'alarm_add';

        public static const ALARM_OFF:String = 'alarm_off';
        public static const ALARM_ON:String = 'alarm_on';
        public static const ALL_OUT:String = 'all_out';
        public static const ANDROID:String = 'android';
        public static const ANNOUNCEMENT:String = 'announcement';
        public static const ASPECT_RATIO:String = 'aspect_ratio';
        public static const ASSESSMENT:String = 'assessment';
        public static const ASSIGNMENT:String = 'assignment';
        public static const ASSIGNMENT_IND:String = 'assignment_ind';
        public static const ASSIGNMENT_LATE:String = 'assignment_late';

        public static const ASSIGNMENT_RETURN:String = 'assignment_return';
        public static const ASSIGNMENT_RETURNED:String = 'assignment_returned';
        public static const ASSIGNMENT_TURNED_IN:String = 'assignment_turned_in';
        public static const AUTORENEW:String = 'autorenew';
        public static const BACKUP:String = 'backup';
        public static const BOOK:String = 'book';
        public static const BOOKMARK:String = 'bookmark';
        public static const BOOKMARK_BORDER:String = 'bookmark_border';
        public static const BUG_REPORT:String = 'bug_report';
        public static const BUILD:String = 'build';

        public static const CACHED:String = 'cached';
        public static const CAMERA_ENHANCE:String = 'camera_enhance';
        public static const CARD_GIFTCARD:String = 'card_giftcard';
        public static const CARD_MEMBERSHIP:String = 'card_membership';
        public static const CARD_TRAVEL:String = 'card_travel';
        public static const CHANGE_HISTORY:String = 'change_history';
        public static const CHECK_CIRCLE:String = 'check_circle';
        public static const CHORME_READER_MODE:String = 'chrome_reader_mode';
        public static const CLASS:String = 'class';
        public static const CODE:String = 'code';

        public static const COMPARE_ARROWS:String = 'compare_arrows';
        public static const COPYRIGHT:String = 'copyright';
        public static const CREDIT_CARD:String = 'credit_card';
        public static const DASHBOARD:String = 'dashboard';
        public static const DATE_RANGE:String = 'date_range';
        public static const DELETE:String = 'delete';
        public static const DELETE_FOREVER:String = 'delete_forever';
        public static const DESCRIPTION:String = 'description';
        public static const DNS:String = 'dns';
        public static const DONE:String = 'done';

        public static const DONE_ALL:String = 'done_all';
        public static const DONUT_LARGE:String = 'donut_large';
        public static const DONUT_SMALL:String = 'donut_small';
        public static const EJECT:String = 'eject';
        public static const EURO_SYMBOL:String = 'euro_symbol';
        public static const EVENT:String = 'event';
        public static const EVENT_SEAT:String = 'event_seat';
        public static const EXIT_TO_APP:String = 'exit_to_app';
        public static const EXPLORE:String = 'explore';
        public static const EXTENSION:String = 'extension';

        public static const FACE:String = 'face';
        public static const FAVORITE:String = 'favorite';
        public static const FAVORITE_BORDER:String = 'favorite_border';
        public static const FEEDBACK:String = 'feedback';
        public static const FIND_IN_PAGE:String = 'find_in_page';
        public static const FIND_REPLACE:String = 'find_replace';
        public static const FINGERPRINT:String = 'fingerprint';
        public static const FLIGHT_LAND:String = 'flight_land';
        public static const FLIGHT_TAKEOFF:String = 'flight_takeoff';
        public static const FLIP_TO_BACK:String = 'flip_to_back';

        public static const FLIP_TO_FRONT:String = 'flip_to_front';
        public static const G_TRANSLATE:String = 'g_translate';
        public static const GAVEL:String = 'gavel';
        public static const GET_APP:String = 'get_app';
        public static const GIF:String = 'gif';
        public static const GRADE:String = 'grade';
        public static const GROUP_WORK:String = 'group_work';
        public static const HELP:String = 'help';
        public static const HELP_OUTLINE:String = 'help_outline';
        public static const HIGHLIGHT_OFF:String = 'highlight_off';

        public static const HISTORY:String = 'history';
        public static const HOME:String = 'home';
        public static const HOURGLASS_EMPTY:String = 'hourglass_empty';
        public static const HOURGLASS_FULL:String = 'hourglass_full';
        public static const HTTP:String = 'http';
        public static const HTTPS:String = 'https';
        public static const IMPORTANT_DEVICES:String = 'important_devices';
        public static const INFO:String = 'info';
        public static const INFO_OUTLINE:String = 'info_outline';
        public static const INPUT:String = 'input';

        public static const INVERT_COLORS:String = 'invert_colors';
        public static const LABEL:String = 'label';
        public static const LABEL_OUTLINE:String = 'label_outline';
        public static const LANGUAGE:String = 'language';
        public static const LAUNCH:String = 'launch';
        public static const LIGHTBULB_OUTLINE:String = 'lightbulb_outline';
        public static const LINE_STYLE:String = 'line_style';
        public static const LINE_WEIGHT:String = 'line_weight';
        public static const LIST:String = 'list';
        public static const LOCK:String = 'lock';

        public static const LOCK_OPEN:String = 'lock_open';
        public static const LOCK_OUTLINE:String = 'lock_outline';
        public static const LOYALTY:String = 'loyalty';
        public static const MARKUNREAD_MAILBOX:String = 'markunread_mailbox';
        public static const MOTORCYCLE:String = 'motorcycle';
        public static const NOTE_ADD:String = 'note_add';
        public static const OFFLINE_PIN:String = 'offline_pin';
        public static const OPACITY:String = 'opacity';
        public static const OPEN_IN_BROWSER:String = 'open_in_browser';
        public static const OPEN_IN_NEW:String = 'open_in_new';

        public static const OPEN_WITH:String = 'open_with';
        public static const PAGEVIEW:String = 'pageview';
        public static const PAN_TOOL:String = 'pan_tool';
        public static const PAYMENT:String = 'payment';
        public static const PERM_CAMERA_MIC:String = 'perm_camera_mic';
        public static const PERM_CONTACT_CALENDAR:String = 'perm_contact_calendar';
        public static const PERM_DATA_SETTING:String = 'perm_data_setting';
        public static const PERM_DEVICE_INFORMATION:String = 'perm_device_information';
        public static const PERM_IDENTITY:String = 'perm_identity';
        public static const PERM_MEDIA:String = 'perm_media';

        public static const PERM_PHONE_MSG:String = 'perm_phone_msg';
        public static const PERM_SCAN_WIFI:String = 'perm_scan_wifi';
        public static const PETS:String = 'pets';
        public static const PICTURE_IN_PICTURE:String = 'picture_in_picture';
        public static const PICTURE_IN_PICTURE_ALT:String = 'picture_in_picture_alt';
        public static const PLAY_FOR_WORK:String = 'play_for_work';
        public static const POLYMER:String = 'polymer';
        public static const POWER_SETTINGS_NEW:String = 'power_settings_new';
        public static const PREGNANT_WOMAN:String = 'pregnant_woman';
        public static const PRINT:String = 'print';
        
        public static const QUERY_BUILDER:String = 'query_builder';
        public static const QUESTION_ANSWER:String = 'question_answer';
        public static const RECEIPT:String = 'receipt';
        public static const RECORD_VOICE_OVER:String = 'record_voice_over';
        public static const REDEEM:String = 'redeem';
        public static const REMOVE_SHOPPING_CART:String = 'remove_shopping_cart';
        public static const REORDER:String = 'reorder';
        public static const REPORT_PROBLEM:String = 'report_problem';
        public static const RESTORE:String = 'restore';
        public static const RESTORE_PAGE:String = 'restore_page';

        public static const ROOM:String = 'room';
        public static const ROUND_CORNER:String = 'rounded_corner';
        public static const ROWING:String = 'rowing';
        public static const SCHEDULE:String = 'schedule';
        public static const SEARCH:String = 'search';
        public static const SETTINGS:String = 'settings';
        public static const SETTINGS_APPLICATIONS:String = 'settings_applications';
        public static const SETTINGS_BACKUP_RESTORE:String = 'settings_backup_restore';
        public static const SETTINGS_BLUETOOTH:String = 'settings_bluetooth';
        public static const SETTINGS_BRIGHTNESS:String = 'settings_brightness';

        public static const SETTINGS_CELL:String = 'settings_cell';
        public static const SETTINGS_ETHERNET:String = 'settings_ethernet';
        public static const SETTINGS_INPUT_ANTENNA:String = 'settings_input_antenna';
        public static const SETTINGS_INPUT_COMPONENT:String = 'settings_input_component';
        public static const SETTINGS_INPUT_COMPOSITE:String = 'settings_input_composite';
        public static const SETTINGS_INPUT_HDMI:String = 'settings_input_hdmi';
        public static const SETTINGS_INPUT_SVIDEO:String = 'settings_input_svideo';
        public static const SETTINGS_OVERSCAN:String = 'settings_overscan';
        public static const SETTINGS_PHONE:String = 'settings_phone';
        public static const SETTINGS_POWER:String = 'settings_power';

        public static const SETTINGS_REMOTE:String = 'settings_remote';
        public static const SETTINGS_VOICE:String = 'settings_voice';
        public static const SHOP:String = 'shop';
        public static const SHOP_TWO:String = 'shop_two';
        public static const SHOPPING_BASKET:String = 'shopping_basket';
        public static const SHOPPING_CART:String = 'shopping_cart';
        public static const SPEAKER_NOTES:String = 'speaker_notes';
        public static const SPEAKER_NOTES_OFF:String = 'speaker_notes_off';
        public static const SPELLCHECK:String = 'spellcheck';
        public static const STAR_RATE:String = 'star_rate';

        public static const STARS:String = 'stars';
        public static const STORE:String = 'store';
        public static const SUBJECT:String = 'subject';
        public static const SUPERVISOR_ACCOUNT:String = 'supervisor_account';
        public static const SWAP_HORIZ:String = 'swap_horiz';
        public static const SWAP_VERT:String = 'swap_vert';
        public static const SWAP_VERTICAL_CIRCLE:String = 'swap_vertical_circle';
        public static const SYSTEM_UPDATE_ALT:String = 'system_update_alt';
        public static const TAB:String = 'tab';
        public static const TAB_UNSELECTED:String = 'tab_unselected';

        public static const THEATERS:String = 'theaters';
        public static const THUMB_DOWN:String = 'thumb_down';
        public static const THUMB_UP:String = 'thumb_up';
        public static const THUMB_UP_DOWN:String = 'thumbs_up_down';
        public static const TIMELINE:String = 'timeline';
        public static const TOC:String = 'toc';
        public static const TODAY:String = 'today';
        public static const TOLL:String = 'toll';
        public static const TOUCH_APP:String = 'touch_app';
        public static const TRACK_CHANGES:String = 'track_changes';
        
        public static const TRANSLATE:String = 'translate';
        public static const TRENDING_DOWN:String = 'trending_down';
        public static const TRENDING_FLAT:String = 'trending_flat';
        public static const TRENDING_UP:String = 'trending_up';
        public static const TURNED_IN:String = 'turned_in';
        public static const TURNED_IN_NOT:String = 'turned_in_not';
        public static const UPDATE:String = 'update';
        public static const VERIFIED_USER:String = 'verified_user';
        public static const VIEW_AGENDA:String = 'view_agenda';
        public static const VIEW_ARRAY:String = 'view_array';

        public static const VIEW_CAROUSEL:String = 'view_carousel';
        public static const VIEW_COLUMN:String = 'view_column';
        public static const VIEW_DAY:String = 'view_day';
        public static const VIEW_HEADLINE:String = 'view_headline';
        public static const VIEW_LIST:String = 'view_list';
        public static const VIEW_MODULE:String = 'view_module';
        public static const VIEW_QUILT:String = 'view_quilt';
        public static const VIEW_STREAM:String = 'view_stream';
        public static const VIEW_WEEK:String = 'view_week';
        public static const VISIBILITY:String = 'visibility';

        public static const VISIBILITY_OFF:String = 'visibility_off';
        public static const WATCH_LATER:String = 'watch_later';
        public static const WORK:String = 'work';
        public static const YOUTUBE_SEARCHED_FOR:String = 'youtube_searched_for';
        public static const ZOMM_IN:String = 'zoom_in';
        public static const ZOOM_OUT:String = 'zoom_out';
        public static const ADD_ALERT:String = 'add_alert';
        public static const ERROR:String = 'error';
        public static const ERROR_OUTLINE:String = 'error_outline';
        public static const WARNING:String = 'warning';

        public static const ADD_TO_QUEUE:String = 'add_to_queue';
        public static const AIRPLAY:String = 'airplay';
        public static const ALBUM:String = 'album';
        public static const ART_TRACK:String = 'art_track';
        public static const AV_TIMER:String = 'av_timer';
        public static const BRANDING_WATERMARK:String = 'branding_watermark';
        public static const CALL_TO_ACTION:String = 'call_to_action';
        public static const CLOSED_CAPTION:String = 'closed_caption';
        public static const EQUALIZER:String = 'equalizer';
        public static const EXPLICIT:String = 'explicit';

        public static const FAST_FORWARD:String = 'fast_forward';
        public static const FAST_REWIND:String = 'fast_rewind';
        public static const FEATURE_PLAY_LIST:String = 'featured_play_list';
        public static const FEATURE_VIDEO:String = 'featured_video';
        public static const FIBER_DVR:String = 'fiber_dvr';
        public static const FIBER_MANUAL_RECORD:String = 'fiber_manual_record';
        public static const FIBER_NEW:String = 'fiber_new';
        public static const FIBER_PIN:String = 'fiber_pin';
        public static const FIBER_SMART_RECORD:String = 'fiber_smart_record';
        public static const FORWARD_10:String = 'forward_10';

        public static const FORWARD_30:String = 'forward_30';
        public static const FORWARD_5:String = 'forward_5';
        public static const GAMES:String = 'games';
        public static const HD:String = 'hd';
        public static const HEARING:String = 'hearing';
        public static const HIGH_QUALITY:String = 'high_quality';
        public static const LIBRARY_ADD:String = 'library_add';
        public static const LIBRARY_BOOKS:String = 'library_books';
        public static const LIBRARY_MUSIC:String = 'library_music';
        public static const LOOP:String = 'loop';

        public static const MIC_:String = 'mic';
        public static const MIC_NONE:String = 'mic_none';
        public static const MIC_OFF:String = 'mic_off';
        public static const MOVIE:String = 'movie';
        public static const MUSIC_VIDEO:String = 'music_video';
        public static const NEW_RELEASES:String = 'new_releases';
        public static const NOT_INTERESTED:String = 'not_interested';
        public static const NOTE:String = 'note';
        public static const PAUSE:String = 'pause';
        public static const PAUSE_CIRCLE_FILLED:String = 'pause_circle_filled';

        public static const PAUSE_CIRCLE_OUTLINE:String = 'pause_circle_outline';
        public static const PLAY_ARROW:String = 'play_arrow';
        public static const PLAY_CIRCLE_FILLED:String = 'play_circle_filled';
        public static const PLAY_CIRCLE_OUTLINE:String = 'play_circle_outline';
        public static const PLAYLIST_ADD:String = 'playlist_add';
        public static const PLAYLIST_ADD_CHECK:String = 'playlist_add_check';
        public static const PLAYLIST_PLAY:String = 'playlist_play';
        public static const QUEUE:String = 'queue';
        public static const QUEUE_MUSIC:String = 'queue_music';
        public static const QUEUE_PLAY_NEXT:String = 'queue_play_next';

        public static const RADIO:String = 'radio';
        public static const RECENT_ACTORS:String = 'recent_actors';
        public static const REMOVE_FROM_QUEUE:String = 'remove_from_queue';
        public static const REPEAT:String = 'repeat';
        public static const REPEAT_ONE:String = 'repeat_one';
        public static const REPLAY:String = 'replay';
        public static const REPLAY_10:String = 'replay_10';
        public static const REPLAY_30:String = 'replay_30';
        public static const REPLAY_5:String = 'replay_5';
        public static const SHUFFLE:String = 'shuffle';

        public static const SKIP_NEXT:String = 'skip_next';
        public static const SKIP_PREVIOUS:String = 'skip_previous';
        public static const SLOW_MOTION_VIDEO:String = 'slow_motion_video';
        public static const SNOOZE:String = 'snooze';
        public static const SORT_BY_ALPHA:String = 'sort_by_alpha';
        public static const STOP:String = 'stop';
        public static const SUBSCRIPTIONS:String = 'subscriptions';
        public static const SUBTITLES:String = 'subtitles';
        public static const SURROUND_SOUND:String = 'surround_sound';
        public static const VIDEO_CALL:String = 'video_call';

        public static const VIDEO_LABEL:String = 'video_label';
        public static const VIDEO_LIBRARY:String = 'video_library';
        public static const VIDEOCAM:String = 'videocam';
        public static const VIDEOCAM_OFF:String = 'videocam_off';
        public static const VOLUME_DOWN:String = 'volume_down';
        public static const VOLUME_MUTE:String = 'volume_mute';
        public static const VOLUME_OFF:String = 'volume_off';
        public static const VOLUME_UP:String = 'volume_up';
        public static const WEB:String = 'web';
        public static const WEB_ASSET:String = 'web_asset';

        public static const BUSINESS:String = 'business';
        public static const CALL:String = 'call';
        public static const CALL_END:String = 'call_end';
        public static const CALL_MADE:String = 'call_made';
        public static const CALL_MERGE:String = 'call_merge';
        public static const CALL_MISSED:String = 'call_missed';
        public static const CALL_MISSED_OUTGOING:String = 'call_missed_outgoing';
        public static const CALL_RECEIVED:String = 'call_received';
        public static const CALL_SPLIT:String = 'call_split';
        public static const CHAT:String = 'chat';

        public static const CHAT_BUBBLE:String = 'chat_bubble';
        public static const CHAT_BUBBLE_OUTLINE:String = 'chat_bubble_outline';
        public static const CLEAR_ALL:String = 'clear_all';
        public static const COMMENT:String = 'comment';
        public static const CONTACT_MAIL:String = 'contact_mail';
        public static const CONTACT_PHONE:String = 'contact_phone';
        public static const CONTACTS:String = 'contacts';
        public static const DIALER_SIP:String = 'dialer_sip';
        public static const DIALPAD:String = 'dialpad';
        public static const EMAIL:String = 'email';

        public static const forum:String = 'forum';
        public static const import_contacts:String = 'import_contacts';
        public static const import_export:String = 'import_export';
        public static const invert_colors_off:String = 'invert_colors_off';
        public static const live_help:String = 'live_help';
        public static const location_off:String = 'location_off';
        public static const location_on:String = 'location_on';
        public static const mail_outline:String = 'mail_outline';
        public static const message:String = 'message';
        public static const no_sim:String = 'no_sim';

        public static const PHONE:String = 'phone';
        public static const PHONELINK_ERASE:String = 'phonelink_erase';
        public static const PHONELINK_LOCK:String = 'phonelink_lock';
        public static const PHONELINK_RING:String = 'phonelink_ring';
        public static const PHONELINK_SETUP:String = 'phonelink_setup';
        public static const PORTABLE_WIFI_OFF:String = 'portable_wifi_off';
        public static const PRESENT_TO_ALL:String = 'present_to_all';
        public static const RING_VOLUME:String = 'ring_volume';
        public static const RSS_FEED:String = 'rss_feed';
        public static const SCREEN_SHARE:String = 'screen_share';

        public static const SPEAKER_PHONE:String = 'speaker_phone';
        public static const STAY_CURRENT_LANDSCAPE:String = 'stay_current_landscape';
        public static const STAY_CURRENT_PORTRAIT:String = 'stay_current_portrait';
        public static const STAY_PRIMARY_LANDSCAPE:String = 'stay_primary_landscape';
        public static const STAY_PRIMARY_PORTRAIT:String = 'stay_primary_portrait';
        public static const STOP_SCREEN_SHARE:String = 'stop_screen_share';
        public static const SWAP_CALLS:String = 'swap_calls';
        public static const TEXTSMS:String = 'textsms';
        public static const VOICEMAIL:String = 'voicemail';
        public static const VPN_KEY:String = 'vpn_key';

        public static const ADD:String = 'add';
        public static const ADD_BOX:String = 'add_box';
        public static const ADD_CIRCLE:String = 'add_circle';
        public static const ADD_CIRCLE_OUTLINE:String = 'add_circle_outline';
        public static const ARCHIVE:String = 'archive';
        public static const BACKSPACE:String = 'backspace';
        public static const BLOCK:String = 'block';
        public static const CLEAR:String = 'clear';
        public static const CONTENT_COPY:String = 'content_copy';
        public static const CONTENT_CUT:String = 'content_cut';

        public static const CONTENT_PASTE:String = 'content_paste';
        public static const CREATE:String = 'create';
        public static const DELETE_SWEEP:String = 'delete_sweep';
        public static const DRAFTS:String = 'drafts';
        public static const FILTER_LIST:String = 'filter_list';
        public static const FLAG:String = 'flag';
        public static const FONT_DOWNLOAD:String = 'font_download';
        public static const FORWARD:String = 'forward';
        public static const GESTURE:String = 'gesture';
        public static const INBOX:String = 'inbox';

        public static const LINK:String = 'link';
        public static const LOW_PRIORITY:String = 'low_priority';
        public static const MAIL:String = 'mail';
        public static const MARKUNREAD:String = 'markunread';
        public static const MOVE_TO_INBOX:String = 'move_to_inbox';
        public static const NEXT_WEEK:String = 'next_week';
        public static const REDO:String = 'redo';
        public static const REMOVE:String = 'remove';
        public static const REMOVE_CIRCLE:String = 'remove_circle';
        public static const REMOVE_CIRCLE_OUTLINE:String = 'remove_circle_outline';

        public static const REPLY:String = 'reply';
        public static const REPLY_ALL:String = 'reply_all';
        public static const REPORT:String = 'report';
        public static const SAVE:String = 'save';
        public static const SELECT_ALL:String = 'select_all';
        public static const SEND:String = 'send';
        public static const SORT:String = 'sort';
        public static const TEXT_FORMAT:String = 'text_format';
        public static const UNARCHIVE:String = 'unarchive';
        public static const UNDO:String = 'undo';

        public static const WEEKEND:String = 'weekend';
        public static const ACCESS_ALARM:String = 'access_alarm';
        public static const ACCESS_ALARMS:String = 'access_alarms';
        public static const ACCESS_TIME:String = 'access_time';
        public static const ADD_ALARM:String = 'add_alarm';
        public static const AIRPLANEMODE_ACTIVE:String = 'airplanemode_active';
        public static const AIRPLANEMODE_INACTIVE:String = 'airplanemode_inactive';
        public static const BATTERY_ALERT:String = 'battery_alert';
        public static const BATTERY_CHARGING_FULL:String = 'battery_charging_full';
        public static const BATTERY_FULL:String = 'battery_full';

        public static const BATTERY_STD:String = 'battery_std';
        public static const BATTERY_UNKNOWN:String = 'battery_unknown';
        public static const BLUETOOTH:String = 'bluetooth';
        public static const BLUETOOTH_CONNECTED:String = 'bluetooth_connected';
        public static const BLUETOOTH_DISABLED:String = 'bluetooth_disabled';
        public static const BLUETOOTH_SEARCHING:String = 'bluetooth_searching';
        public static const BRIGHTNESS_AUTO:String = 'brightness_auto';
        public static const BRIGHTNESS_HIGH:String = 'brightness_high';
        public static const BRIGHTNESS_LOW:String = 'brightness_low';
        public static const BRIGHTNESS_MEDIUM:String = 'brightness_medium';

        public static const DATA_USAGE:String = 'data_usage';
        public static const DEVELOPER_MODE:String = 'developer_mode';
        public static const DEVICES:String = 'devices';
        public static const DVR:String = 'dvr';
        public static const GPS_FIXED:String = 'gps_fixed';
        public static const GPS_NOT_FIXED:String = 'gps_not_fixed';
        public static const GPS_OFF:String = 'gps_off';
        public static const GRAPHIC_EQ:String = 'graphic_eq';
        public static const LOCATION_DISABLED:String = 'location_disabled';
        public static const LOCATION_SEARCHING:String = 'location_searching';
        
        public static const NETWORK_CELL:String = 'network_cell';
        public static const NETWORK_WIFI:String = 'network_wifi';
        public static const NFC:String = 'nfc';
        public static const SCREEN_LOCK_LANDSCAPE:String = 'screen_lock_landscape';
        public static const SCREEN_LOCK_PORTRAIT:String = 'screen_lock_portraitXXX';
        public static const SCREEN_LOCK_ROTATION:String = 'screen_lock_rotation';
        public static const SCREEN_ROTATION:String = 'screen_rotation';
        public static const SD_STORAGE:String = 'sd_storage';
        public static const SETTINGS_SYSTEM_DAYDREAM:String = 'settings_system_daydream';
        public static const SIGNAL_CELLULAR_4_BAR:String = 'signal_cellular_4_bar';

        public static const SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR:String = 'signal_cellular_connected_no_internet_4_bar';
        public static const SIGNAL_CELLULAR_NO_SIM:String = 'signal_cellular_no_sim';
        public static const SIGNAL_CELLULAR_NULL:String = 'signal_cellular_null';
        public static const SIGNAL_CELLULAR_OFF:String = 'signal_cellular_off';
        public static const SIGNAL_WIFI_4_BAR:String = 'signal_wifi_4_bar';
        public static const SIGNAL_WIFI_4_BAR_LOCK:String = 'signal_wifi_4_bar_lock';
        public static const SIGNAL_WIFI_OFF:String = 'signal_wifi_off';
        public static const STORAGE:String = 'storage';
        public static const USB:String = 'usb';
        public static const WALLPAPER:String = 'wallpaper';

        public static const WIDGETS:String = 'widgets';
        public static const WIFI_LOCK:String = 'wifi_lock';
        public static const WIFI_TETHERING:String = 'wifi_tethering';
        public static const ATTACH_FILE:String = 'attach_file';
        public static const ATTACH_MONEY:String = 'attach_money';
        public static const BORDER_ALL:String = 'border_all';
        public static const BORDER_BOTTOM:String = 'border_bottom';
        public static const BORDER_CLEAR:String = 'border_clear';
        public static const BORDER_COLOR:String = 'border_color';
        public static const BORDER_HORIZONTAL:String = 'border_horizontal';

        public static const BORDER_INNER:String = 'border_inner';
        public static const BORDER_LEFT:String = 'border_left';
        public static const BORDER_OUTER:String = 'border_outer';
        public static const BORDER_RIGHT:String = 'border_right';
        public static const BORDER_STYLE:String = 'border_style';
        public static const BORDER_TOP:String = 'border_top';
        public static const BORDER_VERTICAL:String = 'border_vertical';
        public static const BUBBLE_CHART:String = 'bubble_chart';
        public static const DRAG_HANDLE:String = 'drag_handle';
        public static const FORMAT_ALIGN_CENTER:String = 'format_align_center';

        public static const FORMAT_ALIGN_JUSTIFY:String = 'format_align_justify';
        public static const FORMAT_ALIGN_LEFT:String = 'format_align_left';
        public static const FORMAT_ALIGN_RIGHT:String = 'format_align_right';
        public static const FORMAT_BOLD:String = 'format_bold';
        public static const FORMAT_CLEAR:String = 'format_clear';
        public static const FORMAT_COLOR_FILL:String = 'format_color_fill';
        public static const FORMAT_COLOR_RESET:String = 'format_color_reset';
        public static const FORMAT_COLOR_TEXT:String = 'format_color_text';
        public static const FORMAT_INDENT_DECREASE:String = 'format_indent_decrease';
        public static const FORMAT_INDENT_INCREASE:String = 'format_indent_increase';

        public static const FORMAT_ITALIC:String = 'format_italic';
        public static const FORMAT_LINE_SPACING:String = 'format_line_spacing';
        public static const FORMAT_LIST_BULLETED:String = 'format_list_bulleted';
        public static const FORMAT_LIST_NUMBERED:String = 'format_list_numbered';
        public static const FORMAT_PAINT:String = 'format_paint';
        public static const FORMAT_QUOTE:String = 'format_quote';
        public static const FORMAT_SHAPES:String = 'format_shapes';
        public static const FORMAT_SIZE:String = 'format_size';
        public static const FORMAT_STRIKETHROUGH:String = 'format_strikethrough';
        public static const FORMAT_TEXTDIRECTION_L_TO_R:String = 'format_textdirection_l_to_r';

        public static const FORMAT_TEXTDIRECTION_R_TO_L:String = 'format_textdirection_r_to_l';
        public static const FORMAT_UNDERLINED:String = 'format_underlined';
        public static const FUNCTIONS:String = 'functions';
        public static const HIGHLIGHT:String = 'highlight';
        public static const INSERT_CHART:String = 'insert_chart';
        public static const INSERT_COMMENT:String = 'insert_comment';
        public static const INSERT_DRIVE_FILE:String = 'insert_drive_file';
        public static const INSERT_EMOTICON:String = 'insert_emoticon';
        public static const INSERT_INVITATION:String = 'insert_invitation';
        public static const INSERT_LINK:String = 'insert_link';

        public static const INSERT_PHOTO:String = 'insert_photo';
        public static const LINEAR_SCALE:String = 'linear_scale';
        public static const MERGE_TYPE:String = 'merge_type';
        public static const MODE_COMMENT:String = 'mode_comment';
        public static const MODE_EDIT:String = 'mode_edit';
        public static const MONETIZATION_ON:String = 'monetization_on';
        public static const MONEY_OFF:String = 'money_off';
        public static const MULTILINE_CHART:String = 'multiline_chart';
        public static const PIE_CHART:String = 'pie_chart';
        public static const PIE_CHART_OUTLINED:String = 'pie_chart_outlined';

        public static const PUBLISH:String = 'publish';
        public static const SHORT_TEXT:String = 'short_text';
        public static const SHOW_CHART:String = 'show_chart';
        public static const SPACE_BAR:String = 'space_bar';
        public static const STRIKETHROUGH_S:String = 'strikethrough_s';
        public static const TEXT_FIELDS:String = 'text_fields';
        public static const TITLE:String = 'title';
        public static const VERTICAL_ALIGN_BOTTOM:String = 'vertical_align_bottom';
        public static const VERTICAL_ALIGN_CENTER:String = 'vertical_align_center';
        public static const VERTICAL_ALIGN_TOP:String = 'vertical_align_top';

        public static const WRAP_TEXT:String = 'wrap_text';
        public static const ATTACHMENT:String = 'attachment';
        public static const CLOUD:String = 'cloud';
        public static const CLOUD_CIRCLE:String = 'cloud_circle';
        public static const CLOUD_DONE:String = 'cloud_done';
        public static const CLOUD_DOWNLOAD:String = 'cloud_download';
        public static const CLOUD_OFF:String = 'cloud_off';
        public static const CLOUD_QUEUE:String = 'cloud_queue';
        public static const CLOUD_UPLOAD:String = 'cloud_upload';
        public static const CREATE_NEW_FOLDER:String = 'create_new_folder';

        public static const FILE_DOWNLOAD:String = 'file_download';
        public static const FILE_UPLOAD:String = 'file_upload';
        public static const FOLDER:String = 'folder';
        public static const FOLDER_OPEN:String = 'folder_open';
        public static const FOLDER_SHARED:String = 'folder_shared';
        public static const CAST:String = 'cast';
        public static const CAST_CONNECTED:String = 'cast_connected';
        public static const COMPUTER:String = 'computer';
        public static const DESKTOP_MAC:String = 'desktop_mac';
        public static const DESKTOP_WINDOWS:String = 'desktop_windows';

        public static const DEVELOPER_BOARD:String = 'developer_board';
        public static const DEVICE_HUB:String = 'device_hub';
        public static const DEVICES_OTHER:String = 'devices_other';
        public static const DOCK:String = 'dock';
        public static const GAMEPAD:String = 'gamepad';
        public static const HEADSET:String = 'headset';
        public static const HEADSET_MIC:String = 'headset_mic';
        public static const KEYBOARD:String = 'keyboard';
        public static const KEYBOARD_ARROW_DOWN:String = 'keyboard_arrow_down';
        public static const KEYBOARD_ARROW_LEFT:String = 'keyboard_arrow_left';

        public static const KEYBOARD_ARROW_RIGHT:String = 'keyboard_arrow_right';
        public static const KEYBOARD_ARROW_UP:String = 'keyboard_arrow_up';
        public static const KEYBOARD_BACKSPACE:String = 'keyboard_backspace';
        public static const KEYBOARD_CAPSLOCK:String = 'keyboard_capslock';
        public static const KEYBOARD_HIDE:String = 'keyboard_hide';
        public static const KEYBOARD_RETURN:String = 'keyboard_return';
        public static const KEYBOARD_TAB:String = 'keyboard_tab';
        public static const KEYBOARD_VOICE:String = 'keyboard_voice';
        public static const LAPTOP:String = 'laptop';
        public static const LAPTOP_CHROMEBOOK:String = 'laptop_chromebook';

        public static const LAPTOP_MAC:String = 'laptop_mac';
        public static const LAPTOP_WINDOWS:String = 'laptop_windows';
        public static const MEMORY:String = 'memory';
        public static const MOUSE:String = 'mouse';
        public static const PHONE_ANDROID:String = 'phone_android';
        public static const PHONE_IPHONE:String = 'phone_iphone';
        public static const PHONELINK:String = 'phonelink';
        public static const PHONELINK_OFF:String = 'phonelink_off';
        public static const POWER_INPUT:String = 'power_input';
        public static const ROUTER:String = 'router';

        public static const SCANNER:String = 'scanner';
        public static const SECURITY:String = 'security';
        public static const SIM_CARD:String = 'sim_card';
        public static const SMARTPHONE:String = 'smartphone';
        public static const SPEAKER:String = 'speaker';
        public static const SPEAKER_GROUP:String = 'speaker_group';
        public static const TABLET:String = 'tablet';
        public static const TABLET_ANDROID:String = 'tablet_android';
        public static const TABLET_MAC:String = 'tablet_mac';
        public static const TOYS:String = 'toys';

        public static const TV:String = 'tv';
        public static const VIDEOGAME_ASSET:String = 'videogame_asset';
        public static const WATCH:String = 'watch';
        public static const ADD_A_PHOTO:String = 'add_a_photo';
        public static const ADD_TO_PHOTOS:String = 'add_to_photos';
        public static const ADJUST:String = 'adjust';
        public static const ASSISTANT:String = 'assistant';
        public static const ASSISTANT_PHOTO:String = 'assistant_photo';
        public static const AUDIOTRACK:String = 'audiotrack';
        public static const BLUR_CIRCULAR:String = 'blur_circular';

        public static const BLUR_LINEAR:String = 'blur_linear';
        public static const BLUR_OFF:String = 'blur_off';
        public static const BLUR_ON:String = 'blur_on';
        public static const BRIGHTNESS_1:String = 'brightness_1';
        public static const BRIGHTNESS_2:String = 'brightness_2';
        public static const BRIGHTNESS_3:String = 'brightness_3';
        public static const BRIGHTNESS_4:String = 'brightness_4';
        public static const BRIGHTNESS_5:String = 'brightness_5';
        public static const BRIGHTNESS_6:String = 'brightness_6';
        public static const BRIGHTNESS_7:String = 'brightness_7';

        public static const BROKEN_IMAGE:String = 'broken_image';
        public static const BRUSH:String = 'brush';
        public static const BURST_MODE:String = 'burst_mode';
        public static const CAMERA:String = 'camera';
        public static const CAMERA_ALT:String = 'camera_alt';
        public static const CAMERA_FRONT:String = 'camera_front';
        public static const CAMERA_REAR:String = 'camera_rear';
        public static const CAMERA_ROLL:String = 'camera_roll';
        public static const CENTER_FOCUS_STRONG:String = 'center_focus_strong';
        public static const CENTER_FOCUS_WEAK:String = 'center_focus_weak';

        public static const COLLECTIONS:String = 'collections';
        public static const COLLECTIONS_BOOKMARK:String = 'collections_bookmark';
        public static const COLOR_LENS:String = 'color_lens';
        public static const COLORIZE:String = 'colorize';
        public static const COMPARE:String = 'compare';
        public static const CONTROL_POINT:String = 'control_point';
        public static const CONTROL_POINT_DUPLICATE:String = 'control_point_duplicate';
        public static const CROP:String = 'crop';
        public static const CROP_16_9:String = 'crop_16_9';
        public static const CROP_3_2:String = 'crop_3_2';

        public static const CROP_5_4:String = 'crop_5_4';
        public static const CROP_7_5:String = 'crop_7_5';
        public static const CROP_DIN:String = 'crop_din';
        public static const CROP_FREE:String = 'crop_free';
        public static const CROP_LANDSCAPE:String = 'crop_landscape';
        public static const CROP_ORIGINAL:String = 'crop_original';
        public static const CROP_PORTRAIT:String = 'crop_portrait';
        public static const CROP_ROTATE:String = 'crop_rotate';
        public static const CROP_SQUARE:String = 'crop_square';
        public static const DEHAZE:String = 'dehaze';

        public static const DETAILS:String = 'details';
        public static const EDIT:String = 'edit';
        public static const EXPOSURE:String = 'exposure';
        public static const EXPOSURE_NEG_1:String = 'exposure_neg_1';
        public static const EXPOSURE_NEG_2:String = 'exposure_neg_2';
        public static const EXPOSURE_PLUS_1:String = 'exposure_plus_1';
        public static const EXPOSURE_PLUS_2:String = 'exposure_plus_2';
        public static const EXPOSURE_ZERO:String = 'exposure_zero';
        public static const FILTER:String = 'filter';
        public static const FILTER_1:String = 'filter_1';

        public static const FILTER_2:String = 'filter_2';
        public static const FILTER_3:String = 'filter_3';
        public static const FILTER_4:String = 'filter_4';
        public static const FILTER_5:String = 'filter_5';
        public static const FILTER_6:String = 'filter_6';
        public static const FILTER_7:String = 'filter_7';
        public static const FILTER_8:String = 'filter_8';
        public static const FILTER_9:String = 'filter_9';
        public static const FILTER_9_PLUS:String = 'filter_9_plus';
        public static const FILTER_B_AND_W:String = 'filter_b_and_w';

        public static const FILTER_CENTER_FOCUS:String = 'filter_center_focus';
        public static const FILTER_DRAMA:String = 'filter_drama';
        public static const FILTER_FRAMES:String = 'filter_frames';
        public static const FILTER_HDR:String = 'filter_hdr';
        public static const FILTER_NONE:String = 'filter_none';
        public static const FILTER_TILT_SHIFT:String = 'filter_tilt_shift';
        public static const FILTER_VINTAGE:String = 'filter_vintage';
        public static const FLARE:String = 'flare';
        public static const FLASH_AUTO:String = 'flash_auto';
        public static const FLASH_OFF:String = 'flash_off';

        public static const FLASH_ON:String = 'flash_on';
        public static const FLIP:String = 'flip';
        public static const GRADIENT:String = 'gradient';
        public static const GRAIN:String = 'grain';
        public static const GRID_OFF:String = 'grid_off';
        public static const GRID_ON:String = 'grid_on';
        public static const HDR_OFF:String = 'hdr_off';
        public static const HDR_ON:String = 'hdr_on';
        public static const HDR_STRONG:String = 'hdr_strong';
        public static const HDR_WEAK:String = 'hdr_weak';

        public static const HEALING:String = 'healing';
        public static const IMAGE:String = 'image';
        public static const IMAGE_ASPECT_RATIO:String = 'image_aspect_ratio';
        public static const ISO:String = 'iso';
        public static const LANDSCAPE:String = 'landscape';
        public static const LEAK_ADD:String = 'leak_add';
        public static const LEAK_REMOVE:String = 'leak_remove';
        public static const LENS:String = 'lens';
        public static const LINKED_CAMERA:String = 'linked_camera';
        public static const LOOKS:String = 'looks';

        public static const LOOKS_3:String = 'looks_3';
        public static const LOOKS_4:String = 'looks_4';
        public static const LOOKS_5:String = 'looks_5';
        public static const LOOKS_6:String = 'looks_6';
        public static const LOOKS_ONE:String = 'looks_one';
        public static const LOOKS_TWO:String = 'looks_two';
        public static const LOUPE:String = 'loupe';
        public static const MONOCHROME_PHOTOS:String = 'monochrome_photos';
        public static const MOVIE_CREATION:String = 'movie_creation';
        public static const MOVIE_FILTER:String = 'movie_filter';

        public static const MUSIC_NOTE:String = 'music_note';
        public static const NATURE:String = 'nature';
        public static const NATURE_PEOPLE:String = 'nature_people';
        public static const NAVIGATE_BEFORE:String = 'navigate_before';
        public static const NAVIGATE_NEXT:String = 'navigate_next';
        public static const PALETTE:String = 'palette';
        public static const PANORAMA:String = 'panorama';
        public static const PANORAMA_FISH_EYE:String = 'panorama_fish_eye';
        public static const PANORAMA_HORIZONTAL:String = 'panorama_horizontal';
        public static const PANORAMA_VERTICAL:String = 'panorama_vertical';

        public static const PANORAMA_WIDE_ANGLE:String = 'panorama_wide_angle';
        public static const PHOTO:String = 'photo';
        public static const PHOTO_ALBUM:String = 'photo_album';
        public static const PHOTO_CAMERA:String = 'photo_camera';
        public static const PHOTO_FILTER:String = 'photo_filter';
        public static const PHOTO_LIBRARY:String = 'photo_library';
        public static const PHOTO_SIZE_SELECT_ACTUAL:String = 'photo_size_select_actual';
        public static const PHOTO_SIZE_SELECT_LARGE:String = 'photo_size_select_large';
        public static const PHOTO_SIZE_SELECT_SMALL:String = 'photo_size_select_small';
        public static const PICTURE_AS_PDF:String = 'picture_as_pdf';

        public static const PORTRAIT:String = 'portrait';
        public static const REMOVE_RED_EYE:String = 'remove_red_eye';
        public static const ROTATE_90_DEGREES_CCW:String = 'rotate_90_degrees_ccw';
        public static const ROTATE_LEFT:String = 'rotate_left';
        public static const ROTATE_RIGHT:String = 'rotate_right';
        public static const SLIDESHOW:String = 'slideshow';
        public static const STRAIGHTEN:String = 'straighten';
        public static const STYLE:String = 'style';
        public static const SWITCH_CAMERA:String = 'switch_camera';
        public static const SWITCH_VIDEO:String = 'switch_video';

        public static const TAG_FACES:String = 'tag_faces';
        public static const TEXTURE:String = 'texture';
        public static const TIMELAPSE:String = 'timelapse';
        public static const TIMER:String = 'timer';
        public static const TIMER_10:String = 'timer_10';
        public static const TIMER_3:String = 'timer_3';
        public static const TIMER_OFF:String = 'timer_off';
        public static const TONALITY:String = 'tonality';
        public static const TRANSFORM:String = 'transform';
        public static const TUNE:String = 'tune';

        public static const VIEW_COMFY:String = 'view_comfy';
        public static const VIEW_COMPACT:String = 'view_compact';
        public static const VIGNETTE:String = 'vignette';
        public static const WB_AUTO:String = 'wb_auto';
        public static const WB_CLOUDY:String = 'wb_cloudy';
        public static const WB_INCANDESCENT:String = 'wb_incandescent';
        public static const WB_IRIDESCENT:String = 'wb_iridescent';
        public static const WB_SUNNY:String = 'wb_sunny';
        public static const ADD_LOCATION:String = 'add_location';
        public static const BEENHERE:String = 'beenhere';

        public static const DIRECTIONS:String = 'directions';
        public static const DIRECTIONS_BIKE:String = 'directions_bike';
        public static const DIRECTIONS_BOAT:String = 'directions_boat';
        public static const DIRECTIONS_BUS:String = 'directions_bus';
        public static const DIRECTIONS_CAR:String = 'directions_car';
        public static const DIRECTIONS_RAILWAY:String = 'directions_railway';
        public static const DIRECTIONS_RUN:String = 'directions_run';
        public static const DIRECTIONS_SUBWAY:String = 'directions_subway';
        public static const DIRECTIONS_TRANSIT:String = 'directions_transit';
        public static const DIRECTIONS_WALK:String = 'directions_walk';

        public static const EDIT_LOCATION:String = 'edit_location';
        public static const EV_STATION:String = 'ev_station';
        public static const FLIGHT:String = 'flight';
        public static const HOTEL:String = 'hotel';
        public static const LAYERS:String = 'layers';
        public static const LAYERS_CLEAR:String = 'layers_clear';
        public static const LOCAL_ACTIVITY:String = 'local_activity';
        public static const LOCAL_AIRPORT:String = 'local_airport';
        public static const LOCAL_ATM:String = 'local_atm';
        public static const LOCAL_BAR:String = 'local_bar';

        public static const LOCAL_CAFE:String = 'local_cafe';
        public static const LOCAL_CAR_WASH:String = 'local_car_wash';
        public static const LOCAL_CONVENIENCE_STORE:String = 'local_convenience_store';
        public static const LOCAL_DINING:String = 'local_dining';
        public static const LOCAL_DRINK:String = 'local_drink';
        public static const LOCAL_FLORIST:String = 'local_florist';
        public static const LOCAL_GAS_STATION:String = 'local_gas_station';
        public static const LOCAL_GROCERY_STORE:String = 'local_grocery_store';
        public static const LOCAL_HOSPITAL:String = 'local_hospital';
        public static const LOCAL_HOTEL:String = 'local_hotel';

        public static const LOCAL_LAUNDRY_SERVICE:String = 'local_laundry_service';
        public static const LOCAL_LIBRARY:String = 'local_library';
        public static const LOCAL_MALL:String = 'local_mall';
        public static const LOCAL_MOVIES:String = 'local_movies';
        public static const LOCAL_OFFER:String = 'local_offer';
        public static const LOCAL_PARKING:String = 'local_parking';
        public static const LOCAL_PHARMACY:String = 'local_pharmacy';
        public static const LOCAL_PHONE:String = 'local_phone';
        public static const LOCAL_PIZZA:String = 'local_pizza';
        public static const LOCAL_PLAY:String = 'local_play';

        public static const LOCAL_POST_OFFICE:String = 'local_post_office';
        public static const LOCAL_PRINTSHOP:String = 'local_printshop';
        public static const LOCAL_SEE:String = 'local_see';
        public static const LOCAL_SHIPPING:String = 'local_shipping';
        public static const LOCAL_TAXI:String = 'local_taxi';
        public static const MAP:String = 'map';
        public static const MY_LOCATION:String = 'my_location';
        public static const NAVIGATION:String = 'navigation';
        public static const NEAR_ME:String = 'near_me';
        public static const PERSON_PIN:String = 'person_pin';

        public static const PERSON_PIN_CIRCLE:String = 'person_pin_circle';
        public static const PIN_DROP:String = 'pin_drop';
        public static const PLACE:String = 'place';
        public static const RATE_REVIEW:String = 'rate_review';
        public static const RESTAURANT:String = 'restaurant';
        public static const RESTAURANT_MENU:String = 'restaurant_menu';
        public static const SATELLITE:String = 'satellite';
        public static const STORE_MALL_DIRECTORY:String = 'store_mall_directory';
        public static const STREETVIEW:String = 'streetview';
        public static const SUBWAY:String = 'subway';

        public static const TERRAIN:String = 'terrain';
        public static const TRAFFIC:String = 'traffic';
        public static const TRAIN:String = 'train';
        public static const TRAM:String = 'tram';
        public static const TRANSFER_WITHIN_A_STATION:String = 'transfer_within_a_station';
        public static const ZOOM_OUT_MAP:String = 'zoom_out_map';
        public static const APPS:String = 'apps';
        public static const ARROW_BACK:String = 'arrow_back';
        public static const ARROW_DOWNWARD:String = 'arrow_downward';
        public static const ARROW_DROP_DOWN:String = 'arrow_drop_down';

        public static const ARROW_DROP_DOWN_CIRCLE:String = 'arrow_drop_down_circle';
        public static const ARROW_DROP_UP:String = 'arrow_drop_up';
        public static const ARROW_FORWARD:String = 'arrow_forward';
        public static const ARROW_UPWARD:String = 'arrow_upward';
        public static const CANCEL:String = 'cancel';
        public static const CHECK:String = 'check';
        public static const CHEVRON_LEFT:String = 'chevron_left';
        public static const CHEVRON_RIGHT:String = 'chevron_right';
        public static const CLOSE:String = 'close';
        public static const EXPAND_LESS:String = 'expand_less';

        public static const EXPAND_MORE:String = 'expand_more';
        public static const FIRST_PAGE:String = 'first_page';
        public static const FULLSCREEN:String = 'fullscreen';
        public static const FULLSCREEN_EXIT:String = 'fullscreen_exit';
        public static const LAST_PAGE:String = 'last_page';
        public static const MENU:String = 'menu';
        public static const MORE_HORIZ:String = 'more_horiz';
        public static const MORE_VERT:String = 'more_vert';
        public static const REFRESH:String = 'refresh';
        public static const SUBDIRECTORY_ARROW_LEFT:String = 'subdirectory_arrow_left';

        public static const SUBDIRECTORY_ARROW_RIGHT:String = 'subdirectory_arrow_right';
        public static const ADB:String = 'adb';
        public static const AIRLINE_SEAT_FLAT:String = 'airline_seat_flat';
        public static const AIRLINE_SEAT_FLAT_ANGLED:String = 'airline_seat_flat_angled';
        public static const AIRLINE_SEAT_INDIVIDUAL_SUITE:String = 'airline_seat_individual_suite';
        public static const AIRLINE_SEAT_LEGROOM_EXTRA:String = 'airline_seat_legroom_extra';
        public static const AIRLINE_SEAT_LEGROOM_NORMAL:String = 'airline_seat_legroom_normal';
        public static const AIRLINE_SEAT_LEGROOM_REDUCED:String = 'airline_seat_legroom_reduced';
        public static const AIRLINE_SEAT_RECLINE_EXTRA:String = 'airline_seat_recline_extra';
        public static const AIRLINE_SEAT_RECLINE_NORMAL:String = 'airline_seat_recline_normal';

        public static const BLUETOOTH_AUDIO:String = 'bluetooth_audio';
        public static const CONFIRMATION_NUMBER:String = 'confirmation_number';
        public static const DISC_FULL:String = 'disc_full';
        public static const DO_NOT_DISTURB:String = 'do_not_disturb';
        public static const DO_NOT_DISTURB_ALT:String = 'do_not_disturb_alt';
        public static const DO_NOT_DISTURB_OFF:String = 'do_not_disturb_off';
        public static const DO_NOT_DISTURB_ON:String = 'do_not_disturb_on';
        public static const DRIVE_ETA:String = 'drive_eta';
        public static const ENHANCED_ENCRYPTION:String = 'enhanced_encryption';
        public static const EVENT_AVAILABLE:String = 'event_available';

        public static const EVENT_BUSY:String = 'event_busy';
        public static const EVENT_NOTE:String = 'event_note';
        public static const FOLDER_SPECIAL:String = 'folder_special';
        public static const LIVE_TV:String = 'live_tv';
        public static const MMS:String = 'mms';
        public static const MORE:String = 'more';
        public static const NETWORK_CHECK:String = 'network_check';
        public static const NETWORK_LOCKED:String = 'network_locked';
        public static const NO_ENCRYPTION:String = 'no_encryption';
        public static const ONDEMAND_VIDEO:String = 'ondemand_video';

        public static const PERSONAL_VIDEO:String = 'personal_video';
        public static const PHONE_BLUETOOTH_SPEAKER:String = 'phone_bluetooth_speaker';
        public static const PHONE_FORWARDED:String = 'phone_forwarded';
        public static const PHONE_IN_TALK:String = 'phone_in_talk';
        public static const PHONE_LOCKED:String = 'phone_locked';
        public static const PHONE_MISSED:String = 'phone_missed';
        public static const PHONE_PAUSED:String = 'phone_paused';
        public static const POWER:String = 'power';
        public static const PRIORITY_HIGH:String = 'priority_high';
        public static const SD_CARD:String = 'sd_card';

        public static const SIM_CARD_ALERT:String = 'sim_card_alert';
        public static const SMS:String = 'sms';
        public static const SMS_FAILED:String = 'sms_failed';
        public static const SYNC:String = 'sync';
        public static const SYNC_DISABLED:String = 'sync_disabled';
        public static const SYNC_PROBLEM:String = 'sync_problem';
        public static const SYSTEM_UPDATE:String = 'system_update';
        public static const TAP_AND_PLAY:String = 'tap_and_play';
        public static const TIME_TO_LEAVE:String = 'time_to_leave';
        public static const VIBRATION:String = 'vibration';

        public static const VOICE_CHAT:String = 'voice_chat';
        public static const VPN_LOCK:String = 'vpn_lock';
        public static const WC:String = 'wc';
        public static const WIFI:String = 'wifi';
        public static const AC_UNIT:String = 'ac_unit';
        public static const AIRPORT_SHUTTLE:String = 'airport_shuttle';
        public static const ALL_INCLUSIVE:String = 'all_inclusive';
        public static const BEACH_ACCESS:String = 'beach_access';
        public static const BUSINESS_CENTER:String = 'business_center';
        public static const CASINO:String = 'casino';

        public static const CHILD_CARE:String = 'child_care';
        public static const CHILD_FRIENDLY:String = 'child_friendly';
        public static const FITNESS_CENTER:String = 'fitness_center';
        public static const FREE_BREAKFAST:String = 'free_breakfast';
        public static const GOLF_COURSE:String = 'golf_course';
        public static const HOT_TUB:String = 'hot_tub';
        public static const KITCHEN:String = 'kitchen';
        public static const POOL:String = 'pool';
        public static const ROOM_SERVICE:String = 'room_service';
        public static const RV_HOOKUP:String = 'rv_hookup';

        public static const SMOKING_ROOMS:String = 'smoke_free';
        public static const SPA:String = 'spa';
        public static const CAKE:String = 'cake';
        public static const DOMAIN:String = 'domain';
        public static const GROUP:String = 'group';
        public static const GROUP_ADD:String = 'group_add';
        public static const LOCATION_CITY:String = 'location_city';
        public static const MOOD:String = 'mood';
        public static const MOOD_BAD:String = 'mood_bad';
        public static const NOTIFICATIONS:String = 'notifications';

        public static const NOTIFICATIONS_ACTIVE:String = 'notifications_active';
        public static const NOTIFICATIONS_NONE:String = 'notifications_none';
        public static const NOTIFICATIONS_OFF:String = 'notifications_off';
        public static const NOTIFICATIONS_PAUSED:String = 'notifications_paused';
        public static const PAGES:String = 'pages';
        public static const PARTY_MODE:String = 'party_mode';
        public static const PEOPLE:String = 'people';
        public static const PEOPLE_OUTLINE:String = 'people_outline';
        public static const PERSON:String = 'person';
        public static const PERSON_ADD:String = 'person_add';

        public static const PERSON_OUTLINE:String = 'person_outline';
        public static const PLUS_ONE:String = 'plus_one';
        public static const POLL:String = 'poll';
        public static const PUBLIC:String = 'public';
        public static const SCHOOL:String = 'school';
        public static const SENTIMENT_DISSATISFIED:String = 'sentiment_dissatisfied';
        public static const SENTIMENT_NEUTRAL:String = 'sentiment_neutral';
        public static const SENTIMENT_SATISFIED:String = 'sentiment_satisfied';
        public static const SENTIMENT_VERY_DISSATISFIED:String = 'sentiment_very_dissatisfied';
        public static const SENTIMENT_VERY_SATISFIED:String = 'sentiment_very_satisfied';

        public static const SHARE:String = 'share';
        public static const WHATSHOT:String = 'whatshot';
        public static const CHECK_BOX:String = 'check_box';
        public static const CHECK_BOX_OUTLINE_BLANK:String = 'check_box_outline_blank';
        public static const INDETERMINATE_CHECK_BOX:String = 'indeterminate_check_box';
        public static const RADIO_BUTTON_CHECKED:String = 'radio_button_checked';
        public static const RADIO_BUTTON_UNCHECKED:String = 'radio_button_unchecked';
        public static const STAR:String = 'star';
        public static const STAR_BORDER:String = 'star_border';
        public static const STAR_HALF:String = 'star_half';
        
        public static const LIST_ALT:String = 'list_alt';
        public static const UNFOLD_MORE:String = 'unfold_more';
        public static const UNFOLD_LESS:String = 'unfold_less';
        public static const ALL_INBOX:String = 'all_inbox';
        public static const WORK_OUTLINE:String = 'work_outline';
        public static const ARROW_FORWARD_IOS:String = 'arrow_forward_ios';
        public static const ARROW_BACK_IOS:String = 'arrow_back_ios';
        public static const TRIP_ORIGIN:String = 'trip_origin';
        public static const CHECK_CIRCLE_OUTLINE:String = 'check_circle_outline';
        public static const WORK_OFF:String = 'work_off';

        public static const PRINT_DISABLED:String = 'print_disabled';
        public static const MOBILE_SCREEN:String = 'mobile_screen';
    }
}
