/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.utils;

import java.util.Set;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.units.ICompilationUnit;

public class ClosureUtils {
    public static void collectPropertyNamesToKeep(ICompilationUnit cu, RoyaleJSProject project, Set<String> result) {
        if (project.isExternalLinkage(cu)) {
            return;
        }
        boolean preventRenamePublic = project.config.getPreventRenamePublicSymbols();
        boolean preventRenameProtected = project.config.getPreventRenameProtectedSymbols();
        for (IDefinition def : cu.getDefinitionPromises()) {
            if (def instanceof ASProjectScope.DefinitionPromise) {
                def = ((ASProjectScope.DefinitionPromise)def).getActualDefinition();
            }
            if (!(def instanceof ITypeDefinition) || def.isImplicit() || def.isNative()) continue;
            ITypeDefinition typeDef = (ITypeDefinition)def;
            for (IDefinition localDef : typeDef.getContainedScope().getAllLocalDefinitions()) {
                if (localDef.isImplicit() || !localDef.isPublic() && !localDef.isProtected() || localDef.isProtected() && !preventRenameProtected || localDef.isPublic() && !preventRenamePublic || !(localDef instanceof IVariableDefinition) || localDef instanceof IFunctionDefinition) continue;
                result.add(localDef.getBaseName());
            }
        }
    }
}

