/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.driver.js.royale;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSMediaQueryCondition;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.css.ICSSRule;
import org.apache.royale.compiler.css.ICSSSelector;
import org.apache.royale.compiler.css.ICSSSelectorCondition;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.royale.compiler.internal.css.CSSColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSFontFace;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSKeywordPropertyValue;
import org.apache.royale.compiler.internal.css.CSSMultiValuePropertyValue;
import org.apache.royale.compiler.internal.css.CSSNumberPropertyValue;
import org.apache.royale.compiler.internal.css.CSSProperty;
import org.apache.royale.compiler.internal.css.CSSRgbColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSRgbaColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSStringPropertyValue;
import org.apache.royale.compiler.internal.css.CSSURLAndFormatPropertyValue;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;

public class JSCSSCompilationSession
extends CSSCompilationSession {
    private List<String> otherCSSFunctions = Arrays.asList("-moz-linear-gradient", "-webkit-linear-gradient", "linear-gradient", "progid:DXImageTransform.Microsoft.gradient", "translateX", "translateY", "translate", "blur", "brightness", "contrast", "drop-shadow", "hue-rotate", "invert", "saturate", "sepia");
    private ArrayList<String> requires;
    List<String> htmlElementNames = Arrays.asList("a", "aside", "b", "br", "body", "button", "caption", "code", "col", "colgroup", "dialog", "div", "em", "embed", "font", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hr", "html", "i", "img", "input", "label", "li", "main", "nav", "ol", "option", "p", "pre", "s", "select", "small", "span", "strong", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "tr", "u", "ul");

    public String getEncodedCSS() {
        ICSSDocument css = this.synthesisNormalizedCSS(false);
        StringBuilder sb = new StringBuilder();
        this.requires = new ArrayList();
        this.encodeCSS(css, sb);
        if (sb.length() == 0) {
            return null;
        }
        sb.append("];\n");
        for (String r : this.requires) {
            sb.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken() + "('" + this.formatQualifiedName(r) + "');\n");
        }
        return sb.toString();
    }

    public String emitCSS() {
        ICSSDocument css = this.synthesisNormalizedCSS(false);
        StringBuilder sb = new StringBuilder();
        sb.append("/* Generated by Apache Royale Compiler */\n");
        this.walkCSS(css, sb);
        return sb.toString();
    }

    public static String minifyCSSString(String cssString) {
        cssString = cssString.replaceAll("\\S+\\s?\\{[\\s\\n]+}", "");
        cssString = cssString.replaceAll("/\\*[\\d\\D]*?\\*/", "");
        cssString = cssString.replace(";}", "}");
        cssString = cssString.replaceAll("[\\n\\r]+\\s*", "");
        cssString = cssString.replaceAll("\\s+", " ");
        cssString = cssString.replaceAll("\\s?([:,;{}])\\s?", "$1");
        cssString = cssString.replaceAll("([\\s:]0)(px|pt|em)", "$1");
        return cssString;
    }

    private String fontFaceToString(CSSFontFace fontFace) {
        StringBuilder result = new StringBuilder();
        result.append("@font-face {\n");
        result.append("    ");
        result.append("font-family: ");
        result.append(fontFace.getFontFamily() + ";\n");
        result.append("    ");
        result.append("font-style: ");
        result.append(fontFace.getFontStyle() + ";\n");
        result.append("    ");
        result.append("font-weight: ");
        result.append(fontFace.getFontStyle() + ";\n");
        result.append("    ");
        ArrayList sources = fontFace.getSources();
        for (ICSSPropertyValue src : sources) {
            result.append("src: ");
            result.append(src.toString() + ";\n");
        }
        result.append("}\n");
        return result.toString();
    }

    private String cssRuleToString(ICSSRule rule) {
        boolean hasMediaQuery;
        StringBuilder result = new StringBuilder();
        ImmutableList mqList = rule.getMediaQueryConditions();
        boolean bl = hasMediaQuery = !mqList.isEmpty();
        if (hasMediaQuery) {
            result.append("@media ");
            result.append(Joiner.on(" and ").join(rule.getMediaQueryConditions()));
            result.append(" {\n");
            result.append("    ");
        }
        ImmutableList selectors = rule.getSelectorGroup();
        boolean firstOne = true;
        for (ICSSSelector selector : selectors) {
            String s = selector.toString();
            if (!(s.startsWith(".") || s.startsWith("*") || s.startsWith("#") || s.startsWith("::"))) {
                String condition = null;
                int colon = s.indexOf(":");
                if (colon != -1) {
                    condition = s.substring(colon);
                    s = s.substring(0, colon);
                } else {
                    int brace = s.indexOf("[");
                    if (brace != -1) {
                        condition = s.substring(brace);
                        s = s.substring(0, brace);
                    } else {
                        int child = s.indexOf(">");
                        if (child != -1) {
                            condition = s.substring(child);
                            s = s.substring(0, child);
                        } else {
                            int preceded = s.indexOf("+");
                            if (preceded != -1) {
                                condition = s.substring(preceded);
                                s = s.substring(0, preceded);
                            }
                        }
                    }
                }
                if (!this.htmlElementNames.contains(s.toLowerCase())) {
                    if (s.indexOf(" ") > 0) {
                        String[] parts = s.split(" ");
                        int n = parts.length;
                        s = "";
                        for (int i = 0; i < n; ++i) {
                            String part;
                            if (i != 0) {
                                s = s + " ";
                            }
                            if (!((part = parts[i]).startsWith(".") || part.startsWith("*") || part.startsWith("#") || part.startsWith("::"))) {
                                int pipe = part.indexOf("|");
                                if (pipe != -1) {
                                    part = part.substring(pipe + 1);
                                }
                                part = "." + part;
                            }
                            s = s + part;
                        }
                    } else {
                        int pipe = s.indexOf("|");
                        if (pipe != -1) {
                            s = s.substring(pipe + 1);
                        }
                        s = "." + s;
                    }
                }
                if (condition != null) {
                    s = s + condition;
                }
            }
            if (!firstOne) {
                result.append(",\n");
            }
            result.append(s);
        }
        result.append(" {\n");
        ArrayList<String> listOfProps = new ArrayList<String>();
        for (ICSSProperty prop : rule.getProperties()) {
            String propString = ((CSSProperty)prop).toCSSString();
            if (propString.contains("ClassReference")) continue;
            listOfProps.add(propString);
        }
        Collections.sort(listOfProps);
        for (String propString : listOfProps) {
            if (!hasMediaQuery) {
                result.append("    ");
            }
            result.append("    ").append(propString).append("\n");
        }
        if (hasMediaQuery) {
            result.append("    }\n");
        }
        result.append("}\n");
        return result.toString();
    }

    private void walkCSS(ICSSDocument css, StringBuilder sb) {
        for (CSSFontFace fontFace : this.fontFaces) {
            sb.append(this.fontFaceToString(fontFace));
        }
        if (this.fontFaces.size() > 0) {
            sb.append("\n\n");
        }
        ImmutableList rules = css.getRules();
        for (ICSSRule rule : rules) {
            String s = this.cssRuleToString(rule);
            if (s.startsWith("@media -royale-swf")) continue;
            sb.append(s);
            sb.append("\n\n");
        }
    }

    private void encodeCSS(ICSSDocument css, StringBuilder sb) {
        ImmutableList rules = css.getRules();
        boolean skipcomma = true;
        for (ICSSRule rule : rules) {
            String s = this.encodeRule(rule);
            if (s == null) continue;
            if (skipcomma) {
                skipcomma = false;
            } else {
                sb.append(",\n");
            }
            sb.append(s);
        }
    }

    private String escapeDoubleQuotes(String s) {
        if (s.contains("\"")) {
            s = s.replace("\"", "\\\"");
        }
        return s;
    }

    private String encodeRule(ICSSRule rule) {
        StringBuilder result = new StringBuilder();
        ImmutableList mqlist = rule.getMediaQueryConditions();
        int n = mqlist.size();
        if (n > 0) {
            if (((ICSSMediaQueryCondition)mqlist.get(0)).toString().equals("-royale-swf")) {
                return null;
            }
            result.append(n);
            for (Iterator mqcond : mqlist) {
                result.append(",\n");
                result.append("\"" + mqcond.toString() + "\"");
            }
        } else {
            result.append(n);
        }
        result.append(",\n");
        ImmutableList slist = rule.getSelectorGroup();
        result.append(slist.size());
        for (ICSSSelector sel : slist) {
            result.append(",\n");
            Object selName = (String)this.resolvedSelectors.get(sel);
            if (selName == null || ((String)selName).equals("null")) {
                result.append("\"" + sel.toString() + "\"");
                continue;
            }
            selName = this.formatQualifiedName((String)selName);
            ImmutableList conds = sel.getConditions();
            for (ICSSSelectorCondition cond : conds) {
                String condString = this.escapeDoubleQuotes(cond.toString());
                selName = (String)selName + condString;
            }
            result.append("\"" + (String)selName + "\"");
        }
        result.append(",\n");
        result.append("function() {");
        ImmutableList plist = rule.getProperties();
        ArrayList<String> listOfProps = new ArrayList<String>();
        for (ICSSProperty prop : rule.getProperties()) {
            String keywordString;
            CSSKeywordPropertyValue keywordValue;
            ImmutableList values;
            StringBuilder line = new StringBuilder();
            line.append("this[\"" + prop.getName() + "\"] = ");
            ICSSPropertyValue value = prop.getValue();
            if (value instanceof CSSArrayPropertyValue) {
                values = ((CSSArrayPropertyValue)value).getElements();
                line.append("[");
                boolean firstone = true;
                for (ICSSPropertyValue val : values) {
                    if (firstone) {
                        firstone = false;
                    } else {
                        line.append(", ");
                    }
                    if (val instanceof CSSStringPropertyValue) {
                        line.append("\"" + this.escapeDoubleQuotes(((CSSStringPropertyValue)val).getValue()) + "\"");
                        continue;
                    }
                    if (val instanceof CSSColorPropertyValue) {
                        line.append(new Integer(((CSSColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (val instanceof CSSRgbColorPropertyValue) {
                        line.append(new Integer(((CSSRgbColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (value instanceof CSSRgbaColorPropertyValue) {
                        line.append(new Long(((CSSRgbaColorPropertyValue)value).getColorAsLong()));
                        continue;
                    }
                    if (val instanceof CSSKeywordPropertyValue) {
                        keywordValue = (CSSKeywordPropertyValue)val;
                        keywordString = keywordValue.getKeyword();
                        if ("true".equals(keywordString)) {
                            line.append("true");
                            continue;
                        }
                        if ("false".equals(keywordString)) {
                            line.append("false");
                            continue;
                        }
                        line.append("\"" + ((CSSKeywordPropertyValue)val).getKeyword() + "\"");
                        continue;
                    }
                    if (val instanceof CSSNumberPropertyValue) {
                        line.append(new Double(((CSSNumberPropertyValue)val).getNumber().doubleValue()));
                        continue;
                    }
                    if (val instanceof CSSURLAndFormatPropertyValue) {
                        line.append("\"" + this.escapeDoubleQuotes(((CSSURLAndFormatPropertyValue)val).toString()) + "\"");
                        continue;
                    }
                    if (val instanceof CSSMultiValuePropertyValue) {
                        line.append("\"" + ((CSSMultiValuePropertyValue)val).toString() + "\"");
                        continue;
                    }
                    line.append("unexpected value type: " + val.toString());
                }
                line.append("]");
            } else if (value instanceof CSSMultiValuePropertyValue) {
                values = ((CSSMultiValuePropertyValue)value).getElements();
                line.append("[");
                boolean firstone = true;
                for (ICSSPropertyValue val : values) {
                    if (firstone) {
                        firstone = false;
                    } else {
                        line.append(", ");
                    }
                    if (val instanceof CSSStringPropertyValue) {
                        line.append("\"" + this.escapeDoubleQuotes(((CSSStringPropertyValue)val).getValue()) + "\"");
                        continue;
                    }
                    if (val instanceof CSSColorPropertyValue) {
                        line.append(new Integer(((CSSColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (val instanceof CSSRgbColorPropertyValue) {
                        line.append(new Integer(((CSSRgbColorPropertyValue)val).getColorAsInt()));
                        continue;
                    }
                    if (val instanceof CSSRgbaColorPropertyValue) {
                        line.append(new Long(((CSSRgbaColorPropertyValue)val).getColorAsLong()));
                        continue;
                    }
                    if (val instanceof CSSKeywordPropertyValue) {
                        keywordValue = (CSSKeywordPropertyValue)val;
                        keywordString = keywordValue.getKeyword();
                        if ("true".equals(keywordString)) {
                            line.append("true");
                            continue;
                        }
                        if ("false".equals(keywordString)) {
                            line.append("false");
                            continue;
                        }
                        line.append("\"" + ((CSSKeywordPropertyValue)val).getKeyword() + "\"");
                        continue;
                    }
                    if (val instanceof CSSNumberPropertyValue) {
                        line.append(new Double(((CSSNumberPropertyValue)val).getNumber().doubleValue()));
                        continue;
                    }
                    if (val instanceof CSSURLAndFormatPropertyValue) {
                        line.append("\"" + this.escapeDoubleQuotes(((CSSURLAndFormatPropertyValue)val).toString()) + "\"");
                        continue;
                    }
                    if (val instanceof CSSMultiValuePropertyValue) {
                        line.append("\"" + ((CSSMultiValuePropertyValue)val).toString() + "\"");
                        continue;
                    }
                    line.append("unexpected value type: " + val.toString());
                }
                line.append("]");
            } else if (value instanceof CSSStringPropertyValue) {
                line.append("\"" + ((CSSStringPropertyValue)value).getValue() + "\"");
            } else if (value instanceof CSSColorPropertyValue) {
                line.append(new Integer(((CSSColorPropertyValue)value).getColorAsInt()));
            } else if (value instanceof CSSRgbColorPropertyValue) {
                line.append(new Integer(((CSSRgbColorPropertyValue)value).getColorAsInt()));
            } else if (value instanceof CSSRgbaColorPropertyValue) {
                line.append(new Long(((CSSRgbaColorPropertyValue)value).getColorAsLong()));
            } else if (value instanceof CSSKeywordPropertyValue) {
                CSSKeywordPropertyValue keywordValue2 = (CSSKeywordPropertyValue)value;
                String keywordString2 = keywordValue2.getKeyword();
                if ("true".equals(keywordString2)) {
                    line.append("true");
                } else if ("false".equals(keywordString2)) {
                    line.append("false");
                } else {
                    line.append("\"" + ((CSSKeywordPropertyValue)value).getKeyword() + "\"");
                }
            } else if (value instanceof CSSNumberPropertyValue) {
                line.append(new Double(((CSSNumberPropertyValue)value).getNumber().doubleValue()));
            } else if (value instanceof CSSFunctionCallPropertyValue) {
                CSSFunctionCallPropertyValue functionCall = (CSSFunctionCallPropertyValue)value;
                if ("ClassReference".equals(functionCall.name)) {
                    String className = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw((String)functionCall.rawArguments);
                    if ("null".equals(className)) {
                        line.append("null");
                    } else {
                        line.append(this.formatQualifiedName(className));
                        this.requires.add(className);
                    }
                } else if ("url".equals(functionCall.name)) {
                    String urlString = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw((String)functionCall.rawArguments);
                    line.append("\"" + urlString + "\"");
                } else if (!"PropertyReference".equals(functionCall.name)) {
                    if ("calc".equals(functionCall.name)) {
                        line.append("null");
                    } else if (!"Embed".equals(functionCall.name)) {
                        if (this.otherCSSFunctions.contains(functionCall.name)) {
                            line.append("null");
                        } else {
                            assert (false) : "CSS parser bug: unexpected function call property value: " + functionCall;
                            throw new IllegalStateException("Unexpected function call property value: " + functionCall);
                        }
                    }
                }
            }
            listOfProps.add(line.toString());
        }
        Collections.sort(listOfProps);
        boolean firstProp = true;
        for (String line2 : listOfProps) {
            if (!firstProp) {
                result.append(";\n");
            }
            firstProp = false;
            result.append(line2);
        }
        result.append("}");
        return result.toString();
    }

    protected boolean keepRule(ICSSRule newRule) {
        if (super.keepRule(newRule)) {
            return true;
        }
        if (newRule.getSelectorGroup().size() > 0) {
            ICSSSelector selector = (ICSSSelector)newRule.getSelectorGroup().get(0);
            String elementName = selector.getElementName();
            if (elementName != null) {
                if (this.htmlElementNames.contains(elementName)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private String formatQualifiedName(String name) {
        return name;
    }
}

