/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.as.IASEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogDocEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.problems.PublicVarWarningProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

public class JSRoyaleDocEmitter
extends JSGoogDocEmitter {
    private List<String> classIgnoreList;
    private List<String> ignoreList;
    private List<String> coercionList;
    private Map<String, List<String>> localSettings;
    public boolean emitStringConversions = true;
    private boolean emitExports = true;
    private boolean exportProtected = false;
    private boolean suppressClosure = false;
    private boolean usedNames = false;

    public JSRoyaleDocEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    public List<String> getClassIgnoreList() {
        return this.classIgnoreList;
    }

    public void setClassIgnoreList(List<String> value) {
        this.classIgnoreList = value;
    }

    public Boolean getSuppressClosure() {
        return this.suppressClosure;
    }

    public Boolean getEmitExports() {
        return this.emitExports;
    }

    @Override
    protected String convertASTypeToJS(String name, String pname) {
        if (this.ignoreList != null && this.ignoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.coercionList != null && !this.coercionList.contains(pname + "." + name)) {
            return "Object";
        }
        if (this.classIgnoreList != null && this.classIgnoreList.contains(pname + "." + name)) {
            return "Object";
        }
        if (name.matches("Vector\\.<.*>")) {
            String vectorClassName;
            RoyaleJSProject fjp = (RoyaleJSProject)((IASEmitter)this.emitter).getWalker().getProject();
            String string = vectorClassName = fjp.config == null ? null : fjp.config.getJsVectorEmulationClass();
            if (vectorClassName != null) {
                return vectorClassName;
            }
            return super.convertASTypeToJS(name, pname);
        }
        if ((name = super.convertASTypeToJS(name, pname)).equals("Boolean".toLowerCase()) || name.equals("String".toLowerCase()) || name.equals("Number".toLowerCase())) {
            return name;
        }
        return this.formatQualifiedName(name);
    }

    @Override
    protected String formatQualifiedName(String name) {
        return ((JSRoyaleEmitter)this.emitter).formatQualifiedName(name, !this.usedNames);
    }

    @Override
    public void emitMethodDoc(IFunctionNode node, ICompilerProject project) {
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        boolean suppressExports = false;
        if (this.emitter instanceof JSRoyaleEmitter) {
            suppressExports = ((JSRoyaleEmitter)this.emitter).getModel().suppressExports;
        }
        if (fjp.config != null) {
            this.emitExports = !suppressExports && fjp.config.getExportPublicSymbols();
            this.exportProtected = !suppressExports && fjp.config.getExportProtectedSymbols();
        }
        this.coercionList = null;
        this.ignoreList = null;
        this.localSettings = null;
        this.emitStringConversions = true;
        this.suppressClosure = false;
        IClassDefinition classDefinition = this.resolveClassDefinition(node);
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        if (node instanceof IFunctionNode) {
            boolean hasDoc = false;
            Boolean override = false;
            if (node.isConstructor()) {
                String qname;
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
                this.emitJSDocLine(JSEmitterTokens.CONSTRUCTOR);
                IClassDefinition parent = (IClassDefinition)node.getDefinition().getParent();
                IClassDefinition superClass = parent.resolveBaseClass(project);
                String string = qname = superClass != null ? project.getActualPackageName(superClass.getQualifiedName()) : null;
                if ((superClass == null || qname.equals("Object")) && ((JSRoyaleEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.EXTENDS) {
                    superClass = (IClassDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_CLASS_QNAME);
                    if (superClass == null) {
                        System.out.println(BindableEmitter.DISPATCHER_CLASS_QNAME + " not resolved for implicit super class in " + classDefinition.getQualifiedName());
                    } else {
                        qname = BindableEmitter.DISPATCHER_CLASS_QNAME;
                    }
                }
                this.usedNames = true;
                if (superClass != null && !qname.equals("Object")) {
                    this.emitExtends(superClass, superClass.getPackageName());
                }
                IReference[] references = classDefinition.getImplementedInterfaceReferences();
                Boolean sawIEventDispatcher = false;
                Boolean needsIEventDispatcher = ((JSRoyaleEmitter)this.emitter).getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS;
                for (IReference iReference : references) {
                    ITypeDefinition type = (ITypeDefinition)iReference.resolve(project, (IASScope)((ASScope)classDefinition.getContainingScope()), DependencyType.INHERITANCE, true);
                    if (type == null) {
                        System.out.println(iReference.getDisplayString() + " not resolved in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                    if (type.getQualifiedName() != BindableEmitter.DISPATCHER_INTERFACE_QNAME) continue;
                    sawIEventDispatcher = true;
                }
                if (needsIEventDispatcher.booleanValue() && !sawIEventDispatcher.booleanValue()) {
                    ITypeDefinition type = (ITypeDefinition)project.resolveQNameToDefinition(BindableEmitter.DISPATCHER_INTERFACE_QNAME);
                    if (type == null) {
                        System.out.println(BindableEmitter.DISPATCHER_INTERFACE_QNAME + " not resolved for implicit implementation in " + classDefinition.getQualifiedName());
                    } else {
                        this.emitImplements(type, project.getActualPackageName(type.getPackageName()));
                    }
                }
                this.usedNames = false;
            } else {
                override = node.hasModifier(ASModifier.OVERRIDE);
                String ns = node.getNamespace();
                if (ns != null) {
                    if (asDoc != null && keepASDoc) {
                        String suppressExport;
                        String suppressClosureToken;
                        String suppressVectorIndexCheck;
                        String noResolveUncertain;
                        String noImplicitComplexCoercion;
                        String noStringToken;
                        String ignoreToken;
                        String keepToken;
                        IParameterNode[] docText = asDoc.commentNoEnd();
                        if (docText.contains(keepToken = JSRoyaleEmitterTokens.EMIT_COERCION.getToken())) {
                            this.loadKeepers((String)docText);
                        }
                        if (docText.contains(ignoreToken = JSRoyaleEmitterTokens.IGNORE_COERCION.getToken())) {
                            this.loadIgnores((String)docText);
                        }
                        if (docText.contains(noStringToken = JSRoyaleEmitterTokens.IGNORE_STRING_COERCION.getToken())) {
                            this.emitStringConversions = false;
                        }
                        if (docText.contains(noImplicitComplexCoercion = JSRoyaleEmitterTokens.SUPPRESS_COMPLEX_IMPLICIT_COERCION.getToken())) {
                            this.loadLocalSettings((String)docText, noImplicitComplexCoercion, "true");
                        }
                        if (docText.contains(noResolveUncertain = JSRoyaleEmitterTokens.SUPPRESS_RESOLVE_UNCERTAIN.getToken())) {
                            this.loadLocalSettings((String)docText, noResolveUncertain, "true");
                        }
                        if (docText.contains(suppressVectorIndexCheck = JSRoyaleEmitterTokens.SUPPRESS_VECTOR_INDEX_CHECK.getToken())) {
                            this.loadLocalSettings((String)docText, suppressVectorIndexCheck, "true");
                        }
                        if (docText.contains(suppressClosureToken = JSRoyaleEmitterTokens.SUPPRESS_CLOSURE.getToken())) {
                            this.suppressClosure = true;
                        }
                        if (docText.contains(suppressExport = JSRoyaleEmitterTokens.SUPPRESS_EXPORT.getToken())) {
                            this.emitExports = false;
                            if ("public".equals(ns)) {
                                ((JSRoyaleEmitter)this.emitter).getModel().suppressedExportNodes.add((IASNode)node);
                            }
                        }
                        this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                    } else {
                        this.begin();
                    }
                    this.emitMethodAccess(node);
                    hasDoc = true;
                }
            }
            if (!override.booleanValue()) {
                IParameterNode[] parameters;
                for (IParameterNode pnode : parameters = node.getParameterNodes()) {
                    IExpressionNode enode;
                    ITypeDefinition tdef;
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    if ((tdef = (enode = pnode.getNameExpressionNode()).resolveType(project)) == null) continue;
                    this.emitParam(pnode, project.getActualPackageName(tdef.getPackageName()));
                }
            }
            if (!node.isConstructor()) {
                String returnType;
                if (!override.booleanValue() && (returnType = node.getReturnType()) != "" && returnType != ASEmitterTokens.VOID.getToken()) {
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    ITypeDefinition tdef = node.getDefinition().resolveReturnType(project);
                    String packageName = "";
                    packageName = tdef != null ? tdef.getPackageName() : "";
                    this.emitReturn(node, project.getActualPackageName(packageName));
                }
                if (override.booleanValue()) {
                    if (!hasDoc) {
                        if (asDoc != null && keepASDoc) {
                            this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                        } else {
                            this.begin();
                        }
                        this.emitMethodAccess(node);
                        hasDoc = true;
                    }
                    this.emitOverride(node);
                }
            }
            if (hasDoc) {
                this.end();
            }
        }
    }

    private void loadLocalSettings(String doc, String settingToken, String defaultSetting) {
        List<String> settings;
        if (this.localSettings == null) {
            this.localSettings = new HashMap<String, List<String>>();
        }
        int index = doc.indexOf(settingToken);
        List<String> list = settings = this.localSettings.containsKey(settingToken) ? this.localSettings.get(settingToken) : null;
        while (index != -1) {
            String setting = doc.substring(index + settingToken.length());
            int endIndex = setting.indexOf("\n");
            setting = setting.substring(0, endIndex);
            setting = setting.trim();
            if (settings == null) {
                settings = new ArrayList<String>();
                this.localSettings.put(settingToken, settings);
            }
            List<String> settingItems = null;
            settingItems = setting.length() > 0 ? Arrays.asList(setting.split("\\s*(,\\s*)+")) : Arrays.asList(defaultSetting);
            for (String settingItem : settingItems) {
                if (settings.contains(settingItem)) {
                    settings.remove(settingItem);
                }
                settings.add(settingItem);
            }
            index = doc.indexOf(settingToken, index + settingToken.length());
        }
    }

    public boolean hasLocalSetting(String settingToken) {
        if (this.localSettings == null) {
            return false;
        }
        return this.localSettings.keySet().contains(settingToken);
    }

    public boolean getLocalSettingAsBoolean(JSRoyaleEmitterTokens token, Boolean defaultValue) {
        return this.getLocalSettingAsBoolean(token.getToken(), defaultValue);
    }

    public boolean getLocalSettingAsBoolean(String settingToken, Boolean defaultValue) {
        boolean setting = defaultValue;
        if (this.hasLocalSetting(settingToken)) {
            for (String stringVal : this.localSettings.get(settingToken)) {
                if (stringVal.equals("false")) {
                    setting = false;
                    continue;
                }
                if (!stringVal.equals("true")) continue;
                setting = true;
            }
        }
        return setting;
    }

    public boolean getLocalSettingIncludesString(JSRoyaleEmitterTokens token, String searchValue) {
        return this.getLocalSettingIncludesString(token.getToken(), searchValue);
    }

    public boolean getLocalSettingIncludesString(String settingToken, String searchValue) {
        boolean hasValue = false;
        if (this.hasLocalSetting(settingToken)) {
            for (String stringVal : this.localSettings.get(settingToken)) {
                if (!stringVal.equals(searchValue)) continue;
                hasValue = true;
                break;
            }
        }
        return hasValue;
    }

    private void loadIgnores(String doc) {
        this.ignoreList = new ArrayList<String>();
        String ignoreToken = JSRoyaleEmitterTokens.IGNORE_COERCION.getToken();
        int index = doc.indexOf(ignoreToken);
        while (index != -1) {
            String ignore = doc.substring(index + ignoreToken.length());
            int endIndex = ignore.indexOf("\n");
            ignore = ignore.substring(0, endIndex);
            ignore = ignore.trim();
            this.ignoreList.add(ignore);
            index = doc.indexOf(ignoreToken, index + endIndex);
        }
    }

    public boolean hasIgnore(String qName) {
        return this.ignoreList != null && qName != null && this.ignoreList.contains(qName);
    }

    private void loadKeepers(String doc) {
        this.coercionList = new ArrayList<String>();
        String keepToken = JSRoyaleEmitterTokens.EMIT_COERCION.getToken();
        int index = doc.indexOf(keepToken);
        while (index != -1) {
            String keeper = doc.substring(index + keepToken.length());
            int endIndex = keeper.indexOf("\n");
            keeper = keeper.substring(0, endIndex);
            keeper = keeper.trim();
            this.coercionList.add(keeper);
            index = doc.indexOf(keepToken, index + endIndex);
        }
    }

    private String changeAnnotations(String doc) {
        String pass1 = doc.replaceAll("@param", "@asparam");
        String pass2 = pass1.replaceAll("@return", "@asreturn");
        String pass3 = pass2.replaceAll("@private", "@asprivate");
        return pass3;
    }

    @Override
    public void emitInterfaceMemberDoc(IDefinitionNode node, ICompilerProject project) {
        IParameterNode[] parameters;
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        boolean hasDoc = false;
        ASDocComment asDoc = (ASDocComment)((IFunctionNode)node).getASDocComment();
        String returnType = ((IFunctionNode)node).getReturnType();
        if (returnType != "" && returnType != ASEmitterTokens.VOID.getToken()) {
            if (asDoc != null && keepASDoc) {
                this.write(this.changeAnnotations(asDoc.commentNoEnd()));
            } else {
                this.begin();
            }
            hasDoc = true;
            ITypeDefinition tdef = ((IFunctionDefinition)node.getDefinition()).resolveReturnType(project);
            this.emitReturn((IFunctionNode)node, tdef.getPackageName());
        }
        for (IParameterNode pnode : parameters = ((IFunctionNode)node).getParameterNodes()) {
            if (!hasDoc) {
                if (asDoc != null && keepASDoc) {
                    this.write(this.changeAnnotations(asDoc.commentNoEnd()));
                } else {
                    this.begin();
                }
                hasDoc = true;
            }
            IExpressionNode enode = pnode.getNameExpressionNode();
            this.emitParam(pnode, enode.resolveType(project).getPackageName());
        }
        if (hasDoc) {
            this.end();
        }
    }

    @Override
    public void emitMethodAccess(IFunctionNode node) {
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            this.emitProtected((IASNode)node);
        } else {
            this.emitPublic((IASNode)node);
        }
    }

    @Override
    public void emitFieldDoc(IVariableNode node, IDefinition def, ICompilerProject project) {
        this.begin();
        RoyaleJSProject fjp = (RoyaleJSProject)project;
        String ns = node.getNamespace();
        if (ns == "private") {
            this.emitPrivate((IASNode)node);
        } else if (ns == "protected") {
            boolean preventRename;
            this.emitProtected((IASNode)node);
            boolean bl = preventRename = fjp.config != null && fjp.config.getPreventRenameProtectedSymbols();
            if (preventRename && node.hasModifier(ASModifier.STATIC) && !(node instanceof IAccessorNode)) {
                this.emitJSDocLine(JSGoogDocEmitterTokens.NOCOLLAPSE);
            }
        } else {
            boolean avoidExport;
            IMetaTagNode tag;
            boolean warnPublicVars = fjp.config != null && fjp.config.getWarnPublicVars() && !fjp.config.getPreventRenamePublicSymbols();
            IMetaTagsNode meta = node.getMetaTags();
            boolean bindable = false;
            if (meta != null && (tag = meta.getTagByName("Bindable")) != null) {
                bindable = true;
            }
            if (warnPublicVars && !node.isConst() && !bindable && ns.contentEquals("public")) {
                IVariableNode warningNode = node;
                int childCount = node.getChildCount();
                for (int index = 0; index < childCount; ++index) {
                    IASNode child = node.getChild(index);
                    if (!(child instanceof IIdentifierNode) || !((IIdentifierNode)child).getName().equals("public")) continue;
                    warningNode = child;
                    break;
                }
                if (!this.suppressedWarning(node, fjp)) {
                    fjp.getProblems().add(new PublicVarWarningProblem(node.getSourcePath(), node.getStart(), node.getEnd(), warningNode.getLine(), warningNode.getColumn(), node.getEndLine(), node.getEndColumn()));
                }
            }
            boolean bl = avoidExport = node.getASDocComment() instanceof ASDocComment && ((ASDocComment)node.getASDocComment()).commentNoEnd().contains(JSRoyaleEmitterTokens.SUPPRESS_EXPORT.getToken());
            if (!avoidExport) {
                if (ns.equals("public")) {
                    boolean preventRename;
                    this.emitPublic((IASNode)node);
                    boolean bl2 = preventRename = fjp.config != null && fjp.config.getPreventRenamePublicSymbols();
                    if (preventRename && node.hasModifier(ASModifier.STATIC) && !(node instanceof IAccessorNode)) {
                        this.emitJSDocLine(JSGoogDocEmitterTokens.NOCOLLAPSE);
                    }
                }
            } else {
                ((JSRoyaleEmitter)this.emitter).getModel().suppressedExportNodes.add((IASNode)node);
            }
        }
        if (node.isConst()) {
            this.emitConst(node);
        }
        String packageName = "";
        if (def != null) {
            packageName = def.getPackageName();
        }
        this.emitType((IASNode)node, project.getActualPackageName(packageName), project);
        this.end();
    }

    @Override
    public void emitProtected(IASNode node) {
        if (this.exportProtected) {
            super.emitPublic(node);
        } else {
            super.emitProtected(node);
        }
    }

    @Override
    public void emitPublic(IASNode node) {
        if (this.emitExports) {
            super.emitPublic(node);
        }
    }

    private boolean suppressedWarning(IVariableNode node, RoyaleJSProject fjp) {
        String docText;
        ASDocComment asDoc = (ASDocComment)node.getASDocComment();
        boolean keepASDoc = fjp.config != null && fjp.config.getKeepASDoc();
        String suppressToken = JSRoyaleEmitterTokens.SUPPRESS_PUBLIC_VAR_WARNING.getToken();
        if (asDoc != null && keepASDoc && (docText = asDoc.commentNoEnd()).contains(suppressToken)) {
            return true;
        }
        IASNode classNode = node.getParent().getParent();
        if (classNode == null) {
            return false;
        }
        if (classNode.getNodeID() == ASTNodeID.ClassID) {
            String docText2;
            asDoc = (ASDocComment)((IClassNode)classNode).getASDocComment();
            if (asDoc != null && keepASDoc && (docText2 = asDoc.commentNoEnd()).contains(suppressToken)) {
                return true;
            }
            IClassDefinition cdef = ((IClassNode)classNode).getDefinition();
            if (cdef.isBindable()) {
                return true;
            }
            if (!cdef.isPublic()) {
                return true;
            }
        }
        return false;
    }
}

