/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.AggressiveInlineAliases;
import com.google.javascript.jscomp.AliasStrings;
import com.google.javascript.jscomp.AmbiguateProperties;
import com.google.javascript.jscomp.AngularPass;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckConstPrivateProperties;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.CheckMissingGetCssName;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.ChromePass;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureCodeRemoval;
import com.google.javascript.jscomp.ClosureOptimizePrimitives;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CoalesceVariableNames;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollapseAnonymousFunctions;
import com.google.javascript.jscomp.CollapsePropertiesWithModuleSupport;
import com.google.javascript.jscomp.CollapseVariableDeclarations;
import com.google.javascript.jscomp.CollectFunctionNames;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConstParamCheck;
import com.google.javascript.jscomp.ConvertToDottedProperties;
import com.google.javascript.jscomp.CoverageInstrumentationPass;
import com.google.javascript.jscomp.CreateSyntheticBlocks;
import com.google.javascript.jscomp.CrossChunkCodeMotion;
import com.google.javascript.jscomp.CrossChunkMethodMotion;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DartSuperAccessorsPass;
import com.google.javascript.jscomp.DeadAssignmentsElimination;
import com.google.javascript.jscomp.DeadPropertyAssignmentElimination;
import com.google.javascript.jscomp.DeclaredGlobalExternsOnWindow;
import com.google.javascript.jscomp.Denormalize;
import com.google.javascript.jscomp.DevirtualizePrototypeMethods;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguatePrivateProperties;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.ErrorPass;
import com.google.javascript.jscomp.Es6CheckModule;
import com.google.javascript.jscomp.Es6RewriteScriptsToModules;
import com.google.javascript.jscomp.Es6ToEs3ClassSideInheritance;
import com.google.javascript.jscomp.Es6TypedToEs6Converter;
import com.google.javascript.jscomp.ExploitAssigns;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.ExternExportsPass;
import com.google.javascript.jscomp.ExtractPrototypeMemberDeclarations;
import com.google.javascript.jscomp.FlowSensitiveInlineVariables;
import com.google.javascript.jscomp.FunctionRewriter;
import com.google.javascript.jscomp.GatherExternProperties;
import com.google.javascript.jscomp.GatherGettersAndSetterProperties;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.GatherRawExports;
import com.google.javascript.jscomp.GenerateExports;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GoogleJsMessageIdGenerator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.InferConsts;
import com.google.javascript.jscomp.InjectRuntimeLibraries;
import com.google.javascript.jscomp.InlineAliases;
import com.google.javascript.jscomp.InlineFunctions;
import com.google.javascript.jscomp.InlineObjectLiterals;
import com.google.javascript.jscomp.InlineProperties;
import com.google.javascript.jscomp.InlineSimpleMethods;
import com.google.javascript.jscomp.InlineVariables;
import com.google.javascript.jscomp.InstrumentFunctions;
import com.google.javascript.jscomp.J2clAssertRemovalPass;
import com.google.javascript.jscomp.J2clChecksPass;
import com.google.javascript.jscomp.J2clClinitPrunerPass;
import com.google.javascript.jscomp.J2clConstantHoisterPass;
import com.google.javascript.jscomp.J2clEqualitySameRewriterPass;
import com.google.javascript.jscomp.J2clPass;
import com.google.javascript.jscomp.J2clPropertyInlinerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.J2clStringValueOfRewriterPass;
import com.google.javascript.jscomp.J2clUtilGetDefineRewriterPass;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.MarkNoSideEffectCalls;
import com.google.javascript.jscomp.MinimizeExitPoints;
import com.google.javascript.jscomp.MoveFunctionDeclarations;
import com.google.javascript.jscomp.NameAnonymousFunctions;
import com.google.javascript.jscomp.NameAnonymousFunctionsMapped;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.ObjectPropertyStringPostprocess;
import com.google.javascript.jscomp.ObjectPropertyStringPreprocess;
import com.google.javascript.jscomp.OptimizeArgumentsArray;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.OptimizeParameters;
import com.google.javascript.jscomp.OptimizeReturns;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PeepholeCollectPropertyAssignments;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeMinimizeConditions;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeReorderConstantExpression;
import com.google.javascript.jscomp.PeepholeReplaceKnownMethods;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitivesWithModuleSupport;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.RemoveUnusedCode;
import com.google.javascript.jscomp.RemoveUnusedPolyfills;
import com.google.javascript.jscomp.RemoveWeakSources;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.jscomp.RenamePropertiesWithModuleSupport;
import com.google.javascript.jscomp.RenameVarsWithModuleSupport;
import com.google.javascript.jscomp.ReplaceCssNames;
import com.google.javascript.jscomp.ReplaceIdGenerators;
import com.google.javascript.jscomp.ReplaceMessages;
import com.google.javascript.jscomp.ReplaceMessagesForChrome;
import com.google.javascript.jscomp.ReplaceStrings;
import com.google.javascript.jscomp.RescopeGlobalSymbols;
import com.google.javascript.jscomp.RewriteGoogJsImports;
import com.google.javascript.jscomp.RuntimeTypeCheck;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.StatementFusion;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.StripCode;
import com.google.javascript.jscomp.SubstituteEs6Syntax;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.UnreachableCodeElimination;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WhitespaceWrapGoogModules;
import com.google.javascript.jscomp.ijs.ConvertToTypedInterface;
import com.google.javascript.jscomp.lint.CheckArrayWithGoogObject;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckEs6ModuleFileStructure;
import com.google.javascript.jscomp.lint.CheckEs6Modules;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNoMutatedEs6Exports;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckNullableReturn;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class RoyaleClosurePassConfig
extends PassConfig {
    private static final String COMPILED_CONSTANT_NAME = "COMPILED";
    private static final String CLOSURE_LOCALE_CONSTANT_NAME = "goog.LOCALE";
    static final DiagnosticType CANNOT_USE_PROTOTYPE_AND_VAR = DiagnosticType.error((String)"JSC_CANNOT_USE_PROTOTYPE_AND_VAR", (String)"Rename prototypes and inline variables cannot be used together.");
    private static final Pattern GLOBAL_SYMBOL_NAMESPACE_PATTERN = Pattern.compile("^[a-zA-Z0-9$_]+$");
    private transient GlobalNamespace namespaceForChecks = null;
    private final transient PreprocessorSymbolTable.CachedInstanceFactory preprocessorSymbolTableFactory;
    private transient ClosureRewriteModule.GlobalRewriteState moduleRewriteState = null;
    private final boolean protectHiddenSideEffects;
    private String sourceFileName;
    private File varRenameMapFile;
    private Set<String> propertyNamesToKeep;
    private final PassFactory.HotSwapPassFactory checkSideEffects = new PassFactory.HotSwapPassFactory("checkSideEffects"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckSideEffects(compiler, RoyaleClosurePassConfig.this.options.checkSuspiciousCode, RoyaleClosurePassConfig.this.protectHiddenSideEffects);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory stripSideEffectProtection = new PassFactory("stripSideEffectProtection", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckSideEffects.StripProtection(compiler);
        }

        public FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory.HotSwapPassFactory suspiciousCode = new PassFactory.HotSwapPassFactory("suspiciousCode"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ArrayList<Object> sharedCallbacks = new ArrayList<Object>();
            if (RoyaleClosurePassConfig.this.options.checkSuspiciousCode) {
                sharedCallbacks.add(new CheckSuspiciousCode());
                sharedCallbacks.add(new CheckDuplicateCase(compiler));
            }
            if (RoyaleClosurePassConfig.this.options.enables(DiagnosticGroups.GLOBAL_THIS)) {
                sharedCallbacks.add(new CheckGlobalThis(compiler));
            }
            if (RoyaleClosurePassConfig.this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
                sharedCallbacks.add(new CheckDebuggerStatement(compiler));
            }
            return RoyaleClosurePassConfig.combineChecks(compiler, sharedCallbacks);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkRequires = new PassFactory.HotSwapPassFactory("checkMissingAndExtraRequires"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckMissingAndExtraRequires(compiler, CheckMissingAndExtraRequires.Mode.FULL_COMPILE);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkProvides = new PassFactory.HotSwapPassFactory("checkProvides"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckProvides(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private static final DiagnosticType GENERATE_EXPORTS_ERROR = DiagnosticType.error((String)"JSC_GENERATE_EXPORTS_ERROR", (String)"Exports can only be generated if export symbol/property functions are set.");
    private final PassFactory.HotSwapPassFactory checkJsDocAndEs6Modules = new PassFactory.HotSwapPassFactory("checkJsDocAndEs6Modules"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableCollection.Builder callbacks = ((ImmutableList.Builder)ImmutableList.builder().add(new CheckJSDoc(compiler))).add(new Es6CheckModule(compiler));
            return RoyaleClosurePassConfig.combineChecks(compiler, (List)((Object)((ImmutableList.Builder)callbacks).build()));
        }

        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory generateExports = new PassFactory("generateExports", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null && convention.getExportPropertyFunction() != null) {
                final GenerateExports pass = new GenerateExports(compiler, RoyaleClosurePassConfig.this.options.exportLocalPropertyDefinitions, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
                return new CompilerPass(){

                    public void process(Node externs, Node root) {
                        pass.process(externs, root);
                        compiler.addExportedNames(pass.getExportedVariableNames());
                    }
                };
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private final PassFactory generateIjs = new PassFactory("generateIjs", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConvertToTypedInterface(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory exportTestFunctions = new PassFactory("exportTestFunctions", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null) {
                return new ExportTestFunctions(compiler, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory keepPropertyNamesPass = new PassFactory("keep-property-names", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    Node propsObj = new Node(Token.OBJECTLIT);
                    for (String nameToKeep : RoyaleClosurePassConfig.this.propertyNamesToKeep) {
                        Node nameStringKey = IR.stringKey((String)nameToKeep);
                        JSDocInfoBuilder builder = new JSDocInfoBuilder(true);
                        builder.recordExport();
                        JSDocInfo jsDocInfo = builder.build();
                        nameStringKey.setJSDocInfo(jsDocInfo);
                        Node propertyDescriptor = new Node(Token.OBJECTLIT);
                        propertyDescriptor.addChildToBack(IR.propdef((Node)IR.stringKey((String)"get"), (Node)NodeUtil.emptyFunction()));
                        Node prop = IR.propdef((Node)nameStringKey, (Node)propertyDescriptor);
                        propsObj.addChildToBack(prop);
                    }
                    Node definePropertiesTarget = NodeUtil.newQName((AbstractCompiler)compiler, (String)"Object.defineProperties");
                    Node definePropertiesCall = IR.call((Node)definePropertiesTarget, (Node[])new Node[]{IR.objectlit((Node[])new Node[0]), propsObj});
                    Node expression = IR.exprResult((Node)definePropertiesCall);
                    Node scriptNode = compiler.getScriptNode(RoyaleClosurePassConfig.this.sourceFileName);
                    scriptNode.addChildToBack(expression);
                    compiler.reportChangeToEnclosingScope(expression);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory gatherRawExports = new PassFactory("gatherRawExports", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            final GatherRawExports pass = new GatherRawExports(compiler);
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.addExportedNames(pass.getExportedVariableNames());
                }
            };
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory closurePrimitives = new PassFactory.HotSwapPassFactory("closurePrimitives"){

        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            RoyaleClosurePassConfig.this.preprocessorSymbolTableFactory.maybeInitialize(compiler);
            final ProcessClosurePrimitivesWithModuleSupport pass = new ProcessClosurePrimitivesWithModuleSupport(compiler, RoyaleClosurePassConfig.this.preprocessorSymbolTableFactory.getInstanceOrNull(), RoyaleClosurePassConfig.this.options.brokenClosureRequiresLevel, RoyaleClosurePassConfig.this.options.shouldPreservesGoogProvidesAndRequires());
            return new HotSwapCompilerPass(){

                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.addExportedNames(pass.getExportedVariableNames());
                }

                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    pass.hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory angularPass = new PassFactory.HotSwapPassFactory("angularPass"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new AngularPass(compiler);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory replaceMessages = new PassFactory("replaceMessages", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ReplaceMessages(compiler, RoyaleClosurePassConfig.this.options.messageBundle, true, JsMessage.Style.CLOSURE, false);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory replaceMessagesForChrome = new PassFactory("replaceMessages", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ReplaceMessagesForChrome(compiler, (JsMessage.IdGenerator)new GoogleJsMessageIdGenerator(RoyaleClosurePassConfig.this.options.tcProjectId), true, JsMessage.Style.CLOSURE);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory closureGoogScopeAliases = new PassFactory.HotSwapPassFactory("closureGoogScopeAliases"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            RoyaleClosurePassConfig.this.preprocessorSymbolTableFactory.maybeInitialize(compiler);
            return new ScopedAliases(compiler, RoyaleClosurePassConfig.this.preprocessorSymbolTableFactory.getInstanceOrNull(), RoyaleClosurePassConfig.this.options.getAliasTransformationHandler());
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory injectRuntimeLibraries = new PassFactory("InjectRuntimeLibraries", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InjectRuntimeLibraries(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    final PassFactory.HotSwapPassFactory convertEs6TypedToEs6 = new PassFactory.HotSwapPassFactory("convertEs6Typed"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6TypedToEs6Converter(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPESCRIPT;
        }
    };
    private final PassFactory convertStaticInheritance = new PassFactory("Es6StaticInheritance", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6ToEs3ClassSideInheritance(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory inlineTypeAliases = new PassFactory("inlineTypeAliases", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineAliases(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private final PassFactory aggressiveInlineAliases = new PassFactory("aggressiveInlineAliases", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new AggressiveInlineAliases(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory removeWeakSources = new PassFactory("removeWeakSources", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new RemoveWeakSources(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory declaredGlobalExternsOnWindow = new PassFactory("declaredGlobalExternsOnWindow", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeclaredGlobalExternsOnWindow(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory closureRewriteClass = new PassFactory.HotSwapPassFactory("closureRewriteClass"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteClass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory closureCheckModule = new PassFactory.HotSwapPassFactory("closureCheckModule"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureCheckModule(compiler, compiler.getModuleMetadataMap());
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory closureRewriteModule = new PassFactory.HotSwapPassFactory("closureRewriteModule"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            RoyaleClosurePassConfig.this.preprocessorSymbolTableFactory.maybeInitialize(compiler);
            RoyaleClosurePassConfig.this.maybeInitializeModuleRewriteState();
            return new ClosureRewriteModule(compiler, RoyaleClosurePassConfig.this.preprocessorSymbolTableFactory.getInstanceOrNull(), RoyaleClosurePassConfig.this.moduleRewriteState);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory rewriteGoogJsImports = new PassFactory.HotSwapPassFactory("rewriteGoogJsImports"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewriteGoogJsImports(compiler, RewriteGoogJsImports.Mode.LINT_AND_REWRITE);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory closureCheckGetCssName = new PassFactory("closureCheckGetCssName", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckMissingGetCssName(compiler, RoyaleClosurePassConfig.this.options.checkMissingGetCssNameLevel, RoyaleClosurePassConfig.this.options.checkMissingGetCssNameBlacklist);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory closureReplaceGetCssName = new PassFactory("closureReplaceGetCssName", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node jsRoot) {
                    HashMap newCssNames = null;
                    if (RoyaleClosurePassConfig.this.options.gatherCssNames) {
                        newCssNames = new HashMap();
                    }
                    ReplaceCssNames pass = new ReplaceCssNames(compiler, newCssNames, RoyaleClosurePassConfig.this.options.cssRenamingWhitelist);
                    pass.process(externs, jsRoot);
                    compiler.setCssNames(newCssNames);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private final PassFactory createSyntheticBlocks = new PassFactory("createSyntheticBlocks", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CreateSyntheticBlocks(compiler, RoyaleClosurePassConfig.this.options.syntheticBlockStartMarker, RoyaleClosurePassConfig.this.options.syntheticBlockEndMarker);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory earlyPeepholeOptimizations = new PassFactory("earlyPeepholeOptimizations", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            ArrayList<Object> peepholeOptimizations = new ArrayList<Object>();
            peepholeOptimizations.add(new PeepholeRemoveDeadCode());
            if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
                peepholeOptimizations.add(new J2clEqualitySameRewriterPass());
            }
            return new PeepholeOptimizationsPass(compiler, this.getName(), peepholeOptimizations);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory earlyInlineVariables = new PassFactory("earlyInlineVariables", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            InlineVariables.Mode mode;
            if (RoyaleClosurePassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (RoyaleClosurePassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(compiler, mode, true);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory peepholeOptimizations = new PassFactory("peepholeOptimizations", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return RoyaleClosurePassConfig.createPeepholeOptimizationsPass(compiler, this.getName());
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory peepholeOptimizationsOnce = new PassFactory("peepholeOptimizations", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return RoyaleClosurePassConfig.createPeepholeOptimizationsPass(compiler, this.getName());
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory latePeepholeOptimizations = new PassFactory("latePeepholeOptimizations", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            boolean late = true;
            boolean useTypesForOptimization = RoyaleClosurePassConfig.this.options.useTypesForLocalOptimization;
            return new PeepholeOptimizationsPass(compiler, this.getName(), new AbstractPeepholeOptimization[]{new StatementFusion(RoyaleClosurePassConfig.this.options.aggressiveFusion), new PeepholeRemoveDeadCode(), new PeepholeMinimizeConditions(true), new PeepholeSubstituteAlternateSyntax(true), new PeepholeReplaceKnownMethods(true, useTypesForOptimization), new PeepholeFoldConstants(true, useTypesForOptimization), new PeepholeReorderConstantExpression()});
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory checkVars = new PassFactory.HotSwapPassFactory("checkVars"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VarCheck(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory inferConsts = new PassFactory("inferConsts", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InferConsts(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory checkRegExp = new PassFactory("checkRegExp", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            final CheckRegExp pass = new CheckRegExp(compiler);
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.setHasRegExpGlobalReferences(pass.isGlobalRegExpPropertiesUsed());
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkVariableReferencesForTranspileOnly = new PassFactory.HotSwapPassFactory("checkVariableReferences"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler, true);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory checkVariableReferences = new PassFactory.HotSwapPassFactory("checkVariableReferences"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkSuper = new PassFactory.HotSwapPassFactory("checkSuper"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckSuper(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory objectPropertyStringPreprocess = new PassFactory("ObjectPropertyStringPreprocess", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ObjectPropertyStringPreprocess(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    final PassFactory.HotSwapPassFactory resolveTypes = new PassFactory.HotSwapPassFactory("resolveTypes"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new GlobalTypeResolver(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory clearTypedScopePass = new PassFactory("clearTypedScopePass", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClearTypedScope();
        }

        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    final PassFactory.HotSwapPassFactory inferTypes = new PassFactory.HotSwapPassFactory("inferTypes"){

        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull(RoyaleClosurePassConfig.this.topScope);
                    Preconditions.checkNotNull(RoyaleClosurePassConfig.this.getTypedScopeCreator());
                    RoyaleClosurePassConfig.this.makeTypeInference(compiler).process(externs, root);
                }

                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    RoyaleClosurePassConfig.this.makeTypeInference(compiler).inferAllScopes(scriptRoot);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory inferJsDocInfo = new PassFactory.HotSwapPassFactory("inferJsDocInfo"){

        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull(RoyaleClosurePassConfig.this.topScope);
                    Preconditions.checkNotNull(RoyaleClosurePassConfig.this.getTypedScopeCreator());
                    PassConfig.makeInferJsDocInfo((AbstractCompiler)compiler).process(externs, root);
                }

                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    PassConfig.makeInferJsDocInfo((AbstractCompiler)compiler).hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory checkTypes = new PassFactory.HotSwapPassFactory("checkTypes"){

        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull(RoyaleClosurePassConfig.this.topScope);
                    Preconditions.checkNotNull(RoyaleClosurePassConfig.this.getTypedScopeCreator());
                    TypeCheck check = RoyaleClosurePassConfig.this.makeTypeCheck(compiler);
                    check.process(externs, root);
                    compiler.getErrorManager().setTypedPercent(check.getTypedPercent());
                }

                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    RoyaleClosurePassConfig.this.makeTypeCheck(compiler).check(scriptRoot, false);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory checkControlFlow = new PassFactory.HotSwapPassFactory("checkControlFlow"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ArrayList<Object> callbacks = new ArrayList<Object>();
            if (!RoyaleClosurePassConfig.this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE)) {
                callbacks.add(new CheckUnreachableCode(compiler));
            }
            if (!RoyaleClosurePassConfig.this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
                callbacks.add(new CheckMissingReturn(compiler));
            }
            return RoyaleClosurePassConfig.combineChecks(compiler, callbacks);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private final PassFactory.HotSwapPassFactory lintChecks = new PassFactory.HotSwapPassFactory("lintChecks"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableCollection.Builder callbacks = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new CheckEmptyStatements(compiler))).add(new CheckEnums(compiler))).add(new CheckEs6ModuleFileStructure(compiler))).add(new CheckEs6Modules(compiler))).add(new CheckNoMutatedEs6Exports(compiler))).add(new CheckInterfaces(compiler))).add(new CheckJSDocStyle(compiler))).add(new CheckMissingSemicolon(compiler))).add(new CheckNullabilityModifiers(compiler))).add(new CheckPrimitiveAsObject(compiler))).add(new CheckPrototypeProperties(compiler))).add(new CheckUnusedLabels(compiler))).add(new CheckUselessBlocks(compiler));
            return RoyaleClosurePassConfig.combineChecks(compiler, (List)((Object)((ImmutableList.Builder)callbacks).build()));
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory analyzerChecks = new PassFactory.HotSwapPassFactory("analyzerChecks"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableList.Builder callbacks = ImmutableList.builder();
            if (RoyaleClosurePassConfig.this.options.enables(DiagnosticGroups.ANALYZER_CHECKS_INTERNAL)) {
                ((ImmutableList.Builder)((ImmutableList.Builder)callbacks.add(new CheckNullableReturn(compiler))).add(new CheckArrayWithGoogObject(compiler))).add(new ImplicitNullabilityCheck(compiler));
            }
            if (RoyaleClosurePassConfig.this.options.enables(DiagnosticGroups.UNUSED_PRIVATE_PROPERTY)) {
                callbacks.add(new CheckUnusedPrivateProperties(compiler));
            }
            if (RoyaleClosurePassConfig.this.options.enables(DiagnosticGroups.MISSING_CONST_PROPERTY)) {
                callbacks.add(new CheckConstPrivateProperties(compiler));
            }
            return RoyaleClosurePassConfig.combineChecks(compiler, (List)((Object)callbacks.build()));
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory checkRequiresAndProvidesSorted = new PassFactory.HotSwapPassFactory("checkRequiresAndProvidesSorted"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckRequiresAndProvidesSorted(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory checkGlobalNames = new PassFactory("checkGlobalNames", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node jsRoot) {
                    RoyaleClosurePassConfig.this.namespaceForChecks = new GlobalNamespace(compiler, externs, jsRoot);
                    new CheckGlobalNames(compiler, RoyaleClosurePassConfig.this.options.checkGlobalNamesLevel).injectNamespace(RoyaleClosurePassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory checkStrictMode = new PassFactory("checkStrictMode", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new StrictModeCheck(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory processTweaks = new PassFactory("processTweaks", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node jsRoot) {
                    new ProcessTweaks(compiler, RoyaleClosurePassConfig.this.options.getTweakProcessing().shouldStrip(), RoyaleClosurePassConfig.this.options.getTweakReplacements()).process(externs, jsRoot);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory processDefines = new PassFactory("processDefines", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node jsRoot) {
                    HashMap<String, Node> replacements = new HashMap<String, Node>();
                    replacements.putAll(compiler.getDefaultDefineValues());
                    replacements.putAll(RoyaleClosurePassConfig.getAdditionalReplacements(RoyaleClosurePassConfig.this.options));
                    replacements.putAll(RoyaleClosurePassConfig.this.options.getDefineReplacements());
                    new ProcessDefines(compiler, ImmutableMap.copyOf(replacements), !RoyaleClosurePassConfig.this.options.checksOnly).injectNamespace(RoyaleClosurePassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }

        public FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory stripCode = new PassFactory("stripCode", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node jsRoot) {
                    CompilerOptions options = compiler.getOptions();
                    StripCode pass = new StripCode(compiler, options.stripTypes, options.stripNameSuffixes, options.stripTypePrefixes, options.stripNamePrefixes);
                    if (options.getTweakProcessing().shouldStrip()) {
                        pass.enableTweakStripping();
                    }
                    pass.process(externs, jsRoot);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    final PassFactory garbageCollectChecks = new PassFactory.HotSwapPassFactory("garbageCollectChecks"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                public void process(Node externs, Node jsRoot) {
                    RoyaleClosurePassConfig.this.namespaceForChecks = null;
                }

                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    this.process(null, null);
                }
            };
        }

        public FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory checkConstParams = new PassFactory("checkConstParams", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConstParamCheck(compiler);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory computeFunctionNames = new PassFactory("computeFunctionNames", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    CollectFunctionNames pass = new CollectFunctionNames(compiler);
                    pass.process(externs, root);
                    compiler.setFunctionNames(pass.getFunctionNames());
                }
            };
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private final PassFactory runtimeTypeCheck = new PassFactory("runtimeTypeCheck", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new RuntimeTypeCheck(compiler, RoyaleClosurePassConfig.this.options.runtimeTypeCheckLogFunction);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory replaceIdGenerators = new PassFactory("replaceIdGenerators", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    ReplaceIdGenerators pass = new ReplaceIdGenerators(compiler, (Map)RoyaleClosurePassConfig.this.options.idGenerators, RoyaleClosurePassConfig.this.options.generatePseudoNames, RoyaleClosurePassConfig.this.options.idGeneratorsMapSerialized, RoyaleClosurePassConfig.this.options.xidHashFunction);
                    pass.process(externs, root);
                    compiler.setIdGeneratorMap(pass.getSerializedIdMappings());
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory replaceStrings = new PassFactory("replaceStrings", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    ReplaceStrings pass = new ReplaceStrings(compiler, RoyaleClosurePassConfig.this.options.replaceStringsPlaceholderToken, RoyaleClosurePassConfig.this.options.replaceStringsFunctionDescriptions, RoyaleClosurePassConfig.this.options.replaceStringsReservedStrings, RoyaleClosurePassConfig.this.options.replaceStringsInputMap);
                    pass.process(externs, root);
                    compiler.setStringMap(pass.getStringMap());
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory optimizeArgumentsArray = new PassFactory("optimizeArgumentsArray", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new OptimizeArgumentsArray(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory closureCodeRemoval = new PassFactory("closureCodeRemoval", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClosureCodeRemoval(compiler, RoyaleClosurePassConfig.this.options.removeAbstractMethods, RoyaleClosurePassConfig.this.options.removeClosureAsserts);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory closureOptimizePrimitives = new PassFactory("closureOptimizePrimitives", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClosureOptimizePrimitives(compiler, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED, compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.ES6));
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory rescopeGlobalSymbols = new PassFactory("rescopeGlobalSymbols", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new RescopeGlobalSymbols(compiler, RoyaleClosurePassConfig.this.options.renamePrefixNamespace, RoyaleClosurePassConfig.this.options.renamePrefixNamespaceAssumeCrossChunkNames);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory collapseProperties = new PassFactory("collapseProperties", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapsePropertiesWithModuleSupport(compiler, RoyaleClosurePassConfig.this.options.getPropertyCollapseLevel(), RoyaleClosurePassConfig.this.sourceFileName, RoyaleClosurePassConfig.this.varRenameMapFile);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory collapseObjectLiterals = new PassFactory("collapseObjectLiterals", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineObjectLiterals(compiler, compiler.getUniqueNameIdSupplier());
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory disambiguatePrivateProperties = new PassFactory("disambiguatePrivateProperties", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new DisambiguatePrivateProperties(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory disambiguateProperties = new PassFactory("disambiguateProperties", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new DisambiguateProperties(compiler, RoyaleClosurePassConfig.this.options.propertyInvalidationErrors);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory devirtualizePrototypeMethods = new PassFactory("devirtualizePrototypeMethods", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            OptimizeCalls passes = new OptimizeCalls(compiler);
            passes.addPass((OptimizeCalls.CallGraphCompilerPass)new DevirtualizePrototypeMethods(compiler));
            return passes;
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory optimizeCalls = new PassFactory("optimizeCalls", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            OptimizeCalls passes = new OptimizeCalls(compiler);
            passes.addPass((OptimizeCalls.CallGraphCompilerPass)new OptimizeReturns(compiler));
            passes.addPass((OptimizeCalls.CallGraphCompilerPass)new OptimizeParameters(compiler));
            return passes;
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory markPureFunctions = new PassFactory("markPureFunctions", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new PureFunctionIdentifier.Driver(compiler, RoyaleClosurePassConfig.this.options.debugFunctionSideEffectsPath);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory markNoSideEffectCalls = new PassFactory("markNoSideEffectCalls", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new MarkNoSideEffectCalls(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory inlineVariables = new PassFactory("inlineVariables", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            InlineVariables.Mode mode;
            if (RoyaleClosurePassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (RoyaleClosurePassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(compiler, mode, true);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineConstants = new PassFactory("inlineConstants", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineVariables(compiler, InlineVariables.Mode.CONSTANTS_ONLY, true);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory removeUnreachableCode = new PassFactory("removeUnreachableCode", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new UnreachableCodeElimination(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private final PassFactory removeUnusedPolyfills = new PassFactory("removeUnusedPolyfills", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new RemoveUnusedPolyfills(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineSimpleMethods = new PassFactory("inlineSimpleMethods", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineSimpleMethods(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory deadAssignmentsElimination = new PassFactory("deadAssignmentsElimination", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeadAssignmentsElimination(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory deadPropertyAssignmentElimination = new PassFactory("deadPropertyAssignmentElimination", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeadPropertyAssignmentElimination(compiler);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineFunctions = new PassFactory("inlineFunctions", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineFunctions(compiler, compiler.getUniqueNameIdSupplier(), RoyaleClosurePassConfig.this.options.getInlineFunctionsLevel(), RoyaleClosurePassConfig.this.options.assumeStrictThis() || RoyaleClosurePassConfig.this.options.expectStrictModeInput(), RoyaleClosurePassConfig.this.options.assumeClosuresOnlyCaptureReferences, RoyaleClosurePassConfig.this.options.maxFunctionSizeAfterInlining);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineProperties = new PassFactory("inlineProperties", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineProperties(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory removeUnusedCodeOnce = this.getRemoveUnusedCode(true);
    private final PassFactory removeUnusedCode = this.getRemoveUnusedCode(false);
    private final PassFactory crossModuleCodeMotion = new PassFactory("crossChunkCodeMotion", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CrossChunkCodeMotion(compiler, compiler.getModuleGraph(), RoyaleClosurePassConfig.this.options.parentChunkCanSeeSymbolsDeclaredInChildren);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory crossModuleMethodMotion = new PassFactory("crossChunkMethodMotion", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CrossChunkMethodMotion(compiler, compiler.getCrossModuleIdGenerator(), RoyaleClosurePassConfig.this.options.removeUnusedPrototypePropertiesInExterns, RoyaleClosurePassConfig.this.options.crossChunkCodeMotionNoStubMethods);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory flowSensitiveInlineVariables = new PassFactory("flowSensitiveInlineVariables", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new FlowSensitiveInlineVariables(compiler);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory coalesceVariableNames = new PassFactory("coalesceVariableNames", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CoalesceVariableNames(compiler, RoyaleClosurePassConfig.this.options.generatePseudoNames);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory exploitAssign = new PassFactory("exploitAssign", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new PeepholeOptimizationsPass(compiler, this.getName(), new AbstractPeepholeOptimization[]{new ExploitAssigns()});
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory collapseVariableDeclarations = new PassFactory("collapseVariableDeclarations", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseVariableDeclarations(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory extractPrototypeMemberDeclarations = new PassFactory("extractPrototypeMemberDeclarations", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            ExtractPrototypeMemberDeclarations.Pattern pattern;
            switch (RoyaleClosurePassConfig.this.options.extractPrototypeMemberDeclarations) {
                case USE_GLOBAL_TEMP: {
                    pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_GLOBAL_TEMP;
                    break;
                }
                case USE_IIFE: {
                    pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_IIFE;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected");
                }
            }
            return new ExtractPrototypeMemberDeclarations(compiler, pattern);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private final PassFactory rewriteFunctionExpressions = new PassFactory("rewriteFunctionExpressions", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new FunctionRewriter(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory collapseAnonymousFunctions = new PassFactory("collapseAnonymousFunctions", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseAnonymousFunctions(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory moveFunctionDeclarations = new PassFactory("moveFunctionDeclarations", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new MoveFunctionDeclarations(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private final PassFactory nameUnmappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new NameAnonymousFunctions(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory nameMappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    NameAnonymousFunctionsMapped naf = new NameAnonymousFunctionsMapped(compiler, RoyaleClosurePassConfig.this.options.inputAnonymousFunctionNamingMap);
                    naf.process(externs, root);
                    compiler.setAnonymousFunctionNameMap(naf.getFunctionMap());
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory aliasStrings = new PassFactory("aliasStrings", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new AliasStrings(compiler, compiler.getModuleGraph(), RoyaleClosurePassConfig.this.options.aliasAllStrings ? null : RoyaleClosurePassConfig.this.options.aliasableStrings, RoyaleClosurePassConfig.this.options.aliasStringsBlacklist, RoyaleClosurePassConfig.this.options.outputJsStringUsage);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory objectPropertyStringPostprocess = new PassFactory("ObjectPropertyStringPostprocess", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ObjectPropertyStringPostprocess(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory ambiguateProperties = new PassFactory("ambiguateProperties", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new AmbiguateProperties(compiler, RoyaleClosurePassConfig.this.options.getPropertyReservedNamingFirstChars(), RoyaleClosurePassConfig.this.options.getPropertyReservedNamingNonFirstChars());
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory markUnnormalized = new PassFactory("markUnnormalized", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory normalize = new PassFactory("normalize", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new Normalize(compiler, false);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory externExports = new PassFactory("externExports", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ExternExportsPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory denormalize = new PassFactory("denormalize", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new Denormalize(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory invertContextualRenaming = new PassFactory("invertContextualRenaming", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return MakeDeclaredNamesUnique.getContextualRenameInverter((AbstractCompiler)compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory renameProperties = new PassFactory("renameProperties", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            Preconditions.checkState(RoyaleClosurePassConfig.this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED);
            final VariableMap prevPropertyMap = RoyaleClosurePassConfig.this.options.inputPropertyMap;
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    RenamePropertiesWithModuleSupport rprop = new RenamePropertiesWithModuleSupport(compiler, RoyaleClosurePassConfig.this.options.generatePseudoNames, prevPropertyMap, RoyaleClosurePassConfig.this.options.getPropertyReservedNamingFirstChars(), RoyaleClosurePassConfig.this.options.getPropertyReservedNamingNonFirstChars(), RoyaleClosurePassConfig.this.options.nameGenerator);
                    rprop.process(externs, root);
                    compiler.setPropertyMap(rprop.getPropertyMap());
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory renameVars = new PassFactory("renameVars", true){

        protected CompilerPass create(final AbstractCompiler compiler) {
            final VariableMap prevVariableMap = RoyaleClosurePassConfig.this.options.inputVariableMap;
            return new CompilerPass(){

                public void process(Node externs, Node root) {
                    compiler.setVariableMap(RoyaleClosurePassConfig.this.runVariableRenaming(compiler, prevVariableMap, externs, root));
                }
            };
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory renameLabels = new PassFactory("renameLabels", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new RenameLabels(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory convertToDottedProperties = new PassFactory("convertToDottedProperties", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConvertToDottedProperties(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory checkAstValidity = new PassFactory("checkAstValidity", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new AstValidator(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory varCheckValidity = new PassFactory("varCheckValidity", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new VarCheck(compiler, true);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory instrumentFunctions = new PassFactory("instrumentFunctions", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new InstrumentFunctions(compiler, compiler.getFunctionNames(), RoyaleClosurePassConfig.this.options.instrumentationTemplate, RoyaleClosurePassConfig.this.options.appNameStr);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory instrumentForCodeCoverage = new PassFactory("instrumentForCodeCoverage", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            if (RoyaleClosurePassConfig.this.options.instrumentBranchCoverage) {
                return new CoverageInstrumentationPass(compiler, CoverageInstrumentationPass.CoverageReach.CONDITIONAL, CoverageInstrumentationPass.InstrumentOption.BRANCH_ONLY);
            }
            return new CoverageInstrumentationPass(compiler, CoverageInstrumentationPass.CoverageReach.CONDITIONAL);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory gatherExternProperties = new PassFactory("gatherExternProperties", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new GatherExternProperties(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory polymerPass = new PassFactory.HotSwapPassFactory("polymerPass"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new PolymerPass(compiler, compiler.getOptions().polymerVersion, compiler.getOptions().polymerExportPolicy, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory chromePass = new PassFactory("chromePass", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ChromePass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory dartSuperAccessorsPass = new PassFactory.HotSwapPassFactory("dartSuperAccessorsPass"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new DartSuperAccessorsPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory j2clConstantHoisterPass = new PassFactory("j2clConstantHoisterPass", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clConstantHoisterPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clClinitPass = new PassFactory("j2clClinitPass", false){

        protected CompilerPass create(AbstractCompiler compiler) {
            List changedScopeNodes = compiler.getChangedScopeNodesForPass(this.getName());
            return new J2clClinitPrunerPass(compiler, changedScopeNodes);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clPropertyInlinerPass = new PassFactory("j2clES6Pass", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clPropertyInlinerPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clPass = new PassFactory("j2clPass", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clUtilGetDefineRewriterPass = new PassFactory("j2clUtilGetDefineRewriterPass", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clUtilGetDefineRewriterPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clAssertRemovalPass = new PassFactory("j2clAssertRemovalPass", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clAssertRemovalPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clSourceFileChecker = new PassFactory("j2clSourceFileChecker", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clSourceFileChecker(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory j2clChecksPass = new PassFactory("j2clChecksPass", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clChecksPass(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private final PassFactory checkConformance = new PassFactory("checkConformance", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckConformance(compiler, ImmutableList.copyOf(RoyaleClosurePassConfig.this.options.getConformanceConfigs()));
        }

        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory optimizeToEs6 = new PassFactory("optimizeToEs6", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new SubstituteEs6Syntax(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory whitespaceWrapGoogModules = new PassFactory.HotSwapPassFactory("whitespaceWrapGoogModules"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new WhitespaceWrapGoogModules(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory rewriteCommonJsModules = new PassFactory("rewriteCommonJsModules", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new ProcessCommonJSModules(compiler);
        }

        public FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory rewriteScriptsToEs6Modules = new PassFactory("rewriteScriptsToEs6Modules", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteScriptsToModules(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory gatherModuleMetadataPass = new PassFactory.HotSwapPassFactory("gatherModuleMetadata"){

        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new GatherModuleMetadata(compiler, RoyaleClosurePassConfig.this.options.processCommonJSModules, RoyaleClosurePassConfig.this.options.moduleResolutionMode);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory gatherGettersAndSetters = new PassFactory("gatherGettersAndSetters", true){

        protected CompilerPass create(AbstractCompiler compiler) {
            return new GatherGettersAndSetterProperties(compiler);
        }

        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };

    public RoyaleClosurePassConfig(CompilerOptions options, String sourceFileName, File varRenameMapFile, Set<String> propertyNamesToKeep) {
        super(options);
        this.protectHiddenSideEffects = options != null && options.shouldProtectHiddenSideEffects();
        this.preprocessorSymbolTableFactory = new PreprocessorSymbolTable.CachedInstanceFactory();
        this.varRenameMapFile = varRenameMapFile;
        this.sourceFileName = sourceFileName;
        this.propertyNamesToKeep = propertyNamesToKeep;
    }

    GlobalNamespace getGlobalNamespace() {
        return this.namespaceForChecks;
    }

    @Nullable
    PreprocessorSymbolTable getPreprocessorSymbolTable() {
        return this.preprocessorSymbolTableFactory.getInstanceOrNull();
    }

    void maybeInitializeModuleRewriteState() {
        if (this.options.allowsHotswapReplaceScript() && this.moduleRewriteState == null) {
            this.moduleRewriteState = new ClosureRewriteModule.GlobalRewriteState();
        }
    }

    protected List<PassFactory> getTranspileOnlyPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.needsTranspilationFrom(FeatureSet.TYPESCRIPT)) {
            passes.add((PassFactory)this.convertEs6TypedToEs6);
        }
        passes.add((PassFactory)this.checkVariableReferencesForTranspileOnly);
        passes.add((PassFactory)this.gatherModuleMetadataPass);
        if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.add((PassFactory)this.rewriteGoogJsImports);
            switch (this.options.getEs6ModuleTranspilation()) {
                case COMPILE: {
                    TranspilationPasses.addEs6ModulePass(passes, (PreprocessorSymbolTable.CachedInstanceFactory)this.preprocessorSymbolTableFactory);
                    break;
                }
                case TO_COMMON_JS_LIKE_MODULES: {
                    TranspilationPasses.addEs6ModuleToCjsPass(passes);
                    break;
                }
                case RELATIVIZE_IMPORT_PATHS: {
                    TranspilationPasses.addEs6RewriteImportPathPass(passes);
                    break;
                }
            }
        }
        passes.add((PassFactory)this.checkSuper);
        if (this.options.dartPass && this.options.needsTranspilationFrom(FeatureSet.ES6)) {
            passes.add((PassFactory)this.dartSuperAccessorsPass);
        }
        TranspilationPasses.addPreTypecheckTranspilationPasses(passes, (CompilerOptions)this.options);
        TranspilationPasses.addPostCheckTranspilationPasses(passes, (CompilerOptions)this.options);
        if (this.options.needsTranspilationFrom(FeatureSet.ES6) && this.options.rewritePolyfills) {
            TranspilationPasses.addRewritePolyfillPass(passes);
        }
        passes.add(this.injectRuntimeLibraries);
        RoyaleClosurePassConfig.assertAllOneTimePasses(passes);
        this.assertValidOrderForChecks(passes);
        return passes;
    }

    protected List<PassFactory> getWhitespaceOnlyPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.processCommonJSModules) {
            passes.add(this.rewriteCommonJsModules);
        } else if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.add(this.rewriteScriptsToEs6Modules);
        }
        if (this.options.wrapGoogModulesForWhitespaceOnly) {
            passes.add((PassFactory)this.whitespaceWrapGoogModules);
        }
        return passes;
    }

    private void addTypeCheckerPasses(List<PassFactory> checks, CompilerOptions options) {
        if (!options.allowsHotswapReplaceScript()) {
            checks.add(this.inlineTypeAliases);
        }
        if (options.checkTypes || options.inferTypes) {
            checks.add((PassFactory)this.resolveTypes);
            checks.add((PassFactory)this.inferTypes);
            if (options.checkTypes) {
                checks.add((PassFactory)this.checkTypes);
            } else {
                checks.add((PassFactory)this.inferJsDocInfo);
            }
            if (!options.preservesDetailedSourceInfo() && !options.allowsHotswapReplaceScript()) {
                checks.add(this.clearTypedScopePass);
            }
        }
    }

    protected List<PassFactory> getChecks() {
        ArrayList<PassFactory> checks = new ArrayList<PassFactory>();
        checks.add(this.gatherGettersAndSetters);
        if (this.options.shouldGenerateTypedExterns()) {
            checks.add((PassFactory)this.closureGoogScopeAliases);
            checks.add((PassFactory)this.closureRewriteClass);
            checks.add(this.generateIjs);
            checks.add((PassFactory)this.whitespaceWrapGoogModules);
            return checks;
        }
        checks.add(PassFactory.createEmptyPass((String)"beforeStandardChecks"));
        if (this.options.processCommonJSModules) {
            checks.add(this.rewriteCommonJsModules);
        } else if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.add(this.rewriteScriptsToEs6Modules);
        }
        if (this.options.isChromePassEnabled()) {
            checks.add(this.chromePass);
        }
        checks.add((PassFactory)this.checkJsDocAndEs6Modules);
        if (this.options.needsTranspilationFrom(FeatureSet.TYPESCRIPT)) {
            checks.add((PassFactory)this.convertEs6TypedToEs6);
        }
        checks.add((PassFactory)this.gatherModuleMetadataPass);
        if (this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add((PassFactory)this.lintChecks);
        }
        if (this.options.closurePass && this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add((PassFactory)this.checkRequiresAndProvidesSorted);
        }
        if (this.options.enables(DiagnosticGroups.MISSING_REQUIRE) || this.options.enables(DiagnosticGroups.STRICT_MISSING_REQUIRE) || this.options.enables(DiagnosticGroups.EXTRA_REQUIRE)) {
            checks.add((PassFactory)this.checkRequires);
        }
        checks.add((PassFactory)this.checkVariableReferences);
        if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.add((PassFactory)this.rewriteGoogJsImports);
            TranspilationPasses.addEs6ModulePass(checks, (PreprocessorSymbolTable.CachedInstanceFactory)this.preprocessorSymbolTableFactory);
        }
        checks.add(this.checkStrictMode);
        if (this.options.closurePass) {
            checks.add((PassFactory)this.closureCheckModule);
            checks.add((PassFactory)this.closureRewriteModule);
        }
        if (this.options.declaredGlobalExternsOnWindow) {
            checks.add(this.declaredGlobalExternsOnWindow);
        }
        checks.add((PassFactory)this.checkSuper);
        if (this.options.closurePass) {
            checks.add((PassFactory)this.closureGoogScopeAliases);
            checks.add((PassFactory)this.closureRewriteClass);
        }
        checks.add((PassFactory)this.checkSideEffects);
        if (this.options.enables(DiagnosticGroups.MISSING_PROVIDE)) {
            checks.add((PassFactory)this.checkProvides);
        }
        if (this.options.angularPass) {
            checks.add((PassFactory)this.angularPass);
        }
        if (this.propertyNamesToKeep != null && this.propertyNamesToKeep.size() > 0) {
            checks.add(this.keepPropertyNamesPass);
        }
        if (!this.options.generateExportsAfterTypeChecking && this.options.generateExports) {
            checks.add(this.generateExports);
        }
        if (this.options.exportTestFunctions) {
            checks.add(this.exportTestFunctions);
        }
        if (this.options.closurePass) {
            checks.add((PassFactory)this.closurePrimitives);
        }
        if (this.options.polymerVersion != null) {
            checks.add((PassFactory)this.polymerPass);
        }
        if (this.options.checkSuspiciousCode || this.options.enables(DiagnosticGroups.GLOBAL_THIS) || this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
            checks.add((PassFactory)this.suspiciousCode);
        }
        if (this.options.closurePass && this.options.checkMissingGetCssNameLevel.isOn()) {
            checks.add(this.closureCheckGetCssName);
        }
        if (this.options.syntheticBlockStartMarker != null) {
            checks.add(this.createSyntheticBlocks);
        }
        checks.add((PassFactory)this.checkVars);
        if (this.options.inferConsts) {
            checks.add(this.inferConsts);
        }
        if (this.options.computeFunctionSideEffects) {
            checks.add(this.checkRegExp);
        }
        if (this.options.processObjectPropertyString) {
            checks.add(this.objectPropertyStringPreprocess);
        }
        if (this.options.dartPass && !this.options.getOutputFeatureSet().contains(FeatureSet.ES6)) {
            checks.add((PassFactory)this.dartSuperAccessorsPass);
        }
        checks.add(PassFactory.createEmptyPass((String)"beforeES2017Transpilation"));
        TranspilationPasses.addPreTypecheckTranspilationPasses(checks, (CompilerOptions)this.options);
        if (this.options.rewritePolyfills && !this.options.checksOnly) {
            TranspilationPasses.addRewritePolyfillPass(checks);
        }
        checks.add(this.injectRuntimeLibraries);
        checks.add(PassFactory.createEmptyPass((String)"beforeTypeChecking"));
        this.addTypeCheckerPasses(checks, this.options);
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.add(this.j2clSourceFileChecker);
        }
        if (!this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE) || !this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
            checks.add((PassFactory)this.checkControlFlow);
        }
        if (this.options.enables(DiagnosticGroups.ANALYZER_CHECKS) && this.options.isTypecheckingEnabled()) {
            checks.add((PassFactory)this.analyzerChecks);
        }
        if (this.options.checkGlobalNamesLevel.isOn()) {
            checks.add(this.checkGlobalNames);
        }
        if (!this.options.getConformanceConfigs().isEmpty()) {
            checks.add(this.checkConformance);
        }
        if (this.options.closurePass && !this.options.shouldPreserveGoogLibraryPrimitives()) {
            checks.add(this.closureReplaceGetCssName);
        }
        if (this.options.getTweakProcessing().isOn()) {
            checks.add(this.processTweaks);
        }
        if (this.options.instrumentationTemplate != null || this.options.recordFunctionInformation) {
            checks.add(this.computeFunctionNames);
        }
        if (this.options.checksOnly) {
            checks.add(this.processDefines);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.add(this.j2clChecksPass);
        }
        if (this.options.shouldRunTypeSummaryChecksLate()) {
            checks.add(this.generateIjs);
        }
        if (this.options.generateExportsAfterTypeChecking && this.options.generateExports) {
            checks.add(this.generateExports);
        }
        checks.add(PassFactory.createEmptyPass((String)"afterStandardChecks"));
        if (!this.options.checksOnly) {
            TranspilationPasses.addPostCheckTranspilationPasses(checks, (CompilerOptions)this.options);
            if (this.options.needsTranspilationFrom(FeatureSet.ES6)) {
                checks.add(this.convertStaticInheritance);
            }
        }
        RoyaleClosurePassConfig.assertAllOneTimePasses(checks);
        this.assertValidOrderForChecks(checks);
        return checks;
    }

    protected List<PassFactory> getOptimizations() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.skipNonTranspilationPasses) {
            return passes;
        }
        passes.add(this.removeWeakSources);
        passes.add(this.garbageCollectChecks);
        if (this.options.replaceMessagesWithChromeI18n) {
            passes.add(this.replaceMessagesForChrome);
        } else if (this.options.messageBundle != null) {
            passes.add(this.replaceMessages);
        }
        passes.add(this.processDefines);
        if (!(!this.options.getTweakProcessing().shouldStrip() && this.options.stripTypes.isEmpty() && this.options.stripNameSuffixes.isEmpty() && this.options.stripTypePrefixes.isEmpty() && this.options.stripNamePrefixes.isEmpty())) {
            passes.add(this.stripCode);
        }
        passes.add(this.normalize);
        if (this.options.isExternExportsEnabled() || this.options.externExportsPath != null) {
            passes.add(this.externExports);
        }
        passes.add(this.gatherExternProperties);
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.add(this.j2clPass);
            passes.add(this.j2clUtilGetDefineRewriterPass);
        }
        if (this.options.instrumentForCoverage) {
            passes.add(this.instrumentForCodeCoverage);
        }
        if (this.options.runtimeTypeCheck) {
            passes.add(this.runtimeTypeCheck);
        }
        passes.add(PassFactory.createEmptyPass((String)"beforeStandardOptimizations"));
        if (this.options.replaceIdGenerators) {
            passes.add(this.replaceIdGenerators);
        }
        if (this.options.optimizeArgumentsArray) {
            passes.add(this.optimizeArgumentsArray);
        }
        if (this.options.closurePass && (this.options.removeAbstractMethods || this.options.removeClosureAsserts)) {
            passes.add(this.closureCodeRemoval);
        }
        if (this.options.removeJ2clAsserts) {
            passes.add(this.j2clAssertRemovalPass);
        }
        if (this.options.disambiguatePrivateProperties) {
            passes.add(this.disambiguatePrivateProperties);
        }
        RoyaleClosurePassConfig.assertAllOneTimePasses(passes);
        if (this.options.shouldCollapseProperties()) {
            passes.add(this.aggressiveInlineAliases);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses() && this.options.shouldCollapseProperties()) {
            passes.add(this.j2clPropertyInlinerPass);
        }
        if (this.options.shouldCollapseProperties()) {
            passes.add(this.collapseProperties);
        }
        if (this.options.inferConsts) {
            passes.add(this.inferConsts);
        }
        passes.add(this.checkConstParams);
        if (this.options.extraSmartNameRemoval && this.options.smartNameRemoval) {
            if (this.options.foldConstants && (this.options.inlineVariables || this.options.inlineLocalVariables)) {
                passes.add(this.earlyInlineVariables);
                passes.add(this.earlyPeepholeOptimizations);
            }
            passes.add(this.removeUnusedCodeOnce);
        }
        if (this.options.rewritePolyfills) {
            passes.add(this.removeUnusedPolyfills);
        }
        if (this.options.shouldDisambiguateProperties() && this.options.isTypecheckingEnabled()) {
            passes.add(this.disambiguateProperties);
        }
        if (this.options.computeFunctionSideEffects) {
            passes.add(this.markPureFunctions);
        } else if (this.options.markNoSideEffectCalls) {
            passes.add(this.markNoSideEffectCalls);
        }
        if (this.options.smartNameRemoval) {
            passes.addAll(this.getCodeRemovingPasses());
        }
        if (this.options.closurePass) {
            passes.add(this.closureOptimizePrimitives);
        }
        if (!this.options.replaceStringsFunctionDescriptions.isEmpty()) {
            passes.add(this.replaceStrings);
        }
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.devirtualizePrototypeMethods) {
            passes.add(this.devirtualizePrototypeMethods);
        }
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATION_LOOP));
        }
        passes.add(PassFactory.createEmptyPass((String)"beforeMainOptimizations"));
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.flowSensitiveInlineVariables);
        }
        passes.addAll(this.getMainOptimizationLoop());
        passes.add(PassFactory.createEmptyPass((String)"afterMainOptimizations"));
        passes.add(PassFactory.createEmptyPass((String)"beforeModuleMotion"));
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.shouldRunCrossChunkMethodMotion()) {
            passes.add(this.crossModuleMethodMotion);
        }
        passes.add(PassFactory.createEmptyPass((String)"afterModuleMotion"));
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.AFTER_OPTIMIZATION_LOOP));
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.flowSensitiveInlineVariables);
            if (this.shouldRunRemoveUnusedCode()) {
                passes.add(this.removeUnusedCodeOnce);
            }
        }
        if (this.options.collapseAnonymousFunctions) {
            passes.add(this.collapseAnonymousFunctions);
        }
        if (this.options.moveFunctionDeclarations || this.options.renamePrefixNamespace != null) {
            passes.add(this.moveFunctionDeclarations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.MAPPED) {
            passes.add(this.nameMappedAnonymousFunctions);
        }
        if (this.options.extractPrototypeMemberDeclarations != CompilerOptions.ExtractPrototypeMemberDeclarationsMode.OFF) {
            passes.add(this.extractPrototypeMemberDeclarations);
        }
        if (this.options.shouldAmbiguateProperties() && this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED && this.options.isTypecheckingEnabled()) {
            passes.add(this.ambiguateProperties);
        }
        if (this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            passes.add(this.renameProperties);
        }
        if (this.options.reserveRawExports) {
            passes.add(this.gatherRawExports);
        }
        if (this.options.convertToDottedProperties) {
            passes.add(this.convertToDottedProperties);
        }
        if (this.options.rewriteFunctionExpressions) {
            passes.add(this.rewriteFunctionExpressions);
        }
        if (!this.options.aliasableStrings.isEmpty() || this.options.aliasAllStrings) {
            passes.add(this.aliasStrings);
        }
        if (this.options.coalesceVariableNames) {
            passes.add(this.coalesceVariableNames);
            if (this.options.foldConstants) {
                passes.add(this.peepholeOptimizationsOnce);
            }
        }
        passes.add(this.markUnnormalized);
        if (this.options.collapseVariableDeclarations) {
            passes.add(this.exploitAssign);
            passes.add(this.collapseVariableDeclarations);
        }
        passes.add(this.denormalize);
        if (this.options.instrumentationTemplate != null) {
            passes.add(this.instrumentFunctions);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.ALL) {
            passes.add(this.invertContextualRenaming);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.OFF) {
            passes.add(this.renameVars);
        }
        if (this.options.processObjectPropertyString) {
            passes.add(this.objectPropertyStringPostprocess);
        }
        if (this.options.labelRenaming) {
            passes.add(this.renameLabels);
        }
        if (this.options.foldConstants) {
            passes.add(this.latePeepholeOptimizations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.UNMAPPED) {
            passes.add(this.nameUnmappedAnonymousFunctions);
        }
        if (this.protectHiddenSideEffects) {
            passes.add(this.stripSideEffectProtection);
        }
        if (this.options.renamePrefixNamespace != null) {
            if (!GLOBAL_SYMBOL_NAMESPACE_PATTERN.matcher(this.options.renamePrefixNamespace).matches()) {
                throw new IllegalArgumentException("Illegal character in renamePrefixNamespace name: " + this.options.renamePrefixNamespace);
            }
            passes.add(this.rescopeGlobalSymbols);
        }
        passes.add(this.checkAstValidity);
        passes.add(this.varCheckValidity);
        if (this.options.getOutputFeatureSet().contains(FeatureSet.ES6)) {
            passes.add(this.optimizeToEs6);
        }
        this.assertValidOrderForOptimizations(passes);
        return passes;
    }

    private List<PassFactory> getMainOptimizationLoop() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.inlineGetters) {
            passes.add(this.inlineSimpleMethods);
        }
        passes.addAll(this.getCodeRemovingPasses());
        if (this.options.getInlineFunctionsLevel() != CompilerOptions.Reach.NONE) {
            passes.add(this.inlineFunctions);
        }
        if (this.options.shouldInlineProperties() && this.options.isTypecheckingEnabled()) {
            passes.add(this.inlineProperties);
        }
        if ((this.options.removeUnusedVars || this.options.removeUnusedLocalVars) && this.options.deadAssignmentElimination) {
            passes.add(this.deadAssignmentsElimination);
            if (this.options.polymerVersion == null) {
                passes.add(this.deadPropertyAssignmentElimination);
            }
        }
        if (this.options.optimizeCalls) {
            passes.add(this.optimizeCalls);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.add(this.j2clConstantHoisterPass);
            passes.add(this.j2clClinitPass);
        }
        RoyaleClosurePassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private List<PassFactory> getCodeRemovingPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.collapseObjectLiterals) {
            passes.add(this.collapseObjectLiterals);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            passes.add(this.inlineConstants);
        }
        if (this.options.foldConstants) {
            passes.add(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            passes.add(this.removeUnreachableCode);
        }
        if (this.shouldRunRemoveUnusedCode()) {
            passes.add(this.removeUnusedCode);
        }
        RoyaleClosurePassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private boolean shouldRunRemoveUnusedCode() {
        return this.options.removeUnusedVars || this.options.removeUnusedLocalVars || this.options.removeUnusedPrototypeProperties || this.options.isRemoveUnusedClassProperties() || this.options.isRemoveUnusedConstructorProperties();
    }

    private static void assertAllOneTimePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState(pass.isOneTimePass());
        }
    }

    private static void assertAllLoopablePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState(!pass.isOneTimePass());
        }
    }

    private void assertPassOrder(List<PassFactory> passList, PassFactory pass1, PassFactory pass2, String msg) {
        int pass1Index = passList.indexOf(pass1);
        int pass2Index = passList.indexOf(pass2);
        if (pass1Index != -1 && pass2Index != -1) {
            Preconditions.checkState(pass1Index < pass2Index, msg);
        }
    }

    private void assertValidOrderForChecks(List<PassFactory> checks) {
        this.assertPassOrder(checks, this.chromePass, (PassFactory)this.checkJsDocAndEs6Modules, "The ChromePass must run before after JsDoc and Es6 module checking.");
        this.assertPassOrder(checks, (PassFactory)this.closureRewriteModule, this.processDefines, "Must rewrite goog.module before processing @define's, so that @defines in modules work.");
        this.assertPassOrder(checks, (PassFactory)this.closurePrimitives, (PassFactory)this.polymerPass, "The Polymer pass must run after goog.provide processing.");
        this.assertPassOrder(checks, this.chromePass, (PassFactory)this.polymerPass, "The Polymer pass must run after ChromePass processing.");
        this.assertPassOrder(checks, (PassFactory)this.polymerPass, (PassFactory)this.suspiciousCode, "The Polymer pass must run before suspiciousCode processing.");
        this.assertPassOrder(checks, (PassFactory)this.dartSuperAccessorsPass, (PassFactory)TranspilationPasses.es6ConvertSuper, "The Dart super accessors pass must run before ES6->ES3 super lowering.");
        if (checks.contains(this.closureGoogScopeAliases)) {
            Preconditions.checkState(checks.contains(this.checkVariableReferences), "goog.scope processing requires variable checking");
        }
        this.assertPassOrder(checks, (PassFactory)this.checkVariableReferences, (PassFactory)this.closureGoogScopeAliases, "Variable checking must happen before goog.scope processing.");
        this.assertPassOrder(checks, (PassFactory)this.gatherModuleMetadataPass, (PassFactory)this.closureCheckModule, "Need to gather module metadata before checking closure modules.");
    }

    private void assertValidOrderForOptimizations(List<PassFactory> optimizations) {
        this.assertPassOrder(optimizations, this.processDefines, this.j2clUtilGetDefineRewriterPass, "J2CL define re-writing should be done after processDefines since it relies on collectDefines which has side effects.");
    }

    private static CompilerPass createPeepholeOptimizationsPass(AbstractCompiler compiler, String passName) {
        boolean late = false;
        boolean useTypesForOptimization = compiler.getOptions().useTypesForLocalOptimization;
        ArrayList<Object> optimizations = new ArrayList<Object>();
        optimizations.add(new MinimizeExitPoints());
        optimizations.add(new PeepholeMinimizeConditions(false));
        optimizations.add(new PeepholeSubstituteAlternateSyntax(false));
        optimizations.add(new PeepholeReplaceKnownMethods(false, useTypesForOptimization));
        optimizations.add(new PeepholeRemoveDeadCode());
        if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
            optimizations.add(new J2clEqualitySameRewriterPass());
            optimizations.add(new J2clStringValueOfRewriterPass());
        }
        optimizations.add(new PeepholeFoldConstants(false, useTypesForOptimization));
        optimizations.add(new PeepholeCollectPropertyAssignments());
        return new PeepholeOptimizationsPass(compiler, passName, optimizations);
    }

    private static HotSwapCompilerPass combineChecks(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        Preconditions.checkArgument(!callbacks.isEmpty());
        return new CombinedCompilerPass(compiler, callbacks);
    }

    private PassFactory getRemoveUnusedCode(boolean isOneTimePass) {
        return new PassFactory("removeUnusedCode", isOneTimePass){

            protected CompilerPass create(AbstractCompiler compiler) {
                boolean preserveAnonymousFunctionNames = RoyaleClosurePassConfig.this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
                return new RemoveUnusedCode.Builder(compiler).removeLocalVars(RoyaleClosurePassConfig.this.options.removeUnusedLocalVars).removeGlobals(RoyaleClosurePassConfig.this.options.removeUnusedVars).preserveFunctionExpressionNames(preserveAnonymousFunctionNames).removeUnusedPrototypeProperties(RoyaleClosurePassConfig.this.options.removeUnusedPrototypeProperties).allowRemovalOfExternProperties(RoyaleClosurePassConfig.this.options.removeUnusedPrototypePropertiesInExterns).removeUnusedThisProperties(RoyaleClosurePassConfig.this.options.isRemoveUnusedClassProperties()).removeUnusedObjectDefinePropertiesDefinitions(RoyaleClosurePassConfig.this.options.isRemoveUnusedClassProperties()).removeUnusedConstructorProperties(RoyaleClosurePassConfig.this.options.isRemoveUnusedConstructorProperties()).build();
            }

            public FeatureSet featureSet() {
                return FeatureSet.ES8_MODULES;
            }
        };
    }

    private VariableMap runVariableRenaming(AbstractCompiler compiler, VariableMap prevVariableMap, Node externs, Node root) {
        char[] reservedChars = this.options.anonymousFunctionNaming.getReservedCharacters();
        boolean preserveAnonymousFunctionNames = this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
        HashSet<String> reservedNames = new HashSet<String>();
        if (this.options.renamePrefixNamespace != null) {
            reservedNames.add(this.options.renamePrefixNamespace);
        }
        reservedNames.addAll(compiler.getExportedNames());
        reservedNames.addAll(ParserRunner.getReservedVars());
        RenameVarsWithModuleSupport rn = new RenameVarsWithModuleSupport(compiler, this.options.renamePrefix, this.options.variableRenaming == VariableRenamingPolicy.LOCAL, preserveAnonymousFunctionNames, this.options.generatePseudoNames, this.options.shadowVariables, this.options.preferStableNames, prevVariableMap, reservedChars, reservedNames, this.options.nameGenerator);
        rn.process(externs, root);
        return rn.getVariableMap();
    }

    private PassFactory getCustomPasses(final CustomPassExecutionTime executionTime) {
        return new PassFactory("runCustomPasses", true){

            protected CompilerPass create(AbstractCompiler compiler) {
                return RoyaleClosurePassConfig.runInSerial(RoyaleClosurePassConfig.this.options.customPasses.get(executionTime));
            }

            protected FeatureSet featureSet() {
                return FeatureSet.ES5;
            }
        };
    }

    private static CompilerPass runInSerial(final Collection<CompilerPass> passes) {
        return new CompilerPass(){

            public void process(Node externs, Node root) {
                for (CompilerPass pass : passes) {
                    pass.process(externs, root);
                }
            }
        };
    }

    @VisibleForTesting
    static Map<String, Node> getAdditionalReplacements(CompilerOptions options) {
        HashMap<String, Node> additionalReplacements = new HashMap<String, Node>();
        if (options.markAsCompiled || options.closurePass) {
            additionalReplacements.put(COMPILED_CONSTANT_NAME, IR.trueNode());
        }
        if (options.closurePass && options.locale != null) {
            additionalReplacements.put(CLOSURE_LOCALE_CONSTANT_NAME, IR.string((String)options.locale));
        }
        return additionalReplacements;
    }

    class ClearTypedScope
    implements CompilerPass {
        ClearTypedScope() {
        }

        public void process(Node externs, Node root) {
            RoyaleClosurePassConfig.this.clearTypedScope();
        }
    }

    class GlobalTypeResolver
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        GlobalTypeResolver(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        public void process(Node externs, Node root) {
            this.compiler.setTypeCheckingHasRun(true);
            if (RoyaleClosurePassConfig.this.topScope == null) {
                RoyaleClosurePassConfig.this.regenerateGlobalTypedScope(this.compiler, root.getParent());
            } else {
                this.compiler.getTypeRegistry().resolveTypes();
            }
        }

        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            RoyaleClosurePassConfig.this.patchGlobalTypedScope(this.compiler, scriptRoot);
        }
    }
}

