/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.common.PrefixMap;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.mxml.MXMLTagData;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTagDataPayload;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLUnclosedTagProblem;
import org.apache.royale.utils.FastStack;

class MXMLTagDataDepth {
    private static final IMXMLTagAttributeData[] MXML_TAG_ATTRIBUTE_DATAS = new IMXMLTagAttributeData[0];
    private MXMLTagDataDepth parent;
    private ArrayList<IMXMLTagData> openTags;
    private FastStack<IMXMLTagData> closeTags;
    private int depth;

    public MXMLTagDataDepth(int depth) {
        this.depth = depth;
        this.openTags = new ArrayList();
        this.closeTags = new FastStack();
    }

    public final void addOpenTag(IMXMLTagData openTag) {
        this.openTags.add(openTag);
    }

    public final void addCloseTag(IMXMLTagData closeTag) {
        this.closeTags.push(closeTag);
    }

    public final void setParent(MXMLTagDataDepth parent) {
        this.parent = parent;
    }

    public final int getDepth() {
        return this.depth;
    }

    final void ensureOrder() {
        Collections.sort(this.openTags, new MXMLTagDataComparator());
        Collections.sort(this.closeTags, Collections.reverseOrder(new MXMLTagDataComparator()));
    }

    public final boolean balance(List<MXMLTagDataPayload> payload, Map<IMXMLTagData, PrefixMap> prefixMap, IMXMLData mxmlData, IMXMLUnitData[] data, Collection<ICompilerProblem> problems, IFileSpecification fileSpec) {
        this.ensureOrder();
        int size = this.openTags.size();
        boolean didNonPayloadRepair = false;
        block0: for (int i = 0; i < size; ++i) {
            IMXMLTagData openTag = this.openTags.get(i);
            if (!this.closeTags.isEmpty()) {
                IMXMLTagData closeTag = this.closeTags.peek();
                if (closeTag.getName().compareTo(openTag.getName()) != 0) {
                    int insertOffset = -1;
                    while (!this.closeTags.isEmpty()) {
                        IMXMLTagData pop = this.closeTags.pop();
                        if (pop.getName().compareTo(openTag.getName()) != 0) {
                            insertOffset = pop.getIndex();
                            if (this.parent != null) {
                                this.parent.addCloseTag(pop);
                                continue;
                            }
                            FakeMXMLTagData tagData = new FakeMXMLTagData(pop.getName(), false, false);
                            tagData.setOffsets(pop.getAbsoluteEnd(), pop.getAbsoluteEnd());
                            tagData.setLine(pop.getLine());
                            tagData.setColumn(pop.getColumn());
                            payload.add(new MXMLTagDataPayload(tagData, insertOffset - 1));
                            problems.add(this.produceProblemFromToken(tagData, fileSpec));
                            if (i + 1 >= size) continue;
                            openTag = this.openTags.get(++i);
                            continue;
                        }
                        insertOffset = -1;
                        break;
                    }
                    if (insertOffset == -1) continue;
                    if (!openTag.hasExplicitCloseTag()) {
                        ((MXMLTagData)openTag).setEmptyTag();
                        didNonPayloadRepair = true;
                        problems.add(this.produceProblemFromToken(openTag, fileSpec));
                        continue;
                    }
                    FakeMXMLTagData tagData = new FakeMXMLTagData(openTag.getName(), true, false);
                    tagData.setOffsets(openTag.getAbsoluteEnd(), openTag.getAbsoluteEnd());
                    tagData.setLine(openTag.getLine());
                    tagData.setColumn(openTag.getColumn());
                    payload.add(new MXMLTagDataPayload(tagData, insertOffset));
                    problems.add(this.produceProblemFromToken(tagData, fileSpec));
                    continue;
                }
                this.closeTags.pop();
                continue;
            }
            if (this.parent != null) {
                this.parent.addOpenTag(openTag);
                continue;
            }
            int tokenSize = data.length;
            for (int pos = openTag.getIndex(); pos < tokenSize; ++pos) {
                IMXMLUnitData currToken = data[pos];
                if (!(currToken instanceof MXMLTagData) || ((MXMLTagData)currToken).hasExplicitCloseTag()) continue;
                problems.add(new MXMLUnclosedTagProblem(currToken, ((MXMLTagData)currToken).getName()));
                FakeMXMLTagData fakeMXMLTagData = new FakeMXMLTagData((MXMLTagData)currToken, true);
                data[pos] = fakeMXMLTagData;
                prefixMap.remove((MXMLTagData)currToken);
                didNonPayloadRepair = true;
                PrefixMap map = ((MXMLTagData)currToken).getPrefixMap();
                if (map == null) continue block0;
                prefixMap.put(fakeMXMLTagData, map);
                continue block0;
            }
        }
        if (this.parent != null) {
            while (!this.closeTags.isEmpty()) {
                this.parent.addCloseTag(this.closeTags.pop());
            }
        }
        return didNonPayloadRepair;
    }

    private ICompilerProblem produceProblemFromToken(IMXMLTagData tagData, IFileSpecification fileSpec) {
        MXMLTagData tag;
        if (tagData instanceof MXMLTagData && (tag = (MXMLTagData)tagData).getSourcePath() == null) {
            tag.setSourcePath(fileSpec.getPath());
        }
        return new MXMLUnclosedTagProblem(tagData, tagData.getName());
    }

    private class FakeMXMLTagData
    extends MXMLTagData {
        public FakeMXMLTagData(String tagName, boolean closeTag, boolean emptyTag) {
            this.tagName = tagName;
            this.nameType = closeTag ? 3 : 8;
            this.emptyTag = emptyTag;
        }

        public FakeMXMLTagData(MXMLTagData data, boolean emptyTag) {
            super(data);
            this.emptyTag = emptyTag;
        }

        @Override
        public String getRawAttributeValue(String attributeName) {
            return null;
        }

        @Override
        public IMXMLTagAttributeData[] getAttributeDatas() {
            return MXML_TAG_ATTRIBUTE_DATAS;
        }

        @Override
        public boolean isImplicit() {
            return true;
        }
    }

    final class MXMLTagDataComparator
    implements Comparator<IMXMLTagData> {
        MXMLTagDataComparator() {
        }

        @Override
        public final int compare(IMXMLTagData o1, IMXMLTagData o2) {
            if (o1.getIndex() == o2.getIndex()) {
                return 0;
            }
            if (o1.getIndex() < o2.getIndex()) {
                return -1;
            }
            return 1;
        }
    }
}

