/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.mxml;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.common.Multiname;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.PackageDefinition;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.IncludeHandler;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.scopes.PackageScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.units.MXMLCompilationUnit;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLNamespaceAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLLibraryTagNotTheFirstChildProblem;
import org.apache.royale.compiler.problems.MXMLUnresolvedTagProblem;

public class MXMLScopeBuilder {
    private static final String IMPLEMENTS_SPLITTER = ",";
    private IMXMLData mxmlData;
    private RoyaleProject project;
    private MXMLCompilationUnit compilationUnit;
    private String qname;
    private MXMLFileScope fileScope;
    private PackageScope packageScope;
    private ClassDefinition currentClassDefinition;
    private TypeScope currentClassScope;
    private Collection<ICompilerProblem> problems;
    private final IncludeHandler includeHandler;
    private final IFileSpecificationGetter fileSpecGetter;

    public MXMLScopeBuilder(MXMLCompilationUnit compilationUnit, IFileSpecificationGetter fileSpecGetter, IMXMLData mxmlData, String qname, String fileName) {
        this.project = compilationUnit.getProject();
        this.compilationUnit = compilationUnit;
        this.mxmlData = mxmlData;
        this.qname = qname;
        this.fileScope = new MXMLFileScope(compilationUnit, fileName, mxmlData);
        String packageName = Multiname.getPackageNameForQName(qname);
        this.packageScope = new PackageScope((ASScope)this.fileScope, packageName);
        this.packageScope.setContainingScope(this.fileScope);
        PackageDefinition packageDefinition = new PackageDefinition(packageName);
        packageDefinition.setImplicit();
        packageDefinition.setContainedScope(this.packageScope);
        this.fileScope.addDefinition(packageDefinition);
        this.problems = new LinkedList<ICompilerProblem>();
        this.problems.addAll(mxmlData.getProblems());
        this.includeHandler = new IncludeHandler(fileSpecGetter);
        this.includeHandler.setProjectAndCompilationUnit(this.project, compilationUnit);
        this.fileSpecGetter = fileSpecGetter;
        assert (fileSpecGetter != null);
    }

    public MXMLFileScope build() {
        this.includeHandler.enterFile(this.mxmlData.getPath());
        IMXMLTagData rootTag = this.mxmlData.getRootTag();
        if (rootTag == null) {
            return this.fileScope;
        }
        this.processRootTag(rootTag);
        ImmutableSet<String> includedFiles = this.includeHandler.getIncludedFiles();
        for (String includedFile : includedFiles) {
            this.fileScope.addSourceDependency(includedFile);
        }
        this.includeHandler.leaveFile();
        return this.fileScope;
    }

    private void processRootTag(IMXMLTagData rootTag) {
        IReference baseClass = this.fileScope.resolveTagToReference(rootTag);
        String implementsAttrValue = rootTag.getRawAttributeValue("implements");
        IReference[] implementedInterfaces = null;
        if (implementsAttrValue != null) {
            String[] interfaces = rootTag.getMXMLDialect().trim(implementsAttrValue).split(IMPLEMENTS_SPLITTER);
            implementedInterfaces = new IReference[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                implementedInterfaces[i] = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), interfaces[i].trim());
            }
        }
        Multiname mname = Multiname.crackDottedQName(this.project, this.qname);
        INamespaceDefinition packageNS = (INamespaceDefinition)Iterables.getOnlyElement(mname.getNamespaceSet());
        assert (packageNS instanceof INamespaceReference);
        this.currentClassDefinition = new ClassDefinition(mname.getBaseName(), (INamespaceReference)((Object)packageNS));
        this.currentClassDefinition.setLocation(rootTag);
        this.currentClassDefinition.setBaseClassReference(baseClass);
        this.currentClassDefinition.setImplementedInterfaceReferences(implementedInterfaces);
        this.currentClassDefinition.setMetaTags(new IMetaTag[0]);
        this.currentClassDefinition.setNameLocation(0, 0);
        this.packageScope.addDefinition(this.currentClassDefinition);
        this.fileScope.setMainClassDefinition(this.currentClassDefinition);
        this.currentClassScope = new TypeScope((ASScope)this.packageScope, this.currentClassDefinition);
        this.currentClassScope.setContainingDefinition(this.currentClassDefinition);
        if (baseClass instanceof IResolvedQualifiersReference) {
            IDefinition baseDef = ((IResolvedQualifiersReference)baseClass).resolve(this.project);
            if (baseDef == null) {
                this.problems.add(new MXMLUnresolvedTagProblem(rootTag));
            } else {
                this.currentClassScope.addImport(baseDef.getQualifiedName());
            }
        }
        this.currentClassDefinition.setContainedScope(this.currentClassScope);
        this.currentClassDefinition.setupThisAndSuper();
        IMXMLTagData child = rootTag.getFirstChild(true);
        if (child != null && this.fileScope.isLibraryTag(child)) {
            this.processLibraryTag(child);
            child = child.getNextSibling(true);
        }
        while (child != null) {
            this.processTag(child);
            child = child.getNextSibling(true);
        }
        this.currentClassDefinition.buildContingentDefinitions();
    }

    private void processLibraryTag(IMXMLTagData libraryTag) {
        assert (this.fileScope.isLibraryTag(libraryTag));
        for (IMXMLTagData child = libraryTag.getFirstChild(true); child != null; child = child.getNextSibling(true)) {
            if (!this.fileScope.isDefinitionTag(child)) continue;
            this.processDefinitionTag(child);
        }
    }

    private void processDefinitionTag(IMXMLTagData definitionTag) {
        assert (this.fileScope.isDefinitionTag(definitionTag));
        ClassDefinition oldClassDefinition = this.currentClassDefinition;
        TypeScope oldClassScope = this.currentClassScope;
        IMXMLTagAttributeData[] definitionTagAttrs = definitionTag.getAttributeDatas();
        String definitionName = null;
        int nameStart = -1;
        int nameEnd = -1;
        for (IMXMLTagAttributeData attr : definitionTagAttrs) {
            if (attr instanceof IMXMLNamespaceAttributeData || !attr.hasValue() || attr.getURI() != null || !"name".equals(attr.getName()) || definitionName != null) continue;
            definitionName = attr.getRawValue();
            nameStart = attr.getValueStart() + 1;
            nameEnd = attr.getValueEnd() - 1;
        }
        IMXMLTagData firstChild = definitionTag.getFirstChild(true);
        if (firstChild != null) {
            IMXMLTagData secondChild = firstChild.getNextSibling(true);
            if (secondChild != null) {
                return;
            }
            String baseClassQName = this.fileScope.resolveTagToQualifiedName(firstChild);
            if (baseClassQName == null) {
                return;
            }
            ClassDefinition fxDefinitionClassDefinition = this.fileScope.addFXDefinition(this.qname, definitionTag, definitionName, baseClassQName);
            fxDefinitionClassDefinition.setLocation(firstChild);
            fxDefinitionClassDefinition.setNameLocation(nameStart, nameEnd);
            this.currentClassDefinition = fxDefinitionClassDefinition;
            this.currentClassScope = (TypeScope)fxDefinitionClassDefinition.getContainedScope();
            this.processTag(firstChild);
        }
        this.currentClassDefinition = oldClassDefinition;
        this.currentClassScope = oldClassScope;
    }

    private void processTag(IMXMLTagData tag) {
        this.includeHandler.onNextMXMLUnitData(tag);
        boolean recurse = true;
        if (this.fileScope.isScriptTag(tag)) {
            this.processScriptTag(tag);
        } else if (this.fileScope.isStyleTag(tag)) {
            this.processStyleTag(tag);
        } else if (this.fileScope.isMetadataTag(tag)) {
            this.processMetadataTag(tag);
        } else if (this.fileScope.isComponentTag(tag)) {
            this.processComponentTag(tag);
            recurse = false;
        } else if (this.fileScope.isLibraryTag(tag)) {
            MXMLLibraryTagNotTheFirstChildProblem problem = new MXMLLibraryTagNotTheFirstChildProblem(tag);
            this.problems.add(problem);
            this.processLibraryTag(tag);
            recurse = false;
        } else if (this.fileScope.isXMLTag(tag)) {
            this.processXMLTag(tag);
            recurse = false;
        } else if (this.fileScope.isPrivateTag(tag) || this.fileScope.isXMLListTag(tag)) {
            recurse = false;
        } else if (this.fileScope.isModelTag(tag)) {
            this.processModelTag(tag);
            recurse = false;
        } else if (this.fileScope.isStringTag(tag)) {
            this.processStringTag(tag);
        }
        String qname = this.fileScope.resolveTagToQualifiedName(tag);
        if (qname != null) {
            this.currentClassScope.addImport(qname);
            this.currentClassDefinition.addImplicitImport(qname);
            if ("State".equals(tag.getShortName())) {
                this.processState(tag, qname);
            }
        }
        IMXMLTagAttributeData idAttribute = tag.getTagAttributeData("id");
        String id = tag.getRawAttributeValue("id");
        if (id != null) {
            this.processID(tag, idAttribute);
        } else {
            idAttribute = tag.getTagAttributeData("localId");
            id = tag.getRawAttributeValue("localId");
            if (id != null) {
                this.processID(tag, idAttribute);
            }
        }
        if (recurse) {
            for (IMXMLTagData child = tag.getFirstChild(true); child != null; child = child.getNextSibling(true)) {
                this.processTag(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScriptTag(IMXMLTagData scriptTag) {
        assert (this.fileScope.isScriptTag(scriptTag));
        IMXMLTagAttributeData sourceAttribute = scriptTag.getTagAttributeData("source");
        if (sourceAttribute != null) {
            String sourcePath = MXMLNodeBase.resolveSourceAttributePath(null, sourceAttribute, null);
            Reader sourceFileReader = null;
            try {
                Workspace workspace = this.project.getWorkspace();
                IFileSpecification sourceFileSpec = this.fileSpecGetter.getFileSpecification(sourcePath);
                sourceFileReader = sourceFileSpec.createReader();
                String scriptText = IOUtils.toString((Reader)sourceFileReader);
                ASParser.parseFragment2(scriptText, sourcePath, 0, 0, 0, this.problems, workspace, null, this.currentClassScope, this.project.getProjectConfigVariables(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.POPULATE_SCOPE), true, this.includeHandler);
                this.fileScope.addSourceDependency(sourcePath);
            }
            catch (FileNotFoundException e) {
                this.project.addUnfoundReferencedSourceFileDependency(sourcePath, this.compilationUnit);
            }
            catch (IOException e) {
            }
            finally {
                if (sourceFileReader != null) {
                    try {
                        sourceFileReader.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            ArrayList<ScopedBlockNode> nodes = new ArrayList<ScopedBlockNode>(2);
            for (IMXMLUnitData unit = scriptTag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
                IMXMLTextData mxmlTextData;
                if (!(unit instanceof IMXMLTextData) || (mxmlTextData = (IMXMLTextData)unit).getTextType() == IMXMLTextData.TextType.WHITESPACE) continue;
                EnumSet<PostProcessStep> postProcess = EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.POPULATE_SCOPE);
                ScopedBlockNode node = ASParser.parseInlineScript(null, mxmlTextData, this.problems, this.currentClassScope, this.project.getProjectConfigVariables(), this.includeHandler, postProcess);
                assert (node != null) : "Expected node from ASParser.getScopesFromInlineScript().";
                nodes.add(node);
            }
        }
    }

    private void processStyleTag(IMXMLTagData styleTag) {
        assert (this.fileScope.isStyleTag(styleTag));
        this.processSourceAttribute(styleTag);
    }

    private void processMetadataTag(IMXMLTagData metadataTag) {
        assert (this.fileScope.isMetadataTag(metadataTag));
        for (IMXMLUnitData unit = metadataTag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            IMetaTag[] newMetaTags;
            MetaTagsNode metaTagNodes;
            IMXMLTextData mxmlTextData;
            if (!(unit instanceof IMXMLTextData) || (mxmlTextData = (IMXMLTextData)unit).getTextType() == IMXMLTextData.TextType.WHITESPACE || (metaTagNodes = ASParser.parseMetadata(this.project.getWorkspace(), mxmlTextData.getCompilableText(), mxmlTextData.getSourcePath(), mxmlTextData.getCompilableTextStart(), mxmlTextData.getCompilableTextLine(), mxmlTextData.getCompilableTextColumn(), this.problems)) == null) continue;
            if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
                System.out.println("MXMLScopeBuilder waiting for lock in processMetadataTag");
            }
            IFileSpecification containingFileSpec = this.fileScope.getWorkspace().getFileSpecification(this.fileScope.getContainingPath());
            if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
                System.out.println("MXMLScopeBuilder done with lock in processMetadataTag");
            }
            if ((newMetaTags = metaTagNodes.buildMetaTags(containingFileSpec, this.currentClassDefinition)) == null) continue;
            IMetaTag[] oldMetaTags = this.currentClassDefinition.getAllMetaTags();
            IMetaTag[] mergedTags = newMetaTags;
            if (oldMetaTags != null) {
                mergedTags = new IMetaTag[oldMetaTags.length + newMetaTags.length];
                System.arraycopy(oldMetaTags, 0, mergedTags, 0, oldMetaTags.length);
                System.arraycopy(newMetaTags, 0, mergedTags, oldMetaTags.length, newMetaTags.length);
            }
            this.currentClassDefinition.setMetaTags(mergedTags);
        }
    }

    private void processComponentTag(IMXMLTagData componentTag) {
        assert (this.fileScope.isComponentTag(componentTag));
        ClassDefinition oldClassDefinition = this.currentClassDefinition;
        TypeScope oldClassScope = this.currentClassScope;
        IMXMLTagAttributeData[] definitionTagAttrs = componentTag.getAttributeDatas();
        String className = null;
        int nameStart = -1;
        int nameEnd = -1;
        for (IMXMLTagAttributeData attr : definitionTagAttrs) {
            if (attr instanceof IMXMLNamespaceAttributeData || !attr.hasValue() || attr.getURI() != null || !attr.getName().equals("className") || className != null) continue;
            className = attr.getRawValue();
            nameStart = attr.getValueStart() + 1;
            nameEnd = attr.getValueEnd() - 1;
        }
        IMXMLTagData firstChild = componentTag.getFirstChild(true);
        if (firstChild != null) {
            IMXMLTagData secondChild = firstChild.getNextSibling(true);
            if (secondChild != null) {
                return;
            }
            String baseClassQName = this.fileScope.resolveTagToQualifiedName(firstChild);
            if (baseClassQName == null) {
                return;
            }
            ClassDefinition fxComponentClassDefinition = this.fileScope.addFXComponent(this.qname, componentTag.getAbsoluteStart(), className, baseClassQName);
            fxComponentClassDefinition.setNameLocation(nameStart, nameEnd);
            if (className == null) {
                fxComponentClassDefinition.setExcludedClass();
            }
            this.currentClassDefinition = fxComponentClassDefinition;
            this.currentClassScope = (TypeScope)fxComponentClassDefinition.getContainedScope();
            this.currentClassDefinition.buildOuterDocumentMember(ReferenceFactory.resolvedReference(oldClassDefinition));
            this.processTag(firstChild);
        }
        this.currentClassDefinition = oldClassDefinition;
        this.currentClassScope = oldClassScope;
    }

    private void processState(IMXMLTagData tag, String qname) {
        if (!qname.equals(this.project.getStateClass()) || tag.getMXMLDialect() == MXMLDialect.MXML_2006) {
            return;
        }
        IMXMLTagAttributeData nameAttribute = tag.getTagAttributeData("name");
        if (nameAttribute == null) {
            return;
        }
        String stateName = nameAttribute.getRawValue();
        this.currentClassDefinition.addStateName(stateName);
    }

    private void processXMLTag(IMXMLTagData xmlTag) {
        assert (this.fileScope.isXMLTag(xmlTag));
        this.processSourceAttribute(xmlTag);
    }

    private void processModelTag(IMXMLTagData modelTag) {
        assert (this.fileScope.isModelTag(modelTag));
        this.processSourceAttribute(modelTag);
    }

    private void processStringTag(IMXMLTagData stringTag) {
        assert (this.fileScope.isStringTag(stringTag));
        this.processSourceAttribute(stringTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSourceAttribute(IMXMLTagData tag) {
        IMXMLTagAttributeData sourceAttribute = tag.getTagAttributeData("source");
        if (sourceAttribute != null) {
            String sourcePath = MXMLNodeBase.resolveSourceAttributePath(null, sourceAttribute, null);
            Reader sourceFileReader = null;
            try {
                IFileSpecification sourceFileSpec = this.fileSpecGetter.getFileSpecification(sourcePath);
                sourceFileReader = sourceFileSpec.createReader();
                this.fileScope.addSourceDependency(sourcePath);
            }
            catch (FileNotFoundException e) {
                this.project.addUnfoundReferencedSourceFileDependency(sourcePath, this.compilationUnit);
            }
            finally {
                if (sourceFileReader != null) {
                    try {
                        sourceFileReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void processID(IMXMLTagData tag, IMXMLTagAttributeData idAttribute) {
        String id = idAttribute.getRawValue();
        IReference typeRef = this.fileScope.resolveTagToReference(tag);
        if (typeRef == null && this.fileScope.isModelTag(tag)) {
            typeRef = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), "mx.utils.ObjectProxy");
        }
        VariableDefinition variableDefinition = new VariableDefinition(id);
        variableDefinition.setPublic();
        variableDefinition.setTypeReference(typeRef);
        variableDefinition.setNameLocation(idAttribute.getValueStart(), idAttribute.getValueEnd());
        variableDefinition.setBindable();
        variableDefinition.setMxmlDeclared();
        this.currentClassScope.addDefinition(variableDefinition);
    }

    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    public TypeScope getClassScope() {
        return this.currentClassScope;
    }

    public IncludeHandler getIncludeHandler() {
        return this.includeHandler;
    }
}

