/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.MetadataToken;
import org.apache.royale.compiler.internal.parsing.as.RawASTokenizer;

public class MetadataTokenizer {
    protected boolean inAttrList;
    protected int adjust = 0;
    private boolean unknownKeyword;
    private RawASTokenizer tokenizer;
    private static final Map<String, Integer> keywordToTokenMap = new ImmutableMap.Builder().put((Object)"Bindable", (Object)15).put((Object)"Event", (Object)9).put((Object)"Effect", (Object)10).put((Object)"Style", (Object)11).put((Object)"ArrayElementType", (Object)13).put((Object)"DefaultProperty", (Object)14).put((Object)"Inspectable", (Object)19).put((Object)"InstanceType", (Object)16).put((Object)"NonCommittingChangeEvent", (Object)17).put((Object)"AccessibilityClass", (Object)52).put((Object)"States", (Object)53).put((Object)"ResourceBundle", (Object)59).put((Object)"HostComponent", (Object)56).put((Object)"SkinClass", (Object)60).put((Object)"Alternative", (Object)61).build();
    private static final Map<String, Integer> attrToTokenMap = new ImmutableMap.Builder().put((Object)"name", (Object)26).put((Object)"type", (Object)29).put((Object)"arrayType", (Object)30).put((Object)"format", (Object)28).put((Object)"enumeration", (Object)32).put((Object)"inherit", (Object)31).put((Object)"event", (Object)27).put((Object)"environment", (Object)34).put((Object)"verbose", (Object)35).put((Object)"category", (Object)36).put((Object)"variable", (Object)37).put((Object)"defaultValue", (Object)38).put((Object)"true", (Object)8).put((Object)"false", (Object)8).put((Object)"states", (Object)50).put((Object)"replacement", (Object)29).put((Object)"implementation", (Object)51).build();

    public MetadataTokenizer(Reader reader) {
        this.tokenizer = new RawASTokenizer(reader);
        this.unknownKeyword = true;
        this.inAttrList = false;
    }

    public MetadataTokenizer() {
        this.unknownKeyword = true;
        this.inAttrList = false;
    }

    public void setInput(Reader reader) throws IOException {
        if (this.tokenizer != null) {
            this.close();
        }
        this.tokenizer = new RawASTokenizer(reader);
    }

    public void setAdjust(int offset) {
        this.adjust = offset;
    }

    public MetadataToken next() {
        ASToken token = null;
        boolean needToken = true;
        block7: while (needToken) {
            try {
                token = this.tokenizer.nextToken();
                needToken = false;
            }
            catch (Exception e) {
                needToken = true;
            }
            if (token == null) {
                return null;
            }
            switch (token.getType()) {
                case 15: 
                case 18: 
                case 38: 
                case 46: 
                case 47: 
                case 125: 
                case 127: {
                    return this.transformToken(token);
                }
                case 42: {
                    needToken = true;
                    continue block7;
                }
                case 53: {
                    continue block7;
                }
            }
        }
        return null;
    }

    public void close() throws IOException {
        if (this.tokenizer != null) {
            this.tokenizer.yyclose();
        }
    }

    public List<MetadataToken> parseTokens() {
        ArrayList<MetadataToken> tokenList = new ArrayList<MetadataToken>(100);
        MetadataToken token = null;
        while ((token = this.next()) != null) {
            tokenList.add(token);
        }
        return tokenList;
    }

    public final MetadataToken transformToken(ASToken token) {
        String tokenString = token.getText();
        String sourcePath = token.getSourcePath();
        int startOffset = token.getStart() + this.adjust;
        int endOffset = token.getEnd() + this.adjust;
        int line = token.getLine();
        int column = token.getColumn();
        switch (token.getType()) {
            case 15: {
                if (!this.inAttrList) {
                    this.unknownKeyword = true;
                    Integer object = keywordToTokenMap.get(token.getText());
                    int num = 25;
                    if (object != null) {
                        num = object;
                        this.unknownKeyword = false;
                    }
                    return new MetadataToken(num, sourcePath, startOffset, endOffset, line, column, tokenString);
                }
                Integer object = attrToTokenMap.get(token.getText());
                int num = 33;
                if (object != null && !this.unknownKeyword) {
                    num = object;
                }
                return new MetadataToken(num, sourcePath, startOffset, endOffset, line, column, tokenString);
            }
            case 18: 
            case 125: {
                if (tokenString.length() > 0 && (tokenString.charAt(0) == '\"' || tokenString.charAt(0) == '\'')) {
                    ++startOffset;
                    tokenString = tokenString.substring(1);
                }
                if (tokenString.length() > 0 && (tokenString.charAt(tokenString.length() - 1) == '\"' || tokenString.charAt(tokenString.length() - 1) == '\'')) {
                    --endOffset;
                    tokenString = tokenString.substring(0, tokenString.length() - 1);
                }
                return new MetadataToken(8, sourcePath, startOffset, endOffset, line, column, tokenString);
            }
            case 38: {
                return new MetadataToken(23, sourcePath, startOffset, endOffset, line, column, tokenString);
            }
            case 127: {
                return new MetadataToken(24, sourcePath, startOffset, endOffset, line, column, tokenString);
            }
            case 46: {
                this.inAttrList = true;
                return new MetadataToken(21, sourcePath, startOffset, endOffset, line, column, tokenString);
            }
            case 47: {
                this.inAttrList = false;
                return new MetadataToken(22, sourcePath, startOffset, endOffset, line, column, tokenString);
            }
            case 42: 
            case 53: {
                return null;
            }
        }
        return null;
    }

    public static final MetadataToken buildNameToken(String name) {
        Integer object = keywordToTokenMap.get(name);
        int num = 25;
        if (object != null) {
            num = object;
        }
        return new MetadataToken(num, null, -1, -1, -1, -1, name);
    }

    public static final MetadataToken buildIdentifierToken(String identifier, int parentID) {
        Integer object = attrToTokenMap.get(identifier);
        int num = 33;
        if (object != null && parentID != 25) {
            num = object;
        }
        return new MetadataToken(num, null, -1, -1, -1, -1, identifier);
    }

    public static final MetadataToken buildOpenBraceToken() {
        return new MetadataToken(23, null, -1, -1, -1, -1, "[");
    }

    public static final MetadataToken buildCloseBraceToken() {
        return new MetadataToken(24, null, -1, -1, -1, -1, "]");
    }

    public static final MetadataToken buildOpenParenToken() {
        return new MetadataToken(21, null, -1, -1, -1, -1, "(");
    }

    public static final MetadataToken buildCloseParenToken() {
        return new MetadataToken(22, null, -1, -1, -1, -1, ")");
    }

    public static final MetadataToken buildStringToken(String identifier) {
        return new MetadataToken(8, null, -1, -1, -1, -1, identifier);
    }

    public static final MetadataToken buildIdentifierToken(String identifier) {
        return new MetadataToken(6, null, -1, -1, -1, -1, identifier);
    }
}

