/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSPropertyValue;

public class CSSStringPropertyValue
extends CSSPropertyValue {
    private final String value;

    protected CSSStringPropertyValue(String stringWithQuotes, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        assert (CSSStringPropertyValue.isQuoted(stringWithQuotes)) : "Don't strip quotes in parser: [" + stringWithQuotes + "]";
        this.value = CSSStringPropertyValue.convertEscapes(CSSStringPropertyValue.stripQuotes(stringWithQuotes));
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.format("\"%s\"", this.value);
    }

    public static boolean isQuoted(String testString) {
        return testString.startsWith("\"") && testString.endsWith("\"") || testString.startsWith("'") && testString.endsWith("'");
    }

    public static String stripQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }

    private static String convertEscapes(String value) {
        int idx = 0;
        int c = value.indexOf(92);
        while (c != -1) {
            char cnext = value.charAt(c + 1);
            if (cnext != '\\' && cnext != 'n' && cnext != 't' && cnext != 'r') {
                char cc;
                int i;
                int n = value.length() - (c + 1);
                if (n > 6) {
                    n = 6;
                }
                StringBuilder sub = new StringBuilder();
                for (i = 0; i < n && (cc = value.charAt(c + i + 1)) != ' '; ++i) {
                    sub.append(cc);
                }
                int ccode = Integer.parseInt(sub.toString(), 16);
                sub = new StringBuilder();
                sub.append(Character.toChars(ccode));
                value = value.substring(0, c) + sub.toString() + value.substring(c + i + 1);
            } else {
                idx += 2;
            }
            c = value.indexOf(92, idx);
        }
        return value;
    }
}

