/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.clients.MXMLJSCRoyale;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.codegen.js.IJSWriter;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.driver.js.IJSApplication;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.driver.mxml.royale.MXMLRoyaleSWCBackend;
import org.apache.royale.compiler.internal.parsing.as.RoyaleASDocDelegate;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.targets.JSTarget;
import org.apache.royale.compiler.internal.targets.RoyaleSWCTarget;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.problems.LibraryNotFoundProblem;
import org.apache.royale.compiler.problems.UnableToBuildSWFProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.swc.io.SWCReader;

public class COMPJSCRoyale
extends MXMLJSCRoyale {
    @Override
    public String getName() {
        return "COMPC";
    }

    @Override
    public int execute(String[] args) {
        return COMPJSCRoyale.staticMainNoExit(args);
    }

    public static void main(String[] args) {
        int exitCode = COMPJSCRoyale.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        COMPJSCRoyale mxmlc = new COMPJSCRoyale();
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    public COMPJSCRoyale() {
        MXMLRoyaleSWCBackend backend = new MXMLRoyaleSWCBackend();
        this.workspace = new Workspace();
        this.workspace.setASDocDelegate((IASDocDelegate)new RoyaleASDocDelegate());
        this.project = new RoyaleJSProject(this.workspace, backend);
        this.problems = new ProblemQuery();
        this.asFileHandler = backend.getSourceFileHandlerInstance();
    }

    @Override
    protected boolean compile() {
        boolean compilationSuccess;
        block39: {
            compilationSuccess = false;
            try {
                this.project.getSourceCompilationUnitFactory().addHandler(this.asFileHandler);
                if (this.setupTargetFile()) {
                    this.buildArtifact();
                }
                if (this.jsTarget == null) break block39;
                ArrayList errors = new ArrayList();
                ArrayList warnings = new ArrayList();
                if (!this.config.getCreateTargetWithErrors()) {
                    this.problems.getErrorsAndWarnings(errors, warnings);
                    if (errors.size() > 0) {
                        return false;
                    }
                }
                boolean packingSWC = false;
                String outputFolderName = this.getOutputFilePath();
                File swcFile = new File(outputFolderName);
                File jsOut = new File("js/out");
                File externsOut = new File("externs");
                ZipFile zipFile = null;
                ZipOutputStream zipOutputStream = null;
                String catalog = null;
                StringBuilder fileList = new StringBuilder();
                if (outputFolderName.endsWith(".swc")) {
                    packingSWC = true;
                    if (!swcFile.exists()) {
                        this.problems.add((ICompilerProblem)new LibraryNotFoundProblem(outputFolderName));
                        return false;
                    }
                    zipFile = new ZipFile(swcFile, 1);
                    InputStream catalogInputStream = SWCReader.getInputStream((ZipFile)zipFile, (String)"catalog.xml");
                    catalog = IOUtils.toString(catalogInputStream);
                    catalogInputStream.close();
                    zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFolderName + ".new")));
                    zipOutputStream.setLevel(0);
                    Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
                    while (entryEnum.hasMoreElements()) {
                        long fileDate;
                        ZipEntry entry = entryEnum.nextElement();
                        if (entry.getName().contains("js/out") || entry.getName().contains("catalog.xml")) continue;
                        if (this.config.isVerbose()) {
                            System.out.println("Copy " + entry.getName());
                        }
                        InputStream input = zipFile.getInputStream(entry);
                        ZipEntry ze = new ZipEntry(entry.getName());
                        ze.setMethod(0);
                        ze.setSize(entry.getSize());
                        ze.setCompressedSize(entry.getCompressedSize());
                        ze.setCrc(entry.getCrc());
                        long zipFileDate = fileDate = System.currentTimeMillis();
                        String metadataDate = this.targetSettings.getSWFMetadataDate();
                        if (metadataDate != null) {
                            String metadataFormat = this.targetSettings.getSWFMetadataDateFormat();
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat(metadataFormat);
                                Date d = sdf.parse(metadataDate);
                                GregorianCalendar cal = new GregorianCalendar();
                                cal.setTime(d);
                                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                                d = sdf.parse(metadataDate);
                                fileDate = d.getTime();
                                ZonedDateTime zdt = ZonedDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), 0, ZoneId.systemDefault());
                                zipFileDate = zdt.toInstant().toEpochMilli();
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalArgumentException e1) {
                                e1.printStackTrace();
                            }
                        }
                        ze.setTime(zipFileDate);
                        zipOutputStream.putNextEntry(ze);
                        IOUtils.copy(input, (OutputStream)zipOutputStream);
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                    }
                    int filesIndex = catalog.indexOf("<files>");
                    if (filesIndex != -1) {
                        int filesIndex2 = catalog.indexOf("</files>");
                        String files = catalog.substring(filesIndex, filesIndex2);
                        int fileIndex = files.indexOf("<file", 6);
                        int pathIndex = files.indexOf("path=");
                        while (pathIndex != -1) {
                            int pathIndex2 = files.indexOf("\"", pathIndex + 6);
                            int fileIndex2 = files.indexOf("/>", fileIndex);
                            String path = files.substring(pathIndex + 6, pathIndex2);
                            if (!path.startsWith("js/out")) {
                                fileList.append(files.substring(fileIndex - 8, fileIndex2 + 3));
                            }
                            pathIndex = files.indexOf("path=", pathIndex2);
                            fileIndex = files.indexOf("<file", fileIndex2);
                        }
                        catalog = catalog.substring(0, filesIndex) + catalog.substring(filesIndex2 + 8);
                    }
                }
                File outputFolder = null;
                if (!packingSWC) {
                    outputFolder = new File(outputFolderName);
                }
                Set externs = this.config.getExterns();
                ImmutableList roots = ((RoyaleSWCTarget)this.target).getReachableCompilationUnits(errors);
                List reachableCompilationUnits = this.project.getReachableCompilationUnitsInSWFOrder(roots);
                for (ICompilationUnit cu : reachableCompilationUnits) {
                    long fileDate;
                    String symbol;
                    ICompilationUnit.UnitType cuType = cu.getCompilationUnitType();
                    if (cuType != ICompilationUnit.UnitType.AS_UNIT && cuType != ICompilationUnit.UnitType.MXML_UNIT || externs.contains(symbol = (String)cu.getQualifiedNames().get(0)) || this.project.isExternalLinkage(cu)) continue;
                    if (!packingSWC) {
                        File outputClassFile = this.getOutputClassFile((String)cu.getQualifiedNames().get(0), outputFolder, true);
                        if (this.config.isVerbose()) {
                            System.out.println("Compiling file: " + outputClassFile);
                        }
                        ICompilationUnit unit = cu;
                        IJSWriter writer = cuType == ICompilationUnit.UnitType.AS_UNIT ? (IJSWriter)this.project.getBackend().createWriter(this.project, this.problems.getProblems(), unit, false) : (IJSWriter)this.project.getBackend().createMXMLWriter(this.project, this.problems.getProblems(), unit, false);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputClassFile));
                        BufferedOutputStream sourceMapOut = null;
                        File outputSourceMapFile = null;
                        if (this.project.config.getSourceMap()) {
                            outputSourceMapFile = this.getOutputSourceMapFile((String)cu.getQualifiedNames().get(0), outputFolder, true);
                            sourceMapOut = new BufferedOutputStream(new FileOutputStream(outputSourceMapFile));
                        }
                        writer.writeTo(out, sourceMapOut, outputSourceMapFile);
                        out.flush();
                        out.close();
                        if (sourceMapOut != null) {
                            sourceMapOut.flush();
                            sourceMapOut.close();
                        }
                        writer.close();
                        continue;
                    }
                    if (this.config.isVerbose()) {
                        System.out.println("Compiling file: " + (String)cu.getQualifiedNames().get(0));
                    }
                    ICompilationUnit unit = cu;
                    IJSWriter writer = cuType == ICompilationUnit.UnitType.AS_UNIT ? (IJSWriter)this.project.getBackend().createWriter(this.project, this.problems.getProblems(), unit, false) : (IJSWriter)this.project.getBackend().createMXMLWriter(this.project, this.problems.getProblems(), unit, false);
                    ByteArrayOutputStream temp = new ByteArrayOutputStream();
                    ByteArrayOutputStream sourceMapTemp = null;
                    boolean isExterns = false;
                    if (cu.getDefinitionPromises().size() > 0) {
                        isExterns = this.project.isExterns(((IDefinition)cu.getDefinitionPromises().get(0)).getQualifiedName());
                    }
                    if (this.project.config.getSourceMap() && !isExterns) {
                        sourceMapTemp = new ByteArrayOutputStream();
                    }
                    writer.writeTo(temp, sourceMapTemp, null);
                    String outputClassFile = this.getOutputClassFile((String)cu.getQualifiedNames().get(0), isExterns ? externsOut : jsOut, false).getPath();
                    outputClassFile = outputClassFile.replace('\\', '/');
                    if (this.config.isVerbose()) {
                        System.out.println("Writing file: " + outputClassFile);
                    }
                    long zipFileDate = fileDate = System.currentTimeMillis();
                    String metadataDate = this.targetSettings.getSWFMetadataDate();
                    if (metadataDate != null) {
                        String metadataFormat = this.targetSettings.getSWFMetadataDateFormat();
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat(metadataFormat);
                            Date d = sdf.parse(metadataDate);
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(d);
                            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                            d = sdf.parse(metadataDate);
                            fileDate = d.getTime();
                            ZonedDateTime zdt = ZonedDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), 0, ZoneId.systemDefault());
                            zipFileDate = zdt.toInstant().toEpochMilli();
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ZipEntry ze = new ZipEntry(outputClassFile);
                    ze.setTime(zipFileDate);
                    ze.setMethod(0);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    temp.writeTo(baos);
                    ze.setSize(baos.size());
                    ze.setCompressedSize(baos.size());
                    CRC32 crc = new CRC32();
                    crc.reset();
                    crc.update(baos.toByteArray());
                    ze.setCrc(crc.getValue());
                    zipOutputStream.putNextEntry(ze);
                    baos.writeTo(zipOutputStream);
                    zipOutputStream.flush();
                    zipOutputStream.closeEntry();
                    fileList.append("        <file path=\"" + outputClassFile + "\" mod=\"" + fileDate + "\"/>\n");
                    if (sourceMapTemp != null) {
                        String sourceMapFile = this.getOutputSourceMapFile((String)cu.getQualifiedNames().get(0), isExterns ? externsOut : jsOut, false).getPath();
                        if (this.config.isVerbose()) {
                            System.out.println("Writing file: " + sourceMapFile);
                        }
                        ze = new ZipEntry(sourceMapFile);
                        ze.setTime(zipFileDate);
                        ze.setMethod(0);
                        baos = new ByteArrayOutputStream();
                        sourceMapTemp.writeTo(baos);
                        ze.setSize(baos.size());
                        ze.setCompressedSize(baos.size());
                        crc = new CRC32();
                        crc.reset();
                        crc.update(baos.toByteArray());
                        ze.setCrc(crc.getValue());
                        zipOutputStream.putNextEntry(ze);
                        baos.writeTo(zipOutputStream);
                        zipOutputStream.flush();
                        zipOutputStream.closeEntry();
                        fileList.append("        <file path=\"" + sourceMapFile + "\" mod=\"" + fileDate + "\"/>\n");
                    }
                    writer.close();
                }
                if (!this.config.getCreateTargetWithErrors()) {
                    errors.clear();
                    warnings.clear();
                    this.problems.getErrorsAndWarnings(errors, warnings);
                    if (errors.size() > 0) {
                        return false;
                    }
                }
                if (packingSWC) {
                    long fileDate;
                    zipFile.close();
                    long zipFileDate = fileDate = System.currentTimeMillis();
                    String metadataDate = this.targetSettings.getSWFMetadataDate();
                    if (metadataDate != null) {
                        String metadataFormat = this.targetSettings.getSWFMetadataDateFormat();
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat(metadataFormat);
                            Date d = sdf.parse(metadataDate);
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(d);
                            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                            d = sdf.parse(metadataDate);
                            fileDate = d.getTime();
                            ZonedDateTime zdt = ZonedDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), 0, ZoneId.systemDefault());
                            zipFileDate = zdt.toInstant().toEpochMilli();
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e1) {
                            e1.printStackTrace();
                        }
                    }
                    int libraryIndex = catalog.indexOf("</libraries>");
                    catalog = catalog.substring(0, libraryIndex + 13) + "    <files>\n" + fileList.toString() + "    </files>" + catalog.substring(libraryIndex + 13);
                    ZipEntry ze = new ZipEntry("catalog.xml");
                    ze.setTime(zipFileDate);
                    ze.setMethod(0);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    baos.write(catalog.getBytes());
                    ze.setSize(baos.size());
                    ze.setCompressedSize(baos.size());
                    CRC32 crc = new CRC32();
                    crc.reset();
                    crc.update(baos.toByteArray());
                    ze.setCrc(crc.getValue());
                    zipOutputStream.putNextEntry(ze);
                    baos.writeTo(zipOutputStream);
                    zipOutputStream.flush();
                    zipOutputStream.closeEntry();
                    zipOutputStream.flush();
                    zipOutputStream.close();
                    swcFile.delete();
                    File newSWCFile = new File(outputFolderName + ".new");
                    newSWCFile.renameTo(swcFile);
                }
                compilationSuccess = true;
            }
            catch (Exception e) {
                System.out.println(e);
                InternalCompilerProblem problem = new InternalCompilerProblem(e);
                this.problems.add((ICompilerProblem)problem);
            }
        }
        return compilationSuccess;
    }

    @Override
    protected void buildArtifact() throws InterruptedException, IOException, ConfigurationException {
        this.jsTarget = this.buildJSTarget();
    }

    private IJSApplication buildJSTarget() throws InterruptedException, FileNotFoundException, ConfigurationException {
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        IJSApplication app = this.buildApplication((CompilerProject)this.project, this.config.getMainDefinition(), null, problemsBuildingSWF);
        this.problems.addAll(problemsBuildingSWF);
        if (app == null) {
            UnableToBuildSWFProblem problem = new UnableToBuildSWFProblem(this.getOutputFilePath());
            this.problems.add((ICompilerProblem)problem);
        }
        return app;
    }

    private IJSApplication buildApplication(CompilerProject applicationProject, String rootClassName, ICompilationUnit mainCU, Collection<ICompilerProblem> problems) throws InterruptedException, ConfigurationException, FileNotFoundException {
        Collection fatalProblems = applicationProject.getFatalProblems();
        if (!fatalProblems.isEmpty()) {
            problems.addAll(fatalProblems);
            return null;
        }
        return ((JSTarget)this.target).build(mainCU, problems);
    }

    private String getOutputFilePath() {
        if (this.config.getOutput() == null) {
            String extension = "." + this.project.getBackend().getOutputExtension();
            return FilenameUtils.removeExtension(this.config.getTargetFile()).concat(extension);
        }
        String outputFolderName = this.config.getOutput();
        return outputFolderName;
    }

    private File getOutputClassFile(String qname, File outputFolder, boolean createDirs) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            File sdir;
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            if (createDirs && !(sdir = new File(sdirPath)).exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + "." + this.project.getBackend().getOutputExtension());
    }

    private File getOutputSourceMapFile(String qname, File outputFolder, boolean createDirs) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            File sdir;
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            if (createDirs && !(sdir = new File(sdirPath)).exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + "." + this.project.getBackend().getOutputExtension() + ".map");
    }

    @Override
    protected boolean setupTargetFile() throws InterruptedException {
        this.config.getTargetFile();
        ITargetSettings settings = this.getTargetSettings();
        if (settings == null) {
            return false;
        }
        this.project.setTargetSettings(settings);
        this.target = this.project.getBackend().createTarget(this.project, this.getTargetSettings(), null);
        return true;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(this.getTargetType());
        }
        if (this.targetSettings == null) {
            this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
        }
        return this.targetSettings;
    }

    @Override
    protected void validateTargetFile() throws ConfigurationException {
    }

    protected String getProgramName() {
        return "compc";
    }

    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }

    @Override
    public List<String> getSourceList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ArrayList errors = new ArrayList();
            ImmutableList roots = ((RoyaleSWCTarget)this.target).getReachableCompilationUnits(errors);
            List units = this.project.getReachableCompilationUnitsInSWFOrder(roots);
            for (ICompilationUnit unit : units) {
                ICompilationUnit.UnitType ut = unit.getCompilationUnitType();
                if (ut != ICompilationUnit.UnitType.AS_UNIT && ut != ICompilationUnit.UnitType.MXML_UNIT) continue;
                list.add(unit.getAbsoluteFilename());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public String getMainSource() {
        return null;
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

