/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAssignmentNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorInNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.ForLoopNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NilNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.VariableExpressionNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;

class ArrayLikeLoopMutation
implements ForLoopNode.ILoopMutation {
    private final IForLoopNode.ForLoopKind kind = IForLoopNode.ForLoopKind.FOR;
    private boolean useDynamicAccess;
    private String iteratorVarName;
    private NodeBase iteratee;
    private FunctionCallNode iterateeValueNode;
    private ForLoopNode target;
    private ArrayList<NodeBase> analyzeRequests;
    private ContainerNode mutatedConditionals = new ContainerNode();
    private boolean conditionalsChanged;
    private boolean contentsChanged;

    public ArrayLikeLoopMutation(ForLoopNode target, String iteratorVarName, boolean useDynamicAccess) {
        this.target = target;
        this.iteratorVarName = iteratorVarName;
        this.useDynamicAccess = useDynamicAccess;
    }

    @Override
    public boolean isValid() {
        return this.mutatedConditionals != null && this.mutatedConditionals.getChildCount() == 3 && this.iteratee != null;
    }

    @Override
    public List<NodeBase> getAnalyzeRequests() {
        return this.analyzeRequests;
    }

    private FunctionCallNode createIteratorCall(String methodName) {
        BinaryOperatorNodeBase nameNode;
        ExpressionNodeBase rightOp;
        IdentifierNode leftOp = new IdentifierNode(this.iteratorVarName);
        if (this.useDynamicAccess) {
            rightOp = new LiteralNode(ILiteralNode.LiteralType.STRING, "'" + methodName + "'");
            DynamicAccessNode dynNode = new DynamicAccessNode(leftOp);
            dynNode.setRightOperandNode(rightOp);
            rightOp.setParent(dynNode);
            leftOp.setParent(dynNode);
            nameNode = dynNode;
        } else {
            rightOp = new IdentifierNode(methodName);
            nameNode = new MemberAccessExpressionNode(leftOp, null, rightOp);
            leftOp.setParent(nameNode);
            rightOp.setParent(nameNode);
        }
        FunctionCallNode functionCallNode = new FunctionCallNode(nameNode);
        nameNode.setParent(functionCallNode);
        functionCallNode.getArgumentsNode().setParent(functionCallNode);
        return functionCallNode;
    }

    private NodeBase setupIterator(boolean firstUse, FunctionCallNode assignedValue) {
        ExpressionNodeBase setupNode;
        IdentifierNode varName = new IdentifierNode(this.iteratorVarName);
        if (firstUse) {
            IdentifierNode typeNode = new IdentifierNode("Object");
            VariableNode varNode = new VariableNode(varName, typeNode);
            varNode.setKeyword(new ASToken(51, -1, -1, -1, -1, "var"));
            varNode.getKeywordNode().setParent(varNode);
            varNode.setAssignedValue(null, assignedValue);
            varNode.addChild(varNode.getKeywordNode());
            varNode.addChild(varName);
            varNode.addChild(typeNode);
            varNode.addChild(assignedValue);
            setupNode = new VariableExpressionNode(varNode);
        } else {
            ASToken assignOp = new ASToken(53, -1, -1, -1, -1, "=");
            setupNode = new BinaryOperatorAssignmentNode(assignOp, varName, assignedValue);
            varName.setParent(setupNode);
            assignedValue.setParent(setupNode);
        }
        return setupNode;
    }

    private NodeBase setupIteratee() {
        NodeBase setupNode;
        IExpressionNode original = ((BinaryOperatorInNode)this.target.getConditionalExpressionNodes()[0]).getLeftOperandNode();
        FunctionCallNode assignedValue = this.createIteratorCall("next");
        if (original instanceof VariableExpressionNode) {
            VariableNode varNode = (VariableNode)((VariableExpressionNode)original).getTargetVariable();
            varNode.setAssignedValue(null, assignedValue);
            assignedValue.setParent(varNode);
            setupNode = varNode;
        } else if (original instanceof IdentifierNode) {
            ASToken assignOp = new ASToken(53, -1, -1, -1, -1, "=");
            BinaryOperatorAssignmentNode assignmentNode = new BinaryOperatorAssignmentNode(assignOp, (IdentifierNode)original, assignedValue);
            ((IdentifierNode)original).setParent(assignmentNode);
            assignedValue.setParent(assignmentNode);
            setupNode = assignmentNode;
        } else {
            setupNode = null;
        }
        if (setupNode != null) {
            this.iterateeValueNode = assignedValue;
        }
        return setupNode;
    }

    @Override
    public ForLoopNode getLoopTarget() {
        return this.target;
    }

    @Override
    public IExpressionNode getIterationTarget() {
        return ((BinaryOperatorInNode)this.target.getConditionalExpressionNodes()[0]).getRightOperandNode();
    }

    @Override
    public void prepareConditionals(boolean firstUse, FunctionCallNode factoryFuncCall) {
        assert (!this.conditionalsChanged) : "populateConditionals was already called";
        this.mutatedConditionals.addItem(this.setupIterator(firstUse, factoryFuncCall));
        this.mutatedConditionals.addItem(this.createIteratorCall("hasNext"));
        this.mutatedConditionals.addItem(new NilNode());
        this.conditionalsChanged = true;
    }

    @Override
    public void prepareContent() {
        assert (!this.contentsChanged) : "populateContent was already called";
        this.iteratee = this.setupIteratee();
        this.contentsChanged = this.iteratee != null;
    }

    @Override
    public void processConditionals(ASScope scope, Collection<ICompilerProblem> problems) {
        ContainerNode conditionals = this.target.getConditionalsContainerNode();
        conditionals.removeAllChildren();
        conditionals.addChild((NodeBase)this.mutatedConditionals.getChild(0), 0);
        conditionals.addChild((NodeBase)this.mutatedConditionals.getChild(1), 1);
        conditionals.addChild((NodeBase)this.mutatedConditionals.getChild(2), 2);
        if (this.analyzeRequests == null) {
            this.analyzeRequests = new ArrayList();
        }
        for (int i = 0; i < 3; ++i) {
            this.analyzeRequests.add((NodeBase)conditionals.getChild(i));
        }
    }

    @Override
    public void processContents(ASScope scope, Collection<ICompilerProblem> problems) {
        BlockNode block = this.target.getContentsNode();
        block.addChild(this.iteratee, 0);
        EnumSet<PostProcessStep> set = EnumSet.of(PostProcessStep.POPULATE_SCOPE);
        if (this.analyzeRequests == null) {
            this.analyzeRequests = new ArrayList();
        }
        this.analyzeRequests.add(this.iterateeValueNode);
    }

    @Override
    public IForLoopNode.ForLoopKind getKind() {
        return this.kind;
    }

    @Override
    public boolean mutatesConditionals() {
        return this.conditionalsChanged;
    }

    @Override
    public boolean mutatesContents() {
        return this.contentsChanged;
    }
}

