/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.utils.CheapArray;

public abstract class TreeNode
extends NodeBase {
    private Object children;

    public TreeNode() {
        this.children = CheapArray.create(this.getInitialChildCount());
    }

    public TreeNode(int size) {
        this.children = CheapArray.create(size);
    }

    @Override
    public int getChildCount() {
        return CheapArray.size(this.children);
    }

    @Override
    public IASNode getChild(int i) {
        return (IASNode)CheapArray.get(i, this.children);
    }

    @Override
    protected void replaceChild(NodeBase child, NodeBase target) {
        if (child != null) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (this.getChild(i) != child) continue;
                CheapArray.replace(i, target, this.children);
                target.setParent(this);
                child.setParent(null);
                return;
            }
        }
    }

    @Override
    protected void swapChildren(NodeBase child, NodeBase target) {
        if (child != null && target != null && child.getParent() == target.getParent()) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                IASNode child2 = this.getChild(i);
                if (child2 == child) {
                    CheapArray.replace(i, target, this.children);
                    continue;
                }
                if (this.getChild(i) != target) continue;
                CheapArray.replace(i, child, this.children);
            }
        }
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        super.normalize(fillInOffsets);
        this.optimizeChildren(this.children);
    }

    protected int getInitialChildCount() {
        return 10;
    }

    public void addChild(NodeBase child) {
        if (child != null) {
            CheapArray.add(child, this.children);
            child.setParent(this);
        }
    }

    public void addChild(NodeBase child, int position) {
        if (this.children instanceof List) {
            ((List)this.children).add(position, child);
        } else {
            ArrayList<NodeBase> newArray = new ArrayList<NodeBase>();
            Collections.addAll(newArray, (IASNode[])this.children);
            newArray.add(position, child);
            this.children = CheapArray.toArray(newArray, emptyNodeArray);
        }
        child.setParent(this);
    }

    protected void addChildPostNormalize(NodeBase child) {
        if (child != null) {
            this.children = CheapArray.add(child, this.children, emptyNodeArray);
            child.setParent(this);
        }
    }

    protected void addChildInOrder(NodeBase newChild, boolean fillInOffsets) {
        if (newChild != null) {
            int start;
            newChild.normalize(fillInOffsets);
            int n = start = newChild.getAbsoluteStart() != -1 ? newChild.getAbsoluteStart() : newChild.getAbsoluteEnd();
            if (start != -1) {
                int childrenSize = this.getChildCount();
                if (childrenSize > 0 && start < this.getChild(0).getAbsoluteStart()) {
                    CheapArray.add(0, (Object)newChild, this.children);
                    newChild.setParent(this);
                    return;
                }
                for (int i = childrenSize - 1; i >= 0; --i) {
                    IASNode sibling = this.getChild(i);
                    if (sibling.getAbsoluteEnd() != -1 && sibling.getAbsoluteEnd() > start) continue;
                    CheapArray.add(i + 1, (Object)newChild, this.children);
                    newChild.setParent(this);
                    return;
                }
            }
            CheapArray.add(newChild, this.children);
            newChild.setParent(this);
        }
    }

    protected void addTemporaryChild(NodeBase child) {
        CheapArray.add(child, this.children);
    }

    protected void removeChild(NodeBase child) {
        if (child != null) {
            this.children = CheapArray.remove(child, this.children, emptyNodeArray);
            child.setParent(null);
        }
    }

    protected void removeTemporaryChild(NodeBase child) {
        CheapArray.remove(child, this.children);
    }

    public void removeAllChildren() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(this.getChild(i) instanceof NodeBase)) continue;
            ((NodeBase)this.getChild(i)).setParent(null);
        }
        this.children = this.children instanceof ArrayList ? new ArrayList(this.getInitialChildCount()) : emptyNodeArray;
    }

    protected void optimizeChildren(Object newChildren) {
        this.children = CheapArray.optimize(newChildren, emptyNodeArray);
    }

    protected void sortChildren(boolean updateBounds) {
        if (CheapArray.size(this.children) > 0) {
            CheapArray.sort(this.children, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof NodeBase && o2 instanceof NodeBase) {
                        if (((NodeBase)o1).getAbsoluteStart() < ((NodeBase)o2).getAbsoluteStart()) {
                            return -1;
                        }
                        if (((NodeBase)o1).getAbsoluteStart() == ((NodeBase)o2).getAbsoluteStart()) {
                            return 0;
                        }
                        return 1;
                    }
                    return -1;
                }
            });
            if (updateBounds) {
                this.setStart(((NodeBase)CheapArray.get(0, this.children)).getAbsoluteStart());
                this.setEnd(((NodeBase)CheapArray.get(CheapArray.size(this.children) - 1, this.children)).getAbsoluteEnd());
            }
        }
    }
}

