/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.mxml;

import antlr.CommonToken;
import antlr.Token;
import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.parsing.ICMToken;
import org.apache.royale.compiler.problems.ASDocNotClosedProblem;
import org.apache.royale.compiler.problems.CommentNotClosedProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLUnclosedTagProblem;

public abstract class BaseRawMXMLTokenizer {
    protected int aggregateStart;
    protected int aggregateStartLine;
    protected int aggregateStartColumn;
    protected StringBuilder aggregateContents;
    private Token lastToken = null;
    protected String sourcePath = null;
    protected List<ICompilerProblem> problems = null;

    public abstract String yytext();

    public abstract int getOffset();

    public abstract int getLine();

    public abstract int getColumn();

    protected Token buildToken(int type, int start, int end, int line, int column, String text) {
        CommonToken token = new CommonToken(type, text);
        token.setLine(line);
        token.setColumn(column);
        token.setFilename(this.sourcePath);
        this.lastToken = token;
        return token;
    }

    protected Token buildToken(int type, String text) {
        int start = this.getOffset();
        int end = start + text.length();
        int line = this.getLine();
        int column = this.getColumn();
        return this.buildToken(type, start, end, line, column, text);
    }

    protected Token buildToken(int type) {
        return this.buildToken(type, this.yytext());
    }

    public void reset() {
        this.lastToken = null;
        this.aggregateContents = null;
        this.aggregateStart = -1;
        this.aggregateStartLine = -1;
        this.aggregateStartColumn = -1;
    }

    public final int getLastTokenType() {
        return this.lastToken != null ? this.lastToken.getType() : -1;
    }

    public final String getLastTokenText() {
        return this.lastToken != null ? this.lastToken.getText() : "";
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    protected void setLastToken(Token token) {
        this.lastToken = token;
    }

    protected final void startAggregate() {
        this.aggregateStart = this.getOffset();
        this.aggregateStartLine = this.getLine();
        this.aggregateStartColumn = this.getColumn();
        this.aggregateContents = new StringBuilder();
        this.fillBuffer(this.aggregateContents);
    }

    protected final void startAggregate(Token token) {
        this.aggregateStart = ((ICMToken)((Object)token)).getStart();
        this.aggregateStartLine = ((ICMToken)((Object)token)).getLine();
        this.aggregateStartColumn = ((ICMToken)((Object)token)).getColumn();
        this.aggregateContents = new StringBuilder();
        this.aggregateContents.append(token.getText());
    }

    protected void continueAggregate() {
        if (this.aggregateContents != null) {
            this.fillBuffer(this.aggregateContents);
        }
    }

    protected final void continueAggregate(Token token) {
        if (this.aggregateContents != null) {
            this.aggregateContents.append(token.getText());
        }
    }

    protected void fillBuffer(StringBuilder builder) {
        builder.append(this.yytext());
    }

    protected final boolean hasAggregateContents() {
        return this.aggregateContents != null;
    }

    protected Token buildAggregateToken(int type) {
        if (this.aggregateContents == null) {
            return null;
        }
        String contents = this.aggregateContents.toString();
        this.aggregateContents = null;
        return this.buildToken(type, this.aggregateStart, this.aggregateStart + contents.length(), this.aggregateStartLine, this.aggregateStartColumn, contents);
    }

    protected String getContext(int line) {
        return this.yytext() + " (" + line + ")";
    }

    protected void reportUnclosedCDATA(MXMLToken token) {
        this.getProblems().add(new MXMLUnclosedTagProblem(token, "CDATA"));
    }

    protected void reportUnclosedComment(MXMLToken token) {
        this.getProblems().add(new CommentNotClosedProblem((ISourceLocation)token));
    }

    protected void reportUnclosedASDocComment(MXMLToken token) {
        this.getProblems().add(new ASDocNotClosedProblem((ISourceLocation)token));
    }

    public boolean hasProblems() {
        return this.problems != null && this.problems.size() > 0;
    }

    public List<ICompilerProblem> getProblems() {
        if (this.problems == null) {
            this.problems = new ArrayList<ICompilerProblem>(0);
        }
        return this.problems;
    }

    public boolean hasBufferToken() {
        return false;
    }

    public ASToken getBufferToken() {
        throw new UnsupportedOperationException();
    }

    public boolean isInE4XDatabinding() {
        return false;
    }
}

