/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.Collection;
import java.util.List;
import org.apache.royale.compiler.internal.fxg.dom.AbstractShapeNode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.problems.FXGInvalidRectRadiusXRadiusYAttributeProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.swf.types.LineStyle;
import org.apache.royale.swf.types.Rect;
import org.apache.royale.swf.types.ShapeRecord;

public class RectNode
extends AbstractShapeNode {
    public double width = 0.0;
    public double height = 0.0;
    public double radiusX = 0.0;
    public double radiusY = 0.0;
    public double topLeftRadiusX = Double.NaN;
    public double topLeftRadiusY = Double.NaN;
    public double topRightRadiusY = Double.NaN;
    public double topRightRadiusX = Double.NaN;
    public double bottomRightRadiusX = Double.NaN;
    public double bottomRightRadiusY = Double.NaN;
    public double bottomLeftRadiusX = Double.NaN;
    public double bottomLeftRadiusY = Double.NaN;

    @Override
    public String getNodeName() {
        return "Rect";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name, this.width, problems);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name, this.height, problems);
        } else if ("radiusX".equals(name)) {
            this.radiusX = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.radiusX < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("radiusY".equals(name)) {
            this.radiusY = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.radiusY < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("topLeftRadiusX".equals(name)) {
            this.topLeftRadiusX = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.topLeftRadiusX < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("topLeftRadiusY".equals(name)) {
            this.topLeftRadiusY = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.topLeftRadiusY < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("topRightRadiusX".equals(name)) {
            this.topRightRadiusX = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.topRightRadiusX < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("topRightRadiusY".equals(name)) {
            this.topRightRadiusY = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.topRightRadiusY < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("bottomLeftRadiusX".equals(name)) {
            this.bottomLeftRadiusX = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.bottomLeftRadiusX < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("bottomLeftRadiusY".equals(name)) {
            this.bottomLeftRadiusY = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.bottomLeftRadiusY < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("bottomRightRadiusX".equals(name)) {
            this.bottomRightRadiusX = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.bottomRightRadiusX < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else if ("bottomRightRadiusY".equals(name)) {
            this.bottomRightRadiusY = DOMParserHelper.parseDouble(this, value, name, -1.0, problems);
            if (this.bottomRightRadiusY < 0.0) {
                problems.add(new FXGInvalidRectRadiusXRadiusYAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            }
        } else {
            super.setAttribute(name, value, problems);
        }
    }

    @Override
    public Rect getBounds(List<ShapeRecord> records, LineStyle ls) {
        int x1 = 0;
        int y1 = 0;
        int x2 = (int)(this.width * 20.0);
        int y2 = (int)(this.height * 20.0);
        if (ls != null) {
            int width = 20;
            if (width < ls.getWidth()) {
                width = ls.getWidth();
            }
            int stroke = (int)Math.rint((double)width / 2.0);
            x1 -= stroke;
            y1 -= stroke;
            x2 += stroke;
            y2 += stroke;
        }
        return new Rect(x1, x2, y1, y2);
    }
}

