/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;
import org.apache.royale.abc.graph.algorithms.DominatorTree;
import org.apache.royale.abc.models.FrameModelEncoder;
import org.apache.royale.abc.models.FrameModelVisitor;
import org.apache.royale.abc.models.TreeModelVisitor;
import org.apache.royale.abc.semantics.ExceptionInfo;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.visitors.IDiagnosticsVisitor;
import org.apache.royale.abc.visitors.NilDiagnosticsVisitor;

public class TreeModelEncoder<T> {
    private final MethodBodyInfo mbi;
    private final TreeModelVisitor<T> visitor;
    private final IDiagnosticsVisitor diagnosticsVisitor;
    IBasicBlock currentBlock;
    private FrameModelEncoder encoder;
    ArrayList<Object> localSymbolicReferences = new ArrayList();
    ArrayList<Object> valueSymbolicReferences = new ArrayList();
    ArrayList<Object> scopeSymbolicReferences = new ArrayList();
    private Map<Object, Set<IBasicBlock>> a = new HashMap<Object, Set<IBasicBlock>>();
    private Map<IBasicBlock, Frame> framesByBlock = new HashMap<IBasicBlock, Frame>();

    public TreeModelEncoder(MethodBodyInfo mbi, TreeModelVisitor<T> visitor, IDiagnosticsVisitor diagnosticsVisitor) {
        this.mbi = mbi;
        this.visitor = visitor;
        this.diagnosticsVisitor = diagnosticsVisitor;
        this.visitor.visit(this);
        this.setUpFrames();
        this.placePhiNodes();
        this.visitFrames();
        this.visitor.visitEnd();
    }

    public MethodBodyInfo getMethodBodyInfo() {
        return this.mbi;
    }

    public IFlowgraph getCfg() {
        return this.mbi.getCfg();
    }

    public IBasicBlock getCurrentBlock() {
        return this.currentBlock;
    }

    public int getInstructionIndex() {
        return this.encoder.getInstructionIndex();
    }

    private void setUpFrames() {
        this.mbi.getCfg().traverseGraph(new FrameModelEncoder(this.mbi, new FrameSetupVisitor(), new NilDiagnosticsVisitor()));
    }

    private void placePhiNodes() {
        int iterCount = 0;
        DominatorTree.Multimap<IBasicBlock> df = this.getCfg().getDominatorTree().getDominanceFrontiers();
        HashMap<IBasicBlock, Integer> hasAlready = new HashMap<IBasicBlock, Integer>();
        HashMap<IBasicBlock, Integer> work = new HashMap<IBasicBlock, Integer>();
        for (Object local : this.localSymbolicReferences) {
            iterCount = this.placePhiNodes(iterCount, local, df, this.a, hasAlready, work);
        }
        for (Object scope : this.scopeSymbolicReferences) {
            iterCount = this.placePhiNodes(iterCount, scope, df, this.a, hasAlready, work);
        }
        for (Object value : this.valueSymbolicReferences) {
            iterCount = this.placePhiNodes(iterCount, value, df, this.a, hasAlready, work);
        }
    }

    private int placePhiNodes(int initialIteration, Object v, DominatorTree.Multimap<IBasicBlock> df, Map<Object, Set<IBasicBlock>> a, Map<IBasicBlock, Integer> hasAlready, Map<IBasicBlock, Integer> work) {
        if (!a.containsKey(v)) {
            return initialIteration;
        }
        int iterCount = initialIteration + 1;
        HashSet<IBasicBlock> w = new HashSet<IBasicBlock>();
        for (IBasicBlock x : a.get(v)) {
            work.put(x, iterCount);
            w.add(x);
        }
        while (!w.isEmpty()) {
            IBasicBlock x;
            Iterator it = w.iterator();
            x = (IBasicBlock)it.next();
            it.remove();
            Iterator iterator = df.get(x).iterator();
            while (iterator.hasNext()) {
                IBasicBlock y = (IBasicBlock)iterator.next();
                if (hasAlready.containsKey(y) && hasAlready.get(y) >= iterCount) continue;
                this.placePhiNode(y, v);
                hasAlready.put(y, iterCount);
                if (work.containsKey(y) && work.get(y) >= iterCount) continue;
                work.put(y, iterCount);
                w.add(y);
            }
        }
        return iterCount;
    }

    void placePhiNode(IBasicBlock target, Object frameKey) {
        Frame targetFrame = this.getFrame(target);
        int idx = this.localSymbolicReferences.indexOf(frameKey);
        if (idx != -1) {
            if (this.needsInitializer(targetFrame.locals, idx)) {
                this.setFrameElement(targetFrame.locals, idx, this.visitor.addMergePoint(this.currentBlock));
            }
        } else {
            idx = this.valueSymbolicReferences.indexOf(frameKey);
            if (idx != -1) {
                if (this.needsInitializer(targetFrame.values, idx)) {
                    this.setFrameElement(targetFrame.values, idx, this.visitor.addMergePoint(this.currentBlock));
                }
            } else {
                idx = this.scopeSymbolicReferences.indexOf(frameKey);
                assert (idx != -1);
                if (this.needsInitializer(targetFrame.scopes, idx)) {
                    this.setFrameElement(targetFrame.scopes, idx, this.visitor.addMergePoint(this.currentBlock));
                }
            }
        }
    }

    private boolean needsInitializer(ArrayList<? extends Object> elements, int idx) {
        return elements.size() <= idx || elements.get(idx) == null;
    }

    private void touchFrameElement(ArrayList<Object> elements, int idx) {
        if (this.needsInitializer(elements, idx)) {
            this.setFrameElement(elements, idx, new Object());
        }
    }

    private <E> void setFrameElement(ArrayList<E> elements, int idx, E value) {
        while (elements.size() <= idx) {
            elements.add(null);
        }
        elements.set(idx, value);
    }

    private void modifyFrameElement(ArrayList<Object> elements, int idx, IBasicBlock b) {
        this.touchFrameElement(elements, idx);
        if (!this.a.containsKey(elements.get(idx))) {
            this.a.put(elements.get(idx), new HashSet());
        }
        this.a.get(elements.get(idx)).add(b);
    }

    private void visitFrames() {
        ArrayList<T> parameters = new ArrayList<T>();
        for (int i = 0; i < this.mbi.getMethodInfo().getParamCount(); ++i) {
            parameters.add(this.visitor.translateParameter(i));
        }
        Frame startFrame = this.getFrame(this.mbi.getCfg().getStartBlock());
        startFrame.locals.addAll(parameters);
        for (ExceptionInfo ex : this.mbi.getExceptions()) {
            int i;
            IBasicBlock catchTarget = this.mbi.getCfg().getBlock(ex.getTarget());
            Frame catchFrame = this.getFrame(catchTarget);
            this.setFrameElement(catchFrame.values, 0, this.visitor.translateExceptionVariable(ex.getCatchVar(), ex.getExceptionType()));
            for (i = 0; i < parameters.size(); ++i) {
                catchFrame.locals.add(this.visitor.addMergePoint(catchTarget));
                TreeModelVisitor.IMergePoint mergeNode = (TreeModelVisitor.IMergePoint)catchFrame.locals.get(i);
                mergeNode.addValue(parameters.get(i));
            }
            for (i = parameters.size(); i < this.localSymbolicReferences.size(); ++i) {
                catchFrame.locals.add(this.visitor.addMergePoint(catchTarget));
            }
        }
        this.encoder = new FrameModelEncoder(this.mbi, new ModelDrivingVisitor(this.visitor), this.diagnosticsVisitor);
        this.mbi.getCfg().traverseGraph(this.encoder);
    }

    void propagateLocalToCatchBlocks(int idx, T value) {
        for (ExceptionInfo ex : this.mbi.getExceptions()) {
            IBasicBlock catchTarget = this.mbi.getCfg().getBlock(ex.getTarget());
            Frame catchFrame = this.getFrame(catchTarget);
            if (!(catchFrame.locals.get(idx) instanceof TreeModelVisitor.IMergePoint)) continue;
            TreeModelVisitor.IMergePoint mergeNode = (TreeModelVisitor.IMergePoint)catchFrame.locals.get(idx);
            mergeNode.addValue(value);
        }
    }

    public Frame getFrame(IBasicBlock b) {
        if (!this.framesByBlock.containsKey(b)) {
            this.framesByBlock.put(b, new Frame());
        }
        return this.framesByBlock.get(b);
    }

    private static <X> void adjustSize(ArrayList<X> frameElements, int idx) {
        while (frameElements.size() < idx) {
            frameElements.add(null);
        }
    }

    static <X> X popElement(ArrayList<X> frameElements) {
        int lastIdx = frameElements.size() - 1;
        return frameElements.remove(lastIdx);
    }

    private class ModelDrivingVisitor
    implements FrameModelVisitor<T> {
        final TreeModelVisitor<T> visitor;
        Frame currentFrame = null;

        ModelDrivingVisitor(TreeModelVisitor<T> visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visit(FrameModelEncoder encoder) {
            assert (encoder == TreeModelEncoder.this.encoder);
        }

        @Override
        public void visitEnd() {
            TreeModelEncoder.this.encoder = null;
        }

        @Override
        public T noFrameEffect(Instruction i) {
            return this.visitor.translate(i, this.noOperands());
        }

        @Override
        public T consumeValue(Instruction i, int count) {
            if (this.currentFrame.verifyStackDepth(count)) {
                ArrayList<Object> operands = new ArrayList<Object>(count);
                for (int j = 0; j < count; ++j) {
                    operands.add(this.currentFrame.popValue());
                }
                return this.visitor.translate(i, operands);
            }
            return this.visitor.valueStackUnderflow(i, count);
        }

        @Override
        public T produceValue(Instruction i) {
            return this.currentFrame.pushValue(this.visitor.translate(i, this.noOperands()));
        }

        @Override
        public T consumeAndProduceValue(Instruction i, int consumeCount) {
            if (this.currentFrame.verifyStackDepth(consumeCount)) {
                ArrayList<Object> operands = new ArrayList<Object>(consumeCount);
                for (int j = 0; j < consumeCount; ++j) {
                    operands.add(this.currentFrame.popValue());
                }
                return this.currentFrame.pushValue(this.visitor.translate(i, operands));
            }
            return this.visitor.valueStackUnderflow(i, consumeCount);
        }

        @Override
        public T branch(Instruction i, IBasicBlock target) {
            return this.visitor.translateBranch(i, this.singleOperand(target));
        }

        @Override
        public T multiwayBranch(Instruction i, Collection<IBasicBlock> targets) {
            return this.visitor.translateBranch(i, targets);
        }

        @Override
        public T getlocal(Instruction i, int idx) {
            TreeModelEncoder.adjustSize(this.currentFrame.locals, idx + 1);
            Object result = this.visitor.translate(i, this.singleOperand(this.currentFrame.getlocal(idx)));
            this.currentFrame.pushValue(result);
            return result;
        }

        @Override
        public T setlocal(Instruction i, int idx) {
            TreeModelEncoder.adjustSize(this.currentFrame.locals, idx + 1);
            if (this.currentFrame.verifyStackDepth(1)) {
                Object result = this.visitor.translate(i, this.singleOperand(this.currentFrame.popValue()));
                return this.currentFrame.setlocal(idx, result);
            }
            return this.currentFrame.setlocal(idx, this.visitor.valueStackUnderflow(i, 1));
        }

        @Override
        public void modifyLocal(Instruction i, int idx) {
            this.visitor.translate(i, this.noOperands());
        }

        @Override
        public T moveValueToScopeStack(Instruction i) {
            if (this.currentFrame.verifyStackDepth(1)) {
                return this.currentFrame.pushScope(this.visitor.translate(i, this.singleOperand(this.currentFrame.popValue())));
            }
            return this.visitor.valueStackUnderflow(i, 1);
        }

        @Override
        public T popscope(Instruction i) {
            if (this.currentFrame.verifyScopeDepth(1)) {
                return this.visitor.translate(i, this.singleOperand(this.currentFrame.popScope()));
            }
            return this.visitor.scopeStackUnderflow(i, 1);
        }

        @Override
        public T getScopeobject(Instruction i, int idx) {
            if (this.currentFrame.verifyScopeDepth(idx + 1)) {
                return this.currentFrame.pushValue(this.visitor.translate(i, this.singleOperand(this.currentFrame.scopes.get(idx))));
            }
            return this.visitor.scopeStackUnderflow(i, 1);
        }

        @Override
        public T hasnext2(Instruction i) {
            return null;
        }

        @Override
        public T dup(Instruction i) {
            if (this.currentFrame.verifyStackDepth(1)) {
                return this.currentFrame.pushValue(this.visitor.translate(i, this.singleOperand(this.currentFrame.tos())));
            }
            return this.visitor.valueStackUnderflow(i, 1);
        }

        @Override
        public T swap(Instruction i) {
            if (this.currentFrame.verifyStackDepth(2)) {
                int stackDepth = this.currentFrame.valueStackDepth();
                Object temp = this.visitor.translate(i, this.singleOperand(this.currentFrame.tos()));
                this.currentFrame.values.set(stackDepth, this.currentFrame.values.get(stackDepth - 1));
                this.currentFrame.values.set(stackDepth - 1, temp);
                return this.currentFrame.tos();
            }
            return this.visitor.valueStackUnderflow(i, 2);
        }

        @Override
        public boolean visitBlock(IBasicBlock b) {
            Frame frame = TreeModelEncoder.this.getFrame(b);
            TreeModelEncoder.this.currentBlock = b;
            this.currentFrame = frame;
            if (this.visitor.visitBlock(b)) {
                return true;
            }
            this.currentFrame = null;
            TreeModelEncoder.this.currentBlock = null;
            return false;
        }

        @Override
        public void visitEndBlock(IBasicBlock b) {
            this.visitor.visitEnd(b);
            this.currentFrame = null;
            TreeModelEncoder.this.currentBlock = null;
        }

        @Override
        public void visitEdge(IBasicBlock from, IBasicBlock target) {
            int i;
            assert (TreeModelEncoder.this.getFrame(from) == this.currentFrame);
            Frame targetFrame = TreeModelEncoder.this.getFrame(target);
            for (i = 0; i < this.currentFrame.locals.size(); ++i) {
                this.addInitializer(i, targetFrame.locals, this.currentFrame.getlocal(i));
            }
            for (i = 0; i < this.currentFrame.values.size(); ++i) {
                this.addInitializer(i, targetFrame.values, this.currentFrame.values.get(i));
            }
            for (i = 0; i < this.currentFrame.scopes.size(); ++i) {
                this.addInitializer(i, targetFrame.scopes, this.currentFrame.getscopeobject(i));
            }
        }

        private void addInitializer(int i, ArrayList<T> target, T value) {
            if (target.size() <= i) {
                TreeModelEncoder.adjustSize(target, i);
                target.add(value);
            } else if (target.get(i) instanceof TreeModelVisitor.IMergePoint) {
                TreeModelVisitor.IMergePoint phi = (TreeModelVisitor.IMergePoint)target.get(i);
                phi.addValue(value);
            } else if (target.get(i) == null) {
                target.set(i, value);
            }
        }

        private <X> Collection<X> singleOperand(X operand) {
            ArrayList<X> result = new ArrayList<X>(1);
            result.add(operand);
            return result;
        }

        private Collection<T> noOperands() {
            return Collections.emptyList();
        }
    }

    private static class BlockState {
        int stackDepth = 0;
        int scopeDepth = 0;

        private BlockState() {
        }
    }

    private class FrameSetupVisitor
    implements FrameModelVisitor<T> {
        IBasicBlock currentBlock = null;
        BlockState blockState = null;
        private Set<IBasicBlock> visited = new HashSet<IBasicBlock>();
        private Map<IBasicBlock, BlockState> statesByBlock = new HashMap<IBasicBlock, BlockState>();

        private FrameSetupVisitor() {
        }

        @Override
        public void visit(FrameModelEncoder encoder) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public T noFrameEffect(Instruction i) {
            return null;
        }

        @Override
        public T consumeValue(Instruction i, int count) {
            this.blockState.stackDepth = Math.max(this.blockState.stackDepth - count, 0);
            return null;
        }

        @Override
        public T produceValue(Instruction i) {
            TreeModelEncoder.this.modifyFrameElement(TreeModelEncoder.this.valueSymbolicReferences, this.blockState.stackDepth, this.currentBlock);
            ++this.blockState.stackDepth;
            return null;
        }

        @Override
        public T consumeAndProduceValue(Instruction i, int consumeCount) {
            this.consumeValue(null, consumeCount);
            this.produceValue(null);
            return null;
        }

        @Override
        public T branch(Instruction i, IBasicBlock target) {
            return null;
        }

        @Override
        public T multiwayBranch(Instruction i, Collection<IBasicBlock> targets) {
            return null;
        }

        @Override
        public T getlocal(Instruction i, int idx) {
            TreeModelEncoder.this.touchFrameElement(TreeModelEncoder.this.localSymbolicReferences, idx);
            return null;
        }

        @Override
        public T setlocal(Instruction i, int idx) {
            TreeModelEncoder.this.modifyFrameElement(TreeModelEncoder.this.localSymbolicReferences, idx, this.currentBlock);
            return null;
        }

        @Override
        public void modifyLocal(Instruction i, int idx) {
            TreeModelEncoder.this.modifyFrameElement(TreeModelEncoder.this.localSymbolicReferences, idx, this.currentBlock);
        }

        @Override
        public T moveValueToScopeStack(Instruction i) {
            this.consumeValue(null, 1);
            TreeModelEncoder.this.modifyFrameElement(TreeModelEncoder.this.scopeSymbolicReferences, this.blockState.scopeDepth, this.currentBlock);
            ++this.blockState.scopeDepth;
            return null;
        }

        @Override
        public T popscope(Instruction i) {
            this.blockState.scopeDepth = Math.max(this.blockState.scopeDepth - 1, 0);
            return null;
        }

        @Override
        public T getScopeobject(Instruction i, int idx) {
            TreeModelEncoder.this.touchFrameElement(TreeModelEncoder.this.scopeSymbolicReferences, idx);
            return null;
        }

        @Override
        public T hasnext2(Instruction i) {
            TreeModelEncoder.this.modifyFrameElement(TreeModelEncoder.this.localSymbolicReferences, (Integer)i.getOperand(0), this.currentBlock);
            TreeModelEncoder.this.modifyFrameElement(TreeModelEncoder.this.localSymbolicReferences, (Integer)i.getOperand(1), this.currentBlock);
            return null;
        }

        @Override
        public T dup(Instruction i) {
            this.produceValue(null);
            return null;
        }

        @Override
        public T swap(Instruction i) {
            return null;
        }

        @Override
        public boolean visitBlock(IBasicBlock b) {
            if (this.visited.add(b)) {
                assert (this.currentBlock == null);
                this.currentBlock = b;
                this.blockState = this.getBlockState(b);
                return true;
            }
            return false;
        }

        @Override
        public void visitEndBlock(IBasicBlock b) {
            int i;
            for (i = 0; i < this.blockState.stackDepth; ++i) {
                TreeModelEncoder.this.touchFrameElement(TreeModelEncoder.this.valueSymbolicReferences, i);
            }
            for (i = 0; i < this.blockState.scopeDepth; ++i) {
                TreeModelEncoder.this.touchFrameElement(TreeModelEncoder.this.scopeSymbolicReferences, i);
            }
            this.currentBlock = null;
            this.blockState = null;
        }

        @Override
        public void visitEdge(IBasicBlock from, IBasicBlock target) {
            assert (from == this.currentBlock);
            BlockState targetState = this.getBlockState(target);
            targetState.stackDepth = this.blockState.stackDepth;
            targetState.scopeDepth = this.blockState.scopeDepth;
        }

        private BlockState getBlockState(IBasicBlock b) {
            if (!this.statesByBlock.containsKey(b)) {
                this.statesByBlock.put(b, new BlockState());
            }
            return this.statesByBlock.get(b);
        }
    }

    public class Frame {
        public final ArrayList<T> locals = new ArrayList();
        public final ArrayList<T> scopes = new ArrayList();
        public final ArrayList<T> values = new ArrayList();

        public T tos() {
            return this.values.get(this.valueStackDepth());
        }

        private T popValue() {
            return TreeModelEncoder.popElement(this.values);
        }

        private T pushValue(T value) {
            this.values.add(value);
            return value;
        }

        private T pushScope(T scope) {
            this.scopes.add(scope);
            return scope;
        }

        private T popScope() {
            return TreeModelEncoder.popElement(this.scopes);
        }

        private T getlocal(int idx) {
            TreeModelEncoder.adjustSize(this.locals, idx + 1);
            return this.locals.get(idx);
        }

        private T setlocal(int idx, T value) {
            TreeModelEncoder.adjustSize(this.locals, idx + 1);
            this.locals.set(idx, value);
            TreeModelEncoder.this.propagateLocalToCatchBlocks(idx, value);
            return value;
        }

        private T getscopeobject(int idx) {
            TreeModelEncoder.adjustSize(this.scopes, idx + 1);
            return this.scopes.get(idx);
        }

        private boolean verifyStackDepth(int required) {
            return this.values.size() >= required;
        }

        private int valueStackDepth() {
            return this.values.size() - 1;
        }

        private boolean verifyScopeDepth(int required) {
            return this.scopes.size() >= required;
        }

        private int scopeStackDepth() {
            return this.scopes.size() - 1;
        }
    }
}

