////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package
{
    /**
     *  The FontAwesome4IconType class list all possible icons
	 *  for Font Awesome version 5
     *  found in https://fontawesome.com/ to use with the 
     *  FontAwesomeIcon class.
     *
     *  @langversion 3.0
     *  @playerversion Flash 10.2
     *  @playerversion AIR 2.6
     *  @productversion Royale 0.9.7
     */
    public class FontAwesome5IconType
    {
        /**
		 *  constructor.
         * 
		 *  @langversion 3.0
		 *  @playerversion Flash 10.2
		 *  @playerversion AIR 2.6
		 *  @productversion Royale 0.9.7
		 */
		public function FontAwesome5IconType()
		{
			super();
		}
		
		public static const ADDRESS_BOOK:String = "address-book";
		public static const ADDRESS_CARD:String = "address-card";
		public static const ADJUST:String = "adjust";
		public static const ADN:String = "adn";
		public static const ALIGN_CENTER:String = "align-center";
		public static const ALIGN_JUSTIFY:String = "align-justify";
		public static const ALIGN_LEFT:String = "align-left";
		public static const ALIGN_RIGHT:String = "align-right";
		public static const AMAZON:String = "amazon";
		public static const AMBULANCE:String = "ambulance";
		public static const AMERICAN_SIGN_LANGUAGE_INTERPRETING:String = "american-sign-language-interpreting";
		public static const ANCHOR:String = "anchor";
		public static const ANDROID:String = "android";
		public static const ANGELLIST:String = "angellist";
		public static const ANGLE_DOUBLE_DOWN:String = "angle-double-down";
		public static const ANGLE_DOUBLE_LEFT:String = "angle-double-left";
		public static const ANGLE_DOUBLE_RIGHT:String = "angle-double-right";
		public static const ANGLE_DOUBLE_UP:String = "angle-double-up";
		public static const ANGLE_DOWN:String = "angle-down";
		public static const ANGLE_LEFT:String = "angle-left";
		public static const ANGLE_RIGHT:String = "angle-right";
		public static const ANGLE_UP:String = "angle-up";
		public static const APPLE:String = "apple";
		public static const ARCHIVE:String = "archive";
		public static const AREA_CHART:String = "area-chart";
		public static const ARROW_ALT_CIRCLE_DOWN:String = "arrow-alt-circle-down";
		public static const ARROW_CIRCLE_DOWN:String = "arrow-circle-down";
		public static const ARROW_CIRCLE_LEFT:String = "arrow-circle-left";
		public static const ARROW_CIRCLE_RIGHT:String = "arrow-circle-right";
		public static const ARROW_CIRCLE_UP:String = "arrow-circle-up";
		public static const ARROW_DOWN:String = "arrow-down";
		public static const ARROW_LEFT:String = "arrow-left";
		public static const ARROW_RIGHT:String = "arrow-right";
		public static const ARROW_UP:String = "arrow-up";
		public static const ARROWS_ALT:String = "arrows-alt";
		public static const ARROWS_H:String = "arrows-h";
		public static const ARROWS_V:String = "arrows-v";
		public static const ARROWS:String = "arrows";
		public static const ASSISTIVE_LISTENING_SYSTEMS:String = "assistive-listening-systems";
		public static const ASTERISK:String = "asterisk";
		public static const AT:String = "at";
		public static const AUDIO_DESCRIPTION:String = "audio-description";
		public static const BACKWARD:String = "backward";
		public static const BACTERIA:String = "bacteria";
		public static const BACTERIUM:String = "bacterium";
		public static const BALANCE_SCALE:String = "balance-scale";
		public static const BAN:String = "ban";
		public static const BANDCAMP:String = "bandcamp";
		public static const BAR_CHART:String = "bar-chart";
		public static const BARCODE:String = "barcode";
		public static const BARS:String = "bars";
		public static const BATH:String = "bath";
		public static const BATTERY_EMPTY:String = "battery-empty";
		public static const BATTERY_FULL:String = "battery-full";
		public static const BATTERY_HALF:String = "battery-half";
		public static const BATTERY_QUARTER:String = "battery-quarter";
		public static const BATTERY_THREE_QUARTERS:String = "battery-three-quarters";
		public static const BED:String = "bed";
		public static const BEER:String = "beer";
		public static const BEHANCE_SQUARE:String = "behance-square";
		public static const BEHANCE:String = "behance";
		public static const BELL_SLASH:String = "bell-slash";
		public static const BELL:String = "bell";
		public static const BICYCLE:String = "bicycle";
		public static const BINOCULARS:String = "binoculars";
		public static const BIRTHDAY_CAKE:String = "birthday-cake";
		public static const BITBUCKET_SQUARE:String = "bitbucket-square";
		public static const BITBUCKET:String = "bitbucket";
		public static const BLACK_TIE:String = "black-tie";
		public static const BLIND:String = "blind";
		public static const BLUETOOTH_B:String = "bluetooth-b";
		public static const BLUETOOTH:String = "bluetooth";
		public static const BOLD:String = "bold";
		public static const BOLT:String = "bolt";
		public static const BOMB:String = "bomb";
		public static const BOOK:String = "book";
		public static const BOOKMARK:String = "bookmark";
		public static const BOX_TISSUE:String = "box-tissue";
		public static const BRAILLE:String = "braille";
		public static const BRIEFCASE:String = "briefcase";
		public static const BTC:String = "btc";
		public static const BUG:String = "bug";
		public static const BUILDING:String = "building";
		public static const BULLHORN:String = "bullhorn";
		public static const BULLSEYE:String = "bullseye";
		public static const BUS:String = "bus";
		public static const BUYSELLADS:String = "buysellads";
		public static const CALCULATOR:String = "calculator";
		public static const CALENDAR_CHECK:String = "calendar-check";
		public static const CALENDAR_MINUS:String = "calendar-minus";
		public static const CALENDAR_PLUS:String = "calendar-plus";
		public static const CALENDAR_TIMES:String = "calendar-times";
		public static const CALENDAR:String = "calendar";
		public static const CAMERA_RETRO:String = "camera-retro";
		public static const CAMERA:String = "camera";
		public static const CAR:String = "car";
		public static const CARET_DOWN:String = "caret-down";
		public static const CARET_LEFT:String = "caret-left";
		public static const CARET_RIGHT:String = "caret-right";
		public static const CARET_SQUARE_DOWN:String = "caret-square-down";
		public static const CARET_SQUARE_LEFT:String = "caret-square-left";
		public static const CARET_SQUARE_RIGHT:String = "caret-square-right";
		public static const CARET_SQUARE_UP:String = "caret-square-up";
		public static const CARET_UP:String = "caret-up";
		public static const CART_ARROW_DOWN:String = "cart-arrow-down";
		public static const CART_PLUS:String = "cart-plus";
		public static const CC_AMEX:String = "cc-amex";
		public static const CC_DINERS_CLUB:String = "cc-diners-club";
		public static const CC_DISCOVER:String = "cc-discover";
		public static const CC_JCB:String = "cc-jcb";
		public static const CC_MASTERCARD:String = "cc-mastercard";
		public static const CC_PAYPAL:String = "cc-paypal";
		public static const CC_STRIPE:String = "cc-stripe";
		public static const CC_VISA:String = "cc-visa";
		public static const CC:String = "cc";
		public static const CERTIFICATE:String = "certificate";
		public static const CHAIN_BROKEN:String = "chain-broken";
		public static const CHECK_CIRCLE:String = "check-circle";
		public static const CHECK_SQUARE:String = "check-square";
		public static const CHECK:String = "check";
		public static const CHEVRON_CIRCLE_DOWN:String = "chevron-circle-down";
		public static const CHEVRON_CIRCLE_LEFT:String = "chevron-circle-left";
		public static const CHEVRON_CIRCLE_RIGHT:String = "chevron-circle-right";
		public static const CHEVRON_CIRCLE_UP:String = "chevron-circle-up";
		public static const CHEVRON_DOWN:String = "chevron-down";
		public static const CHEVRON_LEFT:String = "chevron-left";
		public static const CHEVRON_RIGHT:String = "chevron-right";
		public static const CHEVRON_UP:String = "chevron-up";
		public static const CHILD:String = "child";
		public static const CHROME:String = "chrome";
		public static const CIRCLE_NOTCH:String = "circle-notch";
		public static const CIRCLE_THIN:String = "circle-thin";
		public static const CIRCLE:String = "circle";
		public static const CLIPBOARD:String = "clipboard";
		public static const CLOCK:String = "clock";
		public static const CLONE:String = "clone";
		public static const CLOUD_DOWNLOAD:String = "cloud-download";
		public static const CLOUD_UPLOAD:String = "cloud-upload";
		public static const CLOUD:String = "cloud";
		public static const CODE_FORK:String = "code-fork";
		public static const CODE:String = "code";
		public static const CODEPEN:String = "codepen";
		public static const CODIEPIE:String = "codiepie";
		public static const COFFEE:String = "coffee";
		public static const COG:String = "cog";
		public static const COGS:String = "cogs";
		public static const COLUMNS:String = "columns";
		public static const COMMENT:String = "comment";
		public static const COMMENTING:String = "commenting";
		public static const COMMENTS:String = "comments";
		public static const COMPASS:String = "compass";
		public static const COMPRESS:String = "compress";
		public static const CONNECTDEVELOP:String = "connectdevelop";
		public static const CONTAO:String = "contao";
		public static const COPYRIGHT:String = "copyright";
		public static const CREATIVE_COMMONS:String = "creative-commons";
		public static const CREDIT_CARD_ALT:String = "credit-card-alt";
		public static const CREDIT_CARD:String = "credit-card";
		public static const CROP:String = "crop";
		public static const CROSSHAIRS:String = "crosshairs";
		public static const CSS3:String = "css3";
		public static const CUBE:String = "cube";
		public static const CUBES:String = "cubes";
		public static const CUTLERY:String = "cutlery";
		public static const DASHCUBE:String = "dashcube";
		public static const DATABASE:String = "database";
		public static const DEAF:String = "deaf";
		public static const DELICIOUS:String = "delicious";
		public static const DESKTOP:String = "desktop";
		public static const DEVIANTART:String = "deviantart";
		public static const DIAMOND:String = "diamond";
		public static const DIGG:String = "digg";
		public static const DOT_CIRCLE:String = "dot-circle";
		public static const DOWNLOAD:String = "download";
		public static const DRIBBBLE:String = "dribbble";
		public static const DROPBOX:String = "dropbox";
		public static const DRUPAL:String = "drupal";
		public static const EDGE:String = "edge";
		public static const EERCAST:String = "eercast";
		public static const EJECT:String = "eject";
		public static const ELLIPSIS_H:String = "ellipsis-h";
		public static const ELLIPSIS_V:String = "ellipsis-v";
		public static const EMPIRE:String = "empire";
		public static const ENVELOPE_SQUARE:String = "envelope-square";
		public static const ENVELOPE:String = "envelope";
		public static const ENVELOPEPEN:String = "envelopepen";
		public static const ENVIRA:String = "envira";
		public static const ERASER:String = "eraser";
		public static const ETSY:String = "etsy";
		public static const EUR:String = "eur";
		public static const EXCHANGE:String = "exchange";
		public static const EXCLAMATION_CIRCLE:String = "exclamation-circle";
		public static const EXCLAMATION_TRIANGLE:String = "exclamation-triangle";
		public static const EXCLAMATION:String = "exclamation";
		public static const EXPAND:String = "expand";
		public static const EXPEDITEDSSL:String = "expeditedssl";
		public static const EXTERNAL_LINK_SQUARE:String = "external-link-square";
		public static const EXTERNAL_LINK:String = "external-link";
		public static const EYE_SLASH:String = "eye-slash";
		public static const EYE:String = "eye";
		public static const EYEDROPPER:String = "eyedropper";
		public static const F500PX:String = "500px";
		public static const FACEBOOK_SQUARE:String = "facebook-square";
		public static const FACEBOOK:String = "facebook";
		public static const FACEBOOKOFFICIAL:String = "facebookofficial";
		public static const FAST_BACKWARD:String = "fast-backward";
		public static const FAST_FORWARD:String = "fast-forward";
		public static const FAX:String = "fax";
		public static const FEMALE:String = "female";
		public static const FIGHTER_JET:String = "fighter-jet";
		public static const FILE_ARCHIVE:String = "file-archive";
		public static const FILE_AUDIO:String = "file-audio";
		public static const FILE_CODE:String = "file-code";
		public static const FILE_EXCEL:String = "file-excel";
		public static const FILE_IMAGE:String = "file-image";
		public static const FILE_PDF:String = "file-pdf";
		public static const FILE_POWERPOINT:String = "file-powerpoint";
		public static const FILE_TEXT:String = "file-text";
		public static const FILE_VIDEO:String = "file-video";
		public static const FILE_WORD:String = "file-word";
		public static const FILE:String = "file";
		public static const FILES:String = "files";
		public static const FILM:String = "film";
		public static const FILTER:String = "filter";
		public static const FINGERPRINT:String = "fingerprint";
		public static const FIRE_EXTINGUISHER:String = "fire-extinguisher";
		public static const FIRE:String = "fire";
		public static const FIREFOX:String = "firefox";
		public static const FIRSTRDER:String = "firstrder";
		public static const FLAG_CHECKERED:String = "flag-checkered";
		public static const FLAG:String = "flag";
		public static const FLASK:String = "flask";
		public static const FLICKR:String = "flickr";
		public static const FLOPPY:String = "floppy";
		public static const FOLDER:String = "folder";
		public static const FOLDERPEN:String = "folderpen";
		public static const FONT_AWESOME:String = "font-awesome";
		public static const FONT:String = "font";
		public static const FONTICONS:String = "fonticons";
		public static const FORT_AWESOME:String = "fort-awesome";
		public static const FORUMBEE:String = "forumbee";
		public static const FORWARD:String = "forward";
		public static const FOURSQUARE:String = "foursquare";
		public static const FREE_CODE_CAMP:String = "free-code-camp";
		public static const FROWN:String = "frown";
		public static const FUTBOL:String = "futbol";
		public static const GAMEPAD:String = "gamepad";
		public static const GAVEL:String = "gavel";
		public static const GBP:String = "gbp";
		public static const GENDERLESS:String = "genderless";
		public static const GET_POCKET:String = "get-pocket";
		public static const GG_CIRCLE:String = "gg-circle";
		public static const GG:String = "gg";
		public static const GIFT:String = "gift";
		public static const GIT_SQUARE:String = "git-square";
		public static const GIT:String = "git";
		public static const GITHUB_ALT:String = "github-alt";
		public static const GITHUB_SQUARE:String = "github-square";
		public static const GITHUB:String = "github";
		public static const GITLAB:String = "gitlab";
		public static const GLASS:String = "glass";
		public static const GLIDE_G:String = "glide-g";
		public static const GLIDE:String = "glide";
		public static const GLOBE:String = "globe";
		public static const GOOGLE_PLUS_SQUARE:String = "google-plus-square";
		public static const GOOGLE_PLUS:String = "google-plus";
		public static const GOOGLE_PLUSOFFICIAL:String = "google-plusofficial";
		public static const GOOGLE_WALLET:String = "google-wallet";
		public static const GOOGLE:String = "google";
		public static const GRADUATION_CAP:String = "graduation-cap";
		public static const GRATIPAY:String = "gratipay";
		public static const GRAV:String = "grav";
		public static const H_SQUARE:String = "h-square";
		public static const HACKER_NEWS:String = "hacker-news";
		public static const HAND_DOWN:String = "hand-down";
		public static const HAND_LEFT:String = "hand-left";
		public static const HAND_LIZARD:String = "hand-lizard";
		public static const HAND_PAPER:String = "hand-paper";
		public static const HAND_PEACE:String = "hand-peace";
		public static const HAND_POINTER:String = "hand-pointer";
		public static const HAND_RIGHT:String = "hand-right";
		public static const HAND_ROCK:String = "hand-rock";
		public static const HAND_SCISSORS:String = "hand-scissors";
		public static const HAND_SPOCK:String = "hand-spock";
		public static const HAND_UP:String = "hand-up";
		public static const HANDSHAKE:String = "handshake";
		public static const HASHTAG:String = "hashtag";
		public static const HDD:String = "hdd";
		public static const HEADER:String = "header";
		public static const HEADPHONES:String = "headphones";
		public static const HEART:String = "heart";
		public static const HEARTBEAT:String = "heartbeat";
		public static const HISTORY:String = "history";
		public static const HOME:String = "home";
		public static const HOSPITAL:String = "hospital";
		public static const HOURGLASS_END:String = "hourglass-end";
		public static const HOURGLASS_HALF:String = "hourglass-half";
		public static const HOURGLASS_START:String = "hourglass-start";
		public static const HOURGLASS:String = "hourglass";
		public static const HOUZZ:String = "houzz";
		public static const HTML5:String = "html5";
		public static const I_CURSOR:String = "i-cursor";
		public static const ID_BADGE:String = "id-badge";
		public static const ID_CARD:String = "id-card";
		public static const ILS:String = "ils";
		public static const IMDB:String = "imdb";
		public static const INBOX:String = "inbox";
		public static const INDENT:String = "indent";
		public static const INDUSTRY:String = "industry";
		public static const INFO_CIRCLE:String = "info-circle";
		public static const INFO:String = "info";
		public static const INR:String = "inr";
		public static const INSTAGRAM:String = "instagram";
		public static const INTERNET_EXPLORER:String = "internet-explorer";
		public static const IOXHOST:String = "ioxhost";
		public static const ITALIC:String = "italic";
		public static const JOOMLA:String = "joomla";
		public static const JPY:String = "jpy";
		public static const JSFIDDLE:String = "jsfiddle";
		public static const KEY:String = "key";
		public static const KEYBOARD:String = "keyboard";
		public static const KRW:String = "krw";
		public static const LANGUAGE:String = "language";
		public static const LAPTOP:String = "laptop";
		public static const LASTFM_SQUARE:String = "lastfm-square";
		public static const LASTFM:String = "lastfm";
		public static const LEAF:String = "leaf";
		public static const LEANPUB:String = "leanpub";
		public static const LEMON:String = "lemon";
		public static const LEVEL_DOWN:String = "level-down";
		public static const LEVEL_UP:String = "level-up";
		public static const LIFE_RING:String = "life-ring";
		public static const LIGHTBULB:String = "lightbulb";
		public static const LINE_CHART:String = "line-chart";
		public static const LINK:String = "link";
		public static const LINKEDIN_SQUARE:String = "linkedin-square";
		public static const LINKEDIN:String = "linkedin";
		public static const LINODE:String = "linode";
		public static const LINUX:String = "linux";
		public static const LIST_ALT:String = "list-alt";
		public static const LIST_UL:String = "list-ul";
		public static const LIST:String = "list";
		public static const LISTL:String = "listl";
		public static const LOCATION_ARROW:String = "location-arrow";
		public static const LOCK:String = "lock";
		public static const LONG_ARROW_DOWN:String = "long-arrow-down";
		public static const LONG_ARROW_LEFT:String = "long-arrow-left";
		public static const LONG_ARROW_RIGHT:String = "long-arrow-right";
		public static const LONG_ARROW_UP:String = "long-arrow-up";
		public static const LOW_VISION:String = "low-vision";
		public static const MAGIC:String = "magic";
		public static const MAGNET:String = "magnet";
		public static const MALE:String = "male";
		public static const MAP_MARKER:String = "map-marker";
		public static const MAP_PIN:String = "map-pin";
		public static const MAP_SIGNS:String = "map-signs";
		public static const MAP:String = "map";
		public static const MARS_DOUBLE:String = "mars-double";
		public static const MARS_STROKE_H:String = "mars-stroke-h";
		public static const MARS_STROKE_V:String = "mars-stroke-v";
		public static const MARS_STROKE:String = "mars-stroke";
		public static const MARS:String = "mars";
		public static const MAXCDN:String = "maxcdn";
		public static const MEANPATH:String = "meanpath";
		public static const MEDIUM:String = "medium";
		public static const MEDKIT:String = "medkit";
		public static const MEETUP:String = "meetup";
		public static const MEH:String = "meh";
		public static const MERCURY:String = "mercury";
		public static const MICROCHIP:String = "microchip";
		public static const MICROPHONE_SLASH:String = "microphone-slash";
		public static const MICROPHONE:String = "microphone";
		public static const MINUS_CIRCLE:String = "minus-circle";
		public static const MINUS_SQUARE:String = "minus-square";
		public static const MINUS:String = "minus";
		public static const MIXCLOUD:String = "mixcloud";
		public static const MOBILE:String = "mobile";
		public static const MODX:String = "modx";
		public static const MONEY:String = "money";
		public static const MOON:String = "moon";
		public static const MOTORCYCLE:String = "motorcycle";
		public static const MOUSE_POINTER:String = "mouse-pointer";
		public static const MUSIC:String = "music";
		public static const NEUTER:String = "neuter";
		public static const NEWSPAPER:String = "newspaper";
		public static const OBJECT_GROUP:String = "object-group";
		public static const OBJECT_UNGROUP:String = "object-ungroup";
		public static const ODNOKLASSNIKI_SQUARE:String = "odnoklassniki-square";
		public static const ODNOKLASSNIKI:String = "odnoklassniki";
		public static const OPENCART:String = "opencart";
		public static const OPENID:String = "openid";
		public static const OPERA:String = "opera";
		public static const OPTIN_MONSTER:String = "optin-monster";
		public static const OUTDENT:String = "outdent";
		public static const PAGELINES:String = "pagelines";
		public static const PAINT_BRUSH:String = "paint-brush";
		public static const PAPER_PLANE:String = "paper-plane";
		public static const PAPERCLIP:String = "paperclip";
		public static const PARAGRAPH:String = "paragraph";
		public static const PAUSE_CIRCLE:String = "pause-circle";
		public static const PAUSE:String = "pause";
		public static const PAW:String = "paw";
		public static const PAYPAL:String = "paypal";
		public static const PENCIL_SQUARE:String = "pencil-square";
		public static const PENCIL:String = "pencil";
		public static const PERCENT:String = "percent";
		public static const PHONE_SQUARE:String = "phone-square";
		public static const PHONE:String = "phone";
		public static const PICTURE:String = "picture";
		public static const PIE_CHART:String = "pie-chart";
		public static const PIED_PIPER_ALT:String = "pied-piper-alt";
		public static const PIED_PIPER_PP:String = "pied-piper-pp";
		public static const PIED_PIPER:String = "pied-piper";
		public static const PINTEREST_P:String = "pinterest-p";
		public static const PINTEREST_SQUARE:String = "pinterest-square";
		public static const PINTEREST:String = "pinterest";
		public static const PLANE:String = "plane";
		public static const PLAY_CIRCLE:String = "play-circle";
		public static const PLAY:String = "play";
		public static const PLUG:String = "plug";
		public static const PLUS_CIRCLE:String = "plus-circle";
		public static const PLUS_SQUARE:String = "plus-square";
		public static const PLUS:String = "plus";
		public static const PODCAST:String = "podcast";
		public static const POWER_OFF:String = "power-off";
		public static const PRINT:String = "print";
		public static const PRODUCT_HUNT:String = "product-hunt";
		public static const PUMP_SOAP:String = "pump-soap";
		public static const PUZZLE_PIECE:String = "puzzle-piece";
		public static const QQ:String = "qq";
		public static const QRCODE:String = "qrcode";
		public static const QUESTION_CIRCLE:String = "question-circle";
		public static const QUESTION:String = "question";
		public static const QUORA:String = "quora";
		public static const QUOTE_LEFT:String = "quote-left";
		public static const QUOTE_RIGHT:String = "quote-right";
		public static const RANDOM:String = "random";
		public static const RAVELRY:String = "ravelry";
		public static const REBEL:String = "rebel";
		public static const RECYCLE:String = "recycle";
		public static const REDDIT_ALIEN:String = "reddit-alien";
		public static const REDDIT_SQUARE:String = "reddit-square";
		public static const REDDIT:String = "reddit";
		public static const REFRESH:String = "refresh";
		public static const REGISTERED:String = "registered";
		public static const RENREN:String = "renren";
		public static const REPEAT:String = "repeat";
		public static const REPLY_ALL:String = "reply-all";
		public static const REPLY:String = "reply";
		public static const RETWEET:String = "retweet";
		public static const ROAD:String = "road";
		public static const ROCKET:String = "rocket";
		public static const RSS_SQUARE:String = "rss-square";
		public static const RSS:String = "rss";
		public static const RUB:String = "rub";
		public static const SAFARI:String = "safari";
		public static const SCISSORS:String = "scissors";
		public static const SCRIBD:String = "scribd";
		public static const SEARCH_MINUS:String = "search-minus";
		public static const SEARCH_PLUS:String = "search-plus";
		public static const SEARCH:String = "search";
		public static const SELLSY:String = "sellsy";
		public static const SERVER:String = "server";
		public static const SHARE_ALT_SQUARE:String = "share-alt-square";
		public static const SHARE_ALT:String = "share-alt";
		public static const SHARE_SQUARE:String = "share-square";
		public static const SHARE:String = "share";
		public static const SHIELD:String = "shield";
		public static const SHIP:String = "ship";
		public static const SHIRTSINBULK:String = "shirtsinbulk";
		public static const SHOPPING_BAG:String = "shopping-bag";
		public static const SHOPPING_BASKET:String = "shopping-basket";
		public static const SHOPPING_CART:String = "shopping-cart";
		public static const SHOWER:String = "shower";
		public static const SIGN_IN:String = "sign-in";
		public static const SIGN_LANGUAGE:String = "sign-language";
		public static const SIGNAL:String = "signal";
		public static const SIGNUT:String = "signut";
		public static const SIMPLYBUILT:String = "simplybuilt";
		public static const SITEMAP:String = "sitemap";
		public static const SKYATLAS:String = "skyatlas";
		public static const SKYPE:String = "skype";
		public static const SLACK:String = "slack";
		public static const SLIDERS:String = "sliders";
		public static const SLIDESHARE:String = "slideshare";
		public static const SMILE:String = "smile";
		public static const SNAPCHAT_GHOST:String = "snapchat-ghost";
		public static const SNAPCHAT_SQUARE:String = "snapchat-square";
		public static const SNAPCHAT:String = "snapchat";
		public static const SNOWFLAKE:String = "snowflake";
		public static const SORT_ALPHA_ASC:String = "sort-alpha-asc";
		public static const SORT_ALPHA_DESC:String = "sort-alpha-desc";
		public static const SORT_AMOUNT_ASC:String = "sort-amount-asc";
		public static const SORT_AMOUNT_DESC:String = "sort-amount-desc";
		public static const SORT_ASC:String = "sort-asc";
		public static const SORT_DESC:String = "sort-desc";
		public static const SORT_NUMERIC_ASC:String = "sort-numeric-asc";
		public static const SORT_NUMERIC_DESC:String = "sort-numeric-desc";
		public static const SORT:String = "sort";
		public static const SOUNDCLOUD:String = "soundcloud";
		public static const SPACE_SHUTTLE:String = "space-shuttle";
		public static const SPINNER:String = "spinner";
		public static const SPOON:String = "spoon";
		public static const SPOTIFY:String = "spotify";
		public static const SQUARE:String = "square";
		public static const STACK_EXCHANGE:String = "stack-exchange";
		public static const STACKVERFLOW:String = "stackverflow";
		public static const STAR_HALF:String = "star-half";
		public static const STAR:String = "star";
		public static const STEAM_SQUARE:String = "steam-square";
		public static const STEAM:String = "steam";
		public static const STEP_BACKWARD:String = "step-backward";
		public static const STEP_FORWARD:String = "step-forward";
		public static const STETHOSCOPE:String = "stethoscope";
		public static const STICKY_NOTE:String = "sticky-note";
		public static const STOP_CIRCLE:String = "stop-circle";
		public static const STOP:String = "stop";
		public static const STREET_VIEW:String = "street-view";
		public static const STRIKETHROUGH:String = "strikethrough";
		public static const STUMBLEUPON_CIRCLE:String = "stumbleupon-circle";
		public static const STUMBLEUPON:String = "stumbleupon";
		public static const SUBSCRIPT:String = "subscript";
		public static const SUBWAY:String = "subway";
		public static const SUITCASE:String = "suitcase";
		public static const SUN:String = "sun";
		public static const SUPERPOWERS:String = "superpowers";
		public static const SUPERSCRIPT:String = "superscript";
		public static const TABLE:String = "table";
		public static const TABLET:String = "tablet";
		public static const TACHOMETER:String = "tachometer";
		public static const TAG:String = "tag";
		public static const TAGS:String = "tags";
		public static const TASKS:String = "tasks";
		public static const TAXI:String = "taxi";
		public static const TELEGRAM:String = "telegram";
		public static const TELEVISION:String = "television";
		public static const TENCENT_WEIBO:String = "tencent-weibo";
		public static const TERMINAL:String = "terminal";
		public static const TEXT_HEIGHT:String = "text-height";
		public static const TEXT_WIDTH:String = "text-width";
		public static const TH_LARGE:String = "th-large";
		public static const TH_LIST:String = "th-list";
		public static const TH:String = "th";
		public static const THEMEISLE:String = "themeisle";
		public static const THERMOMETER_EMPTY:String = "thermometer-empty";
		public static const THERMOMETER_FULL:String = "thermometer-full";
		public static const THERMOMETER_HALF:String = "thermometer-half";
		public static const THERMOMETER_QUARTER:String = "thermometer-quarter";
		public static const THERMOMETER_THREE_QUARTERS:String = "thermometer-three-quarters";
		public static const THUMB_TACK:String = "thumb-tack";
		public static const THUMBS_DOWN:String = "thumbs-down";
		public static const THUMBS_UP:String = "thumbs-up";
		public static const TICKET:String = "ticket";
		public static const TIMES_CIRCLE:String = "times-circle";
		public static const TIMES:String = "times";
		public static const TINT:String = "tint";
		public static const TOGGLE_OFF:String = "toggle-off";
		public static const TOGGLE_ON:String = "toggle-on";
		public static const TRADEMARK:String = "trademark";
		public static const TRAIN:String = "train";
		public static const TRANSGENDER_ALT:String = "transgender-alt";
		public static const TRANSGENDER:String = "transgender";
		public static const TRASH:String = "trash";
		public static const TREE:String = "tree";
		public static const TRELLO:String = "trello";
		public static const TRIPADVISOR:String = "tripadvisor";
		public static const TROPHY:String = "trophy";
		public static const TRUCK:String = "truck";
		public static const TRY:String = "try";
		public static const TTY:String = "tty";
		public static const TUMBLR_SQUARE:String = "tumblr-square";
		public static const TUMBLR:String = "tumblr";
		public static const TWITCH:String = "twitch";
		public static const TWITTER_SQUARE:String = "twitter-square";
		public static const TWITTER:String = "twitter";
		public static const UMBRELLA:String = "umbrella";
		public static const UNDERLINE:String = "underline";
		public static const UNDO:String = "undo";
		public static const UNIVERSAL_ACCESS:String = "universal-access";
		public static const UNIVERSITY:String = "university";
		public static const UNLOCK_ALT:String = "unlock-alt";
		public static const UNLOCK:String = "unlock";
		public static const UPLOAD:String = "upload";
		public static const USB:String = "usb";
		public static const USD:String = "usd";
		public static const USER_CIRCLE:String = "user-circle";
		public static const USER_CLOCK:String = "user-clock";
		public static const USER_MD:String = "user-md";
		public static const USER_PLUS:String = "user-plus";
		public static const USER_SECRET:String = "user-secret";
		public static const USER_TIMES:String = "user-times";
		public static const USER:String = "user";
		public static const USERS:String = "users";
		public static const VENUS_DOUBLE:String = "venus-double";
		public static const VENUS_MARS:String = "venus-mars";
		public static const VENUS:String = "venus";
		public static const VIACOIN:String = "viacoin";
		public static const VIADEO_SQUARE:String = "viadeo-square";
		public static const VIADEO:String = "viadeo";
		public static const VIDEO_CAMERA:String = "video-camera";
		public static const VIMEO_SQUARE:String = "vimeo-square";
		public static const VIMEO:String = "vimeo";
		public static const VINE:String = "vine";
		public static const VIRUS_SLASH:String = "virus-slash";
		public static const VIRUS:String = "virus";
		public static const VIRUSES:String = "viruses";
		public static const VK:String = "vk";
		public static const VOLUME_CONTROL_PHONE:String = "volume-control-phone";
		public static const VOLUME_DOWN:String = "volume-down";
		public static const VOLUME_UP:String = "volume-up";
		public static const VOLUME_OFF:String = "volume-off";
		public static const WEIBO:String = "weibo";
		public static const WEIXIN:String = "weixin";
		public static const WHATSAPP:String = "whatsapp";
		public static const WHEELCHAIR_ALT:String = "wheelchair-alt";
		public static const WHEELCHAIR:String = "wheelchair";
		public static const WIFI:String = "wifi";
		public static const WIKIPEDIA_W:String = "wikipedia-w";
		public static const WINDOW_CLOSE:String = "window-close";
		public static const WINDOW_MAXIMIZE:String = "window-maximize";
		public static const WINDOW_MINIMIZE:String = "window-minimize";
		public static const WINDOW_RESTORE:String = "window-restore";
		public static const WINDOWS:String = "windows";
		public static const WORDPRESS:String = "wordpress";
		public static const WPBEGINNER:String = "wpbeginner";
		public static const WPEXPLORER:String = "wpexplorer";
		public static const WPFORMS:String = "wpforms";
		public static const WRENCH:String = "wrench";
		public static const XING_SQUARE:String = "xing-square";
		public static const XING:String = "xing";
		public static const Y_COMBINATOR:String = "y-combinator";
		public static const YAHOO:String = "yahoo";
		public static const YELP:String = "yelp";
		public static const YOAST:String = "yoast";
		public static const YOUTUBE_PLAY:String = "youtube-play";
		public static const YOUTUBE_SQUARE:String = "youtube-square";
		public static const YOUTUBE:String = "youtube";
        public static const HAND_HOLDING_MEDICAL:String = "hand-holding-medical";
        public static const HAND_SPARKLES:String = "hand-sparkles";
        public static const HANDS_WASH:String = "hands-wash";
        public static const HANDSHAKE_ALT_SLASH:String = "handshake-alt-slash";
        public static const HANDSHAKE_SLASH:String = "handshake-slash";
        public static const HEAD_SIDE_COUGH_SLASH:String = "head-side-cough-slash";
        public static const HEAD_SIDE_COUGH:String = "head-side-cough";
        public static const HEAD_SIDE_MASK:String = "head-side-mask";
        public static const HEAD_SIDE_VIRUS:String = "head-side-virus";
        public static const HOUSE_USER:String = "house-user";
        public static const LAPTOP_HOUSE:String = "laptop-house";
        public static const LUNGS_VIRUS:String = "lungs-virus";
        public static const PEOPLE_VIRUS:String = "people-arrows";
        public static const PLANE_SLASH:String = "plane-slash";
        public static const PUMP_MEDICAL:String = "pump-medical";
        public static const SHIELD_VIRUS:String = "shield-virus";
        public static const SHINK:String = "shink";
        public static const SOAP:String = "soap";
        public static const STOPWATCH_20:String = "stopwatch-20";
        public static const STORE_ALT_SLASH:String = "store-alt-slash";
        public static const STORE_SLASH:String = "store-slash";
        public static const TOILET_PAPEL_SLASH:String = "toilet-paper-slash";
        public static const USERS_SLASH:String = "users-slash";

    }
}