<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

# Apache Royale TodoMVC Example (Crux version)

> Apache Royale™ is a productive, open-source frontend application technology that lets you code in MXML & AS3 and output to different formats, included Javascript and SWF.

> _[Apache Royale™ Website](https://royale.apache.org)_


## Learning Apache Royale

The [Apache Royale getting started documentation](https://apache.github.io/royale-docs/get-started) is a great way to get started.

Here are some links you may find helpful:

* [Documentation](https://apache.github.io/royale-docs)
* [API Reference](https://royale.apache.org/asdoc)
* [Blog](https://royale.apache.org/blog)
* [Apache Royale on GitHub](https://github.com/apache/royale-asjs/wiki/Apache-Royale-Source-Code-Repositories)
* [Support (Dev Mailing List)](https://royale.apache.org/mailing-lists)
* [FAQ](https://royale.apache.org/faq/)
* [Get Involved](https://royale.apache.org/get-involved)

Crux is a microframework for Inversion of Control (IoC), Dependency Injection (DI) and event handling with metadata.

* [Crux in Apache Royale Docs](https://apache.github.io/royale-docs/libraries/crux)

Articles and guides from the community:

* [Royale Examples](https://royale.apache.org/category/royale-examples)

Apache Royale social media:

* [Twitter](https://twitter.com/apacheroyale)
* [Facebook](https://facebook.com/ApacheRoyaleSDK/)
* [LinkedIn](https://www.linkedin.com/groups/12118437)

Get help from other Apache Royale users:

* [Apache Royale on StackOverflow](https://stackoverflow.com/questions/tagged/apache-royale)
* [Discussion Forum (User Mailing List)](https://royale.apache.org/mailing-lists)

_If you have other helpful links to share, or find any of the links above no longer work, please [let us know](https://github.com/apache/royale-asjs/issues)._


## Running

The app is built upon [AS3](https://apache.github.io/royale-docs/features/as3) and [MXML](https://apache.github.io/royale-docs/features/mxml) languages and compiled with the Apache Royale Compiler.
We use [Maven](https://maven.apache.org) and [ANT](https://ant.apache.org) to build the project.

To run the app, go to the generated code and run `index.html` or visit [https://royale.apache.org/todomvc-jewel].
