/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.problems.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.royale.compiler.clients.problems.IProblemFilter;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredIterator
implements Iterator<ICompilerProblem> {
    IProblemFilter filter;
    Iterator<ICompilerProblem> underlyingProblems;
    ICompilerProblem currentProblem = null;

    public FilteredIterator(Iterator<ICompilerProblem> problems, IProblemFilter filter) {
        this.filter = filter;
        this.underlyingProblems = problems;
        this.currentProblem = null;
    }

    @Override
    public boolean hasNext() {
        return this.findNext();
    }

    @Override
    public ICompilerProblem next() {
        if (!this.findNext()) {
            throw new NoSuchElementException();
        }
        ICompilerProblem result = this.currentProblem;
        this.currentProblem = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean findNext() {
        while (this.currentProblem == null && this.underlyingProblems.hasNext()) {
            ICompilerProblem candidate = this.underlyingProblems.next();
            if (!this.filter.accept(candidate)) continue;
            this.currentProblem = candidate;
        }
        return this.currentProblem != null;
    }

    public static Iterable<ICompilerProblem> getFilteredIterable(final Collection<ICompilerProblem> problems, final IProblemFilter filter) {
        return new Iterable<ICompilerProblem>(){

            @Override
            public Iterator<ICompilerProblem> iterator() {
                return new FilteredIterator(problems.iterator(), filter);
            }
        };
    }
}

