/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients.problems;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.royale.compiler.Messages;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemFormatter {
    public static ProblemFormatter DEFAULT_FORMATTER = new ProblemFormatter();

    public String format(ICompilerProblem problem) {
        Class<?> c = problem.getClass();
        String problemMessage = this.getMessage(c.getSimpleName());
        if (problemMessage == null) {
            try {
                Field descriptionField = c.getDeclaredField("DESCRIPTION");
                problemMessage = (String)descriptionField.get(null);
            }
            catch (Exception e) {
                return '!' + c.getSimpleName() + '!';
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (c != Object.class) {
            for (Field field : c.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
                try {
                    Object value = field.get(problem);
                    if (value == null) continue;
                    map.put(field.getName(), value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            c = c.getSuperclass();
        }
        return ProblemFormatter.substitute(problemMessage, map);
    }

    public static String substitute(String text, Map<String, Object> parameters) {
        for (String key : parameters.keySet()) {
            String value = parameters.get(key).toString();
            if (value == null) continue;
            value = Matcher.quoteReplacement(value);
            text = text.replaceAll("[$][{]" + key + "[}]", value);
        }
        return text;
    }

    protected String getMessage(String key) {
        return Messages.getString(key);
    }
}

