/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.typedefs.reference;

import com.google.common.collect.Lists;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.clients.ExternCConfiguration;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ClassReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.MemberReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ParameterReference;
import org.apache.royale.compiler.internal.codegen.typedefs.reference.ReferenceModel;
import org.apache.royale.compiler.internal.codegen.typedefs.utils.FunctionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodReference
extends MemberReference {
    private boolean isStatic;
    private MethodReference override;
    private Node paramNode;
    private List<ParameterReference> parameters;

    private MethodReference getContext() {
        return this.override == null ? this : this.override;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public List<ParameterReference> getParameters() {
        return this.parameters;
    }

    public Set<String> getParameterNames() {
        return this.getComment().getParameterNames();
    }

    public String toReturnTypeAnnotationString() {
        JSType jsType = this.getModel().evaluate(this.getComment().getReturnType());
        return jsType.toAnnotationString(JSType.Nullability.EXPLICIT);
    }

    public MethodReference(ReferenceModel model, ClassReference classReference, Node node, String name, JSDocInfo comment, boolean isStatic) {
        super(model, classReference, node, name, comment);
        this.isStatic = isStatic;
        if (node.isFunction()) {
            this.paramNode = node.getChildAtIndex(1);
        } else if (node.getLastChild().isFunction()) {
            this.paramNode = node.getLastChild().getChildAtIndex(1);
        }
        this.addParameterReferences();
    }

    private void addParameterReferences() {
        this.parameters = new ArrayList<ParameterReference>();
        if (this.paramNode != null) {
            boolean isDocumented = this.comment.getParameterCount() > 0;
            ArrayList parameterNames = null;
            if (isDocumented) {
                parameterNames = Lists.newArrayList((Iterable)this.comment.getParameterNames());
            }
            for (Node param : this.paramNode.children()) {
                ParameterReference parameterReference;
                if (parameterNames != null && parameterNames.contains(param.getString())) {
                    String qualifiedName = FunctionUtils.toParameterType(this, param.getString());
                    parameterReference = new ParameterReference(this.getModel(), param, qualifiedName);
                } else {
                    parameterReference = new ParameterReference(this.getModel(), param);
                }
                this.parameters.add(parameterReference);
            }
        } else if (this.comment.getParameterCount() > 0 || this.comment.getReturnType() != null) {
            for (int i = 0; i < this.comment.getParameterCount(); ++i) {
                String parameterName = this.comment.getParameterNameAt(i);
                String qualifiedName = FunctionUtils.toParameterType(this, parameterName);
                ParameterReference parameterReference = new ParameterReference(this.getModel(), parameterName, qualifiedName);
                this.parameters.add(parameterReference);
            }
        } else {
            System.out.println(this.getQualifiedName() + " parameters not found!  " + this.comment.getParameterCount());
        }
    }

    @Override
    public void emit(StringBuilder sb) {
        String className = this.getClassReference().getBaseName();
        if (this.getComment().isConstructor() && !this.getBaseName().equals(className)) {
            return;
        }
        if (this.isConstructor()) {
            this.emitConstructor(sb);
            return;
        }
        String qName = this.getQualifiedName();
        if (this.getClassReference().hasSuperMethod(qName)) {
            return;
        }
        this.emitComment(sb);
        ExternCConfiguration.ExcludedMember excluded = this.isExcluded();
        if (excluded != null) {
            excluded.print(sb);
        }
        this.emitCode(sb);
        this.override = null;
    }

    public void emitCode(StringBuilder sb) {
        MethodReference overrideFromInterface;
        String staticValue;
        String string = staticValue = this.isStatic ? "static " : "";
        if (this.getClassReference().isInterface()) {
            staticValue = "";
        }
        String isOverride = "";
        if (!this.getClassReference().isInterface() && (overrideFromInterface = this.getClassReference().getMethodOverrideFromInterface(this)) != null) {
            this.override = overrideFromInterface;
        }
        String qName = this.getQualifiedName();
        String publicModifier = "";
        String braces = "";
        String returns = "";
        String returnString = this.transformReturnString();
        if (!returnString.equals("void")) {
            returns = returnString.equals("Number") ? "return 0;" : (returnString.equals("String") ? "return '';" : " return null;");
        }
        if (!this.getClassReference().isInterface()) {
            publicModifier = "public ";
            braces = " { " + returns + " }";
        }
        if (this.getClassReference().hasSuperMethod(qName)) {
            isOverride = "override ";
        }
        if (this.outputJS) {
            sb.append(this.getClassReference().getPackageName());
            sb.append(".");
            sb.append(this.getClassReference().getBaseName());
            sb.append(".");
            if (!this.isStatic) {
                sb.append("prototype.");
            }
            sb.append(qName);
            sb.append(" = function ");
            sb.append(this.toParameterString());
            sb.append(braces);
            sb.append("\n");
            return;
        }
        sb.append(this.indent);
        sb.append(publicModifier);
        sb.append(isOverride);
        sb.append(staticValue);
        sb.append("function ");
        sb.append(this.getQualifiedName());
        sb.append(this.toParameterString());
        sb.append(":");
        sb.append(this.transformReturnString());
        sb.append(braces);
        sb.append("\n");
    }

    private void emitConstructor(StringBuilder sb) {
        if (!this.outputJS) {
            this.emitComment(sb);
        }
        if (this.outputJS) {
            sb.append(this.getClassReference().getPackageName());
            sb.append(".");
            sb.append(this.getBaseName());
            sb.append(" = function ");
            sb.append(this.toParameterString());
            sb.append(" {}\n");
            return;
        }
        sb.append(this.indent);
        sb.append("public function ");
        sb.append(this.getBaseName());
        if (!this.getBaseName().equals("Object")) {
            sb.append(this.toParameterString());
            sb.append(" {\n");
            sb.append(this.indent);
            this.emitSuperCall(sb);
            sb.append(this.indent);
            sb.append("}");
        } else {
            sb.append("() {}");
        }
        sb.append("\n");
    }

    private void emitSuperCall(StringBuilder sb) {
        sb.append(this.indent);
        sb.append("super(");
        ClassReference superClass = this.getClassReference().getSuperClass();
        if (superClass != null && !superClass.getBaseName().equals("Object")) {
            MethodReference constructor = superClass.getConstructor();
            Set<String> parameterNames = constructor.getParameterNames();
            int len = parameterNames.size();
            for (int i = 0; i < len; ++i) {
                sb.append("null");
                if (i >= len - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(");\n");
    }

    public boolean isConstructor() {
        return this.getComment().isConstructor();
    }

    public String transformReturnString() {
        return FunctionUtils.toReturnString(this.getContext());
    }

    private String toParameterString() {
        if (this.paramNode != null) {
            return FunctionUtils.toParameterString(this.getContext(), this.getContext().getComment(), this.paramNode, this.outputJS);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int len = this.comment.getParameterCount();
        for (int i = 0; i < len; ++i) {
            String parameterName = this.comment.getParameterNameAt(i);
            JSTypeExpression parameterType = this.comment.getParameterType(parameterName);
            sb.append(FunctionUtils.toParameter(this.getContext(), this.comment, parameterName, parameterType, this.outputJS));
            if (i >= len - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean isOverride() {
        return this.getComment().isOverride();
    }

    @Override
    protected void emitCommentBody(StringBuilder sb) {
        this.emitFunctionCommentBody(sb);
    }
}

