/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.tasks.configuration;

import java.io.File;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.tasks.configuration.StepConfiguration;
import org.apache.royale.test.ant.tasks.types.LibraryPaths;
import org.apache.royale.test.ant.tasks.types.LoadConfig;
import org.apache.royale.test.ant.tasks.types.SourcePaths;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class CompilationConfiguration
implements StepConfiguration {
    private SourcePaths sources = new SourcePaths();
    private SourcePaths testSources = new SourcePaths();
    private LibraryPaths libraries = new LibraryPaths();
    private File royaleHome;
    private String player;
    private File workingDir;
    private boolean debug = false;
    private LoadConfig loadConfig;

    public File getRoyaleHome() {
        return this.royaleHome;
    }

    public void setRoyaleHome(File royaleHome) {
        this.royaleHome = royaleHome;
    }

    public void addLibrary(FileSet fileset) {
        this.libraries.add(fileset);
    }

    public LibraryPaths getLibraries() {
        return this.libraries;
    }

    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String player) {
        this.player = player;
    }

    public void addSource(FileSet fileset) {
        this.sources.add(fileset);
    }

    public SourcePaths getSources() {
        return this.sources;
    }

    public void addTestSource(FileSet fileset) {
        this.testSources.add(fileset);
    }

    public SourcePaths getTestSources() {
        return this.testSources;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void validate() throws BuildException {
        if (!this.testSources.exists()) {
            throw new BuildException("One of the directories specified as a 'testSource' element does not exist.");
        }
        if (this.testSources.exists() && this.testSources.isEmpty()) {
            throw new BuildException("No test files could be found for the provided 'testSource' elements.");
        }
        if (!this.libraries.exists()) {
            throw new BuildException("One of the directories specified as a 'library' element does not exist.");
        }
        if (this.libraries.exists() && this.libraries.isEmpty() && this.loadConfig == null) {
            throw new BuildException("'library' elements not specified or 'load-config' element not specified. Also possible no SWC files could be found for the provided 'library' elements.");
        }
    }

    public void log() {
        LoggingUtil.log("Using the following settings for compilation:");
        LoggingUtil.log("\tROYALE_HOME: [" + this.royaleHome.getAbsolutePath() + "]");
        LoggingUtil.log("\tplayer: [" + this.player + "]");
        LoggingUtil.log("\tsourceDirectories: [" + this.sources.getPathElements(",") + "]");
        LoggingUtil.log("\ttestSourceDirectories: [" + this.testSources.getPathElements(",") + "]");
        LoggingUtil.log("\tlibraries: [" + this.libraries.getPathElements(",") + "]");
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    public void setLoadConfig(LoadConfig loadconfig) {
        this.loadConfig = loadconfig;
    }

    public LoadConfig getLoadConfig() {
        return this.loadConfig;
    }
}

