/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands.player;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.launcher.commands.player.DefaultPlayerCommand;
import org.apache.royale.test.ant.launcher.commands.player.PlayerCommand;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;

public class CustomPlayerCommand
implements PlayerCommand {
    private DefaultPlayerCommand proxiedCommand;
    private File executable;

    public PlayerCommand getProxiedCommand() {
        return this.proxiedCommand;
    }

    public void setProxiedCommand(DefaultPlayerCommand playerCommand) {
        this.proxiedCommand = playerCommand;
    }

    public File getExecutable() {
        return this.executable;
    }

    public void setExecutable(File executable) {
        this.executable = executable;
    }

    public void setProject(Project project) {
        this.proxiedCommand.setProject(project);
    }

    public void setSwf(File swf) {
        this.proxiedCommand.setSwf(swf);
    }

    public String getUrl() {
        return this.proxiedCommand.getUrl();
    }

    public void setUrl(String url) {
        this.proxiedCommand.setUrl(url);
    }

    public File getFileToExecute() {
        return this.proxiedCommand.getFileToExecute();
    }

    public void prepare() {
        this.proxiedCommand.prepare();
        this.proxiedCommand.getCommandLine().setExecutable(this.executable.getAbsolutePath());
        this.proxiedCommand.getCommandLine().clearArgs();
        if (this.getUrl() != null) {
            this.proxiedCommand.getCommandLine().addArguments(new String[]{this.getUrl()});
        } else {
            this.proxiedCommand.getCommandLine().addArguments(new String[]{this.getFileToExecute().getAbsolutePath()});
        }
    }

    public Process launch() throws IOException {
        LoggingUtil.log(this.proxiedCommand.getCommandLine().describeCommand());
        return Runtime.getRuntime().exec(this.proxiedCommand.getCommandLine().getCommandline(), this.getJointEnvironment(), this.proxiedCommand.getProject().getBaseDir());
    }

    public void setEnvironment(String[] variables) {
        this.proxiedCommand.setEnvironment(variables);
    }

    private String[] getJointEnvironment() {
        Vector procEnvironment = Execute.getProcEnvironment();
        String[] environment = new String[procEnvironment.size() + this.proxiedCommand.getEnvironment().length];
        System.arraycopy(procEnvironment.toArray(), 0, environment, 0, procEnvironment.size());
        System.arraycopy(this.proxiedCommand.getEnvironment(), 0, environment, procEnvironment.size(), this.proxiedCommand.getEnvironment().length);
        return environment;
    }
}

