/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GatherGettersAndSetterProperties;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenamePropertiesWithModuleSupport
implements CompilerPass {
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private final AbstractCompiler compiler;
    private final boolean generatePseudoNames;
    private final VariableMap prevUsedPropertyMap;
    private final List<String> prevUsedPropertyOldNames = new ArrayList<String>();
    private final List<Node> toRemove = new ArrayList<Node>();
    private final List<Node> stringNodesToRename = new ArrayList<Node>();
    private final Map<Node, Node> callNodeToParentMap = new LinkedHashMap<Node, Node>();
    private final char[] reservedFirstCharacters;
    private final char[] reservedNonFirstCharacters;
    private final Map<String, Property> propertyMap = new LinkedHashMap<String, Property>();
    private final Set<String> externedNames = new LinkedHashSet<String>(Arrays.asList("prototype"));
    private final Set<String> quotedNames = new LinkedHashSet<String>();
    private final NameGenerator nameGenerator;
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            if (p1.numOccurrences != p2.numOccurrences) {
                return p2.numOccurrences - p1.numOccurrences;
            }
            return p1.oldName.compareTo(p2.oldName);
        }
    };
    static final DiagnosticType BAD_CALL = DiagnosticType.error((String)"JSC_BAD_RENAME_PROPERTY_FUNCTION_NAME_CALL", (String)"Bad {0} call - the first argument must be a string literal");
    static final DiagnosticType BAD_ARG = DiagnosticType.error((String)"JSC_BAD_RENAME_PROPERTY_FUNCTION_NAME_ARG", (String)"Bad {0} argument - ''{1}'' is not a valid JavaScript identifier");

    RenamePropertiesWithModuleSupport(AbstractCompiler compiler, boolean generatePseudoNames, NameGenerator nameGenerator) {
        this(compiler, generatePseudoNames, null, null, null, nameGenerator);
    }

    RenamePropertiesWithModuleSupport(AbstractCompiler compiler, boolean generatePseudoNames, VariableMap prevUsedPropertyMap, NameGenerator nameGenerator) {
        this(compiler, generatePseudoNames, prevUsedPropertyMap, null, null, nameGenerator);
    }

    RenamePropertiesWithModuleSupport(AbstractCompiler compiler, boolean generatePseudoNames, VariableMap prevUsedPropertyMap, @Nullable char[] reservedFirstCharacters, @Nullable char[] reservedNonFirstCharacters, NameGenerator nameGenerator) {
        this.compiler = compiler;
        this.generatePseudoNames = generatePseudoNames;
        this.prevUsedPropertyMap = prevUsedPropertyMap;
        this.reservedFirstCharacters = reservedFirstCharacters;
        this.reservedNonFirstCharacters = reservedNonFirstCharacters;
        this.nameGenerator = nameGenerator;
        this.externedNames.addAll(compiler.getExternProperties());
    }

    public void process(Node externs, Node root) {
        Node parent;
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized());
        if (this.prevUsedPropertyMap != null) {
            this.prevUsedPropertyOldNames.addAll(this.prevUsedPropertyMap.getOriginalNameToNewNameMap().keySet());
        }
        NodeTraversal.traverse((AbstractCompiler)this.compiler, (Node)root, (NodeTraversal.Callback)new ProcessProperties());
        HashSet<String> reservedNames = Sets.newHashSetWithExpectedSize(this.externedNames.size() + this.quotedNames.size());
        TreeSet<Property> propsByFreq = new TreeSet<Property>(FREQUENCY_COMPARATOR);
        propsByFreq.addAll(this.propertyMap.values());
        if (this.prevUsedPropertyMap != null) {
            this.reusePropertyNames(reservedNames, propsByFreq);
        }
        reservedNames.addAll(this.externedNames);
        reservedNames.addAll(this.quotedNames);
        this.generateNames(propsByFreq, reservedNames);
        for (Node node : this.stringNodesToRename) {
            String oldName = node.getString();
            Property p = this.propertyMap.get(oldName);
            if (p == null || p.newName == null) continue;
            Preconditions.checkState(oldName.equals(p.oldName));
            node.setString(p.newName);
            if (p.newName.equals(oldName)) continue;
            this.compiler.reportChangeToEnclosingScope(node);
        }
        for (Map.Entry entry : this.callNodeToParentMap.entrySet()) {
            parent = (Node)entry.getValue();
            Node firstArg = ((Node)entry.getKey()).getSecondChild();
            StringBuilder sb = new StringBuilder();
            for (String oldName : DOT_SPLITTER.split(firstArg.getString())) {
                String replacement;
                Property p = this.propertyMap.get(oldName);
                if (p != null && p.newName != null) {
                    Preconditions.checkState(oldName.equals(p.oldName));
                    replacement = p.newName;
                } else {
                    replacement = oldName;
                }
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(replacement);
            }
            parent.replaceChild((Node)entry.getKey(), IR.string((String)sb.toString()));
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        for (Node node : this.toRemove) {
            parent = node.getParent();
            this.compiler.reportChangeToEnclosingScope(node);
            node.detach();
            NodeUtil.markFunctionsDeleted((Node)node, (AbstractCompiler)this.compiler);
            if (parent.hasChildren() || parent.isScript()) continue;
            parent.detach();
        }
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED_OBFUSCATED);
        GatherGettersAndSetterProperties.update((AbstractCompiler)this.compiler, (Node)externs, (Node)root);
    }

    private void reusePropertyNames(Set<String> reservedNames, Collection<Property> allProps) {
        for (Property prop : allProps) {
            String prevName = this.prevUsedPropertyMap.lookupNewName(prop.oldName);
            if (this.generatePseudoNames || prevName == null || reservedNames.contains(prevName)) continue;
            prop.newName = prevName;
            reservedNames.add(prevName);
        }
    }

    private void generateNames(Set<Property> props, Set<String> reservedNames) {
        this.nameGenerator.reset(reservedNames, "", this.reservedFirstCharacters, this.reservedNonFirstCharacters);
        for (Property p : props) {
            if (this.generatePseudoNames) {
                p.newName = "$" + p.oldName + "$";
            } else if (p.newName == null) {
                p.newName = this.nameGenerator.generateNextName();
            }
            reservedNames.add(p.newName);
        }
    }

    VariableMap getPropertyMap() {
        ImmutableMap.Builder<String, String> map = ImmutableMap.builder();
        for (Property p : this.propertyMap.values()) {
            if (p.newName == null) continue;
            map.put(p.oldName, p.newName);
        }
        return new VariableMap(map.build());
    }

    private static class Property {
        final String oldName;
        String newName;
        int numOccurrences;

        Property(String name) {
            this.oldName = name;
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case COMPUTED_PROP: {
                    break;
                }
                case GETPROP: {
                    Node propNode = n.getSecondChild();
                    if (!propNode.isString()) break;
                    if (RenamePropertiesWithModuleSupport.this.compiler.getCodingConvention().blockRenamingForProperty(propNode.getString())) {
                        RenamePropertiesWithModuleSupport.this.externedNames.add(propNode.getString());
                        break;
                    }
                    this.maybeMarkCandidate(propNode);
                    break;
                }
                case OBJECTLIT: {
                    for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        if (key.isComputedProp()) continue;
                        if (key.isQuotedString()) {
                            RenamePropertiesWithModuleSupport.this.quotedNames.add(key.getString());
                            continue;
                        }
                        if (RenamePropertiesWithModuleSupport.this.compiler.getCodingConvention().blockRenamingForProperty(key.getString())) {
                            RenamePropertiesWithModuleSupport.this.externedNames.add(key.getString());
                            continue;
                        }
                        this.maybeMarkCandidate(key);
                    }
                    break;
                }
                case OBJECT_PATTERN: {
                    for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        if (key.isComputedProp()) continue;
                        if (key.isQuotedString()) {
                            RenamePropertiesWithModuleSupport.this.quotedNames.add(key.getString());
                            continue;
                        }
                        if (RenamePropertiesWithModuleSupport.this.compiler.getCodingConvention().blockRenamingForProperty(key.getString())) {
                            RenamePropertiesWithModuleSupport.this.externedNames.add(key.getString());
                            continue;
                        }
                        this.maybeMarkCandidate(key);
                    }
                    break;
                }
                case GETELEM: {
                    Node child = n.getLastChild();
                    if (child == null || !child.isString()) break;
                    RenamePropertiesWithModuleSupport.this.quotedNames.add(child.getString());
                    break;
                }
                case CALL: {
                    Node fnName = n.getFirstChild();
                    if (!RenamePropertiesWithModuleSupport.this.compiler.getCodingConvention().isPropertyRenameFunction(fnName.getOriginalQualifiedName())) break;
                    RenamePropertiesWithModuleSupport.this.callNodeToParentMap.put(n, parent);
                    this.countCallCandidates(t, n);
                    break;
                }
                case CLASS_MEMBERS: {
                    for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        if (key.isComputedProp()) continue;
                        Node member = key.getFirstChild();
                        String memberDefName = key.getString();
                        if (!member.isFunction()) continue;
                        Node fnName = member.getFirstChild();
                        if (RenamePropertiesWithModuleSupport.this.compiler.getCodingConvention().blockRenamingForProperty(memberDefName)) {
                            RenamePropertiesWithModuleSupport.this.externedNames.add(fnName.getString());
                            continue;
                        }
                        if (memberDefName.equals("constructor") || memberDefName.equals("superClass_")) {
                            RenamePropertiesWithModuleSupport.this.externedNames.add(fnName.getString());
                            continue;
                        }
                        this.maybeMarkCandidate(key);
                    }
                    break;
                }
                case FUNCTION: {
                    Node exprResult;
                    if (NodeUtil.isFunctionDeclaration((Node)n)) {
                        String name = n.getFirstChild().getString();
                        if (!"JSCompiler_renameProperty".equals(name)) break;
                        RenamePropertiesWithModuleSupport.this.toRemove.add(n);
                        break;
                    }
                    if (parent.isName() && "JSCompiler_renameProperty".equals(parent.getString())) {
                        Node varNode = parent.getParent();
                        if (!varNode.isVar()) break;
                        RenamePropertiesWithModuleSupport.this.toRemove.add(parent);
                        break;
                    }
                    if (!NodeUtil.isFunctionExpression((Node)n) || !parent.isAssign() || !parent.getFirstChild().isGetProp() || !RenamePropertiesWithModuleSupport.this.compiler.getCodingConvention().isPropertyRenameFunction(parent.getFirstChild().getOriginalQualifiedName()) || !(exprResult = parent.getParent()).isExprResult() || !NodeUtil.isStatementBlock((Node)exprResult.getParent()) || !exprResult.getFirstChild().isAssign()) break;
                    RenamePropertiesWithModuleSupport.this.toRemove.add(exprResult);
                    break;
                }
            }
        }

        private void maybeMarkCandidate(Node n) {
            String name = n.getString();
            if (!RenamePropertiesWithModuleSupport.this.externedNames.contains(name) || RenamePropertiesWithModuleSupport.this.prevUsedPropertyOldNames.contains(name)) {
                RenamePropertiesWithModuleSupport.this.stringNodesToRename.add(n);
                this.countPropertyOccurrence(name);
            }
        }

        private void countCallCandidates(NodeTraversal t, Node callNode) {
            Node firstArg;
            String fnName = callNode.getFirstChild().getOriginalName();
            if (fnName == null) {
                fnName = callNode.getFirstChild().getString();
            }
            if (!(firstArg = callNode.getSecondChild()).isString()) {
                t.report(callNode, BAD_CALL, new String[]{fnName});
                return;
            }
            for (String name : DOT_SPLITTER.split(firstArg.getString())) {
                if (!TokenStream.isJSIdentifier((String)name)) {
                    t.report(callNode, BAD_ARG, new String[]{fnName});
                    continue;
                }
                if (RenamePropertiesWithModuleSupport.this.externedNames.contains(name) && !RenamePropertiesWithModuleSupport.this.prevUsedPropertyOldNames.contains(name)) continue;
                this.countPropertyOccurrence(name);
            }
        }

        private void countPropertyOccurrence(String name) {
            Property prop = (Property)RenamePropertiesWithModuleSupport.this.propertyMap.get(name);
            if (prop == null) {
                prop = new Property(name);
                RenamePropertiesWithModuleSupport.this.propertyMap.put(name, prop);
            }
            ++prop.numOccurrences;
        }
    }
}

