/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.Source;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.util.CompilerMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourcePathBase {
    protected static final String NO_DIR = "";
    protected final String[] mimeTypes;
    protected final Map<String, Source> sources;
    protected boolean allowSourcePathOverlap;
    protected final Set<String> hits;
    protected final Set<String> misses;
    protected final HashMap<String, String> dirs;
    protected final List<ClasspathOverlap> warnings;

    static void addApplicationParentToSourcePath(VirtualFile appPath, VirtualFile[] classPath, List<File> directories) {
        File f;
        if (appPath != null && (f = FileUtil.openFile(appPath.getParent())) != null && f.isDirectory() && FileUtil.isSubdirectoryOf(appPath.getParent(), classPath) == -1) {
            directories.add(f);
        }
    }

    static void addPathElements(VirtualFile[] classPath, List<File> directories, boolean allowSourcePathOverlap, List<ClasspathOverlap> warnings) {
        int length;
        boolean badPaths = false;
        int n = length = classPath == null ? 0 : classPath.length;
        for (int i = 0; i < length; ++i) {
            String dirPath;
            int index;
            String path = classPath[i].getName();
            File f = FileUtil.openFile(path);
            if (f == null || !f.isDirectory()) continue;
            if (!allowSourcePathOverlap && !badPaths && (index = FileUtil.isSubdirectoryOf(f, directories)) != -1 && SourcePathBase.checkValidPackageName(path, dirPath = directories.get(index).getAbsolutePath())) {
                warnings.add(new ClasspathOverlap(path, dirPath));
                badPaths = true;
            }
            directories.add(f);
        }
    }

    private static boolean checkValidPackageName(String path1, String path2) {
        if (path1.equals(path2)) {
            return true;
        }
        String packagePath = path1.length() > path2.length() ? path1.substring(path2.length()) : path2.substring(path1.length());
        StringTokenizer t = new StringTokenizer(packagePath, File.separator);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (TextParser.isValidIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    public SourcePathBase(String[] mimeTypes, boolean allowSourcePathOverlap) {
        this.mimeTypes = mimeTypes;
        this.allowSourcePathOverlap = allowSourcePathOverlap;
        this.sources = new HashMap<String, Source>();
        this.hits = new HashSet<String>();
        this.misses = new HashSet<String>(1024);
        this.dirs = new HashMap();
        this.warnings = new ArrayList<ClasspathOverlap>(5);
    }

    public static class MoreThanOneComponentOfTheSameName
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 5943423934006966281L;
        public final String file1;
        public final String file2;

        public MoreThanOneComponentOfTheSameName(String file1, String file2) {
            this.file1 = file1;
            this.file2 = file2;
        }
    }

    public static class ClasspathOverlap
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -6314431057641028497L;
        public final String cpath;
        public final String directory;

        public ClasspathOverlap(String path, String directory) {
            this.cpath = path;
            this.directory = directory;
        }
    }
}

