/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.internal.definitions.ConstantDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BaseTypedDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IInitializableDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.KeywordNode;
import org.apache.royale.compiler.internal.tree.as.LanguageIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.parts.IDecorationPart;
import org.apache.royale.compiler.internal.tree.as.parts.VariableDecorationPart;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseVariableNode
extends BaseTypedDefinitionNode
implements IVariableNode,
IInitializableDefinitionNode {
    protected int equalsOperatorStart;
    protected boolean isConst;

    public BaseVariableNode(IdentifierNode nameNode) {
        this.init(nameNode);
    }

    public BaseVariableNode(IdentifierNode nameNode, ExpressionNodeBase typeNode) {
        this.init(nameNode);
        this.typeNode = typeNode;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addDecorationChildren(fillInOffsets);
        this.addChildInOrder(((VariableDecorationPart)this.getDecorationPart()).getKeywordValue(), fillInOffsets);
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.ensureTypeNode();
        this.addChildInOrder(this.typeNode, fillInOffsets);
        this.addChildInOrder(this.getAssignedValueNode(), fillInOffsets);
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            if (this.needsBindableDefinition()) {
                DefinitionBase[] bindingDefs = this.buildBindableDefinitions(scope);
                this.setDefinition(bindingDefs[0]);
                scope.addDefinition(bindingDefs[0]);
                scope.addDefinition(bindingDefs[1]);
            } else {
                DefinitionBase definition = this.buildDefinition();
                this.setDefinition(definition);
                scope.addDefinition(definition);
            }
        }
        super.analyze(set, scope, problems);
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append(this.getName());
        String type = this.getVariableType();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
        return true;
    }

    @Override
    protected void init(ExpressionNodeBase node) {
        super.init(node);
        this.equalsOperatorStart = -1;
        this.isConst = false;
    }

    @Override
    protected IDecorationPart createDecorationPart() {
        return new VariableDecorationPart();
    }

    @Override
    public DefinitionBase getDefinition() {
        return super.getDefinition();
    }

    @Override
    public IExpressionNode getVariableTypeNode() {
        return this.getTypeNode();
    }

    @Override
    public String getVariableType() {
        return this.getTypeName();
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public int getDeclarationEnd() {
        return this.getEnd();
    }

    @Override
    public final ExpressionNodeBase getAssignedValueNode() {
        return ((VariableDecorationPart)this.getDecorationPart()).getAssignedValue();
    }

    @Override
    public void setAssignedValue(IASToken equalsOperator, ExpressionNodeBase value) {
        if (equalsOperator != null) {
            this.equalsOperatorStart = equalsOperator.getStart();
        }
        ((VariableDecorationPart)this.getDecorationPart()).setAssignedValue(value);
    }

    public void setKeyword(IASToken keyword) {
        if (keyword != null) {
            ((VariableDecorationPart)this.getDecorationPart()).setKeywordNode(new KeywordNode(keyword));
        }
    }

    public void setKeyword(KeywordNode keyword) {
        if (keyword != null) {
            ((VariableDecorationPart)this.getDecorationPart()).setKeywordNode(keyword);
        }
    }

    public void setIsConst(boolean isConst) {
        this.isConst = isConst;
    }

    protected void ensureTypeNode() {
        if (this.typeNode == null) {
            this.typeNode = LanguageIdentifierNode.buildAnyType();
        }
    }

    DefinitionBase buildDefinition() {
        String definitionName = this.nameNode.computeSimpleReference();
        VariableDefinition definition = this.isConst() ? new ConstantDefinition(definitionName) : new VariableDefinition(definitionName);
        this.fillinDefinition(definition);
        definition.setDeclaredInControlFlow(this.isInControlFlow());
        definition.setInitializer(this.getAssignedValueNode());
        return definition;
    }

    private boolean isInControlFlow() {
        boolean result = false;
        IASNode n = this.getParent();
        while (n != null) {
            if (n instanceof BlockNode || n instanceof ChainedVariableNode) {
                n = n.getParent();
                continue;
            }
            if (n instanceof BaseDefinitionNode) {
                n = null;
                continue;
            }
            result = true;
            n = null;
        }
        return result;
    }

    private boolean needsBindableDefinition() {
        ClassNode cls;
        if (this.hasEmptyBindableMetadata(this.getMetaTagsNode())) {
            return true;
        }
        INamespaceDecorationNode nsNode = this.getNamespaceNode();
        return nsNode != null && nsNode.getName() == "public" && (cls = (ClassNode)this.getAncestorOfType(ClassNode.class)) != null && this.hasEmptyBindableMetadata(cls.getMetaTags());
    }

    private boolean hasEmptyBindableMetadata(IMetaTagsNode metaTagsNode) {
        boolean hasEmptyBindable = false;
        if (metaTagsNode != null) {
            IMetaTagNode[] bindableTags;
            for (IMetaTagNode node : bindableTags = metaTagsNode.getTagsByName("Bindable")) {
                if (node.getAllAttributes().length != 0) continue;
                hasEmptyBindable = true;
                break;
            }
        }
        return hasEmptyBindable;
    }

    public boolean hasEqualsOperator() {
        return this.equalsOperatorStart != -1;
    }

    public int getEqualsOperatorStart() {
        return this.equalsOperatorStart;
    }

    public int getEqualsOperatorEnd() {
        return this.equalsOperatorStart + 1;
    }

    public final KeywordNode getKeywordNode() {
        return ((VariableDecorationPart)this.getDecorationPart()).getKeywordValue();
    }
}

