/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.fxg.flex.FlexFXG2SWFTranscoder;
import org.apache.royale.compiler.internal.as.codegen.BindableHelper;
import org.apache.royale.compiler.internal.config.RoyaleTargetSettings;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.embedding.transcoders.DataTranscoder;
import org.apache.royale.compiler.internal.mxml.MXMLNamespaceMapping;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.projects.SourcePathManager;
import org.apache.royale.compiler.internal.units.FXGCompilationUnit;
import org.apache.royale.compiler.problems.ANELibraryNotAllowedProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.projects.IRoyaleProject;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.swc.ISWC;
import org.apache.royale.utils.FilenameNormalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoyaleProjectConfigurator
extends Configurator {
    private static final String[] IMPLICIT_IMPORTS_FOR_MXML = new String[]{"flash.accessibility.*", "flash.data.*", "flash.debugger.*", "flash.desktop.*", "flash.display.*", "flash.errors.*", "flash.events.*", "flash.external.*", "flash.filesystem.*", "flash.geom.*", "flash.html.*", "flash.html.script.*", "flash.media.*", "flash.net.*", "flash.printing.*", "flash.profiler.*", "flash.system.*", "flash.text.*", "flash.ui.*", "flash.utils.*", "flash.xml.*", "mx.binding.*", "mx.core.ClassFactory", "mx.core.DeferredInstanceFromClass", "mx.core.DeferredInstanceFromFunction", "mx.core.IDeferredInstance", "mx.core.IFactory", "mx.core.IFlexModuleFactory", "mx.core.IPropertyChangeNotifier", "mx.core.mx_internal", "mx.styles.*"};
    private static final Map<String, Integer> NAMED_COLORS = new HashMap<String, Integer>();

    public static void configure(RoyaleProject project) {
        RoyaleProjectConfigurator.configure(project, null);
    }

    public static void configure(RoyaleProject project, Configuration configuration) {
        String[] imports = null;
        if (configuration != null) {
            imports = configuration.getCompilerMxmlImplicitImports();
        }
        if (imports == null) {
            imports = IMPLICIT_IMPORTS_FOR_MXML;
        }
        project.setImplicitImportsForMXML(imports);
        project.setComponentTagType("mx.core.IFactory");
        project.setStateClass("mx.states.State");
        project.setStateClientInterface("mx.core.IStateClient");
        project.setInstanceOverrideClass("mx.states.AddItems");
        project.setPropertyOverrideClass("mx.states.SetProperty");
        project.setStyleOverrideClass("mx.states.SetStyle");
        project.setEventOverrideClass("mx.states.SetEventHandler");
        project.setDeferredInstanceInterface("mx.core.IDeferredInstance");
        project.setTransientDeferredInstanceInterface("mx.core.ITransientDeferredInstance");
        project.setDeferredInstanceFromClassClass("mx.core.DeferredInstanceFromClass");
        project.setDeferredInstanceFromFunctionClass("mx.core.DeferredInstanceFromFunction");
        project.setFactoryInterface("mx.core.IFactory");
        project.setClassFactoryClass("mx.core.ClassFactory");
        project.setMXMLObjectInterface("mx.core.IMXMLObject");
        project.setContainerInterface("mx.core.IContainer");
        project.setVisualElementContainerInterface("mx.core.IVisualElementContainer");
        project.setResourceBundleClass("mx.resources.ResourceBundle");
        project.setResourceManagerClass("mx.resources.ResourceManager");
        project.setResourceModuleBaseClass("flex.compiler.support.ResourceModuleBase");
        project.setBindingManagerClass("mx.binding.BindingManager");
        project.setCSSStyleDeclarationClass("mx.styles.CSSStyleDeclaration");
        project.setFlexModuleInterface("mx.core.IFlexModule");
        project.setDeferredInstantiationUIComponentInterface("mx.core.IDeferredInstantiationUIComponent");
        project.setXMLUtilClass("mx.utils.XMLUtil");
        project.setUIComponentDescriptorClass("mx.core.UIComponentDescriptor");
        project.setModelClass("mx.utils.ObjectProxy");
        project.setBindingClass("mx.binding.Binding");
        project.setPropertyWatcherClass("mx.binding.PropertyWatcher");
        project.setObjectProxyClass("mx.utils.ObjectProxy");
        project.setStaticPropertyWatcherClass("mx.binding.StaticPropertyWatcher");
        project.setFunctionReturnWatcherClass("mx.binding.FunctionReturnWatcher");
        project.setXMLWatcherClass("mx.binding.XMLWatcher");
        project.setWebServiceClass("mx.rpc.soap.mxml.WebService");
        project.setWebServiceOperationClass("mx.rpc.soap.mxml.Operation");
        project.setRemoteObjectClass("mx.rpc.remoting.mxml.RemoteObject");
        project.setRemoteObjectMethodClass("mx.rpc.remoting.mxml.Operation");
        project.setHTTPServiceClass("mx.rpc.http.mxml.HTTPService");
        project.setDesignLayerClass("mx.core.DesignLayer");
        project.setRepeaterClass("mx.core.Repeater");
        project.setNamedColors(NAMED_COLORS);
        if (configuration != null) {
            String configValue;
            ClassDefinition.Event = configValue = configuration.getBindingEventHandlerEvent();
            int dotIndex = configValue.lastIndexOf(".");
            String packageName = configValue.substring(0, dotIndex);
            String className = configValue.substring(dotIndex + 1);
            BindableHelper.NAME_EVENT = new Name(7, new Nsset(new Namespace(22, packageName)), className);
            BindableHelper.STRING_EVENT = configValue;
            configValue = configuration.getBindingEventHandlerClass();
            dotIndex = configValue.lastIndexOf(".");
            packageName = configValue.substring(0, dotIndex);
            className = configValue.substring(dotIndex + 1);
            BindableHelper.NAME_EVENT_DISPATCHER = new Name(7, new Nsset(new Namespace(22, packageName)), className);
            BindableHelper.STRING_EVENT_DISPATCHER = configValue;
            configValue = configuration.getBindingEventHandlerInterface();
            dotIndex = configValue.lastIndexOf(".");
            packageName = configValue.substring(0, dotIndex);
            className = configValue.substring(dotIndex + 1);
            BindableHelper.NAME_IEVENT_DISPATCHER = new Name(7, new Nsset(new Namespace(22, packageName)), className);
            BindableHelper.STRING_IEVENT_DISPATCHER = configValue;
            configValue = configuration.getBindingValueChangeEvent();
            dotIndex = configValue.lastIndexOf(".");
            packageName = configValue.substring(0, dotIndex);
            className = configValue.substring(dotIndex + 1);
            BindableHelper.NAME_PROPERTY_CHANGE_EVENT = new Name(7, new Nsset(new Namespace(22, packageName)), className);
            BindableHelper.NAMESPACE_MX_EVENTS = new Namespace(22, packageName);
            BindableHelper.PROPERTY_CHANGE_EVENT = configValue;
            configValue = configuration.getBindingValueChangeEventKind();
            dotIndex = configValue.lastIndexOf(".");
            packageName = configValue.substring(0, dotIndex);
            className = configValue.substring(dotIndex + 1);
            BindableHelper.NAME_PROPERTY_CHANGE_EVENT_KIND = new Name(7, new Nsset(new Namespace(22, packageName)), className);
            BindableHelper.PROPERTY_CHANGE = configValue = configuration.getBindingValueChangeEventType();
            FlexFXG2SWFTranscoder.packageSpriteVisualElement = configValue = configuration.getFxgBaseClass();
            FXGCompilationUnit.fxgBaseClassName = configValue;
            configValue = configuration.getStatesClass();
            project.setStateClass(configValue);
            configValue = configuration.getStatesInstanceOverrideClass();
            project.setInstanceOverrideClass(configValue);
            configValue = configuration.getStatesPropertyOverrideClass();
            project.setPropertyOverrideClass(configValue);
            configValue = configuration.getStatesEventOverrideClass();
            project.setEventOverrideClass(configValue);
            configValue = configuration.getStatesStyleOverrideClass();
            project.setStyleOverrideClass(configValue);
            configValue = configuration.getComponentFactoryInterface();
            project.setFactoryInterface(configValue);
            configValue = configuration.getComponentFactoryClass();
            project.setClassFactoryClass(configValue);
            configValue = configuration.getProxyBaseClass();
            project.setProxyBaseClass(configValue);
            project.setStrictXML(configuration.isStrictXML());
            project.setAllowPrivateNameConflicts(configuration.getCompilerAllowPrivateNameConflicts());
            project.setAllowImportAliases(configuration.getCompilerAllowImportAliases());
            project.setAllowAbstractClasses(configuration.getCompilerAllowAbstractClasses());
            project.setAllowPrivateConstructors(configuration.getCompilerAllowPrivateConstructors());
            project.setSwfDebugfileAlias(configuration.getSwfDebugfileAlias());
            if (configuration.getSwfDebugfileAlias() != null) {
                FileSpecification.useCRLFFilter = true;
            }
            DataTranscoder.embedClassName = configuration.getByteArrayEmbedClass();
        }
    }

    public RoyaleProjectConfigurator(Class<? extends Configuration> configurationClass) {
        super(configurationClass);
    }

    @Override
    public boolean applyToProject(ICompilerProject project) {
        boolean success = super.applyToProject(project);
        if (success && !this.setupSources((IRoyaleProject)project)) {
            success = false;
        }
        return success;
    }

    @Override
    protected boolean applyConfiguration() {
        boolean success = true;
        RoyaleProject royaleProject = (RoyaleProject)this.project;
        RoyaleProjectConfigurator.configure(royaleProject, this.configuration);
        this.setupCompatibilityVersion(royaleProject);
        this.setupConfigVariables(royaleProject);
        this.setupLocaleSettings(royaleProject);
        this.setupServices(royaleProject);
        this.setupThemeFiles(royaleProject);
        this.setupRoyale(royaleProject);
        this.setupCodegenOptions(royaleProject);
        royaleProject.setRuntimeSharedLibraryPath(RoyaleProjectConfigurator.getRSLSettingsFromConfiguration(this.configuration));
        if (!this.setupProjectLibraries(royaleProject)) {
            success = false;
        }
        this.setupNamespaces(royaleProject);
        return success;
    }

    protected void setupCompatibilityVersion(RoyaleProject project) {
        int compatibilityVersion = this.configuration.getCompilerMxmlCompatibilityVersion();
        if (compatibilityVersion < 0x3000000) {
            throw new UnsupportedOperationException("Unsupported compatibility version: " + this.configuration.getCompilerCompatibilityVersionString());
        }
        project.setCompatibilityVersion(this.configuration.getCompilerMxmlMajorCompatibilityVersion(), this.configuration.getCompilerMxmlMinorCompatibilityVersion(), this.configuration.getCompilerMxmlRevisionCompatibilityVersion());
    }

    protected void setupServices(RoyaleProject project) {
        if (this.configuration.getCompilerServices() != null) {
            project.setServicesXMLPath(this.configuration.getCompilerServices().getPath(), this.configuration.getCompilerContextRoot());
        }
    }

    protected void setupConfigVariables(IRoyaleProject project) {
        Map<String, String> compilerDefine = project.getCompilerDefine(this.configuration);
        if (compilerDefine != null) {
            project.setDefineDirectives(compilerDefine);
        }
    }

    protected boolean setupSources(IRoyaleProject project) {
        ArrayList<String> sourcePath = new ArrayList<String>();
        this.applySourcePathRules(sourcePath);
        project.setSourcePath(RoyaleProjectConfigurator.toFiles(sourcePath));
        try {
            project.setIncludeSources(RoyaleProjectConfigurator.toFileList(this.configuration.getIncludeSources()));
        }
        catch (InterruptedException e) {
            assert (false) : "InterruptedException should never be thrown here";
            return false;
        }
        return true;
    }

    protected boolean setupProjectLibraries(IRoyaleProject project) {
        LinkedHashSet<File> libraries = new LinkedHashSet<File>();
        List<File> externalLibraryFiles = RoyaleProjectConfigurator.toFileList(project.getCompilerExternalLibraryPath(this.configuration));
        libraries.addAll(externalLibraryFiles);
        libraries.addAll(this.configuration.getRslExcludedLibraries());
        libraries.addAll(RoyaleProjectConfigurator.toFileList(this.configuration.getCompilerIncludeLibraries()));
        libraries.addAll(RoyaleProjectConfigurator.toFileList(project.getCompilerLibraryPath(this.configuration)));
        List<String> themes = this.configuration.getCompilerThemeFiles();
        for (String theme : themes) {
            if (!theme.endsWith(".swc")) continue;
            File f = new File(theme);
            libraries.add(f);
        }
        project.setLibraries(new ArrayList<File>(libraries));
        return this.validateNoANEFiles(project, externalLibraryFiles);
    }

    private boolean validateNoANEFiles(IRoyaleProject project, List<File> externalLibraryFiles) {
        List<ISWC> libraries = project.getLibraries();
        for (ISWC library : libraries) {
            if (!library.isANE() || this.isOnExternalLibrayPath(library, externalLibraryFiles)) continue;
            this.configurationProblems.add(new ANELibraryNotAllowedProblem(library.getSWCFile().getAbsolutePath()));
            return false;
        }
        return true;
    }

    protected void setupNamespaces(IRoyaleProject project) {
        List<MXMLNamespaceMapping> configManifestMappings = project.getCompilerNamespacesManifestMappings(this.configuration);
        if (configManifestMappings != null) {
            project.setNamespaceMappings(configManifestMappings);
        }
    }

    protected void setupLocaleSettings(IRoyaleProject project) {
        project.setLocales(this.configuration.getCompilerLocales());
        project.setLocaleDependentResources(this.configuration.getLocaleDependentSources());
    }

    private void setupRoyale(RoyaleProject royaleProject) {
        royaleProject.setRoyale(this.configuration.isRoyale());
    }

    private void setupCodegenOptions(RoyaleProject royaleProject) {
        royaleProject.setEnableInlining(this.configuration.isInliningEnabled());
    }

    protected void setupThemeFiles(RoyaleProject project) {
        project.setThemeFiles(RoyaleProjectConfigurator.toFileSpecifications(this.configuration.getCompilerThemeFiles(), project.getWorkspace()));
    }

    @Override
    protected ITargetSettings instantiateTargetSettings() {
        return new RoyaleTargetSettings(this.configuration, this.project);
    }

    @Override
    protected String computeQNameForTargetFile() {
        ArrayList<String> computedSourcePath = new ArrayList<String>();
        this.applySourcePathRules(computedSourcePath);
        String targetSourceFileName = this.configuration.getTargetFile();
        if (targetSourceFileName == null) {
            return null;
        }
        File targetSourceFile = FilenameNormalization.normalize(new File(this.configuration.getTargetFile()));
        for (String sourcePathEntry : computedSourcePath) {
            String computedQName = SourcePathManager.computeQName(new File(sourcePathEntry), targetSourceFile);
            if (computedQName == null) continue;
            return computedQName;
        }
        return null;
    }

    private boolean isOnExternalLibrayPath(ISWC library, List<File> externalLibraryFiles) {
        File aneFile = library.getSWCFile();
        for (File file : externalLibraryFiles) {
            if (!file.equals(aneFile)) continue;
            return true;
        }
        return false;
    }

    static {
        NAMED_COLORS.put("aqua", 65535);
        NAMED_COLORS.put("black", 0);
        NAMED_COLORS.put("blue", 255);
        NAMED_COLORS.put("cyan", 65535);
        NAMED_COLORS.put("fuchsia", 0xFF00FF);
        NAMED_COLORS.put("gray", 0x808080);
        NAMED_COLORS.put("green", 32768);
        NAMED_COLORS.put("lime", 65280);
        NAMED_COLORS.put("magenta", 0xFF00FF);
        NAMED_COLORS.put("maroon", 0x800000);
        NAMED_COLORS.put("navy", 128);
        NAMED_COLORS.put("olive", 0x808000);
        NAMED_COLORS.put("purple", 0x800080);
        NAMED_COLORS.put("red", 0xFF0000);
        NAMED_COLORS.put("silver", 0xC0C0C0);
        NAMED_COLORS.put("teal", 32896);
        NAMED_COLORS.put("white", 0xFFFFFF);
        NAMED_COLORS.put("yellow", 0xFFFF00);
        NAMED_COLORS.put("haloBlue", 40447);
        NAMED_COLORS.put("haloGreen", 8453965);
        NAMED_COLORS.put("haloOrange", 16758272);
        NAMED_COLORS.put("haloSilver", 11455193);
    }
}

