/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.embedding.transcoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.ModifierNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.EmbedSourceAttributeCouldNotBeReadProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTranscoder
extends TranscoderBase {
    private String encoding = "";

    public XMLTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.analyze(location, problems);
        this.baseClassQName = "";
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case ENCODING: {
                this.encoding = (String)this.data.getAttribute(EmbedAttribute.ENCODING);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        return Collections.emptyMap();
    }

    @Override
    public FileNode buildAST(Collection<ICompilerProblem> problems, String filename) {
        FileNode fileNode = new FileNode((IFileSpecificationGetter)this.workspace, filename);
        PackageNode packageNode = new PackageNode(new IdentifierNode(""), null);
        fileNode.addItem(packageNode);
        ScopedBlockNode contents = packageNode.getScopedNode();
        ClassNode classNode = new ClassNode(new IdentifierNode(this.data.getQName()));
        classNode.setNamespace(new NamespaceIdentifierNode("public"));
        contents.addItem(classNode);
        VariableNode variableNodeData = new VariableNode(new IdentifierNode("data"));
        variableNodeData.setNamespace(new NamespaceIdentifierNode("public"));
        variableNodeData.addModifier(new ModifierNode("static"));
        variableNodeData.setType(null, new IdentifierNode("XML"));
        ASToken assignToken = new ASToken(53, -1, -1, -1, -1, "=");
        String xmlContents = this.getXMLString(problems);
        LiteralNode xmlData = new LiteralNode(ILiteralNode.LiteralType.STRING, xmlContents);
        variableNodeData.setAssignedValue(assignToken, xmlData);
        classNode.getScopedNode().addItem(variableNodeData);
        fileNode.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
        return fileNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getXMLString(Collection<ICompilerProblem> problems) {
        StringBuilder str;
        block22: {
            IOException iOException2222;
            BOMInputStream bomStream;
            Reader reader;
            block20: {
                InputStream strm = this.getDataStream(problems);
                if (strm == null) {
                    return "";
                }
                reader = null;
                bomStream = null;
                str = new StringBuilder();
                bomStream = new BOMInputStream(strm);
                String bomCharsetName = bomStream.getBOMCharsetName();
                if (bomCharsetName == null) {
                    bomCharsetName = this.encoding == null || this.encoding.length() == 0 ? System.getProperty("file.encoding") : this.encoding;
                }
                reader = new InputStreamReader((InputStream)bomStream, bomCharsetName);
                char[] line = new char[2048];
                int count = 0;
                while ((count = reader.read(line, 0, line.length)) >= 0) {
                    str.append(line, 0, count);
                }
                Object var10_10 = null;
                if (bomStream == null) break block20;
                try {
                    bomStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException2222) {}
            }
            break block22;
            {
                catch (IOException e) {
                    IOException iOException32222;
                    problems.add(new EmbedSourceAttributeCouldNotBeReadProblem(this.source));
                    Object var10_11 = null;
                    if (bomStream != null) {
                        try {
                            bomStream.close();
                        }
                        catch (IOException iOException32222) {
                            // empty catch block
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException32222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var10_12 = null;
                if (bomStream != null) {
                    try {
                        bomStream.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return str.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof XMLTranscoder)) {
            return false;
        }
        XMLTranscoder t = (XMLTranscoder)o;
        return this.encoding.equals(t.encoding);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode += this.encoding.hashCode();
    }
}

