/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IEffectDefinition;
import org.apache.royale.compiler.definitions.IEventDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.IStyleDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.config.QNameNormalization;
import org.apache.royale.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.EffectDefinition;
import org.apache.royale.compiler.internal.definitions.EventDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.GetterDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.StyleDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.definitions.metadata.MetaTag;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.TypeScope;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnitFactory;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.DuplicateSkinStateProblem;
import org.apache.royale.compiler.problems.EmbedMultipleMetaTagsProblem;
import org.apache.royale.compiler.problems.HostComponentClassNotFoundProblem;
import org.apache.royale.compiler.problems.HostComponentMustHaveTypeProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MissingSkinPartProblem;
import org.apache.royale.compiler.problems.MissingSkinStateProblem;
import org.apache.royale.compiler.problems.OnlyOneHostComponentAllowedProblem;
import org.apache.royale.compiler.problems.SkinPartsMustBePublicProblem;
import org.apache.royale.compiler.problems.UnimplementedAbstractMethodProblem;
import org.apache.royale.compiler.problems.WrongSkinPartProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.metadata.IEventTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IStyleTagNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.workspaces.IWorkspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDefinition
extends ClassDefinitionBase
implements IClassDefinition {
    private static final ClassDefinition ANY_TYPE;
    private static final ClassDefinition NULL;
    private static final ClassDefinition UNDEFINED;
    private static final ClassDefinition VOID;
    private static final String NO_REMOTE_CLASS_ALIAS = "";
    private static final String HOST_COMPONENT = "hostComponent";
    public static String Event;
    private final INamespaceDefinition.ILanguageNamespaceDefinition privateNamespaceReference;
    private final INamespaceDefinition.ILanguageNamespaceDefinition protectedNamespaceReference;
    private final INamespaceDefinition.ILanguageNamespaceDefinition staticProtectedNamespaceReference;
    private IReference baseClassReference;
    private IReference[] interfaceReferences;
    private IFunctionDefinition constructor;
    private AtomicReference<Map<String, IEventDefinition>> eventDefinitions;
    private final AtomicReference<Map<String, IStyleDefinition>> styleDefinitions;
    private final AtomicReference<Map<String, IEffectDefinition>> effectDefinitions;
    private final AtomicReference<String[]> skinStates;
    private final AtomicReference<IMetaTag[]> skinParts;
    private Set<String> stateNames;
    private final AtomicReference<FrameInformation> frameInformation;
    private final AtomicReference<String> remoteClassAlias;
    private Set<String> implicitImports;
    private List<IDefinition> contingentDefinitions;

    private static ClassDefinition makeImplicitClassDefinition(String name) {
        ClassDefinition def = new ClassDefinition(name, NamespaceDefinition.getPublicNamespaceDefinition());
        def.setPublic();
        def.setFinal();
        def.setImplicit();
        TypeScope scope = new TypeScope(null, def);
        scope.setContainingDefinition(def);
        def.setContainedScope(scope);
        return def;
    }

    public static IClassDefinition getAnyTypeClassDefinition() {
        return ANY_TYPE;
    }

    public static IClassDefinition getNullClassDefinition() {
        return NULL;
    }

    public static IClassDefinition getUndefinedClassDefinition() {
        return UNDEFINED;
    }

    public static IClassDefinition getVoidClassDefinition() {
        return VOID;
    }

    private static String getGeneratedURIPrefix(INamespaceReference namespaceRef) {
        if (namespaceRef instanceof INamespaceDefinition.INamespaceWithPackageName) {
            return ((INamespaceDefinition.INamespaceWithPackageName)namespaceRef).getGeneratedURIPrefix();
        }
        return NO_REMOTE_CLASS_ALIAS;
    }

    public ClassDefinition(String name, INamespaceReference namespaceRef) {
        this(name, namespaceRef, NamespaceDefinition.createProtectedNamespaceDefinition(ClassDefinition.getGeneratedURIPrefix(namespaceRef) + name));
    }

    public ClassDefinition(String name, INamespaceReference namespaceRef, INamespaceDefinition.IProtectedNamespaceDefinition protectedNamespace) {
        super(name);
        assert (name.indexOf(46) == -1) : "name must not be a qualified name!";
        this.setNamespaceReference(namespaceRef);
        String generatedURI = ClassDefinition.getGeneratedURIPrefix(namespaceRef) + name;
        this.privateNamespaceReference = NamespaceDefinition.createPrivateNamespaceDefinition(generatedURI);
        this.protectedNamespaceReference = protectedNamespace;
        this.staticProtectedNamespaceReference = NamespaceDefinition.createStaticProtectedNamespaceDefinition(generatedURI);
        this.contingentDefinitions = new LinkedList<IDefinition>();
        this.eventDefinitions = new AtomicReference();
        this.styleDefinitions = new AtomicReference();
        this.effectDefinitions = new AtomicReference();
        this.skinStates = new AtomicReference();
        this.skinParts = new AtomicReference();
        this.stateNames = new HashSet<String>();
        this.frameInformation = new AtomicReference();
        this.remoteClassAlias = new AtomicReference();
    }

    @Override
    public IClassDefinition.ClassClassification getClassClassification() {
        if (this.inPackageNamespace()) {
            return IClassDefinition.ClassClassification.PACKAGE_MEMBER;
        }
        return IClassDefinition.ClassClassification.FILE_MEMBER;
    }

    @Override
    public IFunctionDefinition getConstructor() {
        return this.constructor;
    }

    protected void setConstructor(IFunctionDefinition constructor) {
        this.constructor = constructor;
        if (this.constructor.isPrivate() && this.constructor.getMetaTagByName("RoyalePrivateConstructor") == null) {
            MetaTag privateMetaTag = new MetaTag(this, "RoyalePrivateConstructor", new IMetaTagAttribute[0]);
            this.addMetaTag(privateMetaTag);
        }
    }

    @Override
    public String getBaseClassAsDisplayString() {
        return this.baseClassReference != null ? this.baseClassReference.getDisplayString() : NO_REMOTE_CLASS_ALIAS;
    }

    @Override
    public IReference getBaseClassReference() {
        return this.baseClassReference;
    }

    public void setBaseClassReference(IReference baseClassReference) {
        if (baseClassReference == null) {
            boolean isObject;
            boolean bl = isObject = this.getBaseName().equals("Object") && this.getNamespaceReference().isPublicOrInternalNamespace() && ((INamespaceDefinition)((Object)this.getNamespaceReference())).getURI().isEmpty();
            if (!isObject) {
                baseClassReference = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.OBJECT);
            }
        }
        this.baseClassReference = baseClassReference;
    }

    @Override
    public IClassDefinition resolveBaseClass(ICompilerProject project) {
        if (this.baseClassReference == null) {
            return null;
        }
        TypeDefinitionBase typeDefinition = this.resolveType(this.baseClassReference, project, DependencyType.INHERITANCE);
        if (typeDefinition == null) {
            return null;
        }
        if (!(typeDefinition instanceof IClassDefinition)) {
            return null;
        }
        if (((IClassDefinition)((Object)typeDefinition)).isFinal()) {
            return null;
        }
        if (typeDefinition == this) {
            return null;
        }
        return (IClassDefinition)((Object)typeDefinition);
    }

    @Override
    public String[] getImplementedInterfacesAsDisplayStrings() {
        if (this.interfaceReferences == null) {
            return new String[0];
        }
        int n = this.interfaceReferences.length;
        String[] interfaces = new String[n];
        for (int i = 0; i < n; ++i) {
            interfaces[i] = this.interfaceReferences[i].getDisplayString();
        }
        return interfaces;
    }

    public void setImplementedInterfaceReferences(IReference[] interfaceReferences) {
        this.interfaceReferences = interfaceReferences;
    }

    @Override
    public IReference[] getImplementedInterfaceReferences() {
        if (this.interfaceReferences == null) {
            return new IReference[0];
        }
        return this.interfaceReferences;
    }

    @Override
    public IEventDefinition getEventDefinition(IWorkspace w, String name) {
        if (this.eventDefinitions.get() == null) {
            this.buildEventDefinitions(w);
        }
        return this.eventDefinitions.get().get(name);
    }

    @Override
    public IEventDefinition[] getEventDefinitions(IWorkspace w) {
        if (this.eventDefinitions.get() == null) {
            this.buildEventDefinitions(w);
        }
        return this.eventDefinitions.get().values().toArray(new IEventDefinition[0]);
    }

    private void buildEventDefinitions(IWorkspace w) {
        IMetaTag[] metaTags;
        HashMap<String, EventDefinition> map = new HashMap<String, EventDefinition>();
        HashMap<String, IEventTagNode> availableTagNodes = new HashMap<String, IEventTagNode>();
        if (this.getNode() != null && this.getNode().getMetaTags() != null) {
            IMetaTagNode[] allNodes = this.getNode().getMetaTags().getTagsByName("Event");
            for (ISourceLocation iSourceLocation : allNodes) {
                IEventTagNode eventTagNode = (IEventTagNode)iSourceLocation;
                availableTagNodes.put(eventTagNode.getName(), (IEventTagNode)iSourceLocation);
            }
        }
        if ((metaTags = this.getAllMetaTags()) != null) {
            for (ISourceLocation iSourceLocation : metaTags) {
                IMetaTagAttribute[] attrs;
                if (!iSourceLocation.getTagName().equals("Event")) continue;
                String name = iSourceLocation.getAttributeValue("name");
                String type = iSourceLocation.getAttributeValue("type");
                if (name == null && (attrs = iSourceLocation.getAllAttributes()) != null && attrs.length > 0) {
                    name = attrs[0].getValue();
                }
                if (type == null) {
                    type = Event;
                }
                if (name == null) continue;
                EventDefinition eventDefinition = new EventDefinition(name, this);
                eventDefinition.setContainingScope(this.getContainingScope());
                eventDefinition.setTypeReference(ReferenceFactory.packageQualifiedReference(w, type));
                if (availableTagNodes.containsKey(name)) {
                    eventDefinition.setNode((IDefinitionNode)availableTagNodes.get(name));
                }
                map.put(name, eventDefinition);
            }
        }
        this.eventDefinitions.compareAndSet(null, map);
    }

    @Override
    public IEventDefinition[] findEventDefinitions(ICompilerProject project) {
        IWorkspace workspace = project.getWorkspace();
        HashMap<String, IEventDefinition> map = new HashMap<String, IEventDefinition>();
        for (IClassDefinition c : this.classIterable(project, true)) {
            for (IEventDefinition eventTag : c.getEventDefinitions(workspace)) {
                String eventName = eventTag.getBaseName();
                if (map.containsKey(eventName)) continue;
                map.put(eventName, eventTag);
            }
        }
        return map.values().toArray(new IEventDefinition[0]);
    }

    @Override
    public IStyleDefinition getStyleDefinition(IWorkspace workspace, String name) {
        if (this.styleDefinitions.get() == null) {
            this.buildStyleDefinitions(workspace);
        }
        return this.styleDefinitions.get().get(name);
    }

    @Override
    public IStyleDefinition[] getStyleDefinitions(IWorkspace w) {
        if (this.styleDefinitions.get() == null) {
            this.buildStyleDefinitions(w);
        }
        return this.styleDefinitions.get().values().toArray(new IStyleDefinition[0]);
    }

    private void buildStyleDefinitions(IWorkspace workspace) {
        HashMap<String, StyleDefinition> styleMap = new HashMap<String, StyleDefinition>();
        for (IMetaTag metaTag : this.getAllMetaTags()) {
            IMetaTagNode styleTagNode;
            if (!metaTag.getTagName().equals("Style")) continue;
            String name = metaTag.getAttributeValue("name");
            String type = metaTag.getAttributeValue("type");
            String format = metaTag.getAttributeValue("format");
            String inherit = metaTag.getAttributeValue("inherit");
            String themes = metaTag.getAttributeValue("theme");
            String minValue = metaTag.getAttributeValue("minValue");
            String minValueExclusive = metaTag.getAttributeValue("minValueExclusive");
            String maxValue = metaTag.getAttributeValue("maxValue");
            String maxValueExclusive = metaTag.getAttributeValue("maxValueExclusive");
            String enumeration = metaTag.getAttributeValue("enumeration");
            String states = metaTag.getAttributeValue("states");
            String arrayTypeName = metaTag.getAttributeValue("arrayType");
            if (name == null) continue;
            if (type == null) {
                type = "*";
            }
            StyleDefinition styleDefinition = new StyleDefinition(name, this);
            styleDefinition.setContainingScope(this.getContainingScope());
            styleDefinition.setTypeReference(ReferenceFactory.packageQualifiedReference(workspace, type));
            styleDefinition.setFormat(format);
            styleDefinition.setInherit(inherit);
            styleDefinition.setThemes(themes);
            styleDefinition.setMinValue(minValue);
            styleDefinition.setMinValueExclusive(minValueExclusive);
            styleDefinition.setMaxValue(maxValue);
            styleDefinition.setMaxValueExclusive(maxValueExclusive);
            styleDefinition.setArrayType(arrayTypeName);
            if (states != null) {
                Iterable statesIterable = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)states);
                String[] statesArray = (String[])Iterables.toArray((Iterable)statesIterable, String.class);
                styleDefinition.setStates(statesArray);
            }
            if (enumeration != null) {
                String[] split = enumeration.split(",");
                styleDefinition.setEnumeration(split);
            }
            if ((styleTagNode = metaTag.getTagNode()) != null && styleTagNode instanceof IStyleTagNode) {
                styleDefinition.setNode((IStyleTagNode)styleTagNode);
            }
            styleMap.put(name, styleDefinition);
        }
        this.styleDefinitions.compareAndSet(null, styleMap);
    }

    @Override
    public IStyleDefinition[] findStyleDefinitions(ICompilerProject project) {
        IWorkspace workspace = project.getWorkspace();
        HashMap<String, IStyleDefinition> map = new HashMap<String, IStyleDefinition>();
        for (IClassDefinition c : this.classIterable(project, true)) {
            for (IStyleDefinition styleTag : c.getStyleDefinitions(workspace)) {
                String styleName = styleTag.getBaseName();
                if (map.containsKey(styleName)) continue;
                map.put(styleName, styleTag);
            }
        }
        return map.values().toArray(new IStyleDefinition[0]);
    }

    @Override
    public IEffectDefinition getEffectDefinition(IWorkspace w, String name) {
        if (this.effectDefinitions.get() == null) {
            this.buildEffectDefinitions(w);
        }
        return this.effectDefinitions.get().get(name);
    }

    @Override
    public IEffectDefinition[] getEffectDefinitions(IWorkspace w) {
        if (this.effectDefinitions.get() == null) {
            this.buildEffectDefinitions(w);
        }
        return this.effectDefinitions.get().values().toArray(new IEffectDefinition[0]);
    }

    private void buildEffectDefinitions(IWorkspace workspace) {
        HashMap<String, EffectDefinition> effectMap = new HashMap<String, EffectDefinition>();
        for (IMetaTag metaTag : this.getAllMetaTags()) {
            if (!metaTag.getTagName().equals("Effect")) continue;
            String name = metaTag.getAttributeValue("name");
            String eventName = metaTag.getAttributeValue("event");
            EffectDefinition effectDefinition = new EffectDefinition(name, this);
            effectDefinition.setEvent(eventName);
            effectDefinition.setContainingScope(this.getContainingScope());
            effectMap.put(name, effectDefinition);
        }
        this.effectDefinitions.compareAndSet(null, effectMap);
    }

    @Override
    public IEffectDefinition[] findEffectDefinitions(ICompilerProject project) {
        IWorkspace workspace = project.getWorkspace();
        HashMap<String, IEffectDefinition> map = new HashMap<String, IEffectDefinition>();
        for (IClassDefinition c : this.classIterable(project, true)) {
            for (IEffectDefinition effectTag : c.getEffectDefinitions(workspace)) {
                String effectName = effectTag.getBaseName();
                if (map.containsKey(effectName)) continue;
                map.put(effectName, effectTag);
            }
        }
        return map.values().toArray(new IEffectDefinition[0]);
    }

    private void buildSkinStates(Collection<ICompilerProblem> problems) {
        IMetaTag[] tags = this.getMetaTagsByName("SkinState");
        HashSet<String> states = new HashSet<String>();
        for (IMetaTag tag : tags) {
            IMetaTagAttribute[] attributes = tag.getAllAttributes();
            if (attributes.length < 1) continue;
            String state = attributes[0].getValue();
            if (states.contains(state)) {
                DuplicateSkinStateProblem problem = new DuplicateSkinStateProblem(tag, state);
                problems.add(problem);
            }
            states.add(state);
        }
        this.skinStates.compareAndSet(null, states.toArray(new String[states.size()]));
    }

    @Override
    public String[] getSkinStates(Collection<ICompilerProblem> problems) {
        if (this.skinStates.get() == null) {
            this.buildSkinStates(problems);
        }
        return this.skinStates.get();
    }

    @Override
    public String[] findSkinStates(ICompilerProject project, Collection<ICompilerProblem> problems) {
        HashSet<String> states = new HashSet<String>();
        for (IClassDefinition c : this.classIterable(project, false)) {
            for (String state : c.getSkinStates(problems)) {
                states.add(state);
            }
        }
        for (String state : this.getSkinStates(problems)) {
            if (states.contains(state)) {
                DuplicateSkinStateProblem problem = new DuplicateSkinStateProblem(this, state);
                problems.add(problem);
            }
            states.add(state);
        }
        return states.toArray(new String[states.size()]);
    }

    public EmbedData getEmbeddedAsset(CompilerProject project, Collection<ICompilerProblem> problems) {
        IMetaTag[] embedMetaTags = this.getMetaTagsByName("Embed");
        if (embedMetaTags == null || embedMetaTags.length == 0) {
            return null;
        }
        if (embedMetaTags.length > 1) {
            problems.add(new EmbedMultipleMetaTagsProblem(this.getNode()));
            return null;
        }
        String containingSourceFilename = this.getFileSpecification().getPath();
        IMetaTag location = embedMetaTags[0];
        IMetaTagAttribute[] attributes = embedMetaTags[0].getAllAttributes();
        return EmbedCompilationUnitFactory.getEmbedData(project, this.getQualifiedName(), containingSourceFilename, location, attributes, problems);
    }

    private Collection<VariableDefinition> getAllLocalVariables() {
        Collection<IDefinitionSet> allDefinitions = this.getContainedScope().getAllLocalDefinitionSets();
        LinkedList<VariableDefinition> variables = new LinkedList<VariableDefinition>();
        for (IDefinitionSet defSet : allDefinitions) {
            for (int i = 0; i < defSet.getSize(); ++i) {
                IDefinition definition = defSet.getDefinition(i);
                if (!(definition instanceof VariableDefinition)) continue;
                variables.add((VariableDefinition)definition);
            }
        }
        return variables;
    }

    private Collection<GetterDefinition> getAllLocalGetters() {
        Collection<IDefinitionSet> allDefinitions = this.getContainedScope().getAllLocalDefinitionSets();
        LinkedList<GetterDefinition> getters = new LinkedList<GetterDefinition>();
        for (IDefinitionSet defSet : allDefinitions) {
            for (int i = 0; i < defSet.getSize(); ++i) {
                IDefinition definition = defSet.getDefinition(i);
                if (!(definition instanceof GetterDefinition)) continue;
                getters.add((GetterDefinition)definition);
            }
        }
        return getters;
    }

    private void buildSkinParts(Collection<ICompilerProblem> problems) {
        Collection<VariableDefinition> variables = this.getAllLocalVariables();
        LinkedList<IMetaTag> parts = new LinkedList<IMetaTag>();
        for (VariableDefinition variable : variables) {
            IMetaTag skinPart = variable.getSkinPart();
            if (skinPart == null) continue;
            parts.add(skinPart);
        }
        Collection<GetterDefinition> getters = this.getAllLocalGetters();
        for (GetterDefinition getter : getters) {
            IMetaTag skinPart = getter.getSkinPart();
            if (skinPart == null) continue;
            parts.add(skinPart);
        }
        for (IMetaTag part : parts) {
            IDefinition definition = part.getDecoratedDefinition();
            if (definition.getNamespaceReference().equals(NamespaceDefinition.getPublicNamespaceDefinition())) continue;
            SkinPartsMustBePublicProblem problem = new SkinPartsMustBePublicProblem(definition);
            problems.add(problem);
        }
        this.skinParts.compareAndSet(null, parts.toArray(new IMetaTag[parts.size()]));
    }

    @Override
    public IMetaTag[] getSkinParts(Collection<ICompilerProblem> problems) {
        if (this.skinParts.get() == null) {
            this.buildSkinParts(problems);
        }
        return this.skinParts.get();
    }

    @Override
    public IMetaTag[] findSkinParts(ICompilerProject project, Collection<ICompilerProblem> problems) {
        HashMap<String, IMetaTag> map = new HashMap<String, IMetaTag>();
        for (IClassDefinition c : this.classIterable(project, true)) {
            for (IMetaTag skinPart : c.getSkinParts(problems)) {
                String variableName = skinPart.getDecoratedDefinition().getBaseName();
                if (map.containsKey(variableName)) continue;
                map.put(variableName, skinPart);
            }
        }
        return map.values().toArray(new IMetaTag[map.size()]);
    }

    public void addStateName(String stateName) {
        this.stateNames.add(stateName);
    }

    @Override
    public Set<String> getStateNames() {
        return this.stateNames;
    }

    @Override
    public Set<String> findStateNames(ICompilerProject project) {
        HashSet<String> set = new HashSet<String>();
        for (IClassDefinition c : this.classIterable(project, true)) {
            set.addAll(c.getStateNames());
        }
        return set;
    }

    public List<IDefinition> getContingentDefinitions() {
        return this.contingentDefinitions;
    }

    public void buildContingentDefinitions() {
        VariableDefinition definition = this.buildHostComponentMember();
        if (definition != null) {
            this.contingentDefinitions.add(definition);
        }
    }

    public void verifyHostComponent(CompilerProject project, Collection<ICompilerProblem> problems) {
        ICompilationUnit referencingCU;
        String hostComponentClassName;
        IMetaTag[] metaTags = this.getHostComponentMetaData();
        if (metaTags.length == 0) {
            return;
        }
        if (metaTags.length > 1) {
            OnlyOneHostComponentAllowedProblem problem = new OnlyOneHostComponentAllowedProblem(metaTags[1]);
            problems.add(problem);
        }
        if ((hostComponentClassName = ClassDefinition.getHostComponentClassName(metaTags[0])) == null) {
            HostComponentMustHaveTypeProblem problem = new HostComponentMustHaveTypeProblem(metaTags[0]);
            problems.add(problem);
            return;
        }
        IResolvedQualifiersReference hostComponentRef = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), hostComponentClassName);
        IDefinition hostComponentDef = hostComponentRef.resolve(project, referencingCU = project.getScope().getCompilationUnitForDefinition(this), DependencyType.SIGNATURE);
        if (!(hostComponentDef instanceof IClassDefinition)) {
            HostComponentClassNotFoundProblem problem = new HostComponentClassNotFoundProblem(metaTags[0], hostComponentClassName);
            problems.add(problem);
            return;
        }
        IClassDefinition hostComponentClassDef = (IClassDefinition)hostComponentDef;
        this.verifySkinParts(hostComponentClassDef, project, problems);
        this.verifySkinStates(hostComponentClassDef, project, problems);
    }

    private void verifySkinParts(IClassDefinition hostComponentDef, ICompilerProject project, Collection<ICompilerProblem> problems) {
        IMetaTag[] skinParts;
        for (IMetaTag skinPart : skinParts = hostComponentDef.findSkinParts(project, problems)) {
            CompilerProblem problem;
            IVariableDefinition hostSkinPartDef = (IVariableDefinition)skinPart.getDecoratedDefinition();
            String hostStringPartName = hostSkinPartDef.getBaseName();
            IDefinition skinPartDef = this.getContainedScope().getPropertyFromDef(project, this, hostStringPartName, false);
            if (skinPartDef instanceof ISetterDefinition) {
                skinPartDef = ((ISetterDefinition)skinPartDef).resolveGetter(project);
            }
            if (!(skinPartDef instanceof IVariableDefinition) && !(skinPartDef instanceof IGetterDefinition)) {
                skinPartDef = null;
            }
            ITypeDefinition skinPartTypeDef = null;
            if (skinPartDef != null) {
                skinPartTypeDef = skinPartDef.resolveType(project);
            }
            if (skinPartTypeDef == null && hostSkinPartDef.isRequiredSkinPart()) {
                problem = new MissingSkinPartProblem(skinPart, hostComponentDef.getBaseName());
                problems.add(problem);
                continue;
            }
            if (skinPartTypeDef == null || skinPartTypeDef.isInstanceOf(hostSkinPartDef.resolveType(project), project)) continue;
            problem = new WrongSkinPartProblem(skinPart, skinPartTypeDef, hostSkinPartDef.resolveType(project));
            problems.add(problem);
        }
    }

    private void verifySkinStates(IClassDefinition hostComponentDef, ICompilerProject project, Collection<ICompilerProblem> problems) {
        String[] skinStates;
        Set<String> stateNames = this.findStateNames(project);
        for (String skinStateName : skinStates = hostComponentDef.findSkinStates(project, problems)) {
            if (stateNames.contains(skinStateName)) continue;
            problems.add(new MissingSkinStateProblem(this.getFileSpecification().getPath(), skinStateName));
        }
    }

    private VariableDefinition buildHostComponentMember() {
        IMetaTag[] metaTags = this.getHostComponentMetaData();
        if (metaTags.length == 0) {
            return null;
        }
        String hostComponentClassName = ClassDefinition.getHostComponentClassName(metaTags[0]);
        if (hostComponentClassName == null) {
            return null;
        }
        ASScope containedScope = this.getContainedScope();
        VariableDefinition hostComponentDef = new VariableDefinition(HOST_COMPONENT);
        hostComponentDef.setPublic();
        hostComponentDef.setBindable();
        hostComponentDef.setImplicit();
        hostComponentDef.setContingent();
        IResolvedQualifiersReference typeRef = ReferenceFactory.packageQualifiedReference(containedScope.getWorkspace(), hostComponentClassName);
        hostComponentDef.setTypeReference(typeRef);
        containedScope.addDefinition(hostComponentDef);
        return hostComponentDef;
    }

    public VariableDefinition buildOuterDocumentMember(IReference outerClass) {
        ASScope containedScope = this.getContainedScope();
        VariableDefinition outerDocumentDef = new VariableDefinition("outerDocument");
        outerDocumentDef.setPublic();
        outerDocumentDef.setBindable();
        outerDocumentDef.setImplicit();
        outerDocumentDef.setTypeReference(outerClass);
        containedScope.addDefinition(outerDocumentDef);
        outerDocumentDef.setContingent();
        this.contingentDefinitions.add(outerDocumentDef);
        return outerDocumentDef;
    }

    private IMetaTag[] getHostComponentMetaData() {
        return this.getMetaTagsByName("HostComponent");
    }

    private static String getHostComponentClassName(IMetaTag metaTag) {
        assert ("HostComponent".equals(metaTag.getTagName()));
        String hostComponentClassName = metaTag.getValue();
        if (hostComponentClassName == null || hostComponentClassName.isEmpty()) {
            return null;
        }
        return hostComponentClassName;
    }

    private void buildFrameInformation(IWorkspace w) {
        FrameInformation result = new FrameInformation();
        IMetaTag[] frameTags = this.getMetaTagsByName("Frame");
        result.extraClasses = Collections.emptySet();
        for (IMetaTag frameTag : frameTags) {
            String frameTagExtraClass;
            String frameTagFactoryClass = frameTag.getAttributeValue("factoryClass");
            if (frameTagFactoryClass != null) {
                result.factoryClass = ReferenceFactory.packageQualifiedReference(w, QNameNormalization.normalize(frameTagFactoryClass));
            }
            if ((frameTagExtraClass = frameTag.getAttributeValue("extraClass")) == null) continue;
            if (result.extraClasses.size() == 0) {
                result.extraClasses = new LinkedList<IResolvedQualifiersReference>();
            }
            result.extraClasses.add(ReferenceFactory.packageQualifiedReference(w, QNameNormalization.normalize(frameTagExtraClass)));
        }
        this.frameInformation.compareAndSet(null, result);
    }

    private IResolvedQualifiersReference getFactoryClass(IWorkspace w) {
        if (this.frameInformation.get() == null) {
            this.buildFrameInformation(w);
        }
        return this.frameInformation.get().factoryClass;
    }

    public boolean hasOwnFactoryClass(IWorkspace w) {
        return this.getFactoryClass(w) != null;
    }

    private void buildRemoteClassAlias() {
        IMetaTag lastRemoteClassTag;
        IMetaTag[] remoteClassTags = this.getMetaTagsByName("RemoteClass");
        String remoteClassAlias = NO_REMOTE_CLASS_ALIAS;
        if (remoteClassTags.length != 0 && (remoteClassAlias = (lastRemoteClassTag = remoteClassTags[remoteClassTags.length - 1]).getAttributeValue("alias")) == null) {
            remoteClassAlias = "<" + this.getQualifiedName();
        }
        this.remoteClassAlias.compareAndSet(null, remoteClassAlias);
    }

    public String getRemoteClassAlias() {
        String result;
        if (this.remoteClassAlias.get() == null) {
            this.buildRemoteClassAlias();
        }
        if ((result = this.remoteClassAlias.get()) == NO_REMOTE_CLASS_ALIAS) {
            return null;
        }
        return result;
    }

    public ClassDefinition resolveInheritedFactoryClass(ICompilerProject project) {
        for (IClassDefinition c : this.classIterable(project, true)) {
            IDefinition factoryDef;
            assert (c instanceof ClassDefinition) : "IClassDefinition " + c.getBaseName() + "is not a ClassDefinition!";
            ClassDefinition classDef = (ClassDefinition)c;
            IResolvedQualifiersReference factoryRef = classDef.getFactoryClass(project.getWorkspace());
            if (factoryRef == null || !((factoryDef = factoryRef.resolve(project, (ASScope)this.getContainingScope(), DependencyType.EXPRESSION, true)) instanceof ClassDefinition)) continue;
            return (ClassDefinition)factoryDef;
        }
        return null;
    }

    public Collection<IDefinition> resolveExtraClasses(ICompilerProject project) {
        if (this.frameInformation.get() == null) {
            this.buildFrameInformation(project.getWorkspace());
        }
        LinkedList<IDefinition> result = new LinkedList<IDefinition>();
        for (IResolvedQualifiersReference extraClassRef : this.frameInformation.get().extraClasses) {
            IDefinition extraClassDef = extraClassRef.resolve(project, (ASScope)this.getContainingScope(), DependencyType.EXPRESSION, true);
            if (extraClassDef == null) continue;
            result.add(extraClassDef);
        }
        return ImmutableList.copyOf(result);
    }

    @Override
    public String getDefaultPropertyName(ICompilerProject project) {
        for (IClassDefinition c : this.classIterable(project, true)) {
            IMetaTagAttribute[] attrs;
            IMetaTag defaultPropertyMetaData = c.getMetaTagByName("DefaultProperty");
            if (defaultPropertyMetaData == null || (attrs = defaultPropertyMetaData.getAllAttributes()).length != 1 || attrs[0].hasKey()) continue;
            return attrs[0].getValue();
        }
        return null;
    }

    @Override
    public void setContainedScope(IASScope value) {
        super.setContainedScope(value);
        ((DefinitionBase)((Object)this.privateNamespaceReference)).setContainingScope(value);
    }

    public INamespaceDefinition.ILanguageNamespaceDefinition getPrivateNamespaceReference() {
        return this.privateNamespaceReference;
    }

    @Override
    public INamespaceDefinition.ILanguageNamespaceDefinition getProtectedNamespaceReference() {
        return this.protectedNamespaceReference;
    }

    @Override
    public INamespaceDefinition.ILanguageNamespaceDefinition getStaticProtectedNamespaceReference() {
        return this.staticProtectedNamespaceReference;
    }

    @Override
    public Name getMName(ICompilerProject project) {
        if (this.getBaseName() == "*") {
            return null;
        }
        return super.getMName(project);
    }

    @Override
    public ASFileScope getFileScope() {
        if (this.isImplicit()) {
            return null;
        }
        return super.getFileScope();
    }

    public void addImplicitImport(String qname) {
        if (this.implicitImports == null) {
            this.implicitImports = new HashSet<String>();
        }
        this.implicitImports.add(qname);
    }

    public String[] getImplicitImports() {
        return this.implicitImports != null ? this.implicitImports.toArray(new String[0]) : new String[]{};
    }

    public void setupThisAndSuper() {
        VariableDefinition thisDef = new VariableDefinition("this");
        ASScope containedScope = this.getContainedScope();
        IWorkspace workspace = containedScope.getWorkspace();
        thisDef.setTypeReference(ReferenceFactory.lexicalReference(workspace, this.getBaseName()));
        thisDef.setImplicit();
        thisDef.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
        VariableDefinition superDef = new VariableDefinition("super");
        IReference baseClassRef = this.getBaseClassReference();
        if (baseClassRef == null) {
            baseClassRef = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.OBJECT);
        }
        superDef.setTypeReference(baseClassRef);
        superDef.setImplicit();
        superDef.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
        containedScope.addDefinition(thisDef);
        containedScope.addDefinition(superDef);
    }

    public void setExcludedClass() {
        MetaTag excludeClassMetaTag = new MetaTag(this, "ExcludeClass", new IMetaTagAttribute[0]);
        this.addMetaTag(excludeClassMetaTag);
    }

    @Override
    protected void buildInnerString(StringBuilder sb) {
        String[] implementedInterfaces;
        int n;
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        sb.append("class");
        sb.append(' ');
        sb.append(this.getBaseName());
        sb.append(' ');
        if (this.baseClassReference != null) {
            sb.append("extends");
            sb.append(' ');
            String baseClassName = this.getBaseClassAsDisplayString();
            sb.append(baseClassName.isEmpty() ? "Object" : baseClassName);
        }
        if ((n = (implementedInterfaces = this.getImplementedInterfacesAsDisplayStrings()).length) > 0) {
            sb.append(' ');
            sb.append("implements");
            sb.append(' ');
            for (int i = 0; i < n; ++i) {
                sb.append(implementedInterfaces[i]);
                if (i >= n - 1) continue;
                sb.append(',');
                sb.append(' ');
            }
        }
    }

    public boolean getOwnNeedsProtected() {
        return ((TypeScope)this.getContainedScope()).getNeedsProtected();
    }

    @Override
    public IClassDefinition resolveHostComponent(ICompilerProject project) {
        for (IClassDefinition c : this.classIterable(project, true)) {
            ClassDefinition classDef;
            IMetaTag[] hostComponentMetaData;
            if (!(c instanceof ClassDefinition) || (hostComponentMetaData = (classDef = (ClassDefinition)c).getHostComponentMetaData()).length < 1) continue;
            String hostComponentName = ClassDefinition.getHostComponentClassName(hostComponentMetaData[0]);
            if (hostComponentName == null) {
                return null;
            }
            IResolvedQualifiersReference hostComponentRef = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), hostComponentName);
            IDefinition hostComponentDef = hostComponentRef.resolve(project);
            if (!(hostComponentDef instanceof IClassDefinition)) {
                return null;
            }
            return (IClassDefinition)hostComponentDef;
        }
        return null;
    }

    @Override
    public boolean isInProject(ICompilerProject project) {
        if (!this.isImplicit()) {
            return super.isInProject(project);
        }
        if (this == NULL) {
            return true;
        }
        if (this == VOID) {
            return true;
        }
        if (this == ANY_TYPE) {
            return true;
        }
        return this == UNDEFINED;
    }

    public void validateClassImplementsAllMethods(ICompilerProject project, ClassDefinition cls, Collection<ICompilerProblem> problems) {
        ASScope classScope = cls.getContainedScope();
        for (IDefinitionSet defSet : this.getContainedScope().getAllLocalDefinitionSets()) {
            int l = defSet.getSize();
            for (int i = 0; i < l; ++i) {
                IDefinition c;
                FunctionDefinition abstractMethod;
                IDefinition def = defSet.getDefinition(i);
                if (!(def instanceof FunctionDefinition) || def instanceof IAccessorDefinition || (abstractMethod = (FunctionDefinition)def).isImplicit() || abstractMethod.getBaseName().equals(this.getBaseName()) || abstractMethod.isStatic() || !abstractMethod.isAbstract()) continue;
                INamespaceDefinition ns = abstractMethod.resolveNamespace(project);
                if (ns instanceof INamespaceDefinition.IProtectedNamespaceDefinition) {
                    ns = cls.getProtectedNamespaceReference();
                }
                if ((c = classScope.getQualifiedPropertyFromDef(project, (IDefinition)cls, abstractMethod.getBaseName(), ns, false)) != null && !c.isAbstract()) continue;
                problems.add(new UnimplementedAbstractMethodProblem(cls, abstractMethod.getBaseName(), this.getBaseName(), cls.getBaseName()));
            }
        }
    }

    static {
        Event = "flash.events.Event";
        ANY_TYPE = ClassDefinition.makeImplicitClassDefinition("*");
        ANY_TYPE.setDynamic();
        NULL = ClassDefinition.makeImplicitClassDefinition("Null");
        UNDEFINED = ClassDefinition.makeImplicitClassDefinition("Undefined");
        VOID = ClassDefinition.makeImplicitClassDefinition("void");
    }

    private static class FrameInformation {
        IResolvedQualifiersReference factoryClass;
        Collection<IResolvedQualifiersReference> extraClasses;

        private FrameInformation() {
        }
    }
}

