/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import java.util.List;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.ConstantDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AmbiguousDefinition
extends DefinitionBase
implements IDefinition {
    private static AmbiguousDefinition def = new AmbiguousDefinition();

    public static boolean isAmbiguous(IDefinition d) {
        return d == def;
    }

    public static AmbiguousDefinition get() {
        return def;
    }

    private AmbiguousDefinition() {
        super("");
    }

    public static IDefinition resolveAmbiguities(ICompilerProject project, List<IDefinition> defs, boolean favorTypes) {
        IDefinition resolvedDef = null;
        assert (defs.size() > 1) : "This method should only be called when there is an ambiguity to resolve!";
        if (SemanticUtils.isGetterSetterPair(defs, project)) {
            resolvedDef = defs.get(0);
        }
        if (resolvedDef == null && defs.size() == 2) {
            IDefinition def0 = defs.get(0);
            IDefinition def1 = defs.get(1);
            if (def0 instanceof FunctionDefinition && (def1 instanceof ClassDefinition || def1 instanceof InterfaceDefinition)) {
                resolvedDef = favorTypes ? def1 : def0;
            } else if (def1 instanceof FunctionDefinition && (def0 instanceof ClassDefinition || def0 instanceof InterfaceDefinition)) {
                IDefinition iDefinition = resolvedDef = favorTypes ? def0 : def1;
            }
        }
        if (resolvedDef == null) {
            resolvedDef = defs.get(0);
            assert (resolvedDef.isInProject(project));
            List<IDefinition> defsAfterFirst = defs.subList(1, defs.size());
            for (IDefinition d : defsAfterFirst) {
                assert (d.isInProject(project));
                resolvedDef = resolvedDef instanceof VariableDefinition ? (d instanceof VariableDefinition ? AmbiguousDefinition.resolveAmbiguousVariableDefinitions(project, resolvedDef, d) : (d instanceof FunctionDefinition ? AmbiguousDefinition.resolveAmbiguousFunctionVariableDefinitions(project, resolvedDef, d) : null)) : (resolvedDef instanceof FunctionDefinition ? (d instanceof FunctionDefinition ? AmbiguousDefinition.resolveAmbiguousFunctionDefinitions(project, resolvedDef, d) : (d instanceof VariableDefinition ? AmbiguousDefinition.resolveAmbiguousFunctionVariableDefinitions(project, resolvedDef, d) : null)) : null);
                if (resolvedDef != null) continue;
                break;
            }
        }
        return resolvedDef;
    }

    private static boolean namesAndContainingScopeMatch(ICompilerProject project, IDefinition d1, IDefinition d2) {
        if (!d1.getBaseName().equals(d2.getBaseName())) {
            return false;
        }
        if (!d1.resolveNamespace(project).equals(d2.resolveNamespace(project))) {
            return false;
        }
        return d1.getContainingScope() == d2.getContainingScope();
    }

    private static IDefinition resolveAmbiguousVariableDefinitions(ICompilerProject project, IDefinition v1, IDefinition v2) {
        assert (v1 instanceof VariableDefinition && v2 instanceof VariableDefinition);
        if (!AmbiguousDefinition.namesAndContainingScopeMatch(project, v1, v2)) {
            return null;
        }
        if (v1 instanceof ConstantDefinition || v2 instanceof ConstantDefinition) {
            return null;
        }
        IASScope containingScope = v1.getContainingScope();
        IScopedDefinition containingDef = v1.getContainingScope().getDefinition();
        if (containingDef instanceof FunctionDefinition || containingScope instanceof ASFileScope) {
            TypeDefinitionBase thatType;
            VariableDefinition var1 = (VariableDefinition)v1;
            VariableDefinition var2 = (VariableDefinition)v2;
            TypeDefinitionBase thisType = var1.resolveType(project);
            if (thisType == (thatType = var2.resolveType(project))) {
                return v1;
            }
            ITypeDefinition anyType = project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
            if (thisType == anyType) {
                return v2;
            }
            if (thatType == anyType) {
                return v1;
            }
        }
        return null;
    }

    private static IDefinition resolveAmbiguousFunctionDefinitions(ICompilerProject project, IDefinition f1, IDefinition f2) {
        assert (f1 instanceof FunctionDefinition && f2 instanceof FunctionDefinition);
        if (!AmbiguousDefinition.namesAndContainingScopeMatch(project, f1, f2)) {
            return null;
        }
        ASScope containingScope = (ASScope)f1.getContainingScope();
        if (containingScope instanceof ASFileScope || containingScope.getContainingDefinition() instanceof FunctionDefinition) {
            int thatStartAbsoluteOffset;
            int thisStartAbsoluteOffset = f1.getAbsoluteStart();
            if (thisStartAbsoluteOffset >= (thatStartAbsoluteOffset = f2.getAbsoluteStart())) {
                return f1;
            }
            return f2;
        }
        return null;
    }

    private static IDefinition resolveAmbiguousFunctionVariableDefinitions(ICompilerProject project, IDefinition f1, IDefinition f2) {
        VariableDefinition varDef = null;
        FunctionDefinition funcDef = null;
        if (f1 instanceof VariableDefinition) {
            assert (f2 instanceof FunctionDefinition);
            varDef = (VariableDefinition)f1;
            funcDef = (FunctionDefinition)f2;
        } else {
            assert (f1 instanceof FunctionDefinition && f2 instanceof VariableDefinition);
            varDef = (VariableDefinition)f2;
            funcDef = (FunctionDefinition)f1;
        }
        if (!AmbiguousDefinition.namesAndContainingScopeMatch(project, varDef, funcDef)) {
            return null;
        }
        if (varDef instanceof ConstantDefinition || funcDef instanceof AccessorDefinition) {
            return null;
        }
        IASScope containingScope = varDef.getContainingScope();
        IScopedDefinition containingDef = varDef.getContainingScope().getDefinition();
        if (containingDef instanceof FunctionDefinition || containingScope instanceof ASFileScope) {
            ITypeDefinition funcType;
            TypeDefinitionBase varType = varDef.resolveType(project);
            if (varType == (funcType = project.getBuiltinType(IASLanguageConstants.BuiltinType.FUNCTION))) {
                return funcDef;
            }
            ITypeDefinition anyType = project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
            if (varType == anyType) {
                return funcDef;
            }
        }
        return null;
    }

    @Override
    public boolean isInProject(ICompilerProject project) {
        return true;
    }
}

