/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.databinding;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import org.apache.royale.compiler.internal.codegen.databinding.BindingCodeGenUtils;
import org.apache.royale.compiler.internal.codegen.databinding.BindingDatabase;
import org.apache.royale.compiler.internal.codegen.databinding.BindingInfo;
import org.apache.royale.compiler.internal.codegen.databinding.FunctionWatcherInfo;
import org.apache.royale.compiler.internal.codegen.databinding.PropertyWatcherInfo;
import org.apache.royale.compiler.internal.codegen.databinding.StaticPropertyWatcherInfo;
import org.apache.royale.compiler.internal.codegen.databinding.WatcherInfoBase;
import org.apache.royale.compiler.internal.codegen.databinding.XMLWatcherInfo;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.targets.RoyaleAppSWFTarget;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAsNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.mxml.IMXMLTypeConstants;
import org.apache.royale.compiler.targets.ISWFTarget;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDataBindingNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXMLBindingDirectiveHelper {
    private static final Name NAME_OBJTYPE = new Name("Object");
    private static final Name NAME_ARRAYTYPE = new Name("Array");
    private final MXMLClassDirectiveProcessor host;
    private final IABCVisitor emitter;
    private BindingDatabase bindingDataBase = new BindingDatabase();
    private MethodInfo propertyGetter = null;

    public MXMLBindingDirectiveHelper(MXMLClassDirectiveProcessor ddp, IABCVisitor emitter) {
        this.host = ddp;
        BindingDatabase.bindingMap.put(ddp.getClassDefinition(), this.bindingDataBase);
        this.emitter = emitter;
    }

    public BindingInfo visitNode(IMXMLDataBindingNode node) {
        return this.bindingDataBase.analyze(node, this.host.getProblems(), this.host);
    }

    public void visitNode(IMXMLBindingNode node) {
        this.bindingDataBase.analyzeBindingNode(node, this.host.getProblems(), this.host);
    }

    public InstructionList getConstructorCode() {
        if (this.bindingDataBase.getBindingInfo().isEmpty()) {
            return null;
        }
        if (!this.host.getProject().getTargetSettings().getMxmlChildrenAsData() && !this.establishSDKDependencies()) {
            return null;
        }
        this.bindingDataBase.finishAnalysis();
        boolean isFlexSDK = false;
        ISWFTarget target = this.host.getProject().getSWFTarget();
        if (target instanceof RoyaleAppSWFTarget) {
            if (!((RoyaleAppSWFTarget)target).isFlexInfo()) {
                this.makeSpecialMemberVariablesForBinding();
                isFlexSDK = true;
            } else {
                this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGS, NAME_ARRAYTYPE);
            }
        } else if (this.host.getProject().resolveQNameToDefinition(this.host.getProject().getBindingManagerClass()) != null) {
            this.makeSpecialMemberVariablesForBinding();
            isFlexSDK = true;
        } else {
            this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGS, NAME_ARRAYTYPE);
        }
        if (this.host.getProject().getTargetSettings().getMxmlChildrenAsData()) {
            return this.outputBindingInfoAsData(isFlexSDK);
        }
        InstructionList ret = new InstructionList();
        this.makePropertyGetterIfNeeded();
        ret.addAll(this.makeBindingsAndGetters());
        ret.addAll(this.makeAllWatchers());
        ret.addAll(BindingCodeGenUtils.fireInitialBindings());
        return ret;
    }

    private InstructionList outputBindingInfoAsData(boolean isFlexSDK) {
        InstructionList ret = new InstructionList();
        int propertyCount = 0;
        Set<BindingInfo> bindingInfo = this.bindingDataBase.getBindingInfo();
        ret.pushNumericConstant(bindingInfo.size());
        ++propertyCount;
        for (BindingInfo bi : bindingInfo) {
            String s = bi.getSourceString();
            if (s == null && bi.isSourceSimplePublicProperty()) {
                s = this.getSourceStringFromGetter(bi.getExpressionNodesForGetter());
            }
            if (s == null || s.length() == 0 || isFlexSDK) {
                BindingCodeGenUtils.generateGetter(this.emitter, ret, bi.getExpressionNodesForGetter(), this.host.getInstanceScope());
            } else if (s.contains(".") && !isFlexSDK) {
                String[] parts = s.split("\\.");
                if (bi.classDef != null) {
                    ret.addInstruction(44, bi.classDef.getQualifiedName());
                    ret.addInstruction(44, parts[1]);
                } else {
                    for (String part : parts) {
                        ret.addInstruction(44, part);
                    }
                }
                ret.addInstruction(86, parts.length);
            } else {
                ret.addInstruction(44, s);
            }
            IExpressionNode destNode = bi.getExpressionNodeForDestination();
            if (destNode != null) {
                BindingCodeGenUtils.generateSetter(ret, destNode, this.host.getInstanceScope());
            } else {
                ret.addInstruction(32);
            }
            s = bi.getDestinationString();
            if (s == null) {
                s = "";
            }
            if (s.contains(".")) {
                String[] parts;
                for (String part : parts = s.split("\\.")) {
                    ret.addInstruction(44, part);
                }
                ret.addInstruction(86, parts.length);
            } else {
                ret.addInstruction(44, s);
            }
            propertyCount += 3;
        }
        Set<Map.Entry<Object, WatcherInfoBase>> watcherChains = this.bindingDataBase.getWatcherChains();
        if (watcherChains != null) {
            for (Map.Entry<Object, WatcherInfoBase> entry : watcherChains) {
                WatcherInfoBase watcherInfoBase = entry.getValue();
                propertyCount += this.encodeWatcher(ret, watcherInfoBase);
            }
        }
        ret.addInstruction(86, propertyCount);
        ret.addInstruction(208);
        ret.addInstruction(43);
        if (isFlexSDK) {
            ret.addInstruction(79, IMXMLTypeConstants.ARG_SETUPBINDINGS);
        } else {
            ret.addInstruction(97, IMXMLTypeConstants.NAME_BINDINGS);
        }
        return ret;
    }

    private int encodeWatcher(InstructionList ret, WatcherInfoBase watcherInfoBase) {
        ret.pushNumericConstant(watcherInfoBase.getIndex());
        WatcherInfoBase.WatcherType type = watcherInfoBase.getType();
        int propertyCount = 1;
        if (type == WatcherInfoBase.WatcherType.FUNCTION) {
            ret.pushNumericConstant(0L);
            FunctionWatcherInfo functionWatcherInfo = (FunctionWatcherInfo)watcherInfoBase;
            ret.addInstruction(44, functionWatcherInfo.getFunctionName());
            InstructionList paramFunction = new InstructionList();
            BindingCodeGenUtils.makeParameterFunction(this.emitter, paramFunction, functionWatcherInfo.params);
            ret.addAll(paramFunction);
            this.outputEventNames(ret, functionWatcherInfo.getEventNames());
            this.outputBindings(ret, functionWatcherInfo.getBindings());
            propertyCount += 5;
        } else if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY || type == WatcherInfoBase.WatcherType.PROPERTY) {
            ret.pushNumericConstant(type == WatcherInfoBase.WatcherType.STATIC_PROPERTY ? 1L : 2L);
            PropertyWatcherInfo propertyWatcherInfo = (PropertyWatcherInfo)watcherInfoBase;
            boolean makeStaticWatcher = watcherInfoBase.getType() == WatcherInfoBase.WatcherType.STATIC_PROPERTY;
            MethodInfo propertyGetterFunction = null;
            if (watcherInfoBase.isRoot && !makeStaticWatcher) {
                propertyGetterFunction = this.propertyGetter;
            } else if (!watcherInfoBase.isRoot || makeStaticWatcher) {
                // empty if block
            }
            ret.addInstruction(44, propertyWatcherInfo.getPropertyName());
            this.outputEventNames(ret, propertyWatcherInfo.getEventNames());
            this.outputBindings(ret, propertyWatcherInfo.getBindings());
            if (propertyGetterFunction == null) {
                ret.addInstruction(32);
            } else {
                ret.addInstruction(64, propertyGetterFunction);
            }
            if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY) {
                StaticPropertyWatcherInfo pwinfo = (StaticPropertyWatcherInfo)watcherInfoBase;
                Name classMName = pwinfo.getContainingClass(this.host.getProject());
                ret.addInstruction(96, classMName);
                ++propertyCount;
            }
            propertyCount += 5;
        } else if (type == WatcherInfoBase.WatcherType.XML) {
            ret.pushNumericConstant(3L);
            XMLWatcherInfo xmlWatcherInfo = (XMLWatcherInfo)watcherInfoBase;
            ret.addInstruction(44, xmlWatcherInfo.getPropertyName());
            this.outputBindings(ret, xmlWatcherInfo.getBindings());
            propertyCount += 3;
        } else assert (false);
        Set<Map.Entry<Object, WatcherInfoBase>> children = watcherInfoBase.getChildren();
        if (children != null) {
            int childCount = 0;
            for (Map.Entry<Object, WatcherInfoBase> ent : children) {
                childCount += this.encodeWatcher(ret, ent.getValue());
            }
            ret.addInstruction(86, childCount);
            ++propertyCount;
        } else {
            ret.addInstruction(32);
            ++propertyCount;
        }
        return propertyCount;
    }

    private String getSourceStringFromMemberAccessExpressionNode(MemberAccessExpressionNode node) {
        String s = "";
        IExpressionNode left = node.getLeftOperandNode();
        if (left instanceof FunctionCallNode) {
            IASNode child = ((FunctionCallNode)left).getArgumentsNode().getChild(0);
            if (child instanceof IdentifierNode) {
                s = this.getSourceStringFromIdentifierNode((IdentifierNode)child);
            } else if (child instanceof MemberAccessExpressionNode) {
                s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)child);
            }
        } else if (left instanceof MemberAccessExpressionNode) {
            s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)left);
        } else if (left instanceof IdentifierNode) {
            s = this.getSourceStringFromIdentifierNode((IdentifierNode)left);
        } else if (left instanceof BinaryOperatorAsNode) {
            if ((left = (IExpressionNode)((BinaryOperatorAsNode)left).getChild(0)) instanceof MemberAccessExpressionNode) {
                s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)left);
            } else if (left instanceof IdentifierNode) {
                s = this.getSourceStringFromIdentifierNode((IdentifierNode)left);
            } else {
                System.out.println("expected binding BinaryOperatorAsNode left node" + node.toString());
            }
        } else {
            System.out.println("expected binding member access left node" + node.toString());
        }
        s = s + ".";
        IExpressionNode right = node.getRightOperandNode();
        if (right instanceof FunctionCallNode) {
            IASNode child = ((FunctionCallNode)right).getArgumentsNode().getChild(0);
            if (child instanceof IdentifierNode) {
                s = s + this.getSourceStringFromIdentifierNode((IdentifierNode)child);
            } else if (child instanceof MemberAccessExpressionNode) {
                s = s + this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)child);
            }
        } else if (right instanceof MemberAccessExpressionNode) {
            s = s + this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)right);
        } else if (right instanceof IdentifierNode) {
            s = s + this.getSourceStringFromIdentifierNode((IdentifierNode)right);
        } else {
            System.out.println("expected binding member access right node" + node.toString());
        }
        return s;
    }

    private String getSourceStringFromIdentifierNode(IdentifierNode node) {
        return node.getName();
    }

    private String getSourceStringFromGetter(List<IExpressionNode> nodes) {
        String s = "";
        IExpressionNode node = nodes.get(0);
        if (node instanceof MemberAccessExpressionNode) {
            s = this.getSourceStringFromMemberAccessExpressionNode((MemberAccessExpressionNode)node);
        } else if (node instanceof IdentifierNode) {
            s = ((IdentifierNode)node).getName();
        }
        return s;
    }

    private void outputEventNames(InstructionList ret, List<String> events) {
        if (events.size() > 1) {
            for (String event : events) {
                ret.addInstruction(44, event);
            }
            ret.addInstruction(86, events.size());
        } else if (events.size() == 1) {
            ret.addInstruction(44, events.get(0));
        } else {
            ret.addInstruction(32);
        }
    }

    private void outputBindings(InstructionList ret, List<BindingInfo> bindings) {
        if (bindings.size() > 1) {
            for (BindingInfo binding : bindings) {
                ret.pushNumericConstant(binding.getIndex());
            }
            ret.addInstruction(86, bindings.size());
        } else if (bindings.size() == 1) {
            ret.pushNumericConstant(bindings.get(0).getIndex());
        } else {
            ret.addInstruction(32);
        }
    }

    private InstructionList makeBindingsAndGetters() {
        InstructionList insns = new InstructionList();
        MXMLBindingDirectiveHelper.log(insns, "makeBindingsAndGetters");
        for (BindingInfo bindingInfo : this.bindingDataBase.getBindingInfo()) {
            this.makeBindingAndGetter(insns, bindingInfo);
        }
        insns.addInstruction(86, this.bindingDataBase.getBindingInfo().size());
        insns.addInstruction(208);
        insns.addInstruction(43);
        insns.addInstruction(97, IMXMLTypeConstants.NAME_BINDINGS);
        this.linkTwoWayCounterparts(insns);
        MXMLBindingDirectiveHelper.log(insns, "leave makebindingsArray");
        return insns;
    }

    private void linkTwoWayCounterparts(InstructionList insns) {
        Map<Integer, Integer> pairs = this.bindingDataBase.getTwoWayBindingInfoPairs();
        Set<Map.Entry<Integer, Integer>> entries = pairs.entrySet();
        for (Map.Entry<Integer, Integer> pair : entries) {
            this.setTwoWayCounterpart(insns, pair.getKey(), pair.getValue());
            this.setTwoWayCounterpart(insns, pair.getValue(), pair.getKey());
        }
    }

    private void setTwoWayCounterpart(InstructionList insns, int dest, int src) {
        assert (dest >= 0);
        assert (src >= 0);
        assert (src != dest);
        insns.addInstruction(208);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_BINDINGS);
        insns.pushNumericConstant(dest);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(208);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_BINDINGS);
        insns.pushNumericConstant(src);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(97, IMXMLTypeConstants.NAME_TWOWAYCOUNTERPART);
    }

    private void makeBindingAndGetter(InstructionList insns, BindingInfo bindingInfo) {
        MXMLBindingDirectiveHelper.log(insns, "makeBindingAndGetter");
        InstructionList methodIsns = new InstructionList();
        if (bindingInfo.isSourceSimplePublicProperty()) {
            methodIsns.addInstruction(32);
        } else {
            BindingCodeGenUtils.generateGetter(this.emitter, methodIsns, bindingInfo.getExpressionNodesForGetter(), this.host.getInstanceScope());
        }
        if (bindingInfo.getExpressionNodeForDestination() != null) {
            BindingCodeGenUtils.generateSetter(methodIsns, bindingInfo.getExpressionNodeForDestination(), this.host.getInstanceScope());
        } else {
            methodIsns.addInstruction(32);
        }
        String destStr = bindingInfo.getDestinationString();
        String srcStr = bindingInfo.getSourceString();
        BindingCodeGenUtils.makeBinding(insns, this.host.getProject(), destStr, srcStr, methodIsns);
    }

    private boolean establishSDKDependencies() {
        RoyaleProject project = this.host.getProject();
        String[] depends = new String[]{project.getBindingClass(), project.getPropertyWatcherClass(), project.getStaticPropertyWatcherClass(), project.getFunctionReturnWatcherClass(), project.getXMLWatcherClass(), project.getBindingManagerClass()};
        ASScope scope = this.bindingDataBase.getScope();
        Workspace workspace = project.getWorkspace();
        for (String depend : depends) {
            IResolvedQualifiersReference ref = ReferenceFactory.packageQualifiedReference(workspace, depend);
            if (ref == null) {
                assert (false);
                return false;
            }
            IDefinition def = ref.resolve(project, scope, DependencyType.EXPRESSION, false);
            if (def != null) continue;
            assert (false);
            return false;
        }
        return true;
    }

    private InstructionList makeAllWatchers() {
        InstructionList insns = new InstructionList();
        MXMLBindingDirectiveHelper.log(insns, "makeWatchers");
        this.allocateNullWatchersArray(insns, this.bindingDataBase.getNumWatchers());
        insns.addInstruction(208);
        insns.addInstruction(42);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_BINDINGS);
        insns.addInstruction(213);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_WATCHERS);
        insns.addInstruction(214);
        Set<Map.Entry<Object, WatcherInfoBase>> watcherChains = this.bindingDataBase.getWatcherChains();
        if (watcherChains != null) {
            for (Map.Entry<Object, WatcherInfoBase> ent : watcherChains) {
                this.makeWatcherChain(insns, ent.getValue());
            }
        }
        MXMLBindingDirectiveHelper.log(insns, "leave makeWatchersArray");
        return insns;
    }

    private void allocateNullWatchersArray(InstructionList insns, int numWatchers) {
        MXMLBindingDirectiveHelper.log(insns, "allocateNullWatchersArray");
        for (int i = 0; i < numWatchers; ++i) {
            insns.addInstruction(32);
        }
        insns.addInstruction(86, numWatchers);
        insns.addInstruction(208);
        insns.addInstruction(43);
        insns.addInstruction(97, IMXMLTypeConstants.NAME_WATCHERS);
    }

    private void makeWatcherChain(InstructionList insns, WatcherInfoBase watcherChain) {
        MXMLBindingDirectiveHelper.log(insns, "** makeWatcherChain " + watcherChain.getIndex());
        if (watcherChain.getChildren() == null && watcherChain.getEventNames().isEmpty()) {
            MXMLBindingDirectiveHelper.log("not making watcher for non-bindable");
            if (watcherChain.getType() != WatcherInfoBase.WatcherType.FUNCTION) {
                return;
            }
        }
        this.makeWatcherAndChildren(insns, watcherChain);
        this.watcherUpdateParent(insns, watcherChain);
        this.watcherAddChildren(insns, watcherChain);
    }

    private void watcherAddChildren(InstructionList insns, WatcherInfoBase watcher) {
        Set<Map.Entry<Object, WatcherInfoBase>> children = watcher.getChildren();
        if (children == null) {
            return;
        }
        for (Map.Entry<Object, WatcherInfoBase> child : children) {
            this.watcherAddChild(insns, watcher, child.getValue());
            this.watcherAddChildren(insns, child.getValue());
        }
    }

    private void watcherAddChild(InstructionList insns, WatcherInfoBase parent, WatcherInfoBase child) {
        MXMLBindingDirectiveHelper.log(insns, "add child. parent=" + parent.getIndex() + " child=" + child.getIndex());
        insns.addInstruction(210);
        insns.pushNumericConstant(parent.getIndex());
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(215);
        insns.addInstruction(210);
        insns.pushNumericConstant(child.getIndex());
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(99, 4);
        if (child.getType() == WatcherInfoBase.WatcherType.FUNCTION) {
            insns.addInstruction(98, 4);
            insns.addInstruction(211);
            insns.addInstruction(97, IMXMLTypeConstants.NAME_PARENTWATCHER);
        }
        insns.addInstruction(211);
        insns.addInstruction(98, 4);
        insns.addInstruction(79, IMXMLTypeConstants.ARG_ADDCHILD);
    }

    private void watcherUpdateParent(InstructionList insns, WatcherInfoBase watcherInfo) {
        assert (watcherInfo.getIndex() >= 0 && watcherInfo.getIndex() < this.bindingDataBase.getNumWatchers());
        insns.addInstruction(210);
        insns.pushNumericConstant(watcherInfo.getIndex());
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        switch (watcherInfo.getType()) {
            case PROPERTY: 
            case FUNCTION: {
                insns.addInstruction(208);
                break;
            }
            case STATIC_PROPERTY: {
                StaticPropertyWatcherInfo pwinfo = (StaticPropertyWatcherInfo)watcherInfo;
                Name classMName = pwinfo.getContainingClass(this.host.getProject());
                insns.addInstruction(96, classMName);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        insns.addInstruction(79, IMXMLTypeConstants.ARG_UPDATEPARENT);
    }

    private void makeWatcherAndChildren(InstructionList insns, WatcherInfoBase watcherInfo) {
        MXMLBindingDirectiveHelper.log(insns, "makeWatchers for " + watcherInfo.getIndex());
        this.makeWatcher(insns, watcherInfo);
        Set<Map.Entry<Object, WatcherInfoBase>> children = watcherInfo.getChildren();
        if (children != null) {
            for (Map.Entry<Object, WatcherInfoBase> ent : children) {
                this.makeWatcherAndChildren(insns, ent.getValue());
            }
        }
    }

    private void makeWatcher(InstructionList insns, WatcherInfoBase watcherInfo) {
        MXMLBindingDirectiveHelper.log(insns, "makeWatcher slot " + watcherInfo.getIndex());
        insns.addInstruction(210);
        insns.pushNumericConstant(watcherInfo.getIndex());
        WatcherInfoBase.WatcherType type = watcherInfo.getType();
        if (type == WatcherInfoBase.WatcherType.FUNCTION) {
            FunctionWatcherInfo functionWatcherInfo = (FunctionWatcherInfo)watcherInfo;
            BindingCodeGenUtils.makeFunctionWatcher(insns, this.host.getProject(), this.emitter, functionWatcherInfo.getFunctionName(), functionWatcherInfo.getEventNames(), functionWatcherInfo.getBindings(), functionWatcherInfo.params);
        } else if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY || type == WatcherInfoBase.WatcherType.PROPERTY) {
            PropertyWatcherInfo propertyWatcherInfo = (PropertyWatcherInfo)watcherInfo;
            boolean makeStaticWatcher = watcherInfo.getType() == WatcherInfoBase.WatcherType.STATIC_PROPERTY;
            MethodInfo propertyGetterFunction = null;
            if (watcherInfo.isRoot && !makeStaticWatcher) {
                propertyGetterFunction = this.propertyGetter;
                assert (propertyGetterFunction != null);
            } else if (!watcherInfo.isRoot || makeStaticWatcher) {
                // empty if block
            }
            BindingCodeGenUtils.makePropertyWatcher(makeStaticWatcher, insns, propertyWatcherInfo.getPropertyName(), propertyWatcherInfo.getEventNames(), propertyWatcherInfo.getBindings(), propertyGetterFunction, this.host.getProject());
        } else if (type == WatcherInfoBase.WatcherType.XML) {
            XMLWatcherInfo xmlWatcherInfo = (XMLWatcherInfo)watcherInfo;
            BindingCodeGenUtils.makeXMLWatcher(insns, xmlWatcherInfo.getPropertyName(), xmlWatcherInfo.getBindings(), this.host.getProject());
        } else assert (false);
        ++this.bindingDataBase._watchersCreated;
        insns.addInstruction(97, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
    }

    private void makeSpecialMemberVariablesForBinding() {
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGSBYDESTINATION, NAME_OBJTYPE);
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGSBEGINWITHWORD, NAME_OBJTYPE);
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_WATCHERS, NAME_ARRAYTYPE);
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGS, NAME_ARRAYTYPE);
    }

    private void makePropertyGetterIfNeeded() {
        assert (this.propertyGetter == null);
        if (this.bindingDataBase.getRequiresPropertyGetter()) {
            this.propertyGetter = BindingCodeGenUtils.generatePropertyGetterFunction(this.emitter, this.host.getProject(), this.bindingDataBase.getScope());
        }
    }

    private static void log(String s) {
        BindingCodeGenUtils.log(s);
    }

    private static void log(InstructionList insns, String s) {
        BindingCodeGenUtils.log(insns, s);
    }
}

