/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.util.Iterator;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.ClassInfo;
import org.apache.royale.abc.semantics.InstanceInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.IClassVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.ITraitVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.IMetaInfo;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.as.codegen.DirectiveProcessor;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.definitions.AmbiguousDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.tree.as.InterfaceNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.problems.AbstractOutsideClassProblem;
import org.apache.royale.compiler.problems.AmbiguousReferenceProblem;
import org.apache.royale.compiler.problems.BadAccessInterfaceMemberProblem;
import org.apache.royale.compiler.problems.CannotExtendClassProblem;
import org.apache.royale.compiler.problems.ConstructorInInterfaceProblem;
import org.apache.royale.compiler.problems.DuplicateInterfaceDefinitionProblem;
import org.apache.royale.compiler.problems.FinalOutsideClassProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InterfaceBindablePropertyProblem;
import org.apache.royale.compiler.problems.InterfaceMethodWithBodyProblem;
import org.apache.royale.compiler.problems.InterfaceNamespaceAttributeProblem;
import org.apache.royale.compiler.problems.InvalidOverrideProblem;
import org.apache.royale.compiler.problems.NamespaceInInterfaceProblem;
import org.apache.royale.compiler.problems.NativeUsedInInterfaceProblem;
import org.apache.royale.compiler.problems.StaticOutsideClassProblem;
import org.apache.royale.compiler.problems.SyntaxProblem;
import org.apache.royale.compiler.problems.UnknownInterfaceProblem;
import org.apache.royale.compiler.problems.VarInInterfaceProblem;
import org.apache.royale.compiler.problems.VirtualOutsideClassProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;

public class InterfaceDirectiveProcessor
extends DirectiveProcessor {
    InterfaceNode interfaceNode;
    LexicalScope interfaceScope;
    IABCVisitor emitter;
    Name interfaceName;
    ITraitsVisitor itraits;
    IClassVisitor cv;
    ClassInfo cinfo = new ClassInfo();
    InstanceInfo iinfo = new InstanceInfo();

    InterfaceDirectiveProcessor(InterfaceNode in, LexicalScope enclosing_scope, IABCVisitor emitter) {
        super(enclosing_scope.getProblems());
        this.interfaceNode = in;
        this.emitter = emitter;
        this.interfaceScope = enclosing_scope.pushFrame();
        InterfaceDefinition interfDef = this.interfaceNode.getDefinition();
        this.iinfo.name = this.interfaceName = interfDef.getMName(this.interfaceScope.getProject());
        switch (SemanticUtils.getMultiDefinitionType(this.interfaceNode.getDefinition(), this.interfaceScope.getProject())) {
            case AMBIGUOUS: {
                this.interfaceScope.addProblem(new DuplicateInterfaceDefinitionProblem(in, this.interfaceName.getBaseName()));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.interfaceName != null) {
            SemanticUtils.checkScopedToDefaultNamespaceProblem(this.interfaceScope, in, interfDef, this.interfaceName.getBaseName());
        }
        Iterator<IInterfaceDefinition> ifaces = interfDef.interfaceIterator(this.interfaceScope.getProject(), false, this.interfaceScope.getProblems());
        while (ifaces.hasNext()) {
            ifaces.next();
        }
        this.iinfo.superName = null;
        IExpressionNode[] raw_interfaces = this.interfaceNode.getExtendedInterfaceNodes();
        this.iinfo.interfaceNames = new Name[raw_interfaces.length];
        for (int i = 0; i < raw_interfaces.length; ++i) {
            IExpressionNode extendedInterface = raw_interfaces[i];
            IDefinition extendedDefinition = extendedInterface.resolve(this.interfaceScope.getProject());
            if (extendedDefinition instanceof IInterfaceDefinition) {
                Name interfaceName;
                this.iinfo.interfaceNames[i] = interfaceName = ((DefinitionBase)extendedDefinition).getMName(this.interfaceScope.getProject());
            } else if (extendedDefinition instanceof ClassDefinition) {
                this.interfaceScope.addProblem(new CannotExtendClassProblem(extendedInterface, extendedDefinition.getBaseName()));
            } else if (extendedDefinition instanceof AmbiguousDefinition) {
                if (extendedInterface instanceof IIdentifierNode) {
                    this.interfaceScope.addProblem(new AmbiguousReferenceProblem(extendedInterface, ((IIdentifierNode)extendedInterface).getName()));
                } else {
                    this.interfaceScope.addProblem(new AmbiguousReferenceProblem(extendedInterface, ""));
                }
            } else if (extendedDefinition != null) {
                this.interfaceScope.addProblem(new UnknownInterfaceProblem(extendedInterface, extendedDefinition.getBaseName()));
            } else if (extendedInterface instanceof IIdentifierNode) {
                this.interfaceScope.addProblem(new UnknownInterfaceProblem(extendedInterface, ((IIdentifierNode)extendedInterface).getName()));
            } else {
                this.interfaceScope.addProblem(new UnknownInterfaceProblem(extendedInterface, ""));
            }
            if (extendedDefinition == null || !extendedDefinition.isDeprecated() || SemanticUtils.hasDeprecatedAncestor(extendedInterface)) continue;
            ICompilerProblem problem = SemanticUtils.createDeprecationProblem(extendedDefinition, extendedInterface);
            this.interfaceScope.addProblem(problem);
        }
        if (interfDef.isFinal()) {
            this.iinfo.flags |= 2;
        }
        if (!interfDef.isDynamic()) {
            this.iinfo.flags |= 1;
        }
        this.iinfo.flags |= 4;
        this.cv = emitter.visitClass(this.iinfo, this.cinfo);
        this.cv.visit();
        this.itraits = this.cv.visitInstanceTraits();
        InstructionList setup_insns = this.interfaceScope.getGlobalScope().getInitInstructions();
        setup_insns.addInstruction(101, 0);
        setup_insns.addInstruction(32);
        setup_insns.addInstruction(88, this.cinfo);
        setup_insns.addInstruction(104, this.interfaceName);
        ITraitVisitor tv = this.interfaceScope.getGlobalScope().traitsVisitor.visitClassTrait(4, this.interfaceName, 0, this.cinfo);
        this.interfaceScope.processMetadata(tv, interfDef.getAllMetaTags());
        tv.visitEnd();
    }

    void finishInterfaceDefinition() {
        this.itraits.visitEnd();
        this.cv.visitEnd();
    }

    void declareVariable(VariableNode var) {
        this.interfaceScope.addProblem(new VarInInterfaceProblem(var.getNameExpressionNode()));
    }

    void declareFunction(FunctionNode func) {
        func.parseFunctionBody(this.interfaceScope.getProblems());
        this.functionSemanticChecks(func);
        FunctionDefinition func_def = func.getDefinition();
        String interfaceBaseName = this.interfaceNode.getShortName();
        if (func_def.getBaseName().equals(interfaceBaseName)) {
            return;
        }
        MethodInfo mi = this.interfaceScope.getGenerator().createMethodInfoWithDefaultArgumentValues(this.interfaceScope, func);
        ICompilerProject project = this.interfaceScope.getProject();
        ExpressionNodeBase return_type_expr = (ExpressionNodeBase)func.getReturnTypeNode();
        if (return_type_expr != null) {
            Name return_type_name = return_type_expr.getMName(project);
            mi.setReturnType(return_type_name);
        }
        IMethodVisitor mv = this.emitter.visitMethod(mi);
        mv.visit();
        mv.visitEnd();
        Name funcName = func_def.getMName(project);
        ITraitVisitor tv = this.itraits.visitMethodTrait(InterfaceDirectiveProcessor.functionTraitKind(func, 1), funcName, 0, mi);
        IMetaInfo[] metaTags = func_def.getAllMetaTags();
        if (metaTags != null && metaTags.length > 0) {
            this.interfaceScope.processMetadata(tv, metaTags);
        }
    }

    void functionSemanticChecks(FunctionNode func) {
        Name funcName;
        FunctionDefinition func_def = func.getDefinition();
        String interfaceBaseName = this.interfaceNode.getShortName();
        if (func_def.getBaseName().equals(interfaceBaseName)) {
            this.interfaceScope.addProblem(new ConstructorInInterfaceProblem(func));
            return;
        }
        this.verifyFunctionModifiers(func);
        this.verifyFunctionNamespace(func, func_def);
        SemanticUtils.checkReturnValueHasNoTypeDeclaration(this.interfaceScope, func, func_def);
        SemanticUtils.checkParametersHaveNoTypeDeclaration(this.interfaceScope, func, func_def);
        if (func.hasBody()) {
            this.interfaceScope.addProblem(new InterfaceMethodWithBodyProblem(SemanticUtils.getFunctionProblemNode(func)));
        }
        ICompilerProject project = this.interfaceScope.getProject();
        this.interfaceScope.getMethodBodySemanticChecker().checkFunctionDecl(func);
        ITypeDefinition return_type = func_def.resolveReturnType(project);
        if (!SemanticUtils.isType(return_type)) {
            this.interfaceScope.getMethodBodySemanticChecker().addTypeProblem(func.getReturnTypeNode(), return_type, func_def.getReturnTypeAsDisplayString(), true);
        }
        if ((funcName = func_def.getMName(project)) != null) {
            this.interfaceScope.getMethodBodySemanticChecker().checkInterfaceFunctionForConflictingDefinitions(func, func_def);
        }
    }

    private void verifyFunctionNamespace(FunctionNode func, FunctionDefinition func_def) {
        INamespaceDecorationNode nsNode = func.getActualNamespaceNode();
        if (nsNode != null) {
            boolean isLanguateNS = false;
            if ("internal".equals(nsNode.getName())) {
                isLanguateNS = true;
            } else {
                INamespaceReference ns_ref = func_def.getNamespaceReference();
                if (ns_ref instanceof INamespaceDefinition.ILanguageNamespaceDefinition) {
                    isLanguateNS = true;
                }
            }
            if (isLanguateNS) {
                this.interfaceScope.addProblem(new BadAccessInterfaceMemberProblem(func));
            } else {
                this.interfaceScope.addProblem(new InterfaceNamespaceAttributeProblem(func));
            }
        }
    }

    protected void verifyFunctionModifiers(FunctionNode f) {
        FunctionDefinition functionDef;
        IExpressionNode site = f.getNameExpressionNode();
        ModifiersSet modifiersSet = f.getModifiers();
        if (modifiersSet != null) {
            ASModifier[] modifiers;
            for (ASModifier modifier : modifiers = modifiersSet.getAllModifiers()) {
                if (modifier == ASModifier.STATIC) {
                    this.interfaceScope.addProblem(new StaticOutsideClassProblem(site));
                    continue;
                }
                if (modifier == ASModifier.OVERRIDE) {
                    this.interfaceScope.addProblem(new InvalidOverrideProblem(site));
                    continue;
                }
                if (modifier == ASModifier.FINAL) {
                    this.interfaceScope.addProblem(new FinalOutsideClassProblem(site));
                    continue;
                }
                if (modifier == ASModifier.NATIVE) {
                    this.interfaceScope.addProblem(new NativeUsedInInterfaceProblem(site));
                    continue;
                }
                if (modifier == ASModifier.VIRTUAL) {
                    this.interfaceScope.addProblem(new VirtualOutsideClassProblem(site));
                    continue;
                }
                if (modifier != ASModifier.DYNAMIC) continue;
            }
            this.interfaceScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(f);
        }
        if ((functionDef = f.getDefinition()).isAbstract()) {
            if (this.interfaceScope.getProject().getAllowAbstractClasses()) {
                this.interfaceScope.addProblem(new AbstractOutsideClassProblem(site));
            } else {
                this.interfaceScope.addProblem(new SyntaxProblem(site, "abstract"));
            }
        }
    }

    void processNamespaceIdentifierDirective(NamespaceIdentifierNode ns) {
        this.interfaceScope.addProblem(new NamespaceInInterfaceProblem(ns));
    }

    void processImportDirective(ImportNode imp) {
        this.interfaceScope.getGenerator().generateInstructions(imp, 13, this.interfaceScope);
    }

    void processDirective(IASNode n) {
        switch (n.getNodeID()) {
            case NamespaceID: {
                this.interfaceScope.addProblem(new NamespaceInInterfaceProblem(n));
                break;
            }
            default: {
                super.processDirective(n);
            }
        }
    }

    void declareBindableVariable(VariableNode varNode) {
        this.interfaceScope.addProblem(new InterfaceBindablePropertyProblem(varNode));
    }
}

