/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Instruction;
import org.apache.royale.abc.semantics.InstructionFactory;
import org.apache.royale.abc.semantics.Label;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.as.codegen.Binding;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.scopes.ScopeView;
import org.apache.royale.compiler.internal.semantics.MethodBodySemanticChecker;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineFunctionLexicalScope
extends LexicalScope {
    public static final int MAX_EXPR_IN_BODY = 50;
    private final IASScope containingScope;
    private final Binding containingClassBinding;
    private final Label inlinedFunctionCallSiteLabel;
    private final Collection<ICompilerProblem> problems;

    protected InlineFunctionLexicalScope(LexicalScope enclosingFrame, IASScope containingScope, boolean storeClassBinding, FunctionNode functionNode) {
        super(enclosingFrame, true);
        this.containingScope = containingScope;
        this.inlinedFunctionCallSiteLabel = new Label();
        this.problems = new ArrayList<ICompilerProblem>();
        this.methodBodySemanticChecker = new MethodBodySemanticChecker(this);
        this.containingClassBinding = storeClassBinding ? this.allocateTemp() : null;
        ScopedBlockNode body = functionNode.getScopedNode();
        FunctionDefinition functionDefinition = functionNode.getDefinition();
        this.setInitialControlFlowRegionNode(body);
        this.setLocalASScope(functionDefinition.getContainedScope());
        this.resetDebugInfo();
        this.setDebugFile(SemanticUtils.getFileName(functionNode));
    }

    public void assignActualsToFormals(FunctionDefinition functionDef, InstructionList result) {
        ParameterDefinition[] params = functionDef.getParameters();
        HashSet<String> uniqueParamNames = new HashSet<String>();
        for (int i = params.length - 1; i >= 0; --i) {
            String paramName = params[i].getBaseName();
            Binding paramBinding = this.getBinding(params[i]);
            if (paramBinding == null || uniqueParamNames.contains(paramName)) continue;
            result.addInstruction(paramBinding.setlocal());
            uniqueParamNames.add(paramName);
        }
    }

    public void mergeIntoContainingScope(InstructionList result) {
        Collection<Binding> localBindings = this.getLocalBindings();
        if (!localBindings.isEmpty()) {
            ArrayList<Binding> inlinedBindings = new ArrayList<Binding>(localBindings.size());
            for (Binding localBinding : localBindings) {
                inlinedBindings.add(localBinding);
                this.releaseTemp(localBinding);
            }
            this.getEnclosingFrame().addInlinedBindings(inlinedBindings);
        }
        this.getEnclosingFrame().addHasNexts(this.getHasNexts());
        this.getEnclosingFrame().mergeTemps(this);
    }

    @Override
    public boolean insideInlineFunction() {
        return true;
    }

    @Override
    protected Binding getThisBinding(IdentifierNode id) {
        if (this.containingClassBinding != null) {
            return this.containingClassBinding;
        }
        return super.getThisBinding(id);
    }

    @Override
    public InstructionList findProperty(Name name, IDefinition def, boolean useStrict) {
        if (def == null) {
            return super.findProperty(name, def, useStrict);
        }
        InstructionList result = new InstructionList(def.isStatic() ? 2 : 1);
        if (def instanceof IClassDefinition) {
            result.addInstruction(95, name);
        } else if (def.isStatic()) {
            DefinitionBase staticContainingScope = (DefinitionBase)((Object)def.getContainingScope().getDefinition());
            Name containingScopeName = staticContainingScope.getMName(this.getProject());
            result.addInstruction(95, containingScopeName);
            result.addInstruction(102, containingScopeName);
        } else if (((DefinitionBase)def).isTopLevelDefinition()) {
            result.addInstruction(95, name);
        } else if (this.containingScope instanceof ScopeView) {
            ScopeView scopeView = (ScopeView)this.containingScope;
            String baseName = name.getBaseName();
            IDefinition propertyDef = scopeView.getPropertyFromDef(this.getProject(), scopeView.getDefinition(), baseName, false);
            if (propertyDef != null) {
                result.addInstruction(this.getContainingClass());
            }
        }
        if (!result.isEmpty()) {
            return result;
        }
        return super.findProperty(name, def, useStrict);
    }

    @Override
    public InstructionList getPropertyValue(Name name, IDefinition def) {
        InstructionList findPropResult = this.findProperty(name, def, true);
        InstructionList result = new InstructionList(findPropResult.size() + 1);
        result.addAll(findPropResult);
        result.addInstruction(102, name);
        return result;
    }

    @Override
    public Collection<ICompilerProblem> getProblems() {
        return this.problems;
    }

    @Override
    InstructionList finishMethodDeclaration(boolean hasBody, String source_path) {
        assert (false) : "finishMethodDeclaration() should never be called on an inline function";
        return null;
    }

    private Instruction getContainingClass() {
        if (this.containingClassBinding != null) {
            return this.containingClassBinding.getlocal();
        }
        return InstructionFactory.getInstruction(208);
    }

    public Instruction setContainingClass() {
        assert (this.containingClassBinding != null) : "don't set the class when there is no class binding, as local0 can be used";
        return this.containingClassBinding.setlocal();
    }

    public Label getInlinedFunctionCallSiteLabel() {
        return this.inlinedFunctionCallSiteLabel;
    }
}

