/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.royale.abc.ABCLinker;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.config.RSLSettings;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.internal.clients.CLIFactory;
import org.apache.royale.compiler.internal.config.FrameInfo;
import org.apache.royale.compiler.internal.projects.ASCProject;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.targets.AppSWFTarget;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.units.ABCCompilationUnit;
import org.apache.royale.compiler.internal.units.ASCompilationUnit;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.ImportedASCompilationUnit;
import org.apache.royale.compiler.internal.units.SWCCompilationUnit;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.FileWriteProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InvalidImportFileProblem;
import org.apache.royale.compiler.problems.MultipleExternallyVisibleDefinitionsProblem;
import org.apache.royale.compiler.problems.UnfoundPropertyProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCLibrary;
import org.apache.royale.swc.ISWCManager;
import org.apache.royale.swc.ISWCScript;
import org.apache.royale.swf.Header;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.io.SWFWriter;
import org.apache.royale.utils.FilenameNormalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASC {
    private static final String DOUBLE_QUOTE = "\"";
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_ERROR = 1;
    private static final int DEFAULT_SWF_VERSION = 10;
    private static final int TARGET_AVM1 = 0;
    private static final int TARGET_AVM2 = 1;
    private static final int DEFAULT_TARGET_AVM = 1;
    private static final int DEFAULT_DIALECT = 9;
    private static final Options ASC_OPTIONS = CLIFactory.getOptionsForASC();
    private PrintStream out;
    private PrintStream err;
    private ProblemQuery problemQuery;
    private ProblemFormatter problemFormatter;
    private static final Map<String, Locale> localeMap = new ImmutableMap.Builder().put((Object)"EN", (Object)Locale.ENGLISH).put((Object)"CN", (Object)Locale.SIMPLIFIED_CHINESE).put((Object)"CS", (Object)new Locale("cs")).put((Object)"DK", (Object)new Locale("da")).put((Object)"DE", (Object)Locale.GERMAN).put((Object)"ES", (Object)new Locale("es")).put((Object)"FI", (Object)new Locale("fi")).put((Object)"FR", (Object)Locale.FRENCH).put((Object)"IT", (Object)Locale.ITALIAN).put((Object)"JP", (Object)Locale.JAPANESE).put((Object)"KR", (Object)Locale.KOREAN).put((Object)"NO", (Object)new Locale("nb")).put((Object)"NL", (Object)new Locale("nl")).put((Object)"PL", (Object)new Locale("pl")).put((Object)"BR", (Object)new Locale("pt")).put((Object)"RU", (Object)new Locale("ru")).put((Object)"SE", (Object)new Locale("sv")).put((Object)"TR", (Object)new Locale("tr")).put((Object)"TW", (Object)Locale.TRADITIONAL_CHINESE).build();
    private List<String> sourceFilenames;
    private List<String> includeFilenames;
    private List<String> importFilenames;
    private Map<String, String> configVars;
    private List<String> useNamespaces;
    private final List<String> internalLibraries = new ArrayList<String>(0);
    private final List<String> externalLibraries = new ArrayList<String>(0);
    private int apiVersion = -1;
    private int dialect = 9;
    private int targetAVM = 1;
    private boolean useStaticSemantics = false;
    private boolean showWarnings = false;
    private boolean useSanityMode = false;
    private Locale locale = Locale.ENGLISH;
    private String symbolClass = null;
    private int width = 550;
    private int height = 400;
    private int frameRate = 12;
    private boolean emitDebugInfo = false;
    private boolean emitDocInfo = false;
    private boolean emitMetadata = false;
    private boolean abcFuture = false;
    private boolean makeMovieClip = false;
    private String avmplusFilename = null;
    private boolean showBytes = false;
    private boolean showParseTrees = false;
    private boolean showInstructions = false;
    private boolean showLineNumbers = false;
    private boolean showMachineCode = false;
    private boolean showFlowGraph = false;
    private boolean showLog = false;
    private boolean optimize = false;
    private List<String> optimizerConfigs = null;
    private boolean mergeABCs = false;
    private String outputDirectory = null;
    private String outputBasename = null;
    private boolean parallel = false;
    private boolean enableInlining = false;
    private boolean removeDeadCode = false;
    private final ArrayList<IASNode> rootedSyntaxTrees = new ArrayList();

    private void printHeader() {
        this.out.println("ActionScript 3.0 Compiler for AVM+");
        this.out.println(VersionInfo.buildMessage());
    }

    private void printHelp(String commandLine, boolean showUsage) {
        PrintWriter pw = new PrintWriter(this.out);
        pw.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 72, commandLine, "       FILENAME...\noptions:", ASC_OPTIONS, 1, 3, null, showUsage);
        pw.flush();
    }

    private void printUsage(String commandLine) {
        PrintWriter pw = new PrintWriter(this.out);
        pw.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(pw, 72, commandLine, ASC_OPTIONS);
        pw.println("       FILENAME...");
        pw.flush();
    }

    public static void main(String[] args) {
        ASC asc = new ASC();
        int exitStatus = asc.mainNoExit(args);
        System.exit(exitStatus);
    }

    public int mainNoExit(String[] args) {
        return this.mainNoExit(args, System.out, System.err);
    }

    public int mainNoExit(String[] args, PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
        boolean showHelp = false;
        boolean clientSuccess = false;
        try {
            PosixParser cliParser = new PosixParser();
            CommandLine commandLine = cliParser.parse(ASC_OPTIONS, args);
            if (commandLine.hasOption("h")) {
                showHelp = true;
            } else {
                clientSuccess = this.createClient(commandLine);
            }
        }
        catch (ParseException ex) {
            err.println("Command-Line Error: " + ex.getMessage());
        }
        int exitStatus = 0;
        if (clientSuccess && !this.getSourceFilenames().isEmpty()) {
            exitStatus = this.main();
        } else {
            exitStatus = 1;
            if (showHelp) {
                this.printHeader();
                this.printHelp("asc", true);
            } else {
                this.printHeader();
                this.printUsage("asc");
            }
        }
        return exitStatus;
    }

    public String getProblems() {
        StringBuffer problems = new StringBuffer();
        if (this.problemQuery != null && this.problemQuery.hasFilteredProblems()) {
            for (ICompilerProblem problem : this.problemQuery.getFilteredProblems()) {
                problems.append(this.problemFormatter.format(problem));
            }
        }
        return problems.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int main() {
        int exitStatus = 0;
        Workspace workspace = new Workspace();
        try {
            boolean success = this.compileSourceFiles(workspace, this.getSourceFilenames());
            if (!success) {
                exitStatus = 1;
            }
        }
        catch (Exception e) {
            this.err.println(e.getMessage());
            e.printStackTrace();
            exitStatus = 1;
        }
        finally {
            workspace.close();
        }
        return exitStatus;
    }

    private Collection<ICompilationUnit> getCompilationUnitsForLibraries(CompilerProject project, Collection<String> swcFilePaths) {
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>();
        ISWCManager swcManager = project.getWorkspace().getSWCManager();
        int order = 0;
        for (String swcFilePath : swcFilePaths) {
            if (!swcFilePath.toLowerCase().endsWith(".swc")) {
                throw new RuntimeException("You can only import SWC libraries.");
            }
            ISWC swc = swcManager.get(new File(swcFilePath));
            for (ISWCLibrary library : swc.getLibraries()) {
                for (ISWCScript script : library.getScripts()) {
                    ArrayList<String> qnames = new ArrayList<String>(script.getDefinitions().size());
                    for (String definitionQName : script.getDefinitions()) {
                        qnames.add(definitionQName.replace(":", "."));
                    }
                    SWCCompilationUnit cu = new SWCCompilationUnit(project, swc, library, script, qnames, order);
                    result.add(cu);
                }
            }
            ++order;
        }
        return result;
    }

    private static String normalizeDirectoryName(String inputDirectoryName) {
        String normalizedSeparators = FilenameUtils.separatorsToSystem((String)inputDirectoryName);
        if (inputDirectoryName.endsWith(File.separator)) {
            return normalizedSeparators;
        }
        return normalizedSeparators + File.separator;
    }

    private boolean compileSourceFiles(Workspace workspace, List<String> sourceFilenames) throws InterruptedException {
        boolean success = true;
        long startTime = System.nanoTime();
        int problemCount = 0;
        this.problemQuery = new ProblemQuery();
        this.problemQuery.setShowProblemByClass(MultipleExternallyVisibleDefinitionsProblem.class, false);
        this.problemQuery.setShowProblemByClass(UnfoundPropertyProblem.class, false);
        this.problemQuery.setShowStrictSemantics(this.useStaticSemantics());
        this.problemQuery.setShowWarnings(this.getShowWarnings());
        LinkedHashSet<ICompilationUnit> mainUnits = new LinkedHashSet<ICompilationUnit>(this.getSourceFilenames().size());
        final HashMap<ASCompilationUnit, Integer> unitOrdering = new HashMap<ASCompilationUnit, Integer>();
        ASCProject applicationProject = this.createProject(workspace, this.problemQuery);
        ArrayList<ICompilerProblem> configProblems = new ArrayList<ICompilerProblem>();
        applicationProject.collectProblems(configProblems);
        this.problemQuery.addAll(configProblems);
        int i = 0;
        for (String sourceFilename : sourceFilenames) {
            ICompilerProblem[] problems;
            if (i > 0 && !this.getMergeABCs()) {
                applicationProject = this.createProject(workspace, this.problemQuery);
                mainUnits.clear();
                unitOrdering.clear();
                this.problemQuery.clear();
            }
            FileSpecification sourceFileSpec = new FileSpecification(sourceFilename);
            workspace.fileAdded(sourceFileSpec);
            ASCompilationUnit cu = ASCompilationUnit.createMainCompilationUnitForASC(applicationProject, sourceFileSpec, this);
            mainUnits.add(cu);
            unitOrdering.put(cu, unitOrdering.size());
            applicationProject.addCompilationUnit(cu);
            applicationProject.updatePublicAndInternalDefinitions(Collections.singletonList(cu));
            this.rootedSyntaxTrees.add(cu.getSyntaxTreeRequest().get().getAST());
            for (ICompilationUnit compilationUnit : applicationProject.getCompilationUnits()) {
                problems = compilationUnit.getSyntaxTreeRequest().get().getProblems();
                this.problemQuery.addAll(problems);
            }
            if (this.getShowParseTrees()) {
                Iterator<ICompilationUnit> outputSyntaxFilename = FilenameUtils.removeExtension((String)sourceFilename).concat(".p");
                try {
                    PrintWriter syntaxFile = new PrintWriter((String)((Object)outputSyntaxFilename));
                    IASNode ast = cu.getSyntaxTreeRequest().get().getAST();
                    if (ast instanceof FileNode) {
                        FileNode fileNode = (FileNode)ast;
                        ImmutableSet skeletonProblems = ImmutableSet.copyOf(fileNode.getProblems());
                        if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                            System.out.println("ASC waiting for lock in populateFunctionNodes");
                        }
                        fileNode.populateFunctionNodes();
                        if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                            System.out.println("ASC done with lock in populateFunctionNodes");
                        }
                        ImmutableSet allProblems = ImmutableSet.copyOf(fileNode.getProblems());
                        Sets.SetView difference = Sets.difference((Set)skeletonProblems, (Set)allProblems);
                        this.problemQuery.addAll((Iterable<ICompilerProblem>)difference);
                    }
                    syntaxFile.println(ast);
                    syntaxFile.flush();
                    syntaxFile.close();
                }
                catch (FileNotFoundException e) {
                    this.problemQuery.add(new FileWriteProblem(e));
                }
            }
            if (!this.getMergeABCs() || this.getMergeABCs() && i == sourceFilenames.size() - 1) {
                String specifiedOutputDirectory;
                for (ICompilationUnit compilationUnit : applicationProject.getCompilationUnits()) {
                    compilationUnit.startBuildAsync(ITarget.TargetType.SWF);
                }
                for (ICompilationUnit compilationUnit : applicationProject.getCompilationUnits()) {
                    problems = compilationUnit.getOutgoingDependenciesRequest().get().getProblems();
                    this.problemQuery.addAll(problems);
                }
                String outputFileBaseName = FilenameUtils.getBaseName((String)sourceFilename);
                String outputDirectoryName = FilenameUtils.getFullPath((String)sourceFilename);
                if (this.getMergeABCs() && this.getOutputBasename() != null) {
                    outputFileBaseName = this.getOutputBasename();
                }
                if (!Strings.isNullOrEmpty((String)(specifiedOutputDirectory = this.getOutputDirectory()))) {
                    outputDirectoryName = ASC.normalizeDirectoryName(specifiedOutputDirectory);
                }
                if (this.isGenerateSWF()) {
                    boolean swfBuilt = this.generateSWF(outputDirectoryName, outputFileBaseName, applicationProject, mainUnits, sourceFilename, this.problemQuery, startTime);
                    if (!swfBuilt) {
                        success = false;
                    }
                } else {
                    boolean abcBuilt;
                    SequencedCollection<ICompilationUnit> units = mainUnits;
                    if (this.getMergeABCs()) {
                        units = applicationProject.getDependencyGraph().topologicalSort(mainUnits, new Comparator<ICompilationUnit>(){

                            @Override
                            public int compare(ICompilationUnit o1, ICompilationUnit o2) {
                                return (unitOrdering.containsKey(o2) ? (Integer)unitOrdering.get(o2) : 0) - (unitOrdering.containsKey(o1) ? (Integer)unitOrdering.get(o1) : 0);
                            }
                        });
                        ArrayList<ICompilationUnit> sourceUnits = new ArrayList<ICompilationUnit>(mainUnits.size());
                        for (ICompilationUnit unit : units) {
                            if (!mainUnits.contains(unit)) continue;
                            sourceUnits.add(unit);
                        }
                        units = sourceUnits;
                    }
                    if (!(abcBuilt = this.generateABCFile(outputDirectoryName, outputFileBaseName, applicationProject, units, sourceFilename, this.problemQuery, startTime))) {
                        success = false;
                    }
                }
                CompilerProblemCategorizer compilerProblemCategorizer = new CompilerProblemCategorizer();
                this.problemFormatter = new WorkspaceProblemFormatter(workspace, compilerProblemCategorizer);
                ProblemPrinter printer = new ProblemPrinter(this.problemFormatter, this.err);
                problemCount += printer.printProblems(this.problemQuery.getFilteredProblems());
                startTime = System.nanoTime();
            }
            ++i;
        }
        if (problemCount > 0) {
            ArrayList<ICompilerProblem> errors = new ArrayList<ICompilerProblem>();
            ArrayList<ICompilerProblem> warnings = new ArrayList<ICompilerProblem>();
            this.problemQuery.getErrorsAndWarnings(errors, warnings);
            int errorCount = errors.size();
            int warningCount = warnings.size();
            if (errorCount == 1) {
                this.err.println();
                this.err.println("1 error found");
            } else if (errorCount > 1) {
                this.err.println();
                this.err.println(errorCount + " errors found");
            }
            if (warningCount == 1) {
                this.err.println();
                this.err.println("1 warning found");
            } else if (warningCount > 1) {
                this.err.println();
                this.err.println(warningCount + " warnings found");
            }
            if (success && errorCount > 0) {
                success = false;
            }
        }
        return success;
    }

    private ASCProject createProject(Workspace workspace, ProblemQuery problemQuery) throws InterruptedException {
        ASCProject applicationProject = new ASCProject(workspace, this.dialect == 10);
        this.setupConfigVars(applicationProject);
        applicationProject.setUseParallelCodeGeneration(this.getParallel());
        ArrayList<ICompilationUnit> compilationUnits = new ArrayList<ICompilationUnit>();
        for (String importFilename : this.getImportFilenames()) {
            CompilationUnitBase cu;
            String lcFilename = importFilename.toLowerCase();
            if (lcFilename.endsWith(".abc")) {
                cu = new ABCCompilationUnit(applicationProject, importFilename);
                compilationUnits.add(cu);
                continue;
            }
            if (lcFilename.endsWith(".as")) {
                cu = new ImportedASCompilationUnit(applicationProject, importFilename, DefinitionPriority.BasePriority.SOURCE_LIST);
                compilationUnits.add(cu);
                continue;
            }
            problemQuery.add(new InvalidImportFileProblem(importFilename));
        }
        ArrayList<String> libraries = new ArrayList<String>(this.externalLibraries.size() + this.internalLibraries.size());
        libraries.addAll(this.externalLibraries);
        libraries.addAll(this.internalLibraries);
        Collection<ICompilationUnit> allLibraryCUs = this.getCompilationUnitsForLibraries(applicationProject, libraries);
        compilationUnits.addAll(allLibraryCUs);
        applicationProject.setCompilationUnits(compilationUnits);
        applicationProject.setEnableInlining(this.isInliningEnabled());
        return applicationProject;
    }

    private void setupConfigVars(ASCProject applicationProject) {
        Map<String, String> vars = this.getConfigVars();
        if (vars != null) {
            applicationProject.addConfigVariables(vars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateABCFile(String outputDirectoryName, String outputBaseName, ASCProject applicationProject, Collection<ICompilationUnit> compilationUnits, String sourceFilename, ProblemQuery problemQuery, long startTime) throws InterruptedException {
        boolean success;
        block13: {
            success = true;
            byte[] abcBytes = null;
            Collection<ICompilerProblem> fatalProblems = applicationProject.getFatalProblems();
            ArrayList<byte[]> abcList = new ArrayList<byte[]>();
            if (fatalProblems.isEmpty()) {
                for (ICompilationUnit cu : compilationUnits) {
                    IABCBytesRequestResult codegenResult = cu.getABCBytesRequest().get();
                    abcBytes = codegenResult.getABCBytes();
                    abcList.add(abcBytes);
                    problemQuery.addAll(codegenResult.getProblems());
                }
            } else {
                problemQuery.addAll(fatalProblems);
            }
            try {
                problemQuery.setShowWarnings(false);
                if (!problemQuery.hasFilteredProblems()) {
                    assert (abcBytes != null);
                    try {
                        if (!this.getEmitDebugInfo() || !this.getABCFuture() || this.getMergeABCs() || this.getOptimize() || this.isInliningEnabled()) {
                            ABCLinker.ABCLinkerSettings settings = new ABCLinker.ABCLinkerSettings();
                            settings.setStripDebugOpcodes(!this.getEmitDebugInfo());
                            settings.setOptimize(this.getOptimize());
                            settings.setEnableInlining(this.isInliningEnabled());
                            settings.setKeepMetadata(this.getEmitMetadata() ? null : Collections.emptyList());
                            settings.setStripGotoDefinitionHelp(true);
                            settings.setRemoveDeadCode(this.getRemoveDeadCode());
                            ArrayList<ICompilerProblem> linkerProblems = new ArrayList<ICompilerProblem>();
                            settings.setProblemsCollection(linkerProblems);
                            abcBytes = ABCLinker.linkABC(abcList, this.getMajorABCVersion(), this.getMinorABCVersion(), settings);
                            problemQuery.addAll(linkerProblems);
                        }
                    }
                    catch (Exception settings) {
                        // empty catch block
                    }
                    String outputABCBaseNameWithExt = outputBaseName + ".abc";
                    File outputABCFile = new File(outputDirectoryName + outputABCBaseNameWithExt);
                    try {
                        BufferedOutputStream abcFile = new BufferedOutputStream(new FileOutputStream(outputABCFile));
                        ((OutputStream)abcFile).write(abcBytes);
                        ((OutputStream)abcFile).flush();
                        ((OutputStream)abcFile).close();
                        this.out.format("%s, %d bytes written in %5.3f seconds\n", outputABCFile.toString(), abcBytes.length, (double)(System.nanoTime() - startTime) / 1.0E9);
                    }
                    catch (IOException e) {
                        problemQuery.add(new FileWriteProblem(e));
                        success = false;
                    }
                    break block13;
                }
                success = false;
            }
            finally {
                problemQuery.setShowWarnings(this.getShowWarnings());
            }
        }
        return success;
    }

    private int getMinorABCVersion() {
        return 16;
    }

    private int getMajorABCVersion() {
        return 46;
    }

    private boolean generateSWF(String outputDirectoryName, String outputBaseName, ASCProject applicationProject, Set<ICompilationUnit> compilationUnits, String sourceFilename, ProblemQuery problemQuery, long startTime) throws InterruptedException {
        boolean success = true;
        AppSWFTarget target = new AppSWFTarget(applicationProject, new ASCTargetSettings(sourceFilename), null, compilationUnits);
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        ISWF swf = target.build(problemsBuildingSWF);
        if (swf != null) {
            swf.setTopLevelClass(this.getSymbolClass());
            SWFWriter writer = new SWFWriter(swf, Header.Compression.NONE);
            String outputFileNameWithExt = outputBaseName + ".swf";
            File outputFile = new File(outputDirectoryName + outputFileNameWithExt);
            try {
                CountingOutputStream output = new CountingOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)));
                writer.writeTo((OutputStream)output);
                output.flush();
                output.close();
                writer.close();
                this.out.format("%s, %d bytes written in %5.3f seconds\n", outputFile.toString(), output.getByteCount(), (double)(System.nanoTime() - startTime) / 1.0E9);
            }
            catch (IOException e) {
                problemQuery.add(new FileWriteProblem(e));
                success = false;
            }
        } else {
            this.err.println("Unable to build SWF.");
            success = false;
        }
        problemQuery.addAll(problemsBuildingSWF);
        return success;
    }

    private static Locale getLocaleForLanguage(String language) throws MissingArgumentException {
        Locale result = localeMap.get(language);
        if (result != null) {
            return result;
        }
        throw new MissingArgumentException("Language option must be one of: " + Joiner.on((String)", ").join(localeMap.keySet()));
    }

    private Boolean createClient(CommandLine line) throws ParseException {
        Option[] options = line.getOptions();
        if (options == null) {
            return false;
        }
        for (int i = 0; i < options.length; ++i) {
            String value;
            Option option = options[i];
            String shortName = option.getOpt();
            if ("import".equals(shortName)) {
                String[] imports = option.getValues();
                for (int j = 0; j < imports.length; ++j) {
                    this.addImportFilename(imports[j]);
                }
                continue;
            }
            if ("in".equals(shortName)) {
                String[] includes = option.getValues();
                for (int j = 0; j < includes.length; ++j) {
                    this.addIncludeFilename(includes[j]);
                }
                continue;
            }
            if ("swf".equals(shortName)) {
                String[] swfValues = option.getValue().split(",");
                if (swfValues.length < 3) {
                    throw new MissingArgumentException("The swf option requires three arguments, only " + swfValues.length + " were found.");
                }
                for (int j = 0; j < swfValues.length; ++j) {
                    String value2 = swfValues[j];
                    if (j == 0) {
                        this.setSymbolClass(value2);
                        continue;
                    }
                    if (j == 1) {
                        this.setWidth(value2);
                        continue;
                    }
                    if (j == 2) {
                        this.setHeight(value2);
                        continue;
                    }
                    if (j != 3) continue;
                    this.setFrameRate(value2);
                }
                continue;
            }
            if ("use".equals(shortName)) {
                String[] namespaces;
                for (String namespace : namespaces = option.getValues()) {
                    this.addNamespace(namespace);
                }
                continue;
            }
            if ("config".equals(shortName)) {
                String[] config = option.getValues();
                if (config.length != 2) continue;
                String name = config[0];
                String value3 = config[1];
                value3 = this.fixupMissingQuote(value3);
                this.putConfigVar(name, value3);
                continue;
            }
            if ("strict".equals(shortName) || "!".equals(shortName)) {
                this.setUseStaticSemantics(true);
                continue;
            }
            if ("d".equals(shortName)) {
                this.setEmitDebugInfo(true);
                continue;
            }
            if ("warnings".equals(shortName) || "coach".equals(shortName)) {
                if ("coach".equals(shortName)) {
                    this.err.println("'coach' has been deprecated. Please use 'warnings' instead.");
                }
                this.setShowWarnings(true);
                continue;
            }
            if ("log".equals(shortName)) {
                this.setShowLog(true);
                continue;
            }
            if ("md".equals(shortName)) {
                this.setEmitMetadata(true);
                continue;
            }
            if ("merge".equals(shortName)) {
                this.setMergeABCs(true);
                continue;
            }
            if ("language".equals(shortName)) {
                value = option.getValue();
                this.setLocale(ASC.getLocaleForLanguage(value));
                continue;
            }
            if ("doc".equals(shortName)) {
                this.setEmitDocInfo(true);
                continue;
            }
            if ("avmtarget".equals(shortName)) {
                value = option.getValue();
                this.setTargetAVM(value);
                continue;
            }
            if ("AS3".equals(shortName)) {
                this.setDialect("AS3");
                continue;
            }
            if ("ES".equals(shortName)) {
                this.setDialect("ES");
                continue;
            }
            if ("o".equalsIgnoreCase(shortName) || "optimize".equalsIgnoreCase(shortName)) {
                this.setOptimize(true);
                continue;
            }
            if ("o2".equalsIgnoreCase(shortName)) {
                this.setOptimize(true);
                continue;
            }
            if ("out".equalsIgnoreCase(shortName)) {
                this.setOutputBasename(option.getValue());
                continue;
            }
            if ("outdir".equalsIgnoreCase(shortName)) {
                this.setOutputDirectory(option.getValue());
                continue;
            }
            if ("abcfuture".equals(shortName)) {
                this.setABCFuture(true);
                continue;
            }
            if ("p".equals(shortName)) {
                this.setShowParseTrees(true);
                continue;
            }
            if ("i".equals(shortName)) {
                this.setShowInstructions(true);
                continue;
            }
            if ("m".equals(shortName)) {
                this.setShowMachineCode(true);
                continue;
            }
            if ("f".equals(shortName)) {
                this.setShowFlowGraph(true);
                continue;
            }
            if ("exe".equals(shortName)) {
                String exe = option.getValue();
                this.setAvmplusFilename(exe);
                continue;
            }
            if ("movieclip".equals(shortName)) {
                this.setMakeMovieClip(true);
                continue;
            }
            if ("ES4".equals(shortName)) {
                this.setDialect("ES4");
                continue;
            }
            if ("li".equals(shortName)) {
                this.internalLibraries.add(option.getValue());
                continue;
            }
            if ("le".equals(shortName)) {
                this.externalLibraries.add(option.getValue());
                continue;
            }
            if ("parallel".equals(shortName)) {
                this.setParallel(true);
                continue;
            }
            if ("inline".equals(shortName)) {
                this.setMergeABCs(true);
                this.setEnableInlining(true);
                continue;
            }
            if ("removedeadcode".equals(shortName)) {
                this.setRemoveDeadCode(true);
                continue;
            }
            throw new UnrecognizedOptionException("Unrecognized option '" + shortName + "'", shortName);
        }
        String[] remainingArgs = line.getArgs();
        if (remainingArgs != null) {
            for (int i = 0; i < remainingArgs.length; ++i) {
                this.addSourceFilename(remainingArgs[i]);
            }
        } else {
            throw new MissingArgumentException("At least one source file must be specified after the list of options.");
        }
        return true;
    }

    private String fixupMissingQuote(String value) {
        if (value.endsWith(DOUBLE_QUOTE)) {
            value = value.concat(DOUBLE_QUOTE);
        } else {
            String[] values = value.split(DOUBLE_QUOTE);
            if (values.length % 2 == 0) {
                value = value.concat(DOUBLE_QUOTE);
            }
        }
        return value;
    }

    public List<String> getSourceFilenames() {
        if (this.sourceFilenames == null) {
            this.sourceFilenames = new ArrayList<String>();
        }
        return this.sourceFilenames;
    }

    public void addSourceFilename(String source) {
        this.getSourceFilenames().add(source);
    }

    public List<String> getIncludeFilenames() {
        if (this.includeFilenames == null) {
            this.includeFilenames = new ArrayList<String>();
        }
        return this.includeFilenames;
    }

    public void addIncludeFilename(String filename) {
        String includeFile = FilenameNormalization.normalize(filename);
        this.getIncludeFilenames().add(includeFile);
    }

    public List<String> getImportFilenames() {
        if (this.importFilenames == null) {
            this.importFilenames = new ArrayList<String>();
        }
        return this.importFilenames;
    }

    public void addImportFilename(String filename) {
        this.getImportFilenames().add(filename);
    }

    public List<String> getInternalLibraries() {
        return this.internalLibraries;
    }

    public List<String> getExternalLibraries() {
        return this.externalLibraries;
    }

    public Map<String, String> getConfigVars() {
        if (this.configVars == null) {
            this.configVars = new LinkedHashMap<String, String>();
        }
        return this.configVars;
    }

    public void putConfigVar(String key, String value) {
        this.getConfigVars().put(key, value);
    }

    public List<String> getNamespaces() {
        if (this.useNamespaces == null) {
            this.useNamespaces = new ArrayList<String>();
        }
        return this.useNamespaces;
    }

    public void addNamespace(String namespace) {
        this.getNamespaces().add(namespace);
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String version) {
        this.apiVersion = Integer.parseInt(version.trim());
    }

    public int getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        if ("AS3".equalsIgnoreCase(dialect)) {
            this.dialect = 10;
        } else if ("ES".equalsIgnoreCase(dialect)) {
            this.dialect = 9;
        } else if ("ES4".equalsIgnoreCase(dialect)) {
            this.dialect = 11;
        } else {
            throw new IllegalArgumentException("Illegal dialect '" + dialect + "'");
        }
    }

    public int getTargetAVM() {
        return this.targetAVM;
    }

    public void setTargetAVM(String version) {
        int v = Integer.parseInt(version.trim());
        if (v != 0 && v != 1) {
            throw new IllegalArgumentException("Illegal target AVM version '" + version + "'");
        }
        this.targetAVM = v;
    }

    public boolean useStaticSemantics() {
        return this.useStaticSemantics;
    }

    public void setUseStaticSemantics(boolean useStaticSemantics) {
        this.useStaticSemantics = useStaticSemantics;
    }

    public boolean getShowWarnings() {
        return this.showWarnings;
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public boolean getUseSanityMode() {
        return this.useSanityMode;
    }

    public void setUseSanityMode(boolean useSanityMode) {
        this.useSanityMode = useSanityMode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean getMakeMovieClip() {
        return this.makeMovieClip;
    }

    public void setMakeMovieClip(boolean makeMovieClip) {
        this.makeMovieClip = makeMovieClip;
    }

    public String getSymbolClass() {
        return this.symbolClass;
    }

    public void setSymbolClass(String symbolClass) {
        this.symbolClass = symbolClass;
    }

    public boolean isGenerateSWF() {
        return this.symbolClass != null;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = Integer.parseInt(width.trim());
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = Integer.parseInt(height.trim());
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(String frameRate) {
        this.frameRate = Integer.parseInt(frameRate.trim());
    }

    public boolean getEmitDebugInfo() {
        return this.emitDebugInfo;
    }

    public boolean getABCFuture() {
        return this.abcFuture;
    }

    public void setABCFuture(boolean b) {
        this.abcFuture = b;
    }

    public void setEmitDebugInfo(boolean emitDebugInfo) {
        this.emitDebugInfo = emitDebugInfo;
    }

    public boolean getEmitDocInfo() {
        return this.emitDocInfo;
    }

    public void setEmitDocInfo(boolean emitDocInfo) {
        this.emitDocInfo = emitDocInfo;
    }

    public boolean getEmitMetadata() {
        return this.emitMetadata;
    }

    public void setEmitMetadata(boolean emitMetadata) {
        this.emitMetadata = emitMetadata;
    }

    public String getAvmplusFilename() {
        return this.avmplusFilename;
    }

    public void setAvmplusFilename(String filename) {
        this.avmplusFilename = filename;
    }

    public boolean getShowBytes() {
        return this.showBytes;
    }

    public void setShowBytes(boolean showBytes) {
        this.showBytes = showBytes;
    }

    public boolean getShowParseTrees() {
        return this.showParseTrees;
    }

    public void setShowParseTrees(boolean showParseTrees) {
        this.showParseTrees = showParseTrees;
    }

    public boolean getShowInstructions() {
        return this.showInstructions;
    }

    public void setShowInstructions(boolean showInstructions) {
        this.showInstructions = showInstructions;
    }

    public boolean getShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
    }

    public boolean getShowMachineCode() {
        return this.showMachineCode;
    }

    public void setShowMachineCode(boolean showMachineCode) {
        this.showMachineCode = showMachineCode;
    }

    public boolean getShowFlowGraph() {
        return this.showFlowGraph;
    }

    public void setShowFlowGraph(boolean showFlowGraph) {
        this.showFlowGraph = showFlowGraph;
    }

    public boolean getShowLog() {
        return this.showLog;
    }

    public void setShowLog(boolean showLog) {
        this.showLog = showLog;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public List<String> getOptimizerConfigs() {
        if (this.optimizerConfigs == null) {
            this.optimizerConfigs = new ArrayList<String>();
        }
        return this.optimizerConfigs;
    }

    public void addOptimizerConfig(String value) {
        this.getOptimizerConfigs().add(value);
    }

    public boolean getMergeABCs() {
        return this.mergeABCs;
    }

    public void setMergeABCs(boolean mergeABCs) {
        this.mergeABCs = mergeABCs;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputBasename() {
        return this.outputBasename;
    }

    public void setOutputBasename(String outputBasename) {
        this.outputBasename = outputBasename;
    }

    public boolean getParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isInliningEnabled() {
        return this.enableInlining;
    }

    public void setEnableInlining(boolean enableInlining) {
        this.enableInlining = enableInlining;
    }

    public void setRemoveDeadCode(boolean removeDeadCode) {
        this.removeDeadCode = removeDeadCode;
    }

    public boolean getRemoveDeadCode() {
        return this.removeDeadCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ASCTargetSettings
    implements ITargetSettings {
        Set<String> externalLibrariesSet;
        final String rootSourceFile;

        ASCTargetSettings(String rootSourceFile) {
            this.rootSourceFile = rootSourceFile;
        }

        @Override
        public boolean isAccessible() {
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            return ASC.this.getEmitDebugInfo();
        }

        @Override
        public boolean isTelemetryEnabled() {
            return false;
        }

        @Override
        public boolean isOptimized() {
            return ASC.this.getOptimize();
        }

        @Override
        public boolean useCompression() {
            return false;
        }

        @Override
        public boolean allowSubclassOverrides() {
            return false;
        }

        @Override
        public boolean areVerboseStacktracesEnabled() {
            return false;
        }

        @Override
        public Collection<String> getASMetadataNames() {
            return ASC.this.getEmitMetadata() ? null : Collections.emptyList();
        }

        @Override
        public File getDefaultCSS() {
            return null;
        }

        @Override
        public int getDefaultBackgroundColor() {
            return 0;
        }

        @Override
        public int getDefaultFrameRate() {
            return ASC.this.getFrameRate();
        }

        @Override
        public boolean areDefaultScriptLimitsSet() {
            return false;
        }

        @Override
        public int getDefaultScriptTimeLimit() {
            return 0;
        }

        @Override
        public int getDefaultScriptRecursionLimit() {
            return 0;
        }

        @Override
        public int getDefaultWidth() {
            return ASC.this.getWidth();
        }

        @Override
        public int getDefaultHeight() {
            return ASC.this.getHeight();
        }

        @Override
        public Collection<String> getExterns() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getIncludes() {
            return Collections.emptyList();
        }

        @Override
        public List<FrameInfo> getFrameLabels() {
            return Collections.emptyList();
        }

        @Override
        public String getSWFMetadata() {
            return null;
        }

        @Override
        public int getSWFVersion() {
            return 10;
        }

        @Override
        public String getPreloaderClassName() {
            return null;
        }

        @Override
        public String getRootSourceFileName() {
            return this.rootSourceFile;
        }

        @Override
        public String getRootClassName() {
            return ASC.this.getSymbolClass();
        }

        @Override
        public boolean keepAllTypeSelectors() {
            return false;
        }

        @Override
        public boolean useNetwork() {
            return false;
        }

        @Override
        public List<File> getThemes() {
            return Collections.emptyList();
        }

        @Override
        public boolean removeUnusedRuntimeSharedLibraryPaths() {
            return false;
        }

        @Override
        public boolean verifyDigests() {
            return false;
        }

        @Override
        public Collection<File> getExternalLibraryPath() {
            if (ASC.this.externalLibraries == null || ASC.this.externalLibraries.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<File> result = new ArrayList<File>(ASC.this.externalLibraries.size());
            for (String path : ASC.this.externalLibraries) {
                result.add(new File(path));
            }
            return result;
        }

        @Override
        public Collection<File> getIncludeLibraries() {
            return Collections.emptyList();
        }

        @Override
        public Collection<File> getIncludeSources() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getRuntimeSharedLibraries() {
            return Collections.emptyList();
        }

        @Override
        public List<RSLSettings> getRuntimeSharedLibraryPath() {
            return Collections.emptyList();
        }

        @Override
        public boolean useResourceBundleMetadata() {
            return false;
        }

        @Override
        public File getOutput() {
            return null;
        }

        @Override
        public Collection<String> getIncludeClasses() {
            return Collections.emptyList();
        }

        @Override
        public Map<String, File> getIncludeFiles() {
            return Collections.emptyMap();
        }

        @Override
        public Collection<String> getIncludeNamespaces() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getIncludeResourceBundles() {
            return Collections.emptyList();
        }

        @Override
        public Map<String, File> getIncludeStyleSheets() {
            return Collections.emptyMap();
        }

        @Override
        public boolean isIncludeLookupOnlyEnabled() {
            return false;
        }

        @Override
        public boolean isLinkageExternal(String path) {
            if (this.externalLibrariesSet == null) {
                this.externalLibrariesSet = new HashSet<String>();
                if (ASC.this.externalLibraries != null) {
                    for (String externalPath : ASC.this.externalLibraries) {
                        this.externalLibrariesSet.add(new File(externalPath).getAbsolutePath());
                    }
                }
            }
            return this.externalLibrariesSet.contains(path);
        }

        @Override
        public boolean useDirectBlit() {
            return false;
        }

        @Override
        public boolean useGPU() {
            return false;
        }

        @Override
        public List<String> getDefaultsCSSFiles() {
            return ImmutableList.of();
        }

        @Override
        public List<String> getExcludeDefaultsCSSFiles() {
            return ImmutableList.of();
        }

        @Override
        public File getLinkReport() {
            return null;
        }

        @Override
        public File getSizeReport() {
            return null;
        }

        @Override
        public String getRoyaleMinimumSupportedVersion() {
            return null;
        }

        @Override
        public boolean getMxmlChildrenAsData() {
            return false;
        }

        @Override
        public boolean getInfoFlex() {
            return false;
        }

        @Override
        public boolean getAllowSubclassOverrides() {
            return false;
        }

        @Override
        public String[] getMxmlImplicitImports() {
            return null;
        }

        @Override
        public boolean getRemoveDeadCode() {
            return ASC.this.removeDeadCode;
        }

        @Override
        public String getSWFMetadataDate() {
            return null;
        }

        @Override
        public String getSWFMetadataDateFormat() {
            return null;
        }
    }
}

