/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.LocalizationManager;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.common.PathResolver;
import flex2.compiler.config.CommandLineConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.config.SystemPropertyConfigurator;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.MxmlJSC;
import flex2.tools.Tool;
import flex2.tools.ToolsConfiguration;
import flex2.tools.VersionInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mxmlc
extends Tool {
    private static String l10nConfigPrefix = "flex2.configuration";
    public static final String FILE_SPECS = "file-specs";

    public static void main(String[] args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        System.exit(Mxmlc.mxmlcNoExit(args));
    }

    public static int mxmlcNoExit(String[] args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        JS_COMPILER = MxmlJSC.class;
        return Mxmlc.compile(args);
    }

    public static void mxmlc(String[] args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        JS_COMPILER = MxmlJSC.class;
        Mxmlc.compile(args);
    }

    public static Configuration processConfiguration(LocalizationManager lmgr, String program, String[] args, ConfigurationBuffer cfgbuf, Class<? extends Configuration> cls, String defaultVar) throws ConfigurationException, IOException {
        return Mxmlc.processConfiguration(lmgr, program, args, cfgbuf, cls, defaultVar, true);
    }

    public static Configuration processConfiguration(LocalizationManager lmgr, String program, String[] args, ConfigurationBuffer cfgbuf, Class<? extends Configuration> cls, String defaultVar, boolean ignoreUnknownItems) throws IOException {
        ToolsConfiguration toolsConfiguration = null;
        try {
            String project;
            VirtualFile projectFile;
            String val;
            int index;
            ConfigurationValue cv;
            String buildNumber;
            String configname;
            String framework;
            SystemPropertyConfigurator.load(cfgbuf, "flex");
            CommandLineConfigurator.parse(cfgbuf, defaultVar, args);
            String flexlib = cfgbuf.getToken("flexlib");
            if (flexlib == null) {
                String appHome = System.getProperty("application.home");
                appHome = appHome == null ? "." : appHome + File.separator + "frameworks";
                cfgbuf.setToken("flexlib", appHome);
            }
            if ((framework = cfgbuf.getToken("framework")) == null) {
                cfgbuf.setToken("framework", "halo");
            }
            if ((configname = cfgbuf.getToken("configname")) == null) {
                cfgbuf.setToken("configname", "flex");
            }
            if ((buildNumber = cfgbuf.getToken("build.number")) == null) {
                buildNumber = "".equals(VersionInfo.getBuild()) ? "workspace" : VersionInfo.getBuild();
                cfgbuf.setToken("build.number", buildNumber);
            }
            if (cfgbuf.getVar("version") != null) {
                System.out.println(VersionInfo.buildMessage());
                System.exit(0);
            }
            Mxmlc.processHelp(cfgbuf, program, defaultVar, lmgr, args);
            ConfigurationPathResolver configResolver = new ConfigurationPathResolver();
            List<ConfigurationValue> configs = cfgbuf.peekConfigurationVar("load-config");
            if (configs != null) {
                for (ConfigurationValue cv2 : configs) {
                    for (String path : cv2.getArgs()) {
                        VirtualFile configFile = ConfigurationPathResolver.getVirtualFile(path, configResolver, cv2);
                        cfgbuf.calculateChecksum(configFile);
                        InputStream in = configFile.getInputStream();
                        if (in != null) {
                            FileConfigurator.load(cfgbuf, new BufferedInputStream(in), configFile.getName(), configFile.getParent(), "royale-config", ignoreUnknownItems);
                            continue;
                        }
                        throw new ConfigurationException.ConfigurationIOError(path, cv2.getVar(), cv2.getSource(), cv2.getLine());
                    }
                }
            }
            PathResolver resolver = ThreadLocalToolkit.getPathResolver();
            List fileValues = cfgbuf.getVar(FILE_SPECS);
            if (fileValues != null && fileValues.size() > 0 && (cv = (ConfigurationValue)fileValues.get(fileValues.size() - 1)).getArgs().size() > 0 && (index = (val = cv.getArgs().get(cv.getArgs().size() - 1)).lastIndexOf(46)) != -1 && (projectFile = resolver.resolve(configResolver, project = val.substring(0, index) + "-config.xml")) != null) {
                cfgbuf.calculateChecksum(projectFile);
                InputStream in = projectFile.getInputStream();
                if (in != null) {
                    FileConfigurator.load(cfgbuf, new BufferedInputStream(in), projectFile.getName(), projectFile.getParent(), "royale-config", ignoreUnknownItems);
                }
            }
            cfgbuf.clearSourceVars("command line");
            CommandLineConfigurator.parse(cfgbuf, defaultVar, args);
            toolsConfiguration = null;
            try {
                toolsConfiguration = (ToolsConfiguration)cls.newInstance();
                toolsConfiguration.setConfigPathResolver(configResolver);
            }
            catch (Exception e) {
                LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
                throw new ConfigurationException(l10n.getLocalizedTextString(new CouldNotInstantiate(toolsConfiguration)));
            }
            cfgbuf.commit(toolsConfiguration);
            Mxmlc.calculateServicesChecksum(toolsConfiguration, cfgbuf);
            toolsConfiguration.validate(cfgbuf);
            VirtualFile licenseFile = toolsConfiguration.getLicenseFile();
            if (licenseFile != null) {
                Map<String, String> fileLicenses = Tool.getLicenseMapFromFile(licenseFile.getName());
                Map<String, String> cmdLicenses = toolsConfiguration.getLicensesConfiguration().getLicenseMap();
                if (cmdLicenses == null) {
                    toolsConfiguration.getLicensesConfiguration().setLicenseMap(fileLicenses);
                } else if (fileLicenses != null) {
                    fileLicenses.putAll(cmdLicenses);
                    toolsConfiguration.getLicensesConfiguration().setLicenseMap(fileLicenses);
                }
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return toolsConfiguration;
    }

    static void processHelp(ConfigurationBuffer cfgbuf, String program, String defaultVar, LocalizationManager lmgr, String[] args) {
        if (cfgbuf.getVar("help") != null) {
            HashSet<String> keywords = new HashSet<String>();
            List vals = cfgbuf.getVar("help");
            for (ConfigurationValue val : vals) {
                Iterator<String> iterator = val.getArgs().iterator();
                while (iterator.hasNext()) {
                    String element;
                    String keyword = element = iterator.next();
                    while (keyword.startsWith("-")) {
                        keyword = keyword.substring(1);
                    }
                    keywords.add(keyword);
                }
            }
            if (keywords.size() == 0) {
                keywords.add("help");
            }
            ThreadLocalToolkit.logInfo(Mxmlc.getStartMessage(program));
            System.out.println();
            System.out.println(CommandLineConfigurator.usage(program, defaultVar, cfgbuf, keywords, lmgr, l10nConfigPrefix));
            System.exit(0);
        }
        if (args.length == 0 && ("mxmlc".equals(program) || "compc".equals(program))) {
            ThreadLocalToolkit.logInfo(Mxmlc.getStartMessage(program));
            System.err.println(CommandLineConfigurator.brief(program, defaultVar, lmgr, l10nConfigPrefix));
            System.exit(1);
        }
    }

    private static void calculateServicesChecksum(Configuration config, ConfigurationBuffer cfgbuf) {
        Map services = null;
        if (config.getCompilerConfiguration().getServicesDependencies() != null) {
            services = config.getCompilerConfiguration().getServicesDependencies().getConfigPaths();
        }
        if (services != null) {
            for (Map.Entry entry : services.entrySet()) {
                cfgbuf.calculateChecksum((String)entry.getKey(), (Long)entry.getValue());
            }
        }
    }

    public static void processConfigurationException(ConfigurationException ex, String program) {
        ThreadLocalToolkit.log(ex);
        if (ex.source == null || ex.source.equals("command line")) {
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("program", program);
            String help = ThreadLocalToolkit.getLocalizationManager().getLocalizedTextString("flex2.compiler.CommandLineHelp", p);
            if (help != null) {
                System.err.println(help);
            }
        }
    }

    private static String getStartMessage(String program) {
        LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
        return l10n.getLocalizedTextString(new StartMessage(program, VersionInfo.buildMessage()));
    }

    public static class OutputMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -4859993585489031839L;
        public String name;
        public String length;

        public OutputMessage(String name, String length) {
            this.name = name;
            this.length = length;
        }
    }

    public static class StartMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 4807822711658875257L;
        public final String program;
        public final String buildMessage;

        public StartMessage(String program, String buildMessage) {
            this.program = program;
            this.buildMessage = buildMessage;
        }
    }

    public static class CouldNotInstantiate
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = -8970190710117830662L;
        public final Configuration config;

        public CouldNotInstantiate(Configuration config) {
            this.config = config;
        }
    }
}

