/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.tree.as.decorators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.tree.as.decorators.IVariableTypeDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolDecoratorProvider {
    private static SymbolDecoratorProvider provider;
    private List<IVariableTypeDecorator> variableTypeDecorators = new ArrayList<IVariableTypeDecorator>();

    public static SymbolDecoratorProvider getProvider() {
        if (provider == null) {
            provider = new SymbolDecoratorProvider();
        }
        return provider;
    }

    private SymbolDecoratorProvider() {
    }

    public void addVariableTypeDecorator(IVariableTypeDecorator decorator) {
        this.variableTypeDecorators.add(decorator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IVariableTypeDecorator> getVariableTypeDecorators(IDefinition context) {
        if ((CompilerDiagnosticsConstants.diagnostics & 0x200) == 512) {
            System.out.println("SymbolDecoratorProvider waiting for lock in getVariableTypeDecorators");
        }
        List<IVariableTypeDecorator> list = this.variableTypeDecorators;
        synchronized (list) {
            Iterator<IVariableTypeDecorator> it = this.variableTypeDecorators.iterator();
            ArrayList<IVariableTypeDecorator> retVal = new ArrayList<IVariableTypeDecorator>();
            while (it.hasNext()) {
                IVariableTypeDecorator next = it.next();
                if (!next.isApplicable(context)) continue;
                retVal.add(next);
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x200) == 512) {
                System.out.println("SymbolDecoratorProvider done with lock in getVariableTypeDecorators");
            }
            return retVal;
        }
    }
}

