/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IStyleDefinition;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLPropertySpecifierNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLInvalidStyleProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLClassReferenceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStyleSpecifierNode;

class MXMLStyleSpecifierNode
extends MXMLPropertySpecifierNode
implements IMXMLStyleSpecifierNode {
    MXMLStyleSpecifierNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLStyleSpecifierID;
    }

    protected void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializeFromAttribute(builder, attribute, info);
        this.validateStyle(builder, attribute);
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        this.validateStyle(builder, tag);
    }

    private void validateStyle(MXMLTreeBuilder builder, ISourceLocation source) {
        IStyleDefinition styleTag;
        ImmutableSet applicableThemes;
        IDefinition definition = this.getDefinition();
        if (definition instanceof IStyleDefinition && !(applicableThemes = ImmutableSet.copyOf((Object[])(styleTag = (IStyleDefinition)definition).getThemes())).isEmpty()) {
            boolean isStyleValid;
            ImmutableSet themeNames = ImmutableSet.copyOf(builder.getProject().getThemeNames());
            boolean bl = isStyleValid = !Sets.intersection((Set)themeNames, (Set)applicableThemes).isEmpty();
            if (!isStyleValid) {
                String componentType = this.getParent() instanceof IMXMLClassReferenceNode ? ((IMXMLClassReferenceNode)this.getParent()).getClassReference(builder.getProject()).getBaseName() : "";
                MXMLInvalidStyleProblem problem = new MXMLInvalidStyleProblem(source, this.getName(), componentType, styleTag.getThemes());
                builder.addProblem(problem);
            }
        }
    }
}

