/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.mxml.IMXMLMetadataNode;

class MXMLMetadataNode
extends MXMLNodeBase
implements IMXMLMetadataNode {
    private IMetaTagNode[] metaTagNodes;

    MXMLMetadataNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLMetadataID;
    }

    public IASNode getChild(int i) {
        return this.metaTagNodes != null ? this.metaTagNodes[i] : null;
    }

    public int getChildCount() {
        return this.metaTagNodes != null ? this.metaTagNodes.length : 0;
    }

    public String getName() {
        return "Metadata";
    }

    public IMetaTagNode[] getMetaTagNodes() {
        return this.metaTagNodes;
    }

    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        for (IMXMLUnitData unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            IMXMLTextData mxmlTextData;
            if (!(unit instanceof IMXMLTextData) || (mxmlTextData = (IMXMLTextData)unit).getTextType() == IMXMLTextData.TextType.WHITESPACE) continue;
            MetaTagsNode metaTagsNode = ASParser.parseMetadata(builder.getWorkspace(), mxmlTextData.getCompilableText(), mxmlTextData.getSourcePath(), mxmlTextData.getCompilableTextStart(), mxmlTextData.getCompilableTextLine(), mxmlTextData.getCompilableTextColumn(), builder.getProblems());
            if (metaTagsNode == null) {
                this.metaTagNodes = null;
                return;
            }
            int n = metaTagsNode.getChildCount();
            this.metaTagNodes = new IMetaTagNode[n];
            for (int i = 0; i < n; ++i) {
                IMetaTagNode child;
                this.metaTagNodes[i] = child = (IMetaTagNode)metaTagsNode.getChild(i);
                ((NodeBase)((Object)child)).setParent(this);
            }
        }
    }
}

