/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.common.IEmbedResolver;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.targets.ITargetAttributes;
import org.apache.royale.compiler.internal.targets.TargetAttributesMap;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDocumentNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLImplicitImportNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.units.MXMLCompilationUnit;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLInstructionData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLConstructorHasParametersProblem;
import org.apache.royale.compiler.problems.MXMLContentAfterRootTagProblem;
import org.apache.royale.compiler.problems.MXMLContentBeforeRootTagProblem;
import org.apache.royale.compiler.problems.MXMLFinalClassProblem;
import org.apache.royale.compiler.problems.MXMLMissingRootTagProblem;
import org.apache.royale.compiler.problems.MXMLMultipleRootTagsProblem;
import org.apache.royale.compiler.problems.MXMLNotAClassProblem;
import org.apache.royale.compiler.problems.MXMLSyntaxProblem;
import org.apache.royale.compiler.problems.MXMLUnresolvedTagProblem;
import org.apache.royale.compiler.problems.MXMLXMLProcessingInstructionLocationProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IFileNodeAccumulator;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFileNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStyleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXMLFileNode
extends MXMLNodeBase
implements IMXMLFileNode,
IScopedNode,
IFileNode,
IFileNodeAccumulator {
    private RoyaleProject project;
    private String qname;
    private MXMLFileScope fileScope;
    private MXMLDocumentNode documentNode;
    private long includeTreeLastModified;
    private final List<IImportNode> importNodes;
    private final List<IEmbedResolver> embedNodes;
    private final Set<String> requiredResourceBundles;
    private OffsetLookup offsetLookup;
    private final List<IMXMLStyleNode> styleNodes = new ArrayList<IMXMLStyleNode>();
    private ITargetAttributes targetAttributes;
    private CSSCompilationSession cssCompilationSession;

    public MXMLFileNode() {
        super(null);
        this.importNodes = new LinkedList<IImportNode>();
        this.embedNodes = new LinkedList<IEmbedResolver>();
        this.requiredResourceBundles = new HashSet<String>();
    }

    void initialize(MXMLTreeBuilder builder) {
        IFileSpecification fileSpec = builder.getFileSpecification();
        this.project = builder.getProject();
        this.qname = builder.getQName();
        this.fileScope = builder.getFileScope();
        OffsetLookup offsetLookup = this.fileScope.getOffsetLookup();
        assert (offsetLookup != null) : "Expected offset lookup on MXMLFileScope.";
        this.offsetLookup = offsetLookup;
        this.setLocation(builder);
        for (String importStr : ASFileScope.getImplicitImportsForAS()) {
            MXMLImplicitImportNode implicitImportNode = new MXMLImplicitImportNode(this.project, importStr);
            this.addImportNode(implicitImportNode);
        }
        for (IImportNode implicitImportNode : this.project.getImplicitImportNodesForMXML(builder.getMXMLDialect())) {
            this.addImportNode(implicitImportNode);
        }
        this.includeTreeLastModified = fileSpec.getLastModified();
        this.processUnits(builder);
    }

    private void processUnits(MXMLTreeBuilder builder) {
        IMXMLData mxmlData = builder.getMXMLData();
        for (ICompilerProblem problem : mxmlData.getProblems()) {
            builder.addProblem(problem);
        }
        if (mxmlData.getNumUnits() == 0) {
            return;
        }
        boolean foundRootTag = false;
        IMXMLTextData asDoc = null;
        for (IMXMLUnitData unit = mxmlData.getUnit(0); unit != null; unit = unit.getNextSiblingUnit()) {
            MXMLSyntaxProblem problem;
            MXMLSyntaxProblem problem2;
            if (unit instanceof IMXMLInstructionData) {
                if (unit.getStart() <= 0) continue;
                problem2 = new MXMLXMLProcessingInstructionLocationProblem(unit);
                builder.addProblem(problem2);
                continue;
            }
            if (unit instanceof IMXMLTagData) {
                if (!foundRootTag) {
                    foundRootTag = true;
                    this.processRootTag(builder, (IMXMLTagData)unit, asDoc);
                    continue;
                }
                problem2 = new MXMLMultipleRootTagsProblem(unit);
                builder.addProblem(problem2);
                continue;
            }
            if (!(unit instanceof IMXMLTextData)) continue;
            IMXMLTextData textData = (IMXMLTextData)unit;
            if (textData.getTextType().equals((Object)IMXMLTextData.TextType.ASDOC)) {
                asDoc = textData;
            }
            if (builder.getMXMLDialect().isWhitespace(textData.getCompilableText())) continue;
            if (this.documentNode == null) {
                problem = new MXMLContentBeforeRootTagProblem(unit);
                builder.addProblem(problem);
                continue;
            }
            problem = new MXMLContentAfterRootTagProblem(unit);
            builder.addProblem(problem);
        }
        if (!foundRootTag) {
            MXMLMissingRootTagProblem problem = new MXMLMissingRootTagProblem(builder.getPath());
            builder.addProblem(problem);
        }
    }

    private void processRootTag(MXMLTreeBuilder builder, IMXMLTagData rootTag, IMXMLTextData asDoc) {
        ClassDefinition fileDef = this.fileScope.getMainClassDefinition();
        assert (fileDef != null);
        IDefinition tagDef = builder.getFileScope().resolveTagToDefinition(rootTag);
        if (tagDef == null) {
            MXMLUnresolvedTagProblem problem = new MXMLUnresolvedTagProblem(rootTag);
            builder.addProblem(problem);
            return;
        }
        if (!(tagDef instanceof IClassDefinition)) {
            MXMLNotAClassProblem problem = new MXMLNotAClassProblem(rootTag, tagDef.getQualifiedName());
            builder.addProblem(problem);
            return;
        }
        IClassDefinition tagDefinition = (IClassDefinition)tagDef;
        if (tagDefinition != null && tagDefinition.isFinal()) {
            MXMLFinalClassProblem problem = new MXMLFinalClassProblem(rootTag, tagDef.getQualifiedName());
            builder.addProblem(problem);
            return;
        }
        IFunctionDefinition constructor = tagDefinition.getConstructor();
        if (constructor != null && constructor.hasRequiredParameters()) {
            MXMLConstructorHasParametersProblem problem = new MXMLConstructorHasParametersProblem(rootTag, tagDef.getQualifiedName());
            builder.addProblem(problem);
            return;
        }
        this.documentNode = new MXMLDocumentNode(this);
        this.documentNode.setClassReference(this.project, tagDefinition);
        this.documentNode.setClassDefinition(fileDef);
        this.documentNode.initializeFromTag(builder, rootTag);
        if (asDoc != null) {
            IASDocComment asDocComment = builder.getWorkspace().getASDocDelegate().createASDocComment(asDoc, tagDefinition);
            this.documentNode.setASDocComment(asDocComment);
        }
        fileDef.setNode(this.documentNode);
        if (fileDef.getNameStart() == -1 && fileDef.getNameEnd() == -1) {
            fileDef.setNameLocation(0, 0);
        }
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.documentNode : null;
    }

    @Override
    public int getChildCount() {
        return this.documentNode != null ? 1 : 0;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLFileID;
    }

    @Override
    public String getName() {
        return this.qname;
    }

    @Override
    public IMXMLDocumentNode getDocumentNode() {
        return this.documentNode;
    }

    @Override
    public IASScope getScope() {
        return this.fileScope;
    }

    @Override
    public void getAllImports(Collection<String> imports) {
        for (IImportNode node : this.importNodes) {
            imports.add(node.getImportName());
        }
    }

    @Override
    public void getAllImportNodes(Collection<IImportNode> imports) {
        imports.addAll(this.importNodes);
    }

    @Override
    public IDefinition[] getTopLevelDefinitions(boolean includeDefinitionsOutsideOfPackage, boolean includeNonPublicDefinitions) {
        IDefinition[] iDefinitionArray;
        if (this.documentNode != null) {
            IDefinition[] iDefinitionArray2 = new IDefinition[1];
            iDefinitionArray = iDefinitionArray2;
            iDefinitionArray2[0] = this.documentNode.getClassDefinition();
        } else {
            iDefinitionArray = new IDefinition[]{};
        }
        return iDefinitionArray;
    }

    @Override
    public IDefinitionNode[] getTopLevelDefinitionNodes(boolean includeDefinitionsOutsideOfPackage, boolean includeNonPublicDefinitions) {
        IDefinitionNode[] iDefinitionNodeArray;
        if (this.documentNode != null) {
            IDefinitionNode[] iDefinitionNodeArray2 = new IDefinitionNode[1];
            iDefinitionNodeArray = iDefinitionNodeArray2;
            iDefinitionNodeArray2[0] = this.documentNode;
        } else {
            iDefinitionNodeArray = new IDefinitionNode[]{};
        }
        return iDefinitionNodeArray;
    }

    @Override
    public boolean hasIncludes() {
        return this.fileScope.getOffsetLookup().hasIncludes();
    }

    public IClassDefinition[] getLibraryDefinitions() {
        return ((MXMLFileScope)this.getScope()).getLibraryDefinitions();
    }

    @Override
    public IFileSpecification getFileSpecification() {
        if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
            System.out.println("MXMLFileNode waiting for lock in getFileSpecification");
        }
        IFileSpecification fs = this.fileScope.getWorkspace().getFileSpecification(this.fileScope.getContainingPath());
        if ((CompilerDiagnosticsConstants.diagnostics & 0x100) == 256) {
            System.out.println("MXMLFileNode done with lock in getFileSpecification");
        }
        return fs;
    }

    @Override
    public ICompilerProject getCompilerProject() {
        return this.project;
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getSourcePath());
        sb.append('\"');
        return true;
    }

    protected void updateIncludeTreeLastModified(long lastModified) {
        this.includeTreeLastModified = Math.max(lastModified, this.includeTreeLastModified);
    }

    @Override
    public long getIncludeTreeLastModified() {
        return this.includeTreeLastModified;
    }

    @Override
    public void addImportNode(IImportNode node) {
        this.importNodes.add(node);
    }

    @Override
    public List<IImportNode> getImportNodes() {
        return this.importNodes;
    }

    @Override
    public void addEmbedNode(IEmbedResolver node) {
        this.embedNodes.add(node);
    }

    @Override
    public List<IEmbedResolver> getEmbedNodes() {
        return this.embedNodes;
    }

    @Override
    public void addRequiredResourceBundle(String bundleName) {
        this.requiredResourceBundles.add(bundleName);
    }

    @Override
    public Set<String> getRequiredResourceBundles() {
        return this.requiredResourceBundles;
    }

    @Override
    public OffsetLookup getOffsetLookup() {
        return this.offsetLookup;
    }

    private void setLocation(MXMLTreeBuilder builder) {
        String sourcePath = builder.getPath();
        MXMLCompilationUnit cu = builder.getCompilationUnit();
        IMXMLData mxmlData = builder.getMXMLData();
        String absoluteFilename = cu.getAbsoluteFilename();
        int mxmlDataEnd = mxmlData.getEnd();
        int[] possibleAbsoluteOffsets = this.offsetLookup.getAbsoluteOffset(absoluteFilename, mxmlDataEnd);
        assert (possibleAbsoluteOffsets.length == 1) : "Expected only 1 match.";
        int absoluteEnd = possibleAbsoluteOffsets[0];
        this.setLocation(sourcePath, 0, absoluteEnd, 1, 1);
    }

    @Override
    public List<IMXMLStyleNode> getStyleNodes() {
        return this.styleNodes;
    }

    @Override
    public ITargetAttributes getTargetAttributes(ICompilerProject project) {
        if (this.targetAttributes == null && this.documentNode != null) {
            this.targetAttributes = new TargetAttributesMap(this.documentNode.rootAttributes);
        }
        return this.targetAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSSCompilationSession getCSSCompilationSession() {
        if (this.cssCompilationSession == null) {
            MXMLFileNode mXMLFileNode = this;
            synchronized (mXMLFileNode) {
                if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                    System.out.println("MXMLFileNode waiting for lock in getCSSCompilationSession");
                }
                if (this.cssCompilationSession == null) {
                    this.cssCompilationSession = this.project.getCSSCompilationSession();
                }
                if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                    System.out.println("MXMLFileNode done with lock in getCSSCompilationSession");
                }
            }
        }
        return this.cssCompilationSession;
    }

    @Override
    public void addDeferredFunctionNode(FunctionNode functionNode) {
        throw new UnsupportedOperationException("Functions should never be deferred in MXML document.");
    }

    @Override
    public void populateFunctionNodes() {
    }

    @Override
    public Collection<ICompilerProblem> getProblems() {
        return Collections.emptyList();
    }
}

