/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassNode;
import org.apache.royale.compiler.tree.mxml.IMXMLFactoryNode;

class MXMLFactoryNode
extends MXMLInstanceNode
implements IMXMLFactoryNode {
    private MXMLClassNode classNode;

    MXMLFactoryNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLFactoryID;
    }

    public IASNode getChild(int i) {
        return i == 0 ? this.classNode : null;
    }

    public int getChildCount() {
        return this.classNode != null ? 1 : 0;
    }

    protected void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        this.initialize(builder);
        super.initializeFromTag(builder, tag);
    }

    protected void initializeFromFragments(MXMLTreeBuilder builder, ISourceLocation location, ISourceFragment[] fragments) {
        this.initialize(builder);
        this.setLocation(location);
        this.classNode = new MXMLClassNode(this);
        this.classNode.initializeFromFragments(builder, location, fragments);
    }

    private void initialize(MXMLTreeBuilder builder) {
        RoyaleProject project = builder.getProject();
        String qname = project.getClassFactoryClass();
        this.setClassReference(project, qname);
        builder.addExpressionDependency(qname);
    }

    public IMXMLClassNode getClassNode() {
        return this.classNode;
    }
}

