/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import antlr.Token;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.CatchNode;
import org.apache.royale.compiler.internal.tree.as.TerminalNode;
import org.apache.royale.compiler.internal.tree.as.TreeNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.ICatchNode;
import org.apache.royale.compiler.tree.as.IStatementNode;
import org.apache.royale.compiler.tree.as.ITerminalNode;
import org.apache.royale.compiler.tree.as.ITryNode;

public class TryNode
extends TreeNode
implements ITryNode,
IStatementNode {
    private BlockNode contentsBlockNode;

    public TryNode(IASToken keyword) {
        this.startBefore(keyword);
        this.contentsBlockNode = new BlockNode();
        this.contentsBlockNode.startAfter((Token)((Object)keyword));
        this.contentsBlockNode.endAfter(keyword);
        this.addChild(this.contentsBlockNode);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.TryID;
    }

    protected void setChildren(boolean fillInOffsets) {
    }

    public IASNode getStatementContentsNode() {
        return this.contentsBlockNode;
    }

    public int getCatchNodeCount() {
        int n = this.getChildCount();
        if (this.getContentsNode() != null) {
            --n;
        }
        if (this.getFinallyNode() != null) {
            --n;
        }
        return n;
    }

    public ICatchNode getCatchNode(int i) {
        if (i < 0 || i >= this.getCatchNodeCount()) {
            return null;
        }
        if (this.getContentsNode() != null) {
            ++i;
        }
        return (ICatchNode)this.getChild(i);
    }

    public ITerminalNode getFinallyNode() {
        int childCount = this.getChildCount();
        if (childCount < 1) {
            return null;
        }
        IASNode child = this.getChild(childCount - 1);
        if (child instanceof TerminalNode && ((TerminalNode)child).kind == ITerminalNode.TerminalKind.FINALLY) {
            return (ITerminalNode)child;
        }
        return null;
    }

    public void addCatchClause(CatchNode node) {
        this.addChild(node);
    }

    public void addFinallyBlock(TerminalNode node) {
        this.addChild(node);
    }

    public BlockNode getContentsNode() {
        return this.contentsBlockNode;
    }
}

