/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.definitions.SetterDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.AccessorNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.parts.IAccessorFunctionContentsPart;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.ISetterNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetterNode
extends AccessorNode
implements ISetterNode {
    public SetterNode(IASToken functionKeyword, IASToken setKeyword, IdentifierNode nameNode) {
        super(functionKeyword, setKeyword, nameNode);
    }

    public SetterNode(IdentifierNode node, IAccessorFunctionContentsPart part) {
        super(node, part);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.SetterID;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        ParameterDefinition[] parameters;
        super.analyze(set, scope, problems);
        FunctionDefinition definition = this.getDefinition();
        if (definition != null && (parameters = definition.getParameters()) != null && parameters.length > 0) {
            definition.setTypeReference(parameters[0].getTypeReference());
        }
    }

    @Override
    protected FunctionDefinition createFunctionDefinition(String name) {
        return new SetterDefinition(name);
    }

    @Override
    public IExpressionNode getAssignedValueNode() {
        return null;
    }

    @Override
    public IExpressionNode getVariableTypeNode() {
        IParameterNode[] arguments = this.getParameterNodes();
        if (arguments.length > 0) {
            return arguments[0].getVariableTypeNode();
        }
        return null;
    }

    @Override
    public String getVariableType() {
        IParameterNode[] arguments = this.getParameterNodes();
        if (arguments.length > 0) {
            return arguments[0].getVariableType();
        }
        return "";
    }

    @Override
    public boolean isConst() {
        return false;
    }
}

