/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import java.math.BigInteger;
import org.apache.royale.abc.semantics.ECMASupport;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;

public class NumericLiteralNode
extends LiteralNode
implements INumericLiteralNode {
    private static final String HEX_PREFIX = "0x";
    private static final String POSITIVE_HEX_PREFIX = "+0x";
    private static final String NEGATIVE_HEX_PREFIX = "-0x";
    private INumericLiteralNode.INumericValue numericValue;
    private final boolean isHex;

    private static Number hexToDec(String unsignedHexString, boolean isNegative) {
        if (unsignedHexString.length() < 16) {
            Long abs = Long.valueOf(unsignedHexString, 16);
            return isNegative ? -abs.longValue() : abs;
        }
        BigInteger bi = new BigInteger(unsignedHexString, 16);
        return isNegative ? -bi.doubleValue() : bi.doubleValue();
    }

    public NumericLiteralNode(String text) {
        super(ILiteralNode.LiteralType.NUMBER, text);
        assert (text != null && text.length() > 0) : "The text of a NumericLiteralNode cannot be null or empty";
        String lowerCaseText = text.toLowerCase();
        this.isHex = lowerCaseText.startsWith(HEX_PREFIX) || lowerCaseText.startsWith(NEGATIVE_HEX_PREFIX) || lowerCaseText.startsWith(POSITIVE_HEX_PREFIX);
    }

    public NumericLiteralNode(ASToken t) {
        super(t, ILiteralNode.LiteralType.NUMBER);
        this.isHex = t.getType() == 126;
    }

    protected NumericLiteralNode(NumericLiteralNode other) {
        super(other);
        this.numericValue = other.numericValue;
        this.isHex = other.isHex;
    }

    public ASTNodeID getNodeID() {
        try {
            INumericLiteralNode.INumericValue numeric = this.getNumericValue();
            switch (numeric.getAssumedType()) {
                case INT: {
                    return numeric.toNumber() == 0.0 ? ASTNodeID.LiteralIntegerZeroID : ASTNodeID.LiteralIntegerID;
                }
                case UINT: {
                    return numeric.toNumber() == 0.0 ? ASTNodeID.LiteralIntegerZeroID : ASTNodeID.LiteralUintID;
                }
            }
            return ASTNodeID.LiteralDoubleID;
        }
        catch (NumberFormatException cannot_convert) {
            return ASTNodeID.LiteralNumberID;
        }
    }

    protected NumericLiteralNode copy() {
        return new NumericLiteralNode(this);
    }

    public INumericLiteralNode.INumericValue getNumericValue() throws NumberFormatException {
        if (this.numericValue == null) {
            String lowerCaseValue = this.value.toLowerCase();
            Number decimal = this.isHex && lowerCaseValue.startsWith(HEX_PREFIX) ? (Number)NumericLiteralNode.hexToDec(this.value.substring(HEX_PREFIX.length()), false) : (Number)(this.isHex && lowerCaseValue.startsWith(POSITIVE_HEX_PREFIX) ? (Number)NumericLiteralNode.hexToDec(this.value.substring(POSITIVE_HEX_PREFIX.length()), false) : (Number)(this.isHex && lowerCaseValue.startsWith(NEGATIVE_HEX_PREFIX) ? (Number)NumericLiteralNode.hexToDec(this.value.substring(NEGATIVE_HEX_PREFIX.length()), true) : (Number)Double.parseDouble(this.value)));
            this.numericValue = new NumericValue(decimal, this.value, this.isHex);
        }
        return this.numericValue;
    }

    public boolean isHex() {
        return this.isHex;
    }

    private static final class NumericValue
    implements INumericLiteralNode.INumericValue {
        private final String text;
        private final Number number;
        private final IASLanguageConstants.BuiltinType baseType;

        private NumericValue(Number number, String text, boolean isHex) {
            this.number = number;
            this.text = text.trim();
            double doubleValue = number.doubleValue();
            this.baseType = text.contains(".") || number.equals(Double.POSITIVE_INFINITY) || number.equals(Double.NEGATIVE_INFINITY) || number.equals(Double.NaN) ? IASLanguageConstants.BuiltinType.NUMBER : (doubleValue == 0.0 && text.startsWith("-") ? IASLanguageConstants.BuiltinType.NUMBER : (Math.floor(doubleValue) == doubleValue ? (doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9 ? IASLanguageConstants.BuiltinType.INT : (doubleValue >= 0.0 && doubleValue <= (double)INumericLiteralNode.MAX_UINT_VALUE ? IASLanguageConstants.BuiltinType.UINT : IASLanguageConstants.BuiltinType.NUMBER)) : IASLanguageConstants.BuiltinType.NUMBER));
        }

        public final IASLanguageConstants.BuiltinType getAssumedType() {
            return this.baseType;
        }

        public final double toInteger() {
            return ECMASupport.toInteger(this.number.doubleValue());
        }

        public final double toNumber() {
            return this.number.doubleValue();
        }

        public final int toInt32() {
            return ECMASupport.toInt32(this.number.doubleValue());
        }

        public final long toUint32() {
            if (this.number instanceof Long) {
                return this.number.longValue();
            }
            return ECMASupport.toUInt32(this.number.doubleValue());
        }

        public final String toString() {
            return this.text;
        }
    }
}

