/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IContainerNode;

public final class ConfigConditionBlockNode
extends BlockNode {
    private boolean enabled;

    public ConfigConditionBlockNode(boolean enabled) {
        this.enabled = enabled;
        this.setContainerType(IContainerNode.ContainerType.CONFIG_BLOCK);
    }

    public int getChildCount() {
        if (this.enabled) {
            return super.getChildCount();
        }
        return 0;
    }

    protected void fillInOffsets() {
        boolean oldEnabled = this.enabled;
        this.enabled = true;
        super.fillInOffsets();
        this.enabled = oldEnabled;
    }

    public void normalize(boolean fillInOffsets) {
        boolean oldEnabled = this.enabled;
        this.enabled = true;
        super.normalize(fillInOffsets);
        this.enabled = oldEnabled;
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append(this.enabled ? "(enabled) " : "(disabled) ");
        return super.buildInnerString(sb);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.ConfigBlockID;
    }
}

