/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IOperatorNode;

public class BinaryOperatorPlusNode
extends BinaryOperatorNodeBase {
    public BinaryOperatorPlusNode(IASToken operatorToken, ExpressionNodeBase leftOperand, ExpressionNodeBase rightOperand) {
        super(operatorToken, leftOperand, rightOperand);
    }

    protected BinaryOperatorPlusNode(BinaryOperatorPlusNode other) {
        super(other);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.Op_AddID;
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        ITypeDefinition leftType = this.getLeftOperandNode().resolveType(project);
        ITypeDefinition rightType = this.getRightOperandNode().resolveType(project);
        if (this.isNumericType(leftType, project) && this.isNumericType(rightType, project)) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
        }
        ITypeDefinition stringType = project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
        if (stringType.equals(leftType) || stringType.equals(rightType)) {
            return stringType;
        }
        if (SemanticUtils.isXMLish(leftType, project) && SemanticUtils.isXMLish(rightType, project)) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    protected BinaryOperatorPlusNode copy() {
        return new BinaryOperatorPlusNode(this);
    }

    public IOperatorNode.OperatorType getOperator() {
        return IOperatorNode.OperatorType.PLUS;
    }

    private boolean isNumericType(ITypeDefinition type, ICompilerProject project) {
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER).equals(type)) {
            return true;
        }
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.INT).equals(type)) {
            return true;
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).equals(type);
    }
}

